/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.core.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_310;
import net.minecraft.class_642;
import padej.soup.base.util.logger.LoggerUtil;
import padej.soup.core.server.SSLHelper;

public class ServerConfigManager {
    private static final Map<String, ServerConfig> SERVER_CONFIGS = new HashMap<String, ServerConfig>();
    private static final Map<String, CachedConfig> configCache = new HashMap<String, CachedConfig>();
    private static final Map<String, Boolean> fetchingStatus = new HashMap<String, Boolean>();
    private static volatile boolean initialLoadSuccessful = false;
    private static volatile boolean needsForceFetch = false;

    private static void loadServersFromBackend() {
        CompletableFuture.runAsync(() -> {
            try {
                String apiBase = "https://77.110.111.251/api";
                URL url = new URL(apiBase + "/servers");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    in.close();
                    JsonObject serversJson = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                    if (serversJson.has("servers")) {
                        JsonObject servers = serversJson.getAsJsonObject("servers");
                        for (String serverId : servers.keySet()) {
                            JsonObject serverData = servers.getAsJsonObject(serverId);
                            String displayName = serverData.get("name").getAsString();
                            String endpoint = apiBase + "/server/config/public?server=" + serverId;
                            if (serverData.has("addresses")) {
                                JsonArray addressArray = serverData.getAsJsonArray("addresses");
                                for (int i = 0; i < addressArray.size(); ++i) {
                                    String serverAddress = addressArray.get(i).getAsString();
                                    SERVER_CONFIGS.put(serverAddress, new ServerConfig(serverAddress, endpoint, displayName));
                                }
                                continue;
                            }
                            if (!serverData.has("address")) continue;
                            String serverAddress = serverData.get("address").getAsString();
                            SERVER_CONFIGS.put(serverAddress, new ServerConfig(serverAddress, endpoint, displayName));
                        }
                    }
                    LoggerUtil.info("Loaded " + SERVER_CONFIGS.size() + " server configurations from backend");
                    initialLoadSuccessful = true;
                    needsForceFetch = false;
                } else {
                    LoggerUtil.warn("Failed to load server configurations: HTTP " + responseCode);
                    initialLoadSuccessful = false;
                    needsForceFetch = true;
                }
                connection.disconnect();
            }
            catch (Exception e) {
                LoggerUtil.error("Error loading server configurations: " + e.getMessage());
                initialLoadSuccessful = false;
                needsForceFetch = true;
            }
        });
    }

    public static String getCurrentServerAddress() {
        class_310 mc = class_310.method_1551();
        if (mc.method_1558() != null) {
            class_642 serverInfo = mc.method_1558();
            String address = serverInfo.field_3761.toLowerCase();
            int colonIndex = address.indexOf(58);
            if (colonIndex > 0) {
                address = address.substring(0, colonIndex);
            }
            return address;
        }
        return null;
    }

    private static boolean matchesAddress(String currentAddress, String pattern) {
        if (currentAddress == null || pattern == null) {
            return false;
        }
        if ((currentAddress = currentAddress.toLowerCase()).equals(pattern = pattern.toLowerCase())) {
            return true;
        }
        if (pattern.contains("*")) {
            Object regex = pattern.replace(".", "\\.").replace("*", ".*");
            if (!((String)regex).startsWith(".*")) {
                regex = "^" + (String)regex;
            }
            if (!((String)regex).endsWith(".*")) {
                regex = (String)regex + "$";
            }
            try {
                return currentAddress.matches((String)regex);
            }
            catch (Exception e) {
                LoggerUtil.warn("Invalid wildcard pattern: " + pattern + " -> " + e.getMessage());
                return false;
            }
        }
        return currentAddress.contains(pattern);
    }

    public static boolean isOnManagedServer() {
        String address = ServerConfigManager.getCurrentServerAddress();
        if (address == null) {
            return false;
        }
        for (String serverKey : SERVER_CONFIGS.keySet()) {
            if (!ServerConfigManager.matchesAddress(address, serverKey)) continue;
            return true;
        }
        return false;
    }

    private static ServerConfig getCurrentServerConfig() {
        String address = ServerConfigManager.getCurrentServerAddress();
        if (address == null) {
            return null;
        }
        for (Map.Entry<String, ServerConfig> entry : SERVER_CONFIGS.entrySet()) {
            if (!ServerConfigManager.matchesAddress(address, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static void fetchConfigAsync(ServerConfig serverConfig) {
        String cacheKey = serverConfig.configEndpoint;
        if (fetchingStatus.getOrDefault(cacheKey, false).booleanValue()) {
            return;
        }
        fetchingStatus.put(cacheKey, true);
        CompletableFuture.runAsync(() -> {
            try {
                URL url = new URL(serverConfig.configEndpoint);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(3000);
                connection.setReadTimeout(3000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    in.close();
                    JsonObject config = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                    configCache.put(cacheKey, new CachedConfig(config, System.currentTimeMillis()));
                    LoggerUtil.info(serverConfig.displayName + " config fetched successfully");
                } else {
                    LoggerUtil.warn("Failed to fetch " + serverConfig.displayName + " config: HTTP " + responseCode);
                }
                connection.disconnect();
            }
            catch (Exception e) {
                LoggerUtil.error("Error fetching " + serverConfig.displayName + " config: " + e.getMessage());
            }
            finally {
                fetchingStatus.put(cacheKey, false);
            }
        });
    }

    public static boolean getConfigValue(String key, boolean defaultValue) {
        ServerConfig serverConfig = ServerConfigManager.getCurrentServerConfig();
        if (serverConfig == null) {
            return true;
        }
        String cacheKey = serverConfig.configEndpoint;
        CachedConfig cached = configCache.get(cacheKey);
        if (cached == null) {
            ServerConfigManager.fetchConfigAsync(serverConfig);
            return defaultValue;
        }
        try {
            if (cached.config.has(key)) {
                return cached.config.get(key).getAsBoolean();
            }
        }
        catch (Exception e) {
            LoggerUtil.error("Error reading config key " + key + " for " + serverConfig.displayName + ": " + e.getMessage());
        }
        return defaultValue;
    }

    public static void refresh() {
        ServerConfig serverConfig = ServerConfigManager.getCurrentServerConfig();
        if (serverConfig != null) {
            configCache.remove(serverConfig.configEndpoint);
            ServerConfigManager.fetchConfigAsync(serverConfig);
        }
    }

    public static void refreshAll() {
        configCache.clear();
        for (ServerConfig config : SERVER_CONFIGS.values()) {
            ServerConfigManager.fetchConfigAsync(config);
        }
    }

    public static String getCurrentServerDisplayName() {
        ServerConfig config = ServerConfigManager.getCurrentServerConfig();
        return config != null ? config.displayName : "Unknown";
    }

    public static Map<String, String> getRegisteredServers() {
        HashMap<String, String> servers = new HashMap<String, String>();
        for (Map.Entry<String, ServerConfig> entry : SERVER_CONFIGS.entrySet()) {
            servers.put(entry.getKey(), entry.getValue().displayName);
        }
        return servers;
    }

    public static boolean getVisibilitySetting(String visibilityLevel, String property, boolean defaultValue) {
        ServerConfig serverConfig = ServerConfigManager.getCurrentServerConfig();
        if (serverConfig == null) {
            return defaultValue;
        }
        String cacheKey = serverConfig.configEndpoint;
        CachedConfig cached = configCache.get(cacheKey);
        if (cached == null) {
            ServerConfigManager.fetchConfigAsync(serverConfig);
            return defaultValue;
        }
        try {
            String key;
            JsonObject visibilitySettings;
            if (cached.config.has("visibilitySettings") && (visibilitySettings = cached.config.getAsJsonObject("visibilitySettings")).has(key = ServerConfigManager.getVisibilityKey(visibilityLevel, property))) {
                return visibilitySettings.get(key).getAsBoolean();
            }
        }
        catch (Exception e) {
            LoggerUtil.error("Error reading visibility setting " + visibilityLevel + "." + property + ": " + e.getMessage());
        }
        return defaultValue;
    }

    private static String getVisibilityKey(String visibilityLevel, String property) {
        String prefix = switch (visibilityLevel) {
            case "FULLY_VISIBLE" -> "fullyVisible";
            case "PARTIALLY_VISIBLE" -> "partiallyVisible";
            case "FULLY_INVISIBLE" -> "fullyInvisible";
            default -> throw new IllegalArgumentException("Unknown visibility level: " + visibilityLevel);
        };
        String suffix = switch (property) {
            case "canBeTargeted" -> "CanBeTargeted";
            case "showSkin" -> "ShowSkin";
            case "showName" -> "ShowName";
            case "showChinaHat" -> "ShowChinaHat";
            case "showTrails" -> "ShowTrails";
            case "showHp" -> "ShowHp";
            default -> throw new IllegalArgumentException("Unknown property: " + property);
        };
        return prefix + suffix;
    }

    public static boolean canBeTargeted(String visibilityLevel) {
        boolean defaultValue = switch (visibilityLevel) {
            case "FULLY_VISIBLE" -> true;
            case "PARTIALLY_VISIBLE" -> true;
            case "FULLY_INVISIBLE" -> false;
            default -> false;
        };
        return ServerConfigManager.getVisibilitySetting(visibilityLevel, "canBeTargeted", defaultValue);
    }

    public static boolean showSkin(String visibilityLevel) {
        boolean defaultValue = switch (visibilityLevel) {
            case "FULLY_VISIBLE" -> true;
            case "PARTIALLY_VISIBLE" -> false;
            case "FULLY_INVISIBLE" -> false;
            default -> false;
        };
        return ServerConfigManager.getVisibilitySetting(visibilityLevel, "showSkin", defaultValue);
    }

    public static boolean showName(String visibilityLevel) {
        boolean defaultValue = switch (visibilityLevel) {
            case "FULLY_VISIBLE" -> true;
            case "PARTIALLY_VISIBLE" -> false;
            case "FULLY_INVISIBLE" -> false;
            default -> false;
        };
        return ServerConfigManager.getVisibilitySetting(visibilityLevel, "showName", defaultValue);
    }

    public static boolean showChinaHat(String visibilityLevel) {
        boolean defaultValue = switch (visibilityLevel) {
            case "FULLY_VISIBLE" -> true;
            case "PARTIALLY_VISIBLE" -> true;
            case "FULLY_INVISIBLE" -> false;
            default -> false;
        };
        return ServerConfigManager.getVisibilitySetting(visibilityLevel, "showChinaHat", defaultValue);
    }

    public static boolean showTrails(String visibilityLevel) {
        boolean defaultValue = switch (visibilityLevel) {
            case "FULLY_VISIBLE" -> true;
            case "PARTIALLY_VISIBLE" -> true;
            case "FULLY_INVISIBLE" -> false;
            default -> false;
        };
        return ServerConfigManager.getVisibilitySetting(visibilityLevel, "showTrails", defaultValue);
    }

    public static boolean showHp(String visibilityLevel) {
        boolean defaultValue = switch (visibilityLevel) {
            case "FULLY_VISIBLE" -> true;
            case "PARTIALLY_VISIBLE" -> false;
            case "FULLY_INVISIBLE" -> false;
            default -> false;
        };
        return ServerConfigManager.getVisibilitySetting(visibilityLevel, "showHp", defaultValue);
    }

    public static boolean fetchConfigSync(ServerConfig serverConfig, int timeoutMs) {
        if (serverConfig == null) {
            return false;
        }
        String cacheKey = serverConfig.configEndpoint;
        try {
            URL url = new URL(serverConfig.configEndpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(timeoutMs);
            connection.setReadTimeout(timeoutMs);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                in.close();
                JsonObject config = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                configCache.put(cacheKey, new CachedConfig(config, System.currentTimeMillis()));
                connection.disconnect();
                return true;
            }
            connection.disconnect();
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void onServerJoin(String serverAddress) {
        ServerConfig serverConfig;
        if (serverAddress == null) {
            return;
        }
        if (needsForceFetch || !initialLoadSuccessful) {
            ServerConfigManager.reloadServersSync();
        }
        if ((serverConfig = ServerConfigManager.getCurrentServerConfig()) != null) {
            configCache.remove(serverConfig.configEndpoint);
            boolean success = ServerConfigManager.fetchConfigSync(serverConfig, 5000);
            if (!success) {
                LoggerUtil.warn("Failed to load config for " + serverConfig.displayName + " - using restrictive defaults");
            }
        }
    }

    private static void reloadServersSync() {
        try {
            String apiBase = "https://77.110.111.251/api";
            URL url = new URL(apiBase + "/servers");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                in.close();
                JsonObject serversJson = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                if (serversJson.has("servers")) {
                    SERVER_CONFIGS.clear();
                    JsonObject servers = serversJson.getAsJsonObject("servers");
                    for (String serverId : servers.keySet()) {
                        JsonObject serverData = servers.getAsJsonObject(serverId);
                        String displayName = serverData.get("name").getAsString();
                        String endpoint = apiBase + "/server/config/public?server=" + serverId;
                        if (serverData.has("addresses")) {
                            JsonArray addressArray = serverData.getAsJsonArray("addresses");
                            for (int i = 0; i < addressArray.size(); ++i) {
                                String serverAddress = addressArray.get(i).getAsString();
                                SERVER_CONFIGS.put(serverAddress, new ServerConfig(serverAddress, endpoint, displayName));
                            }
                            continue;
                        }
                        if (!serverData.has("address")) continue;
                        String serverAddress = serverData.get("address").getAsString();
                        SERVER_CONFIGS.put(serverAddress, new ServerConfig(serverAddress, endpoint, displayName));
                    }
                }
                LoggerUtil.info("Reloaded " + SERVER_CONFIGS.size() + " server configurations (sync)");
                initialLoadSuccessful = true;
                needsForceFetch = false;
            } else {
                LoggerUtil.error("Failed to reload server configurations: HTTP " + responseCode);
            }
            connection.disconnect();
        }
        catch (Exception e) {
            LoggerUtil.error("Error reloading server configurations (sync): " + e.getMessage());
        }
    }

    public static boolean isInitialLoadSuccessful() {
        return initialLoadSuccessful;
    }

    public static boolean needsForceFetch() {
        return needsForceFetch;
    }

    static {
        SSLHelper.trustSelfSignedCertificates();
        ServerConfigManager.loadServersFromBackend();
    }

    private record ServerConfig(String serverAddress, String configEndpoint, String displayName) {
    }

    private static class CachedConfig {
        JsonObject config;
        long fetchTime;

        CachedConfig(JsonObject config, long fetchTime) {
            this.config = config;
            this.fetchTime = fetchTime;
        }
    }
}

