/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.PlayerIntersectionUtil;

public class Consumable
extends AbstractDraggable {
    private static final Map<String, class_1792> ITEM_MAP = new LinkedHashMap<String, class_1792>();
    private final Map<String, Integer> itemCounts = new LinkedHashMap<String, Integer>();

    public Consumable() {
        super("Consumable", 400, 200, 140, 80, true);
    }

    @Override
    public boolean visible() {
        return Consumable.mc.field_1724 != null || PlayerIntersectionUtil.isChat(Consumable.mc.field_1755);
    }

    @Override
    public void tick() {
        if (Consumable.mc.field_1724 == null) {
            return;
        }
        this.itemCounts.clear();
        padej.soup.implement.features.modules.hud.Consumable consumableModule = padej.soup.implement.features.modules.hud.Consumable.getInstance();
        for (String itemType : consumableModule.getItemTypes().getSelected()) {
            int count;
            class_1792 item = ITEM_MAP.get(itemType);
            if (item == null || (count = this.countItem(item)) <= 0) continue;
            this.itemCounts.put(itemType, count);
        }
    }

    private int countItem(class_1792 item) {
        if (Consumable.mc.field_1724 == null) {
            return 0;
        }
        return IntStream.range(0, Consumable.mc.field_1724.method_31548().method_5439()).mapToObj(i -> Consumable.mc.field_1724.method_31548().method_5438(i)).filter(stack -> !stack.method_7960() && stack.method_7909() == item).mapToInt(class_1799::method_7947).sum();
    }

    @Override
    public void drawDraggable(class_332 context) {
        class_4587 matrix = context.method_51448();
        padej.soup.implement.features.modules.hud.Consumable consumableModule = padej.soup.implement.features.modules.hud.Consumable.getInstance();
        boolean showBackground = consumableModule.getShowBackground().isValue();
        boolean showCount = consumableModule.getShowCount().isValue();
        String layout = consumableModule.getLayout().getSelected();
        float scale = consumableModule.getScale().getValue();
        float padding = 3.0f;
        float baseItemSize = 16.0f;
        float itemSize = baseItemSize * scale + 2.0f;
        int visibleItems = this.itemCounts.size();
        if (visibleItems == 0) {
            return;
        }
        int cols = 1;
        int rows = 1;
        float width = 0.0f;
        float height = 0.0f;
        switch (layout) {
            case "Line": {
                cols = visibleItems;
                rows = 1;
                width = (float)cols * itemSize + padding * 2.0f;
                height = itemSize + padding * 2.0f;
                break;
            }
            case "Column": {
                cols = 1;
                rows = visibleItems;
                width = itemSize + padding * 2.0f;
                height = (float)rows * itemSize + padding * 2.0f;
                break;
            }
            case "Table": {
                cols = (int)Math.ceil(Math.sqrt(visibleItems));
                rows = (int)Math.ceil((double)visibleItems / (double)cols);
                width = (float)cols * itemSize + padding * 2.0f;
                height = (float)rows * itemSize + padding * 2.0f;
            }
        }
        this.setWidth((int)width);
        this.setHeight((int)height);
        if (showBackground) {
            blur.render(ShapeProperties.create(matrix, this.getX(), this.getY(), this.getWidth(), this.getHeight()).quality(25.0f).round(4.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        }
        float startY = (float)this.getY() + padding;
        float startX = (float)this.getX() + padding;
        int index = 0;
        for (Map.Entry<String, Integer> entry : this.itemCounts.entrySet()) {
            String itemType = entry.getKey();
            int count = entry.getValue();
            int row = 0;
            int col = 0;
            switch (layout) {
                case "Line": {
                    col = index;
                    row = 0;
                    break;
                }
                case "Column": {
                    col = 0;
                    row = index;
                    break;
                }
                case "Table": {
                    row = index / cols;
                    col = index % cols;
                }
            }
            float x = startX + (float)col * itemSize;
            float y = startY + (float)row * itemSize;
            class_1792 item = ITEM_MAP.get(itemType);
            if (item != null) {
                class_1799 stack = new class_1799((class_1935)item, count);
                matrix.method_22903();
                matrix.method_46416(x, y, 0.0f);
                matrix.method_22905(scale, scale, 1.0f);
                context.method_51427(stack, 0, 0);
                if (showCount) {
                    context.method_51431(Consumable.mc.field_1772, stack, 0, 0);
                }
                matrix.method_22909();
            }
            ++index;
        }
    }

    static {
        ITEM_MAP.put("Snowball", class_1802.field_8543);
        ITEM_MAP.put("Egg", class_1802.field_8803);
        ITEM_MAP.put("Wind Charge", class_1802.field_49098);
        ITEM_MAP.put("Golden Apple", class_1802.field_8463);
        ITEM_MAP.put("Enchanted Golden Apple", class_1802.field_8367);
        ITEM_MAP.put("Arrow", class_1802.field_8107);
        ITEM_MAP.put("Spectral Arrow", class_1802.field_8236);
        ITEM_MAP.put("Tipped Arrow", class_1802.field_8087);
        ITEM_MAP.put("Totem", class_1802.field_8288);
        ITEM_MAP.put("Chorus Fruit", class_1802.field_8233);
        ITEM_MAP.put("Ender Pearl", class_1802.field_8634);
        ITEM_MAP.put("Firework Rocket", class_1802.field_8639);
        ITEM_MAP.put("Experience Bottle", class_1802.field_8287);
    }
}

