/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2656;
import net.minecraft.class_2724;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_7923;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.PlayerIntersectionUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.other.StopWatch;
import padej.soup.base.util.other.StringUtil;
import padej.soup.base.util.render.Render2DUtil;
import padej.soup.implement.events.packet.PacketEvent;
import padej.soup.implement.features.modules.hud.Icons;

public class CoolDowns
extends AbstractDraggable {
    public final List<CoolDown> list = new ArrayList<CoolDown>();

    public static CoolDowns getInstance() {
        return Instance.getDraggable(CoolDowns.class);
    }

    public CoolDowns() {
        super("CoolDowns", 120, 10, 80, 23, true);
    }

    @Override
    public boolean visible() {
        return !this.list.isEmpty() || PlayerIntersectionUtil.isChat(CoolDowns.mc.field_1755);
    }

    @Override
    public void tick() {
        this.list.removeIf(c -> c.anim.isFinished(Direction.BACKWARDS));
        this.list.stream().filter(c -> !Objects.requireNonNull(CoolDowns.mc.field_1724).method_7357().method_7904(c.stack)).forEach(coolDown -> coolDown.anim.setDirection(Direction.BACKWARDS));
    }

    @Override
    public void packet(PacketEvent e) {
        if (PlayerIntersectionUtil.nullCheck()) {
            return;
        }
        class_2596<?> class_25962 = e.getPacket();
        Objects.requireNonNull(class_25962);
        class_2596<?> class_25963 = class_25962;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2656.class, class_2724.class}, class_25963, n)) {
            case 0: {
                class_2656 c = (class_2656)class_25963;
                class_1792 item = (class_1792)class_7923.field_41178.method_63535(c.comp_3082());
                this.list.stream().filter(coolDown -> coolDown.stack.method_7909().equals(item)).forEach(coolDown -> coolDown.anim.setDirection(Direction.BACKWARDS));
                if (c.comp_2199() == 0) break;
                class_1799 stack = this.findItemStack(item);
                this.list.add(new CoolDown(stack, new StopWatch().setMs((long)(-c.comp_2199()) * 50L), new DecelerateAnimation().setMs(150).setValue(1.0)));
                break;
            }
            case 1: {
                class_2724 p = (class_2724)class_25963;
                this.list.clear();
                break;
            }
        }
    }

    private class_1799 findItemStack(class_1792 item) {
        if (CoolDowns.mc.field_1724 == null) {
            return item.method_7854();
        }
        if (CoolDowns.mc.field_1724.method_6047().method_7909().equals(item)) {
            return CoolDowns.mc.field_1724.method_6047();
        }
        if (CoolDowns.mc.field_1724.method_6079().method_7909().equals(item)) {
            return CoolDowns.mc.field_1724.method_6079();
        }
        for (class_1799 stack : CoolDowns.mc.field_1724.method_31548().field_7547) {
            if (!stack.method_7909().equals(item)) continue;
            return stack;
        }
        return item.method_7854();
    }

    @Override
    public void drawDraggable(class_332 context) {
        class_4587 matrix = context.method_51448();
        FontRenderer font = Fonts.getSize(15, Fonts.Type.INTER_DEFAULT);
        FontRenderer fontCoolDown = Fonts.getSize(13, Fonts.Type.INTER_DEFAULT);
        padej.soup.implement.features.modules.hud.CoolDowns coolDownsModule = padej.soup.implement.features.modules.hud.CoolDowns.getInstance();
        float headerHeight = 16.0f;
        float padding = 5.0f;
        boolean showHeader = coolDownsModule.getShowHeader().isValue();
        boolean darkenHeader = coolDownsModule.getDarkenHeader().isValue();
        if (showHeader) {
            int headerColor = darkenHeader ? ColorUtil.getRectDarker(0.9f) : ColorUtil.getRect(0.7f);
            blur.render(ShapeProperties.create(matrix, this.getX(), this.getY(), this.getWidth(), headerHeight).round(4.0f, 0.0f, 4.0f, 0.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(headerColor).build());
            blur.render(ShapeProperties.create(matrix, this.getX(), (float)this.getY() + headerHeight, this.getWidth(), (float)this.getHeight() - headerHeight).round(0.0f, 4.0f, 0.0f, 4.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        } else {
            blur.render(ShapeProperties.create(matrix, this.getX(), this.getY(), this.getWidth(), this.getHeight()).round(4.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        }
        float centerX = (float)this.getX() + (float)this.getWidth() / 2.0f;
        if (showHeader) {
            font.drawString(matrix, this.getName(), (int)((float)this.getX() + padding), (int)((float)this.getY() + 6.5f), ColorUtil.getText());
            float iconSize = 8.0f;
            float iconPadding = 4.0f;
            Icons iconsModule = Icons.getInstance();
            int iconColor = !iconsModule.getColoredIcons().isValue() ? ColorUtil.getText() : (iconsModule.getIconGradient().isValue() ? ColorUtil.fade(8) : ColorUtil.getClientColor());
            image.setTexture("textures/clock.png").render(ShapeProperties.create(matrix, (float)(this.getX() + this.getWidth()) - iconSize - iconPadding, this.getY() + 4, iconSize, iconSize).color(iconColor).build());
        }
        int offset = showHeader ? (int)(headerHeight + 7.0f) : 7;
        int maxWidth = 80;
        for (CoolDown coolDown : this.list) {
            float animation = coolDown.anim.getOutput().floatValue();
            float centerY = this.getY() + offset;
            int time = -coolDown.time.elapsedTime() / 1000;
            class_2561 nameText = coolDown.stack.method_7964();
            String duration = StringUtil.getDuration(time);
            MathUtil.scale(matrix, centerX, centerY, 1.0f, animation, () -> {
                int durationColor;
                Render2DUtil.defaultDrawStack(context, coolDown.stack, this.getX() + 4, centerY - 3.0f, false, false, 0.5f);
                rectangle.render(ShapeProperties.create(matrix, this.getX() + 15, centerY - 1.0f, 0.5, 6.0).color(ColorUtil.getOutline(1.0f, 0.5f)).build());
                fontCoolDown.drawText(matrix, nameText, this.getX() + 18, centerY + 1.0f);
                if (time <= 5) {
                    float blinkProgress = MathUtil.blinking(1000.0, 8.0f);
                    durationColor = ColorUtil.overCol(ColorUtil.getText(), -11141291, blinkProgress);
                } else {
                    durationColor = ColorUtil.getText();
                }
                fontCoolDown.drawString(matrix, duration, (float)(this.getX() + this.getWidth() - 5) - fontCoolDown.getStringWidth(duration), centerY + 1.0f, durationColor);
            });
            int width = (int)(fontCoolDown.getStringWidth(nameText) + fontCoolDown.getStringWidth(duration)) + 30;
            maxWidth = Math.max(width, maxWidth);
            offset += (int)(11.0f * animation);
        }
        this.setWidth(maxWidth);
        this.setHeight(offset);
    }

    public record CoolDown(class_1799 stack, StopWatch time, Animation anim) {
    }
}

