/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.PlayerIntersectionUtil;
import padej.soup.base.util.render.Render2DUtil;
import padej.soup.implement.features.modules.hud.Icons;

public class Inventory
extends AbstractDraggable {
    List<class_1799> stacks = new ArrayList<class_1799>();

    public Inventory() {
        super("Inventory", 390, 10, 123, 60, true);
    }

    @Override
    public boolean visible() {
        return !this.stacks.stream().filter(stack -> !stack.method_7960()).toList().isEmpty() || PlayerIntersectionUtil.isChat(Inventory.mc.field_1755);
    }

    @Override
    public void tick() {
        this.stacks = IntStream.range(9, 36).mapToObj(i -> Inventory.mc.field_1724.field_7514.method_5438(i)).toList();
    }

    @Override
    public void drawDraggable(class_332 context) {
        float totalHeight;
        class_4587 matrix = context.method_51448();
        padej.soup.implement.features.modules.hud.Inventory inventoryModule = padej.soup.implement.features.modules.hud.Inventory.getInstance();
        float headerHeight = 16.0f;
        float padding = 5.0f;
        boolean showHeader = inventoryModule.getShowHeader().isValue();
        boolean darkenHeader = inventoryModule.getDarkenHeader().isValue();
        int itemsPerRow = 9;
        int totalItems = 27;
        int itemSize = 13;
        int itemPadding = 4;
        int rows = (int)Math.ceil((double)totalItems / (double)itemsPerRow);
        float contentHeight = rows * itemSize + itemPadding * 2;
        float f = totalHeight = showHeader ? headerHeight + contentHeight : contentHeight;
        if (showHeader) {
            int headerColor = darkenHeader ? ColorUtil.getRectDarker(0.9f) : ColorUtil.getRect(0.7f);
            blur.render(ShapeProperties.create(matrix, this.getX(), this.getY(), this.getWidth(), headerHeight).round(4.0f, 0.0f, 4.0f, 0.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(headerColor).build());
            blur.render(ShapeProperties.create(matrix, this.getX(), (float)this.getY() + headerHeight, this.getWidth(), contentHeight).quality(25.0f).round(0.0f, 4.0f, 0.0f, 4.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        } else {
            blur.render(ShapeProperties.create(matrix, this.getX(), this.getY(), this.getWidth(), contentHeight).quality(25.0f).round(4.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        }
        if (showHeader) {
            Fonts.getSize(15, Fonts.Type.INTER_DEFAULT).drawString(matrix, this.getName(), (int)((float)this.getX() + padding), (int)((float)this.getY() + 6.5f), ColorUtil.getText());
            float iconSize = 8.0f;
            float iconPadding = 4.0f;
            Icons iconsModule = Icons.getInstance();
            int iconColor = !iconsModule.getColoredIcons().isValue() ? ColorUtil.getText() : (iconsModule.getIconGradient().isValue() ? ColorUtil.fade(8) : ColorUtil.getClientColor());
            image.setTexture("textures/inv.png").render(ShapeProperties.create(matrix, (float)(this.getX() + this.getWidth()) - iconSize - iconPadding, this.getY() + 4, iconSize, iconSize).color(iconColor).build());
        }
        int offsetY = showHeader ? (int)(headerHeight + (float)itemPadding) : itemPadding;
        int offsetX = itemPadding;
        for (class_1799 stack : this.stacks) {
            Render2DUtil.defaultDrawStack(context, stack, this.getX() + offsetX, this.getY() + offsetY, false, true, 0.5f);
            if ((offsetX += itemSize) <= this.getWidth() - itemSize) continue;
            offsetY += itemSize;
            offsetX = itemPadding;
        }
        this.setHeight((int)totalHeight);
    }
}

