/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.LinearAnimation;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.core.Main;

public class ModulesList
extends AbstractDraggable {
    private final Map<Module, Animation> animations = new HashMap<Module, Animation>();
    private final Map<String, Animation> categoryAnimations = new HashMap<String, Animation>();
    private final Map<Module, Float> targetYPositions = new HashMap<Module, Float>();
    private final Map<Module, Float> currentYPositions = new HashMap<Module, Float>();
    private final Map<String, Float> categoryTargetYPositions = new HashMap<String, Float>();
    private final Map<String, Float> categoryCurrentYPositions = new HashMap<String, Float>();
    private ArrayList<ModuleEntry> sortedModules = new ArrayList();
    private boolean positionInitialized = false;
    private float cachedMaxWidth = 0.0f;
    private boolean lastLowercaseState = false;

    public ModulesList() {
        super("ModulesList", 0, 3, 100, 100, true);
    }

    @Override
    public void tick() {
        for (Module module : Main.getInstance().getModuleProvider().getModules()) {
            Animation animation;
            Direction newDirection;
            Direction direction = newDirection = module.isEnabled() ? Direction.FORWARDS : Direction.BACKWARDS;
            if (!this.animations.containsKey(module)) {
                animation = new LinearAnimation().setMs(100).setValue(1.0);
                animation.setDirection(newDirection);
                this.animations.put(module, animation);
                continue;
            }
            animation = this.animations.get(module);
            if (animation.isDirection(newDirection)) {
                animation.setDirection(newDirection);
                continue;
            }
            Animation newAnimation = new LinearAnimation().setMs(100).setValue(1.0);
            newAnimation.setDirection(newDirection);
            this.animations.put(module, newAnimation);
        }
        this.updateCategoryAnimation("HUD", this.hasAnyCategoryEnabled("HUD"));
        this.updateCategoryAnimation("World", this.hasAnyCategoryEnabled("WORLD"));
        this.updateSortedModules();
    }

    private void updateCategoryAnimation(String categoryName, boolean shouldShow) {
        Direction newDirection;
        Direction direction = newDirection = shouldShow ? Direction.FORWARDS : Direction.BACKWARDS;
        if (!this.categoryAnimations.containsKey(categoryName)) {
            Animation animation = new LinearAnimation().setMs(100).setValue(1.0);
            animation.setDirection(newDirection);
            this.categoryAnimations.put(categoryName, animation);
        } else {
            Animation animation = this.categoryAnimations.get(categoryName);
            if (animation.isDirection(newDirection)) {
                animation.setDirection(newDirection);
            } else {
                Animation newAnimation = new LinearAnimation().setMs(100).setValue(1.0);
                newAnimation.setDirection(newDirection);
                this.categoryAnimations.put(categoryName, newAnimation);
            }
        }
    }

    private boolean hasAnyCategoryEnabled(String categoryName) {
        return Main.getInstance().getModuleProvider().getModules().stream().anyMatch(module -> module.getCategory().name().equals(categoryName) && module.isEnabled());
    }

    private void updateSortedModules() {
        Animation worldAnimation;
        FontRenderer font = Fonts.getSize(15, Fonts.Type.INTER_BOLD);
        padej.soup.implement.features.modules.hud.ModulesList modulesListModule = padej.soup.implement.features.modules.hud.ModulesList.getInstance();
        ArrayList moduleEntries = Main.getInstance().getModuleProvider().getModules().stream().filter(module -> !module.getCategory().name().equals("HUD")).filter(module -> !module.getCategory().name().equals("WORLD")).filter(module -> {
            String className = module.getClass().getSimpleName();
            return !className.equals("Language") && !className.equals("Bright") && !className.equals("Fog") && !className.equals("Time") && !className.equals("Light");
        }).map(module -> {
            Animation animation = this.animations.get(module);
            if (animation != null && animation.getOutput() > 0.01) {
                this.currentYPositions.putIfAbsent((Module)module, Float.valueOf(0.0f));
                float currentY = this.currentYPositions.getOrDefault(module, Float.valueOf(0.0f)).floatValue();
                float targetY = this.targetYPositions.getOrDefault(module, Float.valueOf(0.0f)).floatValue();
                return new ModuleEntry((Module)module, animation, targetY, currentY);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        ArrayList<ModuleEntry> categoryEntries = new ArrayList<ModuleEntry>();
        Animation hudAnimation = this.categoryAnimations.get("HUD");
        if (hudAnimation != null && hudAnimation.getOutput() > 0.01) {
            this.categoryCurrentYPositions.putIfAbsent("HUD", Float.valueOf(0.0f));
            float currentY = this.categoryCurrentYPositions.getOrDefault("HUD", Float.valueOf(0.0f)).floatValue();
            float targetY = this.categoryTargetYPositions.getOrDefault("HUD", Float.valueOf(0.0f)).floatValue();
            categoryEntries.add(new ModuleEntry("HUD", hudAnimation, targetY, currentY));
        }
        if ((worldAnimation = this.categoryAnimations.get("World")) != null && worldAnimation.getOutput() > 0.01) {
            this.categoryCurrentYPositions.putIfAbsent("World", Float.valueOf(0.0f));
            float currentY = this.categoryCurrentYPositions.getOrDefault("World", Float.valueOf(0.0f)).floatValue();
            float targetY = this.categoryTargetYPositions.getOrDefault("World", Float.valueOf(0.0f)).floatValue();
            categoryEntries.add(new ModuleEntry("World", worldAnimation, targetY, currentY));
        }
        moduleEntries.addAll(categoryEntries);
        this.sortedModules = moduleEntries.stream().sorted(modulesListModule.getSortMode().isSelected("Length") ? Comparator.nullsLast(Comparator.comparing(entry -> {
            if (entry == null) {
                return Float.valueOf(0.0f);
            }
            if (entry.module != null) {
                String name = this.getModuleName(entry.module, modulesListModule);
                return Float.valueOf(font.getStringWidth(name));
            }
            if (entry.categoryLabel != null) {
                return Float.valueOf(font.getStringWidth(entry.categoryLabel));
            }
            return Float.valueOf(0.0f);
        }, Comparator.reverseOrder())) : Comparator.nullsLast(Comparator.comparing(entry -> {
            if (entry == null) {
                return 0;
            }
            if (entry.module != null) {
                return this.countAllSettings(entry.module);
            }
            if (entry.categoryLabel != null) {
                return 0;
            }
            return 0;
        }, Comparator.reverseOrder()))).collect(Collectors.toCollection(ArrayList::new));
        float lineHeight = 12.0f;
        float lineGap = 0.0f;
        AtomicReference<Float> targetY = new AtomicReference<Float>(Float.valueOf(0.0f));
        this.sortedModules.forEach(entry -> {
            if (entry.module != null) {
                this.targetYPositions.put(entry.module, (Float)targetY.get());
            } else if (entry.categoryLabel != null) {
                this.categoryTargetYPositions.put(entry.categoryLabel, (Float)targetY.get());
            }
            entry.targetY = ((Float)targetY.get()).floatValue();
            targetY.updateAndGet(y -> Float.valueOf(y.floatValue() + lineHeight + lineGap));
        });
        float smoothness = 0.3f;
        this.sortedModules.forEach(entry -> {
            if (entry.module != null) {
                float current = this.currentYPositions.getOrDefault(entry.module, Float.valueOf(entry.targetY)).floatValue();
                float target = entry.targetY;
                float interpolated = current + (target - current) * 0.3f;
                this.currentYPositions.put(entry.module, Float.valueOf(interpolated));
                entry.currentY = interpolated;
            } else if (entry.categoryLabel != null) {
                float current = this.categoryCurrentYPositions.getOrDefault(entry.categoryLabel, Float.valueOf(entry.targetY)).floatValue();
                float target = entry.targetY;
                float interpolated = current + (target - current) * 0.3f;
                this.categoryCurrentYPositions.put(entry.categoryLabel, Float.valueOf(interpolated));
                entry.currentY = interpolated;
            }
        });
    }

    @Override
    public void drawDraggable(class_332 e) {
        boolean isRightSide;
        class_4587 matrix = e.method_51448();
        FontRenderer font = Fonts.getSize(15, Fonts.Type.INTER_BOLD);
        if (!this.positionInitialized) {
            if (this.getX() == 0 && this.getY() == 3) {
                this.setX(window.method_4486() - 105);
            }
            this.positionInitialized = true;
        }
        padej.soup.implement.features.modules.hud.ModulesList modulesListModule = padej.soup.implement.features.modules.hud.ModulesList.getInstance();
        if (this.sortedModules.isEmpty()) {
            String placeholder = this.getPlaceholder();
            float padding = 5.0f;
            float lineHeight = 16.0f;
            float width = font.getStringWidth(placeholder) + padding * 2.0f;
            if (modulesListModule.getShowBackground().isValue()) {
                blur.render(ShapeProperties.create(matrix, this.getX(), this.getY(), width, lineHeight).round(3.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
            }
            font.drawString(matrix, placeholder, (float)this.getX() + padding, (float)this.getY() + 5.5f, ColorUtil.getText());
            this.setWidth((int)width);
            this.setHeight((int)lineHeight);
            return;
        }
        float padding = 4.0f;
        float lineHeight = 12.0f;
        float lineGap = 0.0f;
        float sideLineWidth = 2.5f;
        boolean bl = isRightSide = (float)this.getX() > (float)window.method_4486() / 2.0f;
        if (this.lastLowercaseState != modulesListModule.getLowercase().isValue()) {
            this.cachedMaxWidth = 0.0f;
            this.lastLowercaseState = modulesListModule.getLowercase().isValue();
        }
        if (this.cachedMaxWidth == 0.0f) {
            Main.getInstance().getModuleProvider().getModules().stream().filter(module -> !module.getCategory().name().equals("HUD")).filter(module -> !module.getCategory().name().equals("WORLD")).map(module -> this.getModuleName((Module)module, modulesListModule)).forEach(moduleName -> {
                float textWidth = font.getStringWidth((String)moduleName);
                this.cachedMaxWidth = Math.max(this.cachedMaxWidth, textWidth);
            });
            this.cachedMaxWidth = Math.max(this.cachedMaxWidth, font.getStringWidth("HUD"));
            this.cachedMaxWidth = Math.max(this.cachedMaxWidth, font.getStringWidth("World"));
        }
        float totalWidth = this.cachedMaxWidth + padding * 2.0f + (modulesListModule.getSideLine().isValue() ? sideLineWidth : 0.0f);
        long visibleCount = this.sortedModules.stream().filter(entry -> entry.animation.getOutput() > (double)0.01f).count();
        float totalHeight = (float)visibleCount * (lineHeight + lineGap);
        int lineIndex = 0;
        for (ModuleEntry entry2 : this.sortedModules) {
            float lineX;
            float textX;
            float backgroundX;
            String displayName;
            Animation animation = entry2.animation;
            float animationProgress = animation.getOutput().floatValue();
            if (animationProgress < 0.01f) continue;
            if (entry2.module != null) {
                displayName = this.getModuleName(entry2.module, modulesListModule);
            } else {
                if (entry2.categoryLabel == null) continue;
                displayName = entry2.categoryLabel;
            }
            float textWidth = font.getStringWidth(displayName);
            float lineWidth = textWidth + padding * 2.0f + (modulesListModule.getSideLine().isValue() ? sideLineWidth : 0.0f);
            float backgroundWidth = textWidth + padding * 2.0f;
            float animatedY = (float)this.getY() + entry2.currentY;
            if (isRightSide) {
                gap = -0.4f;
                backgroundX = (float)this.getX() + totalWidth - lineWidth + (modulesListModule.getSideLine().isValue() ? sideLineWidth + gap : 0.0f);
                textX = backgroundX + padding;
                lineX = (float)this.getX() + totalWidth - sideLineWidth;
            } else {
                gap = -2.1f;
                backgroundX = (float)this.getX() + (modulesListModule.getSideLine().isValue() ? sideLineWidth + gap : 0.0f);
                textX = backgroundX + padding;
                lineX = this.getX();
            }
            float finalBackgroundX = backgroundX;
            float finalTextX = textX;
            float finalLineX = lineX;
            float slideOffset = (1.0f - animationProgress) * 20.0f * (float)(isRightSide ? 1 : -1);
            int currentLineIndex = lineIndex++;
            MathUtil.setAlpha(animationProgress, () -> {
                int lineColor;
                matrix.method_22903();
                matrix.method_46416(slideOffset, 0.0f, 0.0f);
                if (modulesListModule.getShowBackground().isValue()) {
                    blur.render(ShapeProperties.create(matrix, finalBackgroundX, animatedY, backgroundWidth, lineHeight).round(3.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
                }
                if (modulesListModule.getSideLine().isValue()) {
                    lineColor = modulesListModule.getGradientSideLine().isValue() ? ColorUtil.fade(currentLineIndex, 20) : ColorUtil.getClientColor();
                    rectangle.render(ShapeProperties.create(matrix, finalLineX, animatedY, sideLineWidth, lineHeight + 0.45f).color(lineColor).build());
                } else {
                    lineColor = ColorUtil.getClientColor();
                }
                float textY = animatedY + 4.0f;
                if (modulesListModule.getGradientText().isValue()) {
                    int textColor = modulesListModule.getGradientSideLine().isValue() ? lineColor : ColorUtil.fade(currentLineIndex, 70);
                    font.drawString(matrix, displayName, finalTextX, textY, textColor);
                } else {
                    font.drawString(matrix, displayName, finalTextX, textY, ColorUtil.getText());
                }
                matrix.method_22909();
            });
        }
        this.setWidth((int)totalWidth);
        this.setHeight((int)totalHeight);
    }

    @NotNull
    private String getPlaceholder() {
        List<Module> modules = Main.getInstance().getModuleProvider().getModules();
        long totalEnabledCount = modules.stream().filter(Module::isEnabled).count();
        long hudModulesCount = modules.stream().filter(Module::isEnabled).filter(module -> module.getCategory().name().equals("HUD")).count();
        return totalEnabledCount == 0L ? "No active modules" : (totalEnabledCount == hudModulesCount ? "Enable non-HUD modules" : "Modules List");
    }

    private String getModuleName(Module module, padej.soup.implement.features.modules.hud.ModulesList modulesListModule) {
        String name = module.getLocalizedName();
        if (modulesListModule.getLowercase().isValue()) {
            name = name.toLowerCase();
        }
        return name;
    }

    private int countAllSettings(Module module) {
        int count = 0;
        for (Setting setting : module.settings()) {
            ++count;
            if (!(setting instanceof GroupSetting)) continue;
            GroupSetting groupSetting = (GroupSetting)setting;
            count += this.countSettingsInGroup(groupSetting);
        }
        return count;
    }

    private int countSettingsInGroup(GroupSetting group) {
        int count = 0;
        for (Setting setting : group.getSubSettings()) {
            ++count;
            if (!(setting instanceof GroupSetting)) continue;
            GroupSetting nestedGroup = (GroupSetting)setting;
            count += this.countSettingsInGroup(nestedGroup);
        }
        return count;
    }

    private static class ModuleEntry {
        Module module;
        Animation animation;
        float targetY;
        float currentY;
        String categoryLabel;

        ModuleEntry(Module module, Animation animation, float targetY, float currentY) {
            this.module = module;
            this.animation = animation;
            this.targetY = targetY;
            this.currentY = currentY;
            this.categoryLabel = null;
        }

        ModuleEntry(String categoryLabel, Animation animation, float targetY, float currentY) {
            this.module = null;
            this.animation = animation;
            this.targetY = targetY;
            this.currentY = currentY;
            this.categoryLabel = categoryLabel;
        }
    }
}

