/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.PlayerIntersectionUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.Instance;
import padej.soup.implement.events.container.SetScreenEvent;
import padej.soup.implement.features.modules.hud.Icons;

public class Notifications
extends AbstractDraggable {
    private final List<Notification> list = new ArrayList<Notification>();
    private final List<Stack> stacks = new ArrayList<Stack>();

    public static Notifications getInstance() {
        return Instance.getDraggable(Notifications.class);
    }

    public Notifications() {
        super("Notifications", 0, 50, 100, 15, true);
    }

    @Override
    public void tick() {
        this.list.forEach(notif -> {
            if (System.currentTimeMillis() > notif.removeTime || notif.text.getString().contains("\u041f\u0440\u0438\u043c\u0435\u0440 \u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f") && !PlayerIntersectionUtil.isChat(Notifications.mc.field_1755)) {
                notif.anim.setDirection(Direction.BACKWARDS);
            }
        });
        this.list.removeIf(notif -> notif.anim.isFinished(Direction.BACKWARDS));
        while (!this.stacks.isEmpty()) {
            this.addTextIfNotEmpty(TypePickUp.INVENTORY, "\u041f\u043e\u0434\u043d\u044f\u0442\u044b \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b: ");
            this.addTextIfNotEmpty(TypePickUp.SHULKER_INVENTORY, "\u0421\u043b\u043e\u0436\u0435\u043d\u044b \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0432 \u0448\u0430\u043b\u043a\u0435\u0440: ");
            this.addTextIfNotEmpty(TypePickUp.SHULKER, "\u041f\u043e\u0434\u043d\u044f\u0442 \u0448\u0430\u043b\u043a\u0435\u0440 \u0441: ");
        }
    }

    @Override
    public void setScreen(SetScreenEvent e) {
        if (e.getScreen() instanceof class_408) {
            this.addList("\u041f\u0440\u0438\u043c\u0435\u0440 \u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f", Integer.MAX_VALUE);
        }
    }

    @Override
    public void drawDraggable(class_332 context) {
        class_4587 matrix = context.method_51448();
        FontRenderer font = Fonts.getSize(12, Fonts.Type.INTER_DEFAULT);
        this.setX((window.method_4486() - this.getWidth()) / 2);
        float offsetY = 0.0f;
        float iconSize = 8.0f;
        float iconGap = 3.0f;
        float padding = 5.0f;
        padej.soup.implement.features.modules.hud.Notifications notificationsModule = padej.soup.implement.features.modules.hud.Notifications.getInstance();
        for (Notification notification : this.list) {
            float anim = notification.anim.getOutput().floatValue();
            float textWidth = font.getStringWidth(notification.text);
            float width = iconSize + iconGap + textWidth + padding * 2.0f;
            float startY = (float)this.getY() + offsetY;
            float startX = (float)this.getX() + ((float)this.getWidth() - width) / 2.0f;
            MathUtil.setAlpha(anim, () -> {
                blur.render(ShapeProperties.create(matrix, startX, startY, width, this.getHeight()).round(3.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
                Icons iconsModule = Icons.getInstance();
                int iconColor = !iconsModule.getColoredIcons().isValue() ? ColorUtil.getText() : (iconsModule.getIconGradient().isValue() ? ColorUtil.fade(8) : ColorUtil.getClientColor());
                image.setTexture("textures/bell.png").render(ShapeProperties.create(matrix, startX + padding, startY + 3.5f, iconSize, iconSize).color(iconColor).build());
                font.drawText(matrix, notification.text, (int)(startX + padding + iconSize + iconGap), startY + 6.5f);
            });
            offsetY += (float)(this.getHeight() + 3) * anim;
        }
    }

    private void addTextIfNotEmpty(TypePickUp type, String prefix) {
        class_5250 text = class_2561.method_43473();
        List<Stack> list = this.stacks.stream().filter(stack -> stack.type.equals((Object)type)).toList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Stack stack2 = list.get(i);
            if (stack2.type != type) continue;
            text.method_10852((class_2561)stack2.text);
            this.stacks.remove(stack2);
            if (text.getString().length() > 150) break;
            if (i + 1 == size) continue;
            text.method_27693(" ,  ");
        }
        if (!text.equals((Object)class_2561.method_43473())) {
            this.addList((class_2561)class_2561.method_43473().method_27693(prefix).method_10852((class_2561)text), 8000L);
        }
    }

    public void addList(String text, long removeTime) {
        this.addList(text, removeTime, null);
    }

    public void addList(class_2561 text, long removeTime) {
        this.addList(text, removeTime, null);
    }

    public void addList(String text, long removeTime, class_3414 sound) {
        this.addList((class_2561)class_2561.method_43473().method_27693(text), removeTime, sound);
    }

    public void addList(class_2561 text, long removeTime, class_3414 sound) {
        this.list.add(new Notification(text, new DecelerateAnimation().setMs(300).setValue(1.0), System.currentTimeMillis() + removeTime));
        if (this.list.size() > 12) {
            this.list.removeFirst();
        }
        this.list.sort(Comparator.comparingDouble(notif -> -notif.removeTime));
        if (sound != null) {
            SoundManager.playSound(sound);
        }
    }

    public static enum TypePickUp {
        INVENTORY,
        SHULKER,
        SHULKER_INVENTORY;

    }

    public record Notification(class_2561 text, Animation anim, long removeTime) {
    }

    public record Stack(TypePickUp type, class_5250 text) {
    }
}

