/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2596;
import net.minecraft.class_2678;
import net.minecraft.class_2718;
import net.minecraft.class_2724;
import net.minecraft.class_2783;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.PlayerIntersectionUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.StringUtil;
import padej.soup.base.util.render.Render2DUtil;
import padej.soup.implement.events.packet.PacketEvent;
import padej.soup.implement.features.modules.hud.Icons;

public class Potions
extends AbstractDraggable {
    private final List<Potion> list = new ArrayList<Potion>();

    public Potions() {
        super("Potions", 210, 10, 80, 23, true);
    }

    @Override
    public boolean visible() {
        return !this.list.isEmpty() || PlayerIntersectionUtil.isChat(Potions.mc.field_1755);
    }

    @Override
    public void tick() {
        this.list.removeIf(p -> p.anim.isFinished(Direction.BACKWARDS));
        this.list.forEach(p -> p.effect.method_5585((class_1309)Potions.mc.field_1724, null));
        if (Potions.mc.field_1724 != null) {
            for (class_1293 playerEffect : Potions.mc.field_1724.method_6026()) {
                boolean exists = this.list.stream().anyMatch(p -> p.effect.method_5579().method_55840().equals(playerEffect.method_5579().method_55840()));
                if (exists) continue;
                this.list.add(new Potion(playerEffect, new DecelerateAnimation().setMs(150).setValue(1.0)));
            }
        }
    }

    @Override
    public void packet(PacketEvent e) {
        class_2596<?> class_25962 = e.getPacket();
        Objects.requireNonNull(class_25962);
        class_2596<?> class_25963 = class_25962;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2783.class, class_2718.class, class_2724.class, class_2678.class}, class_25963, n)) {
            case 0: {
                class_2783 effect = (class_2783)class_25963;
                if (PlayerIntersectionUtil.nullCheck() || effect.method_11943() != Objects.requireNonNull(Potions.mc.field_1724).method_5628()) break;
                class_6880 effectId = effect.method_11946();
                this.list.stream().filter(p -> p.effect.method_5579().method_55840().equals(effectId.method_55840())).forEach(s -> s.anim.setDirection(Direction.BACKWARDS));
                this.list.add(new Potion(new class_1293(effectId, effect.method_11944(), effect.method_11945(), effect.method_11950(), effect.method_11949(), effect.method_11942()), new DecelerateAnimation().setMs(150).setValue(1.0)));
                break;
            }
            case 1: {
                class_2718 effect = (class_2718)class_25963;
                this.list.stream().filter(s -> s.effect.method_5579().method_55840().equals(effect.comp_2176().method_55840())).forEach(s -> s.anim.setDirection(Direction.BACKWARDS));
                break;
            }
            case 2: {
                class_2724 ignored = (class_2724)class_25963;
                this.list.clear();
                break;
            }
            case 3: {
                class_2678 ignored = (class_2678)class_25963;
                this.list.clear();
                break;
            }
        }
    }

    @Override
    public void drawDraggable(class_332 context) {
        class_4587 matrix = context.method_51448();
        FontRenderer font = Fonts.getSize(15, Fonts.Type.INTER_DEFAULT);
        FontRenderer fontPotion = Fonts.getSize(13, Fonts.Type.INTER_DEFAULT);
        padej.soup.implement.features.modules.hud.Potions potionsModule = padej.soup.implement.features.modules.hud.Potions.getInstance();
        float headerHeight = 16.0f;
        float padding = 5.0f;
        boolean showHeader = potionsModule.getShowHeader().isValue();
        boolean darkenHeader = potionsModule.getDarkenHeader().isValue();
        if (showHeader) {
            int headerColor = darkenHeader ? ColorUtil.getRectDarker(0.9f) : ColorUtil.getRect(0.7f);
            blur.render(ShapeProperties.create(matrix, this.getX(), this.getY(), this.getWidth(), headerHeight).round(4.0f, 0.0f, 4.0f, 0.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(headerColor).build());
            blur.render(ShapeProperties.create(matrix, this.getX(), (float)this.getY() + headerHeight, this.getWidth(), (float)this.getHeight() - headerHeight).round(0.0f, 4.0f, 0.0f, 4.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        } else {
            blur.render(ShapeProperties.create(matrix, this.getX(), this.getY(), this.getWidth(), this.getHeight()).round(4.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
        }
        float centerX = (float)this.getX() + (float)this.getWidth() / 2.0f;
        int offset = showHeader ? (int)(headerHeight + 7.0f) : 7;
        int maxWidth = 80;
        if (showHeader) {
            font.drawString(matrix, this.getName(), (int)((float)this.getX() + padding), (int)((float)this.getY() + 6.5f), ColorUtil.getText());
            float iconSize = 8.0f;
            float iconPadding = 4.0f;
            Icons iconsModule = Icons.getInstance();
            int iconColor = !iconsModule.getColoredIcons().isValue() ? ColorUtil.getText() : (iconsModule.getIconGradient().isValue() ? ColorUtil.fade(8) : ColorUtil.getClientColor());
            image.setTexture("textures/potion.png").render(ShapeProperties.create(matrix, (float)(this.getX() + this.getWidth()) - iconSize - iconPadding, this.getY() + 4, iconSize, iconSize).color(iconColor).build());
        }
        for (Potion potion : this.list) {
            Object lvl;
            class_1293 effect = potion.effect;
            float animation = potion.anim.getOutput().floatValue();
            float centerY = this.getY() + offset;
            int amplifier = effect.method_5578();
            String name = ((class_1291)effect.method_5579().comp_349()).method_5560().getString();
            String duration = this.getDuration(effect);
            if (amplifier > 0) {
                String levelStr = potionsModule.getRomanNumerals().isValue() ? StringUtil.toRoman(amplifier + 1) : String.valueOf(amplifier + 1);
                lvl = " " + levelStr;
            } else {
                lvl = "";
            }
            MathUtil.scale(matrix, centerX, centerY, 1.0f, animation, () -> this.lambda$drawDraggable$7(matrix, effect, centerY, potionsModule, fontPotion, name, (String)lvl, duration));
            int width = (int)fontPotion.getStringWidth(name + (String)lvl + duration) + 30;
            maxWidth = Math.max(width, maxWidth);
            offset += (int)(11.0f * animation);
        }
        this.setWidth(maxWidth);
        this.setHeight(offset);
    }

    private String getDuration(class_1293 pe) {
        int var1 = pe.method_5584();
        int mins = var1 / 1200;
        return pe.method_48559() || mins > 60 ? "**:**" : mins + ":" + String.format("%02d", var1 % 1200 / 20);
    }

    private /* synthetic */ void lambda$drawDraggable$7(class_4587 matrix, class_1293 effect, float centerY, padej.soup.implement.features.modules.hud.Potions potionsModule, FontRenderer fontPotion, String name, String lvl, String duration) {
        int durationColor;
        boolean isBeneficial;
        Render2DUtil.drawSprite(matrix, mc.method_18505().method_18663(effect.method_5579()), this.getX() + 5, (int)centerY - 2, 8.0f, 8);
        rectangle.render(ShapeProperties.create(matrix, this.getX() + 14, centerY - 1.0f, 0.5, 7.0).color(ColorUtil.getOutline(0.75f, 0.5f)).build());
        int nameColor = potionsModule.getColoredEffects().isValue() ? ((isBeneficial = ((class_1291)effect.method_5579().comp_349()).method_5573()) ? -11141291 : -43691) : ColorUtil.getText();
        if (effect.method_5584() != -1 && effect.method_5584() <= 120) {
            float blinkProgress = MathUtil.blinking(1000.0, 8.0f);
            durationColor = ColorUtil.overCol(ColorUtil.getText(), -43691, blinkProgress);
        } else {
            durationColor = ColorUtil.getText();
        }
        fontPotion.drawString(matrix, name + lvl, this.getX() + 18, centerY + 1.0f, nameColor);
        fontPotion.drawString(matrix, duration, (float)(this.getX() + this.getWidth() - 5) - fontPotion.getStringWidth(duration), centerY + 1.0f, durationColor);
    }

    private record Potion(class_1293 effect, Animation anim) {
    }
}

