/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_239;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector4d;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.animation.implement.EaseInOutAnimation;
import padej.soup.api.system.animation.implement.LinearAnimation;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.PlayerIntersectionUtil;
import padej.soup.base.util.entity.VisibleUtils;
import padej.soup.base.util.item.ItemUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.math.ProjectionUtil;
import padej.soup.base.util.other.StopWatch;
import padej.soup.base.util.render.Render2DUtil;
import padej.soup.base.util.render.ScissorManager;
import padej.soup.base.util.render.TargetHudRenderer;
import padej.soup.base.util.spatial.SpatialGrid2D;
import padej.soup.core.Main;
import padej.soup.core.server.ServerLimitCfg;
import padej.soup.implement.features.draggables.particles.TargetHudParticle;
import padej.soup.implement.features.modules.particles.render.ParticleBatchRenderer;

public class TargetHud
extends AbstractDraggable {
    private final Animation animation = new DecelerateAnimation().setMs(200).setValue(1.0);
    private final Animation healthAnimation = new DecelerateAnimation().setMs(150).setValue(1.0);
    private final StopWatch stopWatch = new StopWatch();
    private class_1309 targetEntity;
    private class_1309 lastTarget;
    private long lastTargetTime;
    private class_1792 lastItem = class_1802.field_8162;
    private float health = 0.0f;
    private float targetHealth = 0.0f;
    private float animatedHealth = 0.0f;
    private String lastAnimationType = "Decelerate";
    private final List<TargetHudParticle> particles = new ArrayList<TargetHudParticle>();
    private final List<TargetHudParticle> networkParticles = new ArrayList<TargetHudParticle>();
    private SpatialGrid2D<TargetHudParticle> spatialGrid;
    private boolean sentParticles = false;
    private int lastHurtTime = 0;

    public TargetHud() {
        super("TargetHud", 10, 40, 100, 36, true);
    }

    @Override
    public boolean visible() {
        return this.scaleAnimation.isDirection(Direction.FORWARDS);
    }

    private void updateScaleAnimation() {
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        String currentType = hudModule.animationType.getSelected();
        int currentSpeed = (int)hudModule.animationSpeed.getValue();
        if (!currentType.equals(this.lastAnimationType) || this.scaleAnimation.getMs() != currentSpeed) {
            this.lastAnimationType = currentType;
            Direction currentDirection = this.scaleAnimation.isDirection(Direction.FORWARDS) ? Direction.FORWARDS : Direction.BACKWARDS;
            Animation newAnimation = switch (currentType) {
                case "Linear" -> new LinearAnimation();
                case "EaseInOut" -> new EaseInOutAnimation();
                default -> new DecelerateAnimation();
            };
            newAnimation.setMs(currentSpeed);
            newAnimation.setValue(1.0);
            newAnimation.setDirection(currentDirection);
            try {
                Field field = AbstractDraggable.class.getDeclaredField("scaleAnimation");
                field.setAccessible(true);
                field.set(this, newAnimation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void renderParticlesAlways(class_332 context) {
        if (!this.particles.isEmpty() || !this.networkParticles.isEmpty()) {
            class_4587 matrices = context.method_51448();
            this.renderParticlesIndependent(context);
            this.renderNetworkLinksIndependent(matrices);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawDraggable(class_332 context) {
        if (this.lastTarget != null && VisibleUtils.canBeTargeted(this.lastTarget)) {
            float scale;
            padej.soup.implement.features.modules.hud.TargetHud hudModule;
            class_4587 matrix;
            block20: {
                matrix = context.method_51448();
                this.updateDimensionsForStyle();
                hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
                scale = hudModule.scale.getValue();
                matrix.method_22903();
                if (hudModule.displayMode.getSelected().equals("3D")) {
                    String anchor = hudModule.anchor.getSelected();
                    Vector4d projection = ProjectionUtil.getVector4DForAnchor((class_1297)this.lastTarget, anchor);
                    if (projection != null && !ProjectionUtil.cantSee(projection)) {
                        double centerX = ProjectionUtil.centerX(projection);
                        double centerY = projection.y;
                        switch (anchor) {
                            case "HEAD": {
                                centerY -= (double)((float)this.getHeight() / 2.0f + 5.0f);
                                break;
                            }
                            case "BODY": {
                                break;
                            }
                            case "FEET": {
                                centerY += (double)((float)this.getHeight() / 2.0f + 5.0f);
                                break;
                            }
                        }
                        double hudX = centerX + (double)hudModule.xOffset.getValue();
                        matrix.method_22904(hudX, centerY, 0.0);
                        break block20;
                    } else {
                        matrix.method_22909();
                        return;
                    }
                }
                matrix.method_46416((float)this.getX() + (float)this.getWidth() / 2.0f, (float)this.getY() + (float)this.getHeight() / 2.0f, 0.0f);
            }
            float animationValue = this.scaleAnimation.getOutput().floatValue();
            String animationMode = hudModule.animationMode.getSelected();
            float scaleMultiplier = 1.0f;
            if (animationMode.equals("Scale") || animationMode.equals("Both")) {
                scaleMultiplier = animationValue;
            }
            matrix.method_22905(scale * scaleMultiplier, scale * scaleMultiplier, 1.0f);
            matrix.method_46416((float)(-this.getWidth()) / 2.0f, (float)(-this.getHeight()) / 2.0f, 0.0f);
            this.drawUsingItem(context, matrix);
            float alpha = 1.0f;
            if (animationMode.equals("Fade") || animationMode.equals("Both")) {
                alpha = animationValue;
            }
            if (this.lastTarget != null) {
                float currentHealth = this.health;
                if (this.targetHealth > 0.0f) {
                    float healthProgress = this.healthAnimation.getOutput().floatValue();
                    this.animatedHealth = class_3532.method_16439((float)healthProgress, (float)currentHealth, (float)this.targetHealth);
                    this.animatedHealth = class_3532.method_15363((float)this.animatedHealth, (float)2.0f, (float)61.0f);
                    if (this.healthAnimation.isDone()) {
                        this.health = this.targetHealth;
                    }
                } else {
                    this.animatedHealth = currentHealth;
                }
            }
            MathUtil.setAlpha(alpha, () -> {
                switch (hudModule.style.getSelected()) {
                    case "Default": {
                        TargetHudRenderer.renderStyleZenith(context, this.lastTarget, 0.0f, 0.0f, this.getWidth(), this.getHeight(), ServerLimitCfg.showHp(this.lastTarget) ? this.animatedHealth : 61.0f);
                        break;
                    }
                    case "Round": {
                        TargetHudRenderer.renderStyleAres(context, this.lastTarget, 0.0f, 0.0f, this.getWidth(), this.getHeight(), ServerLimitCfg.showHp(this.lastTarget) ? this.animatedHealth : 61.0f);
                    }
                }
            });
            matrix.method_22909();
        }
    }

    private void renderNetworkLinksIndependent(class_4587 matrices) {
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        if (this.networkParticles.size() < 2 || this.spatialGrid == null) {
            return;
        }
        matrices.method_22903();
        if (hudModule.displayMode.getSelected().equals("3D") && this.lastTarget != null) {
            String anchor = hudModule.anchor.getSelected();
            Vector4d projection = ProjectionUtil.getVector4DForAnchor((class_1297)this.lastTarget, anchor);
            if (projection != null && !ProjectionUtil.cantSee(projection)) {
                double centerX = ProjectionUtil.centerX(projection);
                double centerY = projection.y;
                switch (anchor) {
                    case "HEAD": {
                        centerY -= (double)((float)this.getHeight() / 2.0f + 5.0f);
                        break;
                    }
                    case "BODY": {
                        break;
                    }
                    case "FEET": {
                        centerY += (double)((float)this.getHeight() / 2.0f + 5.0f);
                    }
                }
                double hudX = centerX + (double)hudModule.xOffset.getValue();
                matrices.method_22904(hudX, centerY, 0.0);
                float scale = hudModule.scale.getValue();
                matrices.method_22905(scale, scale, 1.0f);
                matrices.method_46416((float)(-this.getWidth()) / 2.0f, (float)(-this.getHeight()) / 2.0f, 0.0f);
                this.renderNetworkLinksInternal(matrices);
            }
        } else {
            matrices.method_46416((float)this.getX() + (float)this.getWidth() / 2.0f, (float)this.getY() + (float)this.getHeight() / 2.0f, 0.0f);
            float scale = hudModule.scale.getValue();
            matrices.method_22905(scale, scale, 1.0f);
            matrices.method_46416((float)(-this.getWidth()) / 2.0f, (float)(-this.getHeight()) / 2.0f, 0.0f);
            this.renderNetworkLinksInternal(matrices);
        }
        matrices.method_22909();
    }

    private void renderNetworkLinksInternal(class_4587 matrices) {
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        float maxLinkDistance = hudModule.linkDistance.getValue();
        int maxLinksPerNode = (int)hudModule.maxLinks.getValue();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        HashSet<ParticlePair2D> processedPairs = new HashSet<ParticlePair2D>();
        HashMap<TargetHudParticle, Integer> linkCounts = new HashMap<TargetHudParticle, Integer>();
        int lineCount = 0;
        block0: for (TargetHudParticle p1 : this.networkParticles) {
            int p1LinkCount = linkCounts.getOrDefault(p1, 0);
            if (p1LinkCount >= maxLinksPerNode) continue;
            float posX1 = MathUtil.interpolate(p1.getPrevX(), p1.getX());
            float posY1 = MathUtil.interpolate(p1.getPrevY(), p1.getY());
            List<SpatialGrid2D.GridEntry2D<TargetHudParticle>> nearbyEntries = this.spatialGrid.queryRadiusWithPositions(posX1, posY1, maxLinkDistance);
            nearbyEntries.sort((a, b) -> {
                float dx1 = a.getX() - posX1;
                float dy1 = a.getY() - posY1;
                float dist1 = dx1 * dx1 + dy1 * dy1;
                float dx2 = b.getX() - posX1;
                float dy2 = b.getY() - posY1;
                float dist2 = dx2 * dx2 + dy2 * dy2;
                return Float.compare(dist1, dist2);
            });
            for (SpatialGrid2D.GridEntry2D<TargetHudParticle> entry : nearbyEntries) {
                float posY2;
                float dy;
                ParticlePair2D pair;
                int p2LinkCount;
                TargetHudParticle p2 = entry.getObject();
                if (p1 == p2 || (p2LinkCount = linkCounts.getOrDefault(p2, 0).intValue()) >= maxLinksPerNode || processedPairs.contains(pair = new ParticlePair2D(p1, p2))) continue;
                if (p1LinkCount >= maxLinksPerNode) continue block0;
                float posX2 = entry.getX();
                float dx = posX2 - posX1;
                float dist = (float)Math.sqrt(dx * dx + (dy = (posY2 = entry.getY()) - posY1) * dy);
                if (!(dist < maxLinkDistance) || !(dist > 0.01f)) continue;
                float lineAlpha = 1.0f - dist / maxLinkDistance;
                float particleAlpha1 = p1.getAlpha();
                float particleAlpha2 = p2.getAlpha();
                float alpha = Math.min(lineAlpha, Math.min(particleAlpha1, particleAlpha2));
                int baseColor = ColorUtil.getClientColor();
                int color = ColorUtil.multAlpha(baseColor, alpha);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b2 = color & 0xFF;
                int a2 = (int)(alpha * 255.0f);
                bufferBuilder.method_22918(matrix, posX1, posY1, 0.0f).method_1336(r, g, b2, a2);
                bufferBuilder.method_22918(matrix, posX2, posY2, 0.0f).method_1336(r, g, b2, a2);
                ++lineCount;
                processedPairs.add(pair);
                linkCounts.put(p1, p1LinkCount + 1);
                linkCounts.put(p2, p2LinkCount + 1);
                ++p1LinkCount;
            }
        }
        if (lineCount > 0) {
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
        RenderSystem.disableBlend();
    }

    private void renderParticlesIndependent(class_332 context) {
        if (this.particles.isEmpty()) {
            return;
        }
        class_4587 matrices = context.method_51448();
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        matrices.method_22903();
        if (hudModule.displayMode.getSelected().equals("3D") && this.lastTarget != null) {
            String anchor = hudModule.anchor.getSelected();
            Vector4d projection = ProjectionUtil.getVector4DForAnchor((class_1297)this.lastTarget, anchor);
            if (projection != null && !ProjectionUtil.cantSee(projection)) {
                double centerX = ProjectionUtil.centerX(projection);
                double centerY = projection.y;
                switch (anchor) {
                    case "HEAD": {
                        centerY -= (double)((float)this.getHeight() / 2.0f + 5.0f);
                        break;
                    }
                    case "BODY": {
                        break;
                    }
                    case "FEET": {
                        centerY += (double)((float)this.getHeight() / 2.0f + 5.0f);
                    }
                }
                double hudX = centerX + (double)hudModule.xOffset.getValue();
                matrices.method_22904(hudX, centerY, 0.0);
                float scale = hudModule.scale.getValue();
                matrices.method_22905(scale, scale, 1.0f);
                matrices.method_46416((float)(-this.getWidth()) / 2.0f, (float)(-this.getHeight()) / 2.0f, 0.0f);
                this.renderParticlesInternal(matrices);
            }
        } else {
            matrices.method_46416((float)this.getX() + (float)this.getWidth() / 2.0f, (float)this.getY() + (float)this.getHeight() / 2.0f, 0.0f);
            float scale = hudModule.scale.getValue();
            matrices.method_22905(scale, scale, 1.0f);
            matrices.method_46416((float)(-this.getWidth()) / 2.0f, (float)(-this.getHeight()) / 2.0f, 0.0f);
            this.renderParticlesInternal(matrices);
        }
        matrices.method_22909();
    }

    private void renderParticlesInternal(class_4587 matrices) {
        String anchor;
        Vector4d projection;
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        float depthFactor = 1.0f;
        if (hudModule.displayMode.getSelected().equals("3D") && this.lastTarget != null && (projection = ProjectionUtil.getVector4DForAnchor((class_1297)this.lastTarget, anchor = hudModule.anchor.getSelected())) != null) {
            depthFactor = class_3532.method_15363((float)(1.0f - (float)projection.z / 10.0f), (float)0.1f, (float)1.0f);
        }
        HashMap<class_2960, List<ParticleRenderData>> texturedBatches = new HashMap<class_2960, List<ParticleRenderData>>();
        ArrayList<ParticleRenderData> bloomParticles = new ArrayList<ParticleRenderData>();
        for (TargetHudParticle particle : this.particles) {
            if (particle.getAlpha() <= 0.01f || particle.isNetworkParticle()) continue;
            float interpolatedX = MathUtil.interpolate(particle.getPrevX(), particle.getX());
            float interpolatedY = MathUtil.interpolate(particle.getPrevY(), particle.getY());
            float finalScale = hudModule.particleSize.getValue() * depthFactor;
            ParticleRenderData data = new ParticleRenderData(particle, interpolatedX, interpolatedY, finalScale);
            if (particle.getType() == TargetHudParticle.ParticleType.CUBE || particle.getType() == TargetHudParticle.ParticleType.PYRAMID) {
                bloomParticles.add(data);
                particle.render(matrices, 0.0f, 0.0f, depthFactor);
                continue;
            }
            class_2960 texture = particle.getTextureForType();
            if (texture == null) continue;
            texturedBatches.computeIfAbsent(texture, k -> new ArrayList()).add(data);
        }
        this.renderTexturedBatches(matrices, texturedBatches);
        ParticleBatchRenderer.renderBatches();
    }

    private void renderTexturedBatches(class_4587 matrices, Map<class_2960, List<ParticleRenderData>> batches) {
        if (batches.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        for (Map.Entry<class_2960, List<ParticleRenderData>> entry : batches.entrySet()) {
            class_2960 texture = entry.getKey();
            List<ParticleRenderData> batchData = entry.getValue();
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            for (ParticleRenderData data : batchData) {
                matrices.method_22903();
                matrices.method_46416(data.x, data.y, 0.0f);
                matrices.method_22905(data.scale, data.scale, data.scale);
                float interpolatedRotation = MathUtil.interpolate(data.particle.getPrevRotation(), data.particle.getRotation());
                matrices.method_22907(class_7833.field_40718.rotationDegrees(interpolatedRotation));
                int r = data.particle.getColor().getRed();
                int g = data.particle.getColor().getGreen();
                int b = data.particle.getColor().getBlue();
                int a = (int)(data.particle.getAlpha() * 255.0f);
                float halfSize = 0.5f;
                Matrix4f matrix = matrices.method_23760().method_23761();
                bufferBuilder.method_22918(matrix, -halfSize, halfSize, 0.0f).method_22913(0.0f, 1.0f).method_1336(r, g, b, a);
                bufferBuilder.method_22918(matrix, halfSize, halfSize, 0.0f).method_22913(1.0f, 1.0f).method_1336(r, g, b, a);
                bufferBuilder.method_22918(matrix, halfSize, -halfSize, 0.0f).method_22913(1.0f, 0.0f).method_1336(r, g, b, a);
                bufferBuilder.method_22918(matrix, -halfSize, -halfSize, 0.0f).method_22913(0.0f, 0.0f).method_1336(r, g, b, a);
                matrices.method_22909();
            }
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private void updateParticles() {
        this.particles.removeIf(particle -> {
            boolean isDead = particle.update();
            if (isDead && particle.isNetworkParticle()) {
                this.networkParticles.remove(particle);
                if (this.spatialGrid != null) {
                    this.spatialGrid.remove((TargetHudParticle)particle, particle.getX(), particle.getY());
                }
            }
            return isDead;
        });
        if (this.spatialGrid != null && !this.networkParticles.isEmpty()) {
            for (TargetHudParticle particle2 : this.networkParticles) {
                this.spatialGrid.update(particle2, particle2.getX(), particle2.getY(), particle2.getX(), particle2.getY());
            }
        }
    }

    private String getRandomMode() {
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        List<String> selected = hudModule.particleMode.getSelected();
        if (selected.isEmpty()) {
            return "Stars";
        }
        return selected.get((int)(Math.random() * (double)selected.size()));
    }

    private void spawnParticlesOnHurt() {
        double spawnY;
        double spawnX;
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        if (!hudModule.particles.isValue() || this.lastTarget == null) {
            return;
        }
        int count = (int)hudModule.particleCount.getValue();
        float size = hudModule.particleSize.getValue();
        float speed = hudModule.particleSpeed.getValue();
        float lifetime = hudModule.particleLifetime.getValue();
        int[] customColors = hudModule.getCustomColors();
        if (hudModule.particleSpawnLoc.isSelected("HP Bar")) {
            float currentHealth = this.animatedHealth;
            spawnX = switch (hudModule.style.getSelected()) {
                case "Default" -> 34.0f + currentHealth;
                case "Round" -> {
                    float widthHp = 68.0f;
                    float healthBarWidth = currentHealth * widthHp / 61.0f;
                    yield 48.0f + healthBarWidth;
                }
                default -> 34.0f + currentHealth;
            };
            spawnY = switch (hudModule.style.getSelected()) {
                case "Default" -> 28.0;
                case "Round" -> 36.5;
                default -> 28.0;
            };
        } else {
            spawnX = switch (hudModule.style.getSelected()) {
                case "Default" -> 15.0;
                case "Round" -> 23.0;
                default -> 15.0;
            };
            spawnY = switch (hudModule.style.getSelected()) {
                case "Default" -> 18.0;
                case "Round" -> 23.0;
                default -> 18.0;
            };
        }
        for (int i = 0; i < count; ++i) {
            Color particleColor;
            String randomMode = this.getRandomMode();
            TargetHudParticle.ParticleType type = TargetHudParticle.parseType(randomMode);
            double motionX = (Math.random() * 2.0 - 1.0) * (double)speed;
            double motionY = (Math.random() * 2.0 - 1.0) * (double)speed;
            if (hudModule.particleColorMode.isSelected("Custom") && customColors != null && customColors.length > 0) {
                if (hudModule.particleColorAnimation.isSelected("Vertex")) {
                    int colorIndex = i % customColors.length;
                    particleColor = new Color(customColors[colorIndex], true);
                } else {
                    long time = System.currentTimeMillis();
                    float phase = ((float)time / 1000.0f + (float)i * 0.1f) % 1.0f;
                    int colorIndex = (int)(phase * (float)customColors.length);
                    particleColor = new Color(customColors[colorIndex], true);
                }
            } else {
                Color color1 = new Color(ColorUtil.getClientColor());
                Color color2 = new Color(ColorUtil.getClientColor(200.0f));
                double colorMix = (Math.sin((double)System.currentTimeMillis() * 0.001 + (double)i) + 1.0) * 0.5;
                particleColor = this.mixColors(color1, color2, colorMix);
            }
            TargetHudParticle particle = new TargetHudParticle((float)spawnX, (float)spawnY, (float)motionX, (float)motionY, size, particleColor, type, lifetime, hudModule.particleSpeed.getValue(), hudModule.particleMaxRadius.getValue(), "Fly");
            this.particles.add(particle);
            if (type != TargetHudParticle.ParticleType.NETWORK2D) continue;
            if (this.spatialGrid == null) {
                this.spatialGrid = new SpatialGrid2D(hudModule.linkDistance.getValue());
            }
            this.networkParticles.add(particle);
            this.spatialGrid.insert(particle, particle.getX(), particle.getY());
        }
    }

    private Color mixColors(Color c1, Color c2, double percent) {
        double inverse = 1.0 - percent;
        int r = (int)((double)c1.getRed() * percent + (double)c2.getRed() * inverse);
        int g = (int)((double)c1.getGreen() * percent + (double)c2.getGreen() * inverse);
        int b = (int)((double)c1.getBlue() * percent + (double)c2.getBlue() * inverse);
        return new Color(r, g, b);
    }

    @Override
    public void tick() {
        class_1309 displayTarget;
        class_1657 player;
        class_3966 entityHit;
        class_1297 class_12972;
        super.tick();
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        this.updateScaleAnimation();
        this.updateParticles();
        class_1309 previousTarget = this.targetEntity;
        class_239 class_2392 = TargetHud.mc.field_1765;
        this.targetEntity = class_2392 instanceof class_3966 ? ((class_12972 = (entityHit = (class_3966)class_2392).method_17782()) instanceof class_1657 && !(player = (class_1657)class_12972).method_29504() && player.method_5805() ? (VisibleUtils.canBeTargeted((class_1309)player) ? player : null) : null) : null;
        if (this.targetEntity != null && (this.targetEntity.method_29504() || !this.targetEntity.method_5805())) {
            this.targetEntity = null;
            if (previousTarget != null) {
                this.lastTargetTime = System.currentTimeMillis();
            }
        }
        if (previousTarget != null && this.targetEntity == null) {
            this.lastTargetTime = System.currentTimeMillis();
        }
        if ((displayTarget = this.getDisplayTarget()) != null) {
            this.lastTarget = displayTarget;
            if (hudModule.isEnabled() && ServerLimitCfg.showHp(displayTarget)) {
                int currentHurtTime = displayTarget.field_6235;
                if (currentHurtTime == 9 && !this.sentParticles && currentHurtTime != this.lastHurtTime) {
                    this.spawnParticlesOnHurt();
                    this.sentParticles = true;
                }
                if (currentHurtTime == 8) {
                    this.sentParticles = false;
                }
                this.lastHurtTime = currentHurtTime;
            }
            float hp = PlayerIntersectionUtil.getHealth(displayTarget);
            float widthHp = 61.0f;
            float newTargetHealth = hp / displayTarget.method_6063() * widthHp;
            if (this.health == 0.0f || Math.abs(this.targetHealth - newTargetHealth) > 0.1f) {
                if (this.health == 0.0f) {
                    this.health = newTargetHealth;
                    this.targetHealth = newTargetHealth;
                    this.animatedHealth = newTargetHealth;
                } else {
                    this.targetHealth = newTargetHealth;
                    this.healthAnimation.reset();
                    this.healthAnimation.setDirection(Direction.FORWARDS);
                }
            }
        }
        if (TargetHud.mc.field_1755 != null && TargetHud.mc.field_1724 != null && TargetHud.mc.field_1724.method_5805() && PlayerIntersectionUtil.isChat(TargetHud.mc.field_1755)) {
            this.lastTarget = TargetHud.mc.field_1724;
            this.startAnimation();
        } else {
            boolean shouldShow;
            boolean bl = shouldShow = displayTarget != null;
            if (shouldShow && !VisibleUtils.canBeTargeted(displayTarget)) {
                shouldShow = false;
            }
            if (shouldShow && hudModule.displayMode.getSelected().equals("3D")) {
                shouldShow = ProjectionUtil.canSeeEntity((class_1297)displayTarget);
            }
            if (shouldShow) {
                this.startAnimation();
            } else {
                this.stopAnimation();
            }
        }
    }

    private void drawUsingItem(class_332 context, class_4587 matrix) {
        if (this.lastTarget == null || !ServerLimitCfg.showItemUsingProgress()) {
            return;
        }
        this.animation.setDirection(this.lastTarget.method_6115() ? Direction.FORWARDS : Direction.BACKWARDS);
        if (!this.lastTarget.method_6030().method_7960() && this.lastTarget.method_6030().method_7947() != 0) {
            this.lastItem = this.lastTarget.method_6030().method_7909();
        }
        if (!this.animation.isFinished(Direction.BACKWARDS) && !this.lastItem.equals(class_1802.field_8162)) {
            int size = 24;
            float anim = this.animation.getOutput().floatValue();
            float progress = ((float)this.lastTarget.method_6048() + tickCounter.method_60637(false)) / (float)ItemUtil.maxUseTick(this.lastItem) * 360.0f;
            float x = (float)(-(size + 5)) * anim;
            float y = 6.0f;
            ScissorManager scissorManager = Main.getInstance().getScissorManager();
            scissorManager.push(matrix.method_23760().method_23761(), -50.0f, 0.0f, 50.0f, this.getHeight());
            MathUtil.setAlpha(anim, () -> {
                blur.render(ShapeProperties.create(matrix, x, y, size, size).round(12.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
                arc.render(ShapeProperties.create(matrix, x, y, size, size).round(0.4f).thickness(0.2f).end(progress).color(ColorUtil.fade(0), ColorUtil.fade(200), ColorUtil.fade(0), ColorUtil.fade(200)).build());
                Render2DUtil.defaultDrawStack(context, this.lastItem.method_7854(), x + 3.0f, y + 3.0f, false, false, 1.0f);
            });
            scissorManager.pop();
        }
    }

    private void updateDimensionsForStyle() {
        String selectedStyle;
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        switch (selectedStyle = hudModule.style.getSelected()) {
            case "Default": {
                this.setWidth(100);
                this.setHeight(36);
                break;
            }
            case "Round": {
                this.setWidth(120);
                this.setHeight(46);
            }
        }
    }

    private class_1309 getDisplayTarget() {
        if (this.targetEntity != null) {
            return this.targetEntity;
        }
        if (this.lastTarget != null) {
            padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
            long currentTime = System.currentTimeMillis();
            long liveTimeMs = (long)(hudModule.liveTime.getValue() * 1000.0f);
            if (hudModule.liveTime.getValue() == 0.0f) {
                return null;
            }
            if (currentTime - this.lastTargetTime < liveTimeMs) {
                if (this.lastTarget.method_29504() || !this.lastTarget.method_5805()) {
                    return null;
                }
                return this.lastTarget;
            }
        }
        return null;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        float scaledY;
        padej.soup.implement.features.modules.hud.TargetHud hudModule = padej.soup.implement.features.modules.hud.TargetHud.getInstance();
        float scale = hudModule.scale.getValue();
        float scaledWidth = (float)this.getWidth() * scale;
        float scaledHeight = (float)this.getHeight() * scale;
        float scaledX = (float)this.getX() + ((float)this.getWidth() - scaledWidth) / 2.0f;
        if (MathUtil.isHovered(mouseX, mouseY, scaledX, scaledY = (float)this.getY() + ((float)this.getHeight() - scaledHeight) / 2.0f, scaledWidth, scaledHeight) && button == 0 && this.isCanDrag()) {
            this.setDragging(true);
            this.setDragX(this.getX() - (int)mouseX);
            this.setDragY(this.getY() - (int)mouseY);
            return true;
        }
        return false;
    }

    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    private record ParticlePair2D(TargetHudParticle p1, TargetHudParticle p2) {
        private ParticlePair2D(TargetHudParticle p1, TargetHudParticle p2) {
            if (System.identityHashCode(p1) < System.identityHashCode(p2)) {
                this.p1 = p1;
                this.p2 = p2;
            } else {
                this.p1 = p2;
                this.p2 = p1;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParticlePair2D that = (ParticlePair2D)o;
            return this.p1 == that.p1 && this.p2 == that.p2;
        }

        @Override
        public int hashCode() {
            return 31 * System.identityHashCode(this.p1) + System.identityHashCode(this.p2);
        }
    }

    private record ParticleRenderData(TargetHudParticle particle, float x, float y, float scale) {
    }
}

