/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.implement.features.draggables.watermark.CPUComponent;
import padej.soup.implement.features.draggables.watermark.ClientIconComponent;
import padej.soup.implement.features.draggables.watermark.ClientNameComponent;
import padej.soup.implement.features.draggables.watermark.FPSComponent;
import padej.soup.implement.features.draggables.watermark.MemoryComponent;
import padej.soup.implement.features.draggables.watermark.PingComponent;
import padej.soup.implement.features.draggables.watermark.RoleComponent;
import padej.soup.implement.features.draggables.watermark.ServerIPComponent;
import padej.soup.implement.features.draggables.watermark.UserComponent;
import padej.soup.implement.features.draggables.watermark.WatermarkComponent;

public class Watermark
extends AbstractDraggable {
    private final List<WatermarkComponent> components = new ArrayList<WatermarkComponent>();

    public Watermark() {
        super("Watermark", 10, 10, 92, 16, true);
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.components.add(new ClientIconComponent());
        this.components.add(new ClientNameComponent());
        this.components.add(new RoleComponent());
        this.components.add(new UserComponent());
        this.components.add(new FPSComponent());
        this.components.add(new ServerIPComponent());
        this.components.add(new PingComponent());
        this.components.add(new MemoryComponent());
        this.components.add(new CPUComponent());
    }

    @Override
    public void tick() {
        for (WatermarkComponent component : this.components) {
            component.tick();
        }
    }

    @Override
    public void drawDraggable(class_332 e) {
        class_4587 matrix = e.method_51448();
        FontRenderer font = Fonts.getSize(15, Fonts.Type.INTER_DEFAULT);
        List<WatermarkComponent> enabledComponents = this.getEnabledComponents();
        if (enabledComponents.isEmpty()) {
            return;
        }
        boolean isSplitStyle = padej.soup.implement.features.modules.hud.Watermark.getInstance().style.isSelected("Split");
        if (isSplitStyle) {
            this.drawSplitStyle(matrix, font, enabledComponents);
        } else {
            this.drawMonoStyle(matrix, font, enabledComponents);
        }
    }

    private void drawMonoStyle(class_4587 matrix, FontRenderer font, List<WatermarkComponent> enabledComponents) {
        List<Object> lines;
        boolean hasIcon = enabledComponents.getFirst().getName().equals("Icon");
        float padding = 5.0f;
        float iconGap = 4.0f;
        float separatorSpacing = 10.0f;
        float lineGap = 4.0f;
        float lineHeight = 16.0f;
        float maxWidth = 300.0f;
        ArrayList<Float> componentWidths = new ArrayList<Float>();
        for (WatermarkComponent comp : enabledComponents) {
            componentWidths.add(Float.valueOf(comp.getSmoothedWidth(font, lineHeight)));
        }
        float totalWidth = 0.0f;
        for (int i = 0; i < enabledComponents.size(); ++i) {
            boolean isIcon = i == 0 && hasIcon;
            float componentWidth = ((Float)componentWidths.get(i)).floatValue();
            if (isIcon) {
                totalWidth += lineHeight + iconGap;
                continue;
            }
            totalWidth += componentWidth + padding * 2.0f;
            if (i <= (hasIcon ? 1 : 0)) continue;
            totalWidth += separatorSpacing;
        }
        if (totalWidth <= maxWidth) {
            lines = new ArrayList();
            ArrayList<Integer> singleLine = new ArrayList<Integer>();
            for (int i = 0; i < enabledComponents.size(); ++i) {
                singleLine.add(i);
            }
            lines.add(singleLine);
        } else {
            lines = this.balanceLines(enabledComponents, componentWidths, hasIcon, maxWidth, padding, separatorSpacing, iconGap, lineHeight);
        }
        float currentY = this.getY();
        float maxLineWidth = 0.0f;
        for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
            List line = (List)lines.get(lineIndex);
            boolean isFirstLineFlag = lineIndex == 0;
            boolean hasIconInLine = isFirstLineFlag && hasIcon;
            float lineContentWidth = 0.0f;
            int nonIconCount = 0;
            Iterator iterator = line.iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                if (idx == 0 && hasIconInLine) continue;
                lineContentWidth += ((Float)componentWidths.get(idx)).floatValue();
                ++nonIconCount;
            }
            if (nonIconCount > 1) {
                lineContentWidth += separatorSpacing * (float)(nonIconCount - 1);
            }
            float iconX = this.getX();
            float iconWidth = hasIconInLine ? lineHeight : 0.0f;
            float gapWidth = hasIconInLine ? iconGap : 0.0f;
            float backgroundX = iconX + iconWidth + gapWidth;
            if (lineContentWidth > 0.0f) {
                float actualWidth = lineContentWidth + padding * 2.0f;
                if (padej.soup.implement.features.modules.hud.Watermark.getInstance().getShowBackground().isValue()) {
                    blur.render(ShapeProperties.create(matrix, backgroundX, currentY, actualWidth, lineHeight).round(3.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
                }
                maxLineWidth = Math.max(maxLineWidth, iconWidth + gapWidth + actualWidth);
            }
            float currentX = iconX;
            for (int i = 0; i < line.size(); ++i) {
                boolean isIconInList;
                int componentIndex = (Integer)line.get(i);
                WatermarkComponent component = enabledComponents.get(componentIndex);
                if (i == 1 && hasIconInLine) {
                    currentX = backgroundX + padding;
                } else if (i == 0 && !hasIconInLine) {
                    currentX = backgroundX + padding;
                }
                component.render(matrix, currentX, currentY, lineHeight, font);
                currentX += ((Float)componentWidths.get(componentIndex)).floatValue();
                boolean bl = isIconInList = i == 0 && hasIconInLine;
                if (isIconInList || i >= line.size() - 1) continue;
                currentX += separatorSpacing;
            }
            this.renderLineSeparators(matrix, line, enabledComponents, componentWidths, hasIconInLine, padding, separatorSpacing, currentY, lineHeight);
            currentY += lineHeight + lineGap;
        }
        int totalHeight = (int)((float)lines.size() * lineHeight + (float)(lines.size() - 1) * lineGap);
        this.setWidth((int)maxLineWidth);
        this.setHeight(totalHeight);
    }

    private List<List<Integer>> balanceLines(List<WatermarkComponent> components, List<Float> widths, boolean hasIcon, float maxWidth, float padding, float separatorSpacing, float iconGap, float lineHeight) {
        List<List<Integer>> bestLines = null;
        float bestDifference = Float.MAX_VALUE;
        for (int numLines = 2; numLines <= components.size(); ++numLines) {
            List<List<Integer>> lines = this.tryBalanceWithLines(components, widths, hasIcon, maxWidth, padding, separatorSpacing, iconGap, lineHeight, numLines);
            if (lines == null) continue;
            float maxLineWidth = 0.0f;
            float minLineWidth = Float.MAX_VALUE;
            for (List<Integer> line : lines) {
                float lineWidth = this.calculateLineWidth(line, widths, hasIcon, padding, separatorSpacing, iconGap, lineHeight);
                maxLineWidth = Math.max(maxLineWidth, lineWidth);
                minLineWidth = Math.min(minLineWidth, lineWidth);
            }
            float difference = maxLineWidth - minLineWidth;
            if (!(difference < bestDifference) || !(maxLineWidth <= maxWidth)) continue;
            bestLines = lines;
            break;
        }
        return bestLines != null ? bestLines : this.createFallbackLines(components, widths, hasIcon, maxWidth, padding, separatorSpacing, iconGap, lineHeight);
    }

    private List<List<Integer>> tryBalanceWithLines(List<WatermarkComponent> components, List<Float> widths, boolean hasIcon, float maxWidth, float padding, float separatorSpacing, float iconGap, float lineHeight, int targetLines) {
        ArrayList<List<Integer>> lines = new ArrayList<List<Integer>>();
        ArrayList<Integer> currentLine = new ArrayList<Integer>();
        float currentLineWidth = 0.0f;
        boolean isFirstLine = true;
        float totalWidth = 0.0f;
        for (int i = 0; i < components.size(); ++i) {
            totalWidth += this.getComponentFullWidth(i, widths.get(i).floatValue(), hasIcon, padding, iconGap, lineHeight, i > (hasIcon ? 1 : 0));
        }
        float targetWidthPerLine = totalWidth / (float)targetLines;
        for (int i = 0; i < components.size(); ++i) {
            boolean shouldWrap;
            boolean isIcon = i == 0 && hasIcon;
            float componentWidth = widths.get(i).floatValue();
            boolean needsSeparator = !currentLine.isEmpty() && (currentLine.size() != 1 || !isFirstLine || !hasIcon);
            float widthNeeded = this.getComponentFullWidth(i, componentWidth, hasIcon, padding, iconGap, lineHeight, needsSeparator);
            boolean bl = shouldWrap = !currentLine.isEmpty() && lines.size() < targetLines - 1 && Math.abs(currentLineWidth + widthNeeded - targetWidthPerLine) > Math.abs(currentLineWidth - targetWidthPerLine);
            if (shouldWrap) {
                lines.add(new ArrayList(currentLine));
                currentLine.clear();
                currentLineWidth = 0.0f;
                isFirstLine = false;
                widthNeeded = this.getComponentFullWidth(i, componentWidth, hasIcon, padding, iconGap, lineHeight, false);
            }
            currentLine.add(i);
            currentLineWidth += widthNeeded;
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines.size() == targetLines ? lines : null;
    }

    private float getComponentFullWidth(int index, float componentWidth, boolean hasIcon, float padding, float iconGap, float lineHeight, boolean needsSeparator) {
        boolean isIcon;
        boolean bl = isIcon = index == 0 && hasIcon;
        if (isIcon) {
            return lineHeight + iconGap;
        }
        float width = componentWidth + padding * 2.0f;
        if (needsSeparator) {
            width += 10.0f;
        }
        return width;
    }

    private float calculateLineWidth(List<Integer> line, List<Float> widths, boolean hasIcon, float padding, float separatorSpacing, float iconGap, float lineHeight) {
        float width = 0.0f;
        boolean isFirstLine = line.contains(0);
        boolean hasIconInLine = isFirstLine && hasIcon;
        for (int i = 0; i < line.size(); ++i) {
            boolean isIcon;
            int idx = line.get(i);
            boolean bl = isIcon = idx == 0 && hasIconInLine;
            if (isIcon) {
                width += lineHeight + iconGap;
                continue;
            }
            width += widths.get(idx).floatValue() + padding * 2.0f;
            if (i <= (hasIconInLine ? 1 : 0)) continue;
            width += separatorSpacing;
        }
        return width;
    }

    private List<List<Integer>> createFallbackLines(List<WatermarkComponent> components, List<Float> widths, boolean hasIcon, float maxWidth, float padding, float separatorSpacing, float iconGap, float lineHeight) {
        ArrayList<List<Integer>> lines = new ArrayList<List<Integer>>();
        ArrayList<Integer> currentLine = new ArrayList<Integer>();
        float currentLineWidth = 0.0f;
        boolean isFirstLine = true;
        for (int i = 0; i < components.size(); ++i) {
            boolean isIcon = i == 0 && hasIcon;
            float componentWidth = widths.get(i).floatValue();
            boolean needsSeparator = !currentLine.isEmpty() && (currentLine.size() != 1 || !isFirstLine || !hasIcon);
            float widthNeeded = this.getComponentFullWidth(i, componentWidth, hasIcon, padding, iconGap, lineHeight, needsSeparator);
            if (!currentLine.isEmpty() && currentLineWidth + widthNeeded > maxWidth) {
                lines.add(new ArrayList(currentLine));
                currentLine.clear();
                currentLineWidth = 0.0f;
                isFirstLine = false;
                widthNeeded = this.getComponentFullWidth(i, componentWidth, hasIcon, padding, iconGap, lineHeight, false);
            }
            currentLine.add(i);
            currentLineWidth += widthNeeded;
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines;
    }

    private void renderLineSeparators(class_4587 matrix, List<Integer> line, List<WatermarkComponent> allComponents, List<Float> componentWidths, boolean hasIcon, float padding, float separatorSpacing, float y, float lineHeight) {
        float iconX = this.getX();
        float iconGap = 4.0f;
        float iconWidth = hasIcon ? lineHeight : 0.0f;
        float gapWidth = hasIcon ? iconGap : 0.0f;
        float backgroundX = iconX + iconWidth + gapWidth;
        float currentX = iconX;
        padej.soup.implement.features.modules.hud.Watermark watermark = padej.soup.implement.features.modules.hud.Watermark.getInstance();
        int separatorColor = !watermark.getColoredSeparators().isValue() ? ColorUtil.getOutline(0.75f, 0.5f) : (watermark.getSeparatorGradient().isValue() ? ColorUtil.fade(8) : ColorUtil.getClientColor());
        for (int i = 0; i < line.size() - 1; ++i) {
            int componentIndex = line.get(i);
            if (i == 0 && hasIcon) {
                currentX += componentWidths.get(componentIndex).floatValue();
                continue;
            }
            if (i == 1 && hasIcon) {
                currentX = backgroundX + padding;
            } else if (i == 0) {
                currentX = backgroundX + padding;
            }
            float width = componentWidths.get(componentIndex).floatValue();
            float separatorX = (currentX += width) + separatorSpacing / 2.0f;
            rectangle.render(ShapeProperties.create(matrix, separatorX, y + 4.0f, 0.5, lineHeight - 8.0f).color(separatorColor).build());
            currentX += separatorSpacing;
        }
    }

    private void drawSplitStyle(class_4587 matrix, FontRenderer font, List<WatermarkComponent> enabledComponents) {
        List<Object> lines;
        float padding = 5.0f;
        float componentGap = 4.0f;
        float lineGap = 4.0f;
        float lineHeight = 16.0f;
        float maxWidth = 300.0f;
        ArrayList<Float> componentWidths = new ArrayList<Float>();
        for (WatermarkComponent comp : enabledComponents) {
            componentWidths.add(Float.valueOf(comp.getSmoothedWidth(font, lineHeight)));
        }
        float totalWidth = 0.0f;
        for (int i = 0; i < enabledComponents.size(); ++i) {
            float componentWidth = ((Float)componentWidths.get(i)).floatValue();
            boolean isIcon = enabledComponents.get(i).getName().equals("Icon");
            float fullWidth = isIcon ? componentWidth : componentWidth + padding * 2.0f;
            totalWidth += fullWidth;
            if (i <= 0) continue;
            totalWidth += componentGap;
        }
        if (totalWidth <= maxWidth) {
            lines = new ArrayList();
            ArrayList<Integer> singleLine = new ArrayList<Integer>();
            for (int i = 0; i < enabledComponents.size(); ++i) {
                singleLine.add(i);
            }
            lines.add(singleLine);
        } else {
            lines = this.balanceSplitLines(enabledComponents, componentWidths, maxWidth, padding, componentGap);
        }
        float currentY = this.getY();
        float maxLineWidth = 0.0f;
        for (List list : lines) {
            float currentX = this.getX();
            float lineWidth = 0.0f;
            for (int i = 0; i < list.size(); ++i) {
                int componentIndex = (Integer)list.get(i);
                WatermarkComponent component = enabledComponents.get(componentIndex);
                float componentWidth = ((Float)componentWidths.get(componentIndex)).floatValue();
                if (!component.getName().equals("Icon") && padej.soup.implement.features.modules.hud.Watermark.getInstance().getShowBackground().isValue()) {
                    blur.render(ShapeProperties.create(matrix, currentX, currentY, componentWidth + padding * 2.0f, lineHeight).round(3.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
                }
                float renderX = component.getName().equals("Icon") ? currentX : currentX + padding;
                component.render(matrix, renderX, currentY, lineHeight, font);
                float fullComponentWidth = component.getName().equals("Icon") ? componentWidth : componentWidth + padding * 2.0f;
                currentX += fullComponentWidth;
                lineWidth += fullComponentWidth;
                if (i >= list.size() - 1) continue;
                currentX += componentGap;
                lineWidth += componentGap;
            }
            maxLineWidth = Math.max(maxLineWidth, lineWidth);
            currentY += lineHeight + lineGap;
        }
        int totalHeight = (int)((float)lines.size() * lineHeight + (float)(lines.size() - 1) * lineGap);
        this.setWidth((int)maxLineWidth);
        this.setHeight(totalHeight);
    }

    private List<List<Integer>> balanceSplitLines(List<WatermarkComponent> components, List<Float> widths, float maxWidth, float padding, float componentGap) {
        List<List<Integer>> bestLines = null;
        float bestDifference = Float.MAX_VALUE;
        for (int numLines = 2; numLines <= components.size(); ++numLines) {
            List<List<Integer>> lines = this.tryBalanceSplitLines(components, widths, maxWidth, padding, componentGap, numLines);
            if (lines == null) continue;
            float maxLineWidth = 0.0f;
            float minLineWidth = Float.MAX_VALUE;
            for (List<Integer> line : lines) {
                float lineWidth = this.calculateSplitLineWidth(line, widths, components, padding, componentGap);
                maxLineWidth = Math.max(maxLineWidth, lineWidth);
                minLineWidth = Math.min(minLineWidth, lineWidth);
            }
            float difference = maxLineWidth - minLineWidth;
            if (!(difference < bestDifference) || !(maxLineWidth <= maxWidth)) continue;
            bestLines = lines;
            break;
        }
        return bestLines != null ? bestLines : this.createFallbackSplitLines(components, widths, maxWidth, padding, componentGap);
    }

    private List<List<Integer>> tryBalanceSplitLines(List<WatermarkComponent> components, List<Float> widths, float maxWidth, float padding, float componentGap, int targetLines) {
        ArrayList<List<Integer>> lines = new ArrayList<List<Integer>>();
        ArrayList<Integer> currentLine = new ArrayList<Integer>();
        float currentLineWidth = 0.0f;
        float totalWidth = 0.0f;
        for (int i = 0; i < components.size(); ++i) {
            boolean isIcon = components.get(i).getName().equals("Icon");
            float fullWidth = isIcon ? widths.get(i).floatValue() : widths.get(i).floatValue() + padding * 2.0f;
            totalWidth += fullWidth;
            if (i <= 0) continue;
            totalWidth += componentGap;
        }
        float targetWidthPerLine = totalWidth / (float)targetLines;
        for (int i = 0; i < components.size(); ++i) {
            boolean shouldWrap;
            boolean isIcon = components.get(i).getName().equals("Icon");
            float fullWidth = isIcon ? widths.get(i).floatValue() : widths.get(i).floatValue() + padding * 2.0f;
            float widthToAdd = fullWidth + (currentLine.isEmpty() ? 0.0f : componentGap);
            boolean bl = shouldWrap = !currentLine.isEmpty() && lines.size() < targetLines - 1 && Math.abs(currentLineWidth + widthToAdd - targetWidthPerLine) > Math.abs(currentLineWidth - targetWidthPerLine);
            if (shouldWrap) {
                lines.add(new ArrayList(currentLine));
                currentLine.clear();
                currentLineWidth = 0.0f;
                widthToAdd = fullWidth;
            }
            currentLine.add(i);
            currentLineWidth += widthToAdd;
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines.size() == targetLines ? lines : null;
    }

    private float calculateSplitLineWidth(List<Integer> line, List<Float> widths, List<WatermarkComponent> components, float padding, float componentGap) {
        float width = 0.0f;
        for (int i = 0; i < line.size(); ++i) {
            int idx = line.get(i);
            boolean isIcon = components.get(idx).getName().equals("Icon");
            float fullWidth = isIcon ? widths.get(idx).floatValue() : widths.get(idx).floatValue() + padding * 2.0f;
            width += fullWidth;
            if (i <= 0) continue;
            width += componentGap;
        }
        return width;
    }

    private List<List<Integer>> createFallbackSplitLines(List<WatermarkComponent> components, List<Float> widths, float maxWidth, float padding, float componentGap) {
        ArrayList<List<Integer>> lines = new ArrayList<List<Integer>>();
        ArrayList<Integer> currentLine = new ArrayList<Integer>();
        float currentLineWidth = 0.0f;
        for (int i = 0; i < components.size(); ++i) {
            boolean isIcon = components.get(i).getName().equals("Icon");
            float fullWidth = isIcon ? widths.get(i).floatValue() : widths.get(i).floatValue() + padding * 2.0f;
            float widthToAdd = fullWidth + (currentLine.isEmpty() ? 0.0f : componentGap);
            if (!currentLine.isEmpty() && currentLineWidth + widthToAdd > maxWidth) {
                lines.add(new ArrayList(currentLine));
                currentLine.clear();
                currentLineWidth = 0.0f;
                widthToAdd = fullWidth;
            }
            currentLine.add(i);
            currentLineWidth += widthToAdd;
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines;
    }

    private List<WatermarkComponent> getEnabledComponents() {
        ArrayList<WatermarkComponent> enabled = new ArrayList<WatermarkComponent>();
        for (WatermarkComponent component : this.components) {
            if (!this.isComponentEnabled(component.getName())) continue;
            enabled.add(component);
        }
        return enabled;
    }

    private boolean isComponentEnabled(String componentName) {
        return padej.soup.implement.features.modules.hud.Watermark.getInstance().watermarkComponents.isSelected(componentName);
    }
}

