/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import padej.soup.base.util.math.MathUtil;
import padej.soup.implement.features.modules.hud.TargetHud;
import padej.soup.implement.features.modules.particles.ParticleData;
import padej.soup.implement.features.modules.particles.render.ParticleBatchRenderer;

public class TargetHudParticle {
    private static final class_310 mc = class_310.method_1551();
    public float x;
    public float y;
    public float px;
    public float py;
    private final float spawnX;
    private final float spawnY;
    public float motionX;
    public float motionY;
    private final float baseSpeed;
    private final float maxRadius;
    public float size;
    private float cachedAlpha;
    private float rotation;
    private float prevRotation;
    private float rotationSpeed;
    private int age;
    private final int maxAge;
    private final ParticleType type;
    private final Color color;
    private final class_2960 cachedTexture;
    private final String physicsMode;

    public TargetHudParticle(float x, float y, float motionX, float motionY, float size, Color color, ParticleType type, float lifetime, float baseSpeed, float maxRadius, String physicsMode) {
        this.x = x;
        this.y = y;
        this.px = x;
        this.py = y;
        this.spawnX = x;
        this.spawnY = y;
        this.motionX = motionX;
        this.motionY = motionY;
        this.baseSpeed = baseSpeed;
        this.maxRadius = maxRadius;
        this.size = size;
        this.color = color;
        this.type = type;
        this.physicsMode = physicsMode;
        this.cachedAlpha = 1.0f;
        this.cachedTexture = this.getCachedTextureForType();
        int baseAge = (int)(lifetime * 20.0f);
        int variance = (int)((double)baseAge * 0.2);
        this.maxAge = this.age = baseAge + (int)(Math.random() * (double)variance);
        this.prevRotation = this.rotation = (float)(Math.random() * 360.0);
        this.rotationSpeed = (float)(Math.random() * 4.0 - 2.0);
    }

    private class_2960 getCachedTextureForType() {
        return switch (this.type.ordinal()) {
            case 0 -> class_2960.method_60654((String)"textures/particles/star.png");
            case 1 -> class_2960.method_60654((String)"textures/particles/heart.png");
            case 2 -> class_2960.method_60654((String)"textures/particles/firefly.png");
            case 3 -> {
                String glyphTexture = ParticleData.getRandomGlyphTexture();
                yield class_2960.method_60654((String)("textures/particles/glyph/" + glyphTexture));
            }
            case 4 -> {
                String glyphAltTexture = ParticleData.getRandomGlyphAltTexture();
                yield class_2960.method_60654((String)("textures/particles/glyph_alt/" + glyphAltTexture));
            }
            case 5 -> class_2960.method_60654((String)"textures/particles/blink.png");
            case 6 -> class_2960.method_60654((String)"textures/particles/coron.png");
            case 7 -> class_2960.method_60654((String)"textures/particles/dollar.png");
            case 8 -> class_2960.method_60654((String)"textures/particles/flame.png");
            case 9 -> class_2960.method_60654((String)"textures/particles/geometric.png");
            case 10 -> class_2960.method_60654((String)"textures/particles/snowflake.png");
            case 11 -> class_2960.method_60654((String)"textures/particles/soupapi_3.png");
            case 12 -> class_2960.method_60654((String)"textures/particles/virus.png");
            case 13 -> class_2960.method_60654((String)"textures/vanilla/soupapi_old.png");
            case 14 -> class_2960.method_60654((String)"textures/vanilla/sword.png");
            default -> null;
        };
    }

    public boolean update() {
        --this.age;
        if (this.age < 0) {
            return true;
        }
        this.px = this.x;
        this.py = this.y;
        float dx = this.x - this.spawnX;
        float dy = this.y - this.spawnY;
        float currentDistance = (float)Math.sqrt(dx * dx + dy * dy);
        float distanceRatio = Math.min(1.0f, currentDistance / this.maxRadius);
        float speedMultiplier = this.baseSpeed * (1.0f - distanceRatio * distanceRatio);
        float adjustedMotionX = this.motionX * speedMultiplier;
        float adjustedMotionY = this.motionY * speedMultiplier;
        this.x += adjustedMotionX;
        this.y += adjustedMotionY;
        this.motionX *= 0.9f;
        this.motionY *= 0.9f;
        if ("Fly".equals(this.physicsMode)) {
            this.motionY *= 0.9f;
        }
        if (currentDistance < this.maxRadius * 0.8f) {
            this.motionY += 0.001f;
        }
        this.prevRotation = this.rotation;
        this.rotation += this.rotationSpeed;
        this.cachedAlpha = (float)this.age / (float)this.maxAge;
        return false;
    }

    public void render(class_4587 matrices, float hudX, float hudY, float depthFactor) {
        TargetHud module = TargetHud.getInstance();
        if (!module.particles.isValue()) {
            return;
        }
        matrices.method_22903();
        float interpolatedX = MathUtil.interpolate(this.px, this.x);
        float interpolatedY = MathUtil.interpolate(this.py, this.y);
        float renderX = interpolatedX + hudX;
        float renderY = interpolatedY + hudY;
        matrices.method_46416(renderX, renderY, 0.0f);
        float finalScale = this.size * depthFactor;
        matrices.method_22905(finalScale, finalScale, finalScale);
        if (this.is2DParticle()) {
            float interpolatedRotation = MathUtil.interpolate(this.prevRotation, this.rotation);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(interpolatedRotation));
            this.render2D(matrices);
        } else {
            this.renderBloomEffect(matrices);
            float interpolatedRotation = MathUtil.interpolate(this.prevRotation, this.rotation);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(interpolatedRotation));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(interpolatedRotation * 0.7f));
            this.render3D(matrices);
        }
        matrices.method_22909();
    }

    private boolean is2DParticle() {
        return this.type != ParticleType.CUBE && this.type != ParticleType.PYRAMID && this.type != ParticleType.NETWORK2D;
    }

    public boolean isNetworkParticle() {
        return this.type == ParticleType.NETWORK2D;
    }

    private void render2D(class_4587 matrices) {
        if (this.type == ParticleType.NETWORK2D) {
            return;
        }
        this.renderTexturedParticle(matrices);
    }

    private void renderTexturedParticle(class_4587 matrices) {
        class_2960 texture = this.getTextureForType();
        if (texture == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        RenderSystem.setShaderColor((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f), (float)this.cachedAlpha);
        float halfSize = 0.5f;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f matrix = matrices.method_23760().method_23761();
        bufferBuilder.method_22918(matrix, -halfSize, halfSize, 0.0f).method_22913(0.0f, 1.0f);
        bufferBuilder.method_22918(matrix, halfSize, halfSize, 0.0f).method_22913(1.0f, 1.0f);
        bufferBuilder.method_22918(matrix, halfSize, -halfSize, 0.0f).method_22913(1.0f, 0.0f);
        bufferBuilder.method_22918(matrix, -halfSize, -halfSize, 0.0f).method_22913(0.0f, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private void render3D(class_4587 matrices) {
        int colorWithAlpha = this.color.getRGB() & 0xFFFFFF | (int)(this.cachedAlpha * 255.0f) << 24;
        if (this.type == ParticleType.CUBE) {
            ParticleBatchRenderer.queueCubeParticle(matrices, 1.0f, this.cachedAlpha, colorWithAlpha);
        } else if (this.type == ParticleType.PYRAMID) {
            ParticleBatchRenderer.queuePyramidParticle(matrices, 1.0f, this.cachedAlpha, colorWithAlpha);
        }
    }

    private void renderBloomEffect(class_4587 matrices) {
        class_2960 bloomTexture = class_2960.method_60654((String)"textures/particles/bloom/bloom_small.png");
        matrices.method_22903();
        float bloomSize = 5.0f;
        matrices.method_46416(-bloomSize / 2.0f, -bloomSize / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.setShaderTexture((int)0, (class_2960)bloomTexture);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        int r = this.color.getRed();
        int g = this.color.getGreen();
        int b = this.color.getBlue();
        int a = (int)(this.cachedAlpha * 255.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        Matrix4f matrix = matrices.method_23760().method_23761();
        bufferBuilder.method_22918(matrix, 0.0f, bloomSize, 0.0f).method_22913(0.0f, 1.0f).method_1336(r, g, b, a);
        bufferBuilder.method_22918(matrix, bloomSize, bloomSize, 0.0f).method_22913(1.0f, 1.0f).method_1336(r, g, b, a);
        bufferBuilder.method_22918(matrix, bloomSize, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_1336(r, g, b, a);
        bufferBuilder.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_1336(r, g, b, a);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    public float getAlpha() {
        return this.cachedAlpha;
    }

    public static ParticleType parseType(String modeName) {
        return switch (modeName) {
            case "Stars" -> ParticleType.STARS;
            case "Hearts" -> ParticleType.HEARTS;
            case "Bloom" -> ParticleType.BLOOM;
            case "Glyph" -> ParticleType.GLYPH;
            case "Things" -> ParticleType.THINGS;
            case "Blink" -> ParticleType.BLINK;
            case "Coron" -> ParticleType.CORON;
            case "Dollar" -> ParticleType.DOLLAR;
            case "Flame" -> ParticleType.FLAME;
            case "Geometric" -> ParticleType.GEOMETRIC;
            case "Snowflake" -> ParticleType.SNOWFLAKE;
            case "Logo" -> ParticleType.LOGO;
            case "Virus" -> ParticleType.VIRUS;
            case "SoupAPI Old" -> ParticleType.SOUPAPI_OLD;
            case "Sword" -> ParticleType.SWORD;
            case "Cube" -> ParticleType.CUBE;
            case "Pyramid" -> ParticleType.PYRAMID;
            case "Network2D" -> ParticleType.NETWORK2D;
            default -> ParticleType.STARS;
        };
    }

    public ParticleType getType() {
        return this.type;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getPrevX() {
        return this.px;
    }

    public float getPrevY() {
        return this.py;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getPrevRotation() {
        return this.prevRotation;
    }

    public Color getColor() {
        return this.color;
    }

    public class_2960 getTextureForType() {
        return this.cachedTexture;
    }

    public static enum ParticleType {
        STARS,
        HEARTS,
        BLOOM,
        GLYPH,
        THINGS,
        BLINK,
        CORON,
        DOLLAR,
        FLAME,
        GEOMETRIC,
        SNOWFLAKE,
        LOGO,
        VIRUS,
        SOUPAPI_OLD,
        SWORD,
        CUBE,
        PYRAMID,
        NETWORK2D;

    }
}

