/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables.watermark;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import net.minecraft.class_4587;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.implement.features.draggables.watermark.WatermarkComponent;

public class CPUComponent
implements WatermarkComponent,
QuickImports {
    private double cpuLoad = 0.0;
    private int tickCounter = 0;
    private float smoothedWidth = 0.0f;

    @Override
    public void tick() {
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            this.tickCounter = 0;
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            this.cpuLoad = osBean.getProcessCpuLoad() * 100.0;
            if (this.cpuLoad < 0.0) {
                this.cpuLoad = 0.0;
            }
        }
    }

    @Override
    public float render(class_4587 matrix, float x, float y, float height, FontRenderer font) {
        String cpuText = String.format("%.1f%%", this.cpuLoad);
        float iconSize = 8.0f;
        float iconOffset = this.shouldShowIcons() ? iconSize + 2.0f : 0.0f;
        float yIconOffset = 4.0f;
        float xIconOffset = -1.0f;
        if (this.shouldShowIcons()) {
            image.setTexture("textures/cpu.png").render(ShapeProperties.create(matrix, x + xIconOffset, y + yIconOffset, iconSize, iconSize).color(this.getIconColor()).build());
        }
        font.drawString(matrix, cpuText, x + iconOffset, y + 6.5f, ColorUtil.getText());
        return iconOffset + font.getStringWidth(cpuText);
    }

    @Override
    public float getWidth(FontRenderer font, float height) {
        int wholeDigits = (int)this.cpuLoad == 0 ? 1 : (int)Math.log10(Math.max(1, (int)this.cpuLoad)) + 1;
        String widestCpu = "8".repeat(wholeDigits) + ".8%";
        float iconSize = 8.0f;
        float iconOffset = this.shouldShowIcons() ? iconSize + 2.0f : 0.0f;
        return iconOffset + font.getStringWidth(widestCpu);
    }

    @Override
    public float getSmoothedWidth(FontRenderer font, float height) {
        return this.getWidth(font, height);
    }

    @Override
    public String getName() {
        return "CPU";
    }

    @Override
    public boolean hasSeparator() {
        return false;
    }
}

