/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables.watermark;

import net.minecraft.class_4587;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.implement.features.draggables.watermark.WatermarkComponent;

public class FPSComponent
implements WatermarkComponent,
QuickImports {
    private int fpsCount = 0;
    private float smoothedWidth = 0.0f;

    @Override
    public void tick() {
        this.fpsCount = (int)MathUtil.interpolate(this.fpsCount, mc.method_47599());
    }

    @Override
    public float render(class_4587 matrix, float x, float y, float height, FontRenderer font) {
        String fps = this.fpsCount + " FPS";
        float iconSize = 8.0f;
        float iconOffset = this.shouldShowIcons() ? iconSize + 2.0f : 0.0f;
        float yIconOffset = 4.0f;
        float xIconOffset = -1.0f;
        if (this.shouldShowIcons()) {
            image.setTexture("textures/frame.png").render(ShapeProperties.create(matrix, x + xIconOffset, y + yIconOffset, iconSize, iconSize).color(this.getIconColor()).build());
        }
        font.drawString(matrix, fps, x + iconOffset, y + 6.5f, ColorUtil.getText());
        return iconOffset + font.getStringWidth(fps);
    }

    @Override
    public float getWidth(FontRenderer font, float height) {
        int digitCount = String.valueOf(this.fpsCount).length();
        String widestFps = "8".repeat(digitCount) + " FPS";
        float iconSize = 8.0f;
        float iconOffset = this.shouldShowIcons() ? iconSize + 2.0f : 0.0f;
        return iconOffset + font.getStringWidth(widestFps) - 1.0f;
    }

    @Override
    public float getSmoothedWidth(FontRenderer font, float height) {
        return this.getWidth(font, height);
    }

    @Override
    public String getName() {
        return "FPS";
    }

    @Override
    public boolean hasSeparator() {
        return false;
    }
}

