/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_10014;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9946;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.render.EndCrystalRenderer;

public class EndCrystal
extends Module {
    private final List<PhantomCrystal> phantomCrystals = new ArrayList<PhantomCrystal>();
    private final Map<class_243, CrystalModelState> activeCrystals = new HashMap<class_243, CrystalModelState>();
    private class_9946 crystalModel;
    private final SelectSetting colorMode = new SelectSetting("setting.endcrystal.colormode.name", "setting.endcrystal.colormode.desc").value("Sync", "Custom").selected("Sync");
    private final SelectSetting customColorsCount = new SelectSetting("setting.endcrystal.colorcount.name", "setting.endcrystal.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Solo").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiColorSetting customColors = new MultiColorSetting("setting.endcrystal.gradientcolors.name", "setting.endcrystal.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom"));
    private final SelectSetting colorAnimation = new SelectSetting("setting.endcrystal.coloranimation.name", "setting.endcrystal.coloranimation.desc").value("Wave", "Vertex").selected("Wave").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiSelectSetting modelParts = new MultiSelectSetting("setting.endcrystal.modelparts.name", "setting.endcrystal.modelparts.desc").value("Outer Glass", "Inner Glass", "Cube").selected("Outer Glass", "Inner Glass", "Cube");
    private final ValueSetting yOffset = new ValueSetting("setting.endcrystal.yoffset.name", "setting.endcrystal.yoffset.desc").setValue(0.0f).range(-2.0f, 2.0f);
    private final ValueSetting size = new ValueSetting("setting.endcrystal.size.name", "setting.endcrystal.size.desc").setValue(2.0f).range(0.5f, 3.0f);
    private final ValueSetting animationSpeed = new ValueSetting("setting.endcrystal.animationspeed.name", "setting.endcrystal.animationspeed.desc").setValue(1.0f).range(0.1f, 3.0f);
    private final ValueSetting breakDuration = new ValueSetting("setting.endcrystal.breakduration.name", "setting.endcrystal.breakduration.desc").setValue(1.0f).range(0.1f, 3.0f);
    private final ValueSetting breakScaleMultiplier = new ValueSetting("setting.endcrystal.breakscalemultiplier.name", "setting.endcrystal.breakscalemultiplier.desc").setValue(0.5f).range(0.0f, 2.0f);

    public static EndCrystal getInstance() {
        return Instance.get(EndCrystal.class);
    }

    public EndCrystal() {
        super("module.endcrystal.name", ModuleCategory.OTHER);
        GroupSetting colorGroup = new GroupSetting("group.endcrystal.colors.name", "group.endcrystal.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors, this.colorAnimation);
        GroupSetting modelGroup = new GroupSetting("group.endcrystal.model.name", "group.endcrystal.model.desc", false).settings(this.modelParts, this.yOffset, this.size);
        GroupSetting animationGroup = new GroupSetting("group.endcrystal.animations.name", "group.endcrystal.animations.desc", false).settings(this.animationSpeed, this.breakDuration, this.breakScaleMultiplier);
        this.setup(colorGroup, modelGroup, animationGroup);
    }

    public void drawCrystals(WorldRenderContext context) {
        EndCrystalRenderer.drawCrystals(context, this);
    }

    public void renderCrystal(class_10014 state, class_4587 matrixStack, int light, class_9946 model, class_4597 vertexConsumerProvider) {
        EndCrystalRenderer.renderCrystal(state, matrixStack, light, model, vertexConsumerProvider, this);
    }

    public float getSize() {
        return this.size.getValue();
    }

    public float getYOffset() {
        return this.yOffset.getValue();
    }

    public boolean isVertexMode() {
        return this.colorAnimation.isSelected("Vertex") && this.colorMode.isSelected("Custom");
    }

    public boolean isWaveMode() {
        return this.colorAnimation.isSelected("Wave");
    }

    public boolean isSyncMode() {
        return this.colorMode.isSelected("Sync");
    }

    public boolean isOuterGlassVisible() {
        return this.modelParts.isSelected("Outer Glass");
    }

    public boolean isInnerGlassVisible() {
        return this.modelParts.isSelected("Inner Glass");
    }

    public boolean isCubeVisible() {
        return this.modelParts.isSelected("Cube");
    }

    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    public void trackCrystal(class_243 pos, float outerGlassYaw, float outerGlassPivotY) {
        this.activeCrystals.put(pos, new CrystalModelState(outerGlassYaw, outerGlassPivotY));
    }

    public void clearTracking() {
        this.activeCrystals.clear();
    }

    public void checkRemovedCrystal(class_243 crystalPos) {
        class_243 closestPos = null;
        CrystalModelState closestState = null;
        double minDistance = 0.1;
        for (Map.Entry<class_243, CrystalModelState> entry : this.activeCrystals.entrySet()) {
            double dist = entry.getKey().method_1022(crystalPos);
            if (!(dist < minDistance)) continue;
            closestPos = entry.getKey();
            closestState = entry.getValue();
            minDistance = dist;
        }
        if (closestPos != null && closestState != null) {
            this.addPhantomCrystal(closestPos, closestState);
            this.activeCrystals.remove(closestPos);
        }
    }

    private void addPhantomCrystal(class_243 pos, CrystalModelState state) {
        int durationMs = (int)(600.0f / this.breakDuration.getValue());
        this.phantomCrystals.add(new PhantomCrystal(pos, state.outerGlassYaw, state.outerGlassPivotY, durationMs));
    }

    public float getBreakScaleMultiplier() {
        return this.breakScaleMultiplier.getValue();
    }

    public float getAnimationSpeed() {
        return this.animationSpeed.getValue();
    }

    public List<PhantomCrystal> getPhantomCrystals() {
        return this.phantomCrystals;
    }

    public class_9946 getCrystalModel() {
        return this.crystalModel;
    }

    public void setCrystalModel(class_9946 crystalModel) {
        this.crystalModel = crystalModel;
    }

    public record CrystalModelState(float outerGlassYaw, float outerGlassPivotY) {
    }

    public static class PhantomCrystal {
        public final class_243 pos;
        public final DecelerateAnimation animation;
        public final float outerGlassYaw;
        public final float outerGlassPivotY;

        public PhantomCrystal(class_243 pos, float outerGlassYaw, float outerGlassPivotY, int duration) {
            this.pos = pos;
            this.animation = new DecelerateAnimation();
            this.animation.setMs(duration);
            this.animation.setValue(1.0);
            this.animation.setDirection(Direction.FORWARDS);
            this.outerGlassYaw = outerGlassYaw;
            this.outerGlassPivotY = outerGlassPivotY;
        }

        public boolean isFinished() {
            return this.animation.isDone();
        }
    }
}

