/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.other;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.IParticleModule;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.api.repository.friend.FriendUtils;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.particle.ParticleUpdateExecutor;
import padej.soup.base.util.spatial.SpatialGrid3D;
import padej.soup.implement.events.player.EventAttack;
import padej.soup.implement.events.player.TickEvent;
import padej.soup.implement.events.render.WorldRenderEvent;
import padej.soup.implement.features.modules.particles.ParticleData;
import padej.soup.implement.features.modules.particles.render.NetworkRenderer;
import padej.soup.implement.features.modules.particles.types.WorldParticle;

public class KillEffect
extends Module
implements IParticleModule {
    private final Map<class_1297, EntityHealthData> trackedEntities = new ConcurrentHashMap<class_1297, EntityHealthData>();
    private final Map<class_1297, Long> recentlyAttacked = new ConcurrentHashMap<class_1297, Long>();
    private final Map<class_1297, Long> recentlyAttackedByFriends = new ConcurrentHashMap<class_1297, Long>();
    private static final long ATTACK_TIMEOUT = 5000L;
    private final CopyOnWriteArrayList<WorldParticle> particles = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<WorldParticle> networkParticles = new CopyOnWriteArrayList();
    private SpatialGrid3D<WorldParticle> spatialGrid = null;
    private final SelectSetting effectType = new SelectSetting("setting.killeffect.effecttype.name", "setting.killeffect.effecttype.desc").value("Particles", "Thunder").selected("Particles");
    private final SelectSetting friendEffectType = new SelectSetting("setting.killeffect.friendeffecttype.name", "setting.killeffect.friendeffecttype.desc").value("Particles", "Thunder").selected("Thunder");
    private final BooleanSetting showForFriends = new BooleanSetting("setting.killeffect.showforfriends.name", "setting.killeffect.showforfriends.desc").setValue(true);
    private final SelectSetting targetType = new SelectSetting("setting.killeffect.targettype.name", "setting.killeffect.targettype.desc").value("Mobs", "Player", "Both").selected("Both");
    public final SelectSetting colorMode = new SelectSetting("setting.killeffect.colormode.name", "setting.killeffect.colormode.desc").value("Sync", "Custom").selected("Sync").visible(this::isParticleMode);
    private final SelectSetting customColorsCount = new SelectSetting("setting.killeffect.colorcount.name", "setting.killeffect.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Solo").visible(() -> this.colorMode.isSelected("Custom") && this.isParticleMode());
    private final MultiColorSetting customColors = new MultiColorSetting("setting.killeffect.gradientcolors.name", "setting.killeffect.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom") && this.isParticleMode());
    public final SelectSetting colorAnimation = new SelectSetting("setting.killeffect.coloranimation.name", "setting.killeffect.coloranimation.desc").value("Wave", "Vertex").selected("Wave").visible(() -> this.colorMode.isSelected("Custom") && this.isParticleMode());
    private final MultiSelectSetting mode = new MultiSelectSetting("setting.killeffect.mode.name", "setting.killeffect.mode.desc").value("Stars", "Hearts", "Bloom", "Glyph", "Things", "Blink", "Coron", "Dollar", "Flame", "Geometric", "Snowflake", "Logo", "Virus", "SoupAPI Old", "Sword", "Network", "Cube", "Pyramid").selected("Stars", "Hearts", "Bloom").visible(this::isParticleMode);
    private final MultiSelectSetting physics = new MultiSelectSetting("setting.killeffect.physics.name", "setting.killeffect.physics.desc").value("Fall", "Fly", "Emerge").selected("Emerge").visible(this::isParticleMode);
    private final ValueSetting scale = new ValueSetting("setting.killeffect.scale.name", "setting.killeffect.scale.desc").setValue(1.5f).range(0.5f, 5.0f).visible(this::isParticleMode);
    private final ValueSetting lifeTime = new ValueSetting("setting.killeffect.lifetime.name", "setting.killeffect.lifetime.desc").setValue(3.0f).range(1, 10).visible(this::isParticleMode);
    private final ValueSetting speed = new ValueSetting("setting.killeffect.speed.name", "setting.killeffect.speed.desc").setValue(1.0f).range(0.1f, 3.0f).visible(this::isParticleMode);
    private final ValueSetting amount = new ValueSetting("setting.killeffect.amount.name", "setting.killeffect.amount.desc").setValue(30.0f).range(10, 70).visible(this::isParticleMode);
    public final ValueSetting linkDistance = new ValueSetting("setting.killeffect.linkdistance.name", "setting.killeffect.linkdistance.desc").setValue(1.0f).range(0.5f, 2.0f).visible(() -> this.isParticleMode() && this.mode.getSelected().contains("Network"));
    private final BooleanSetting enableSound = new BooleanSetting("setting.killeffect.enablesound.name", "setting.killeffect.enablesound.desc").setValue(false);
    private final SelectSetting soundType = new SelectSetting("setting.killeffect.soundtype.name", "setting.killeffect.soundtype.desc").value("Abmiss", "Critow", "Final Blink", "Final Pok", "Neptune", "Rust Headshot", "Whii").selected("Neptune").visible(this.enableSound::isValue);
    private final ValueSetting soundVolume = new ValueSetting("setting.killeffect.soundvolume.name", "setting.killeffect.soundvolume.desc").setValue(1.0f).range(0.1f, 2.0f).visible(this.enableSound::isValue);
    private final ValueSetting soundPitch = new ValueSetting("setting.killeffect.soundpitch.name", "setting.killeffect.soundpitch.desc").setValue(1.0f).range(0.5f, 2.0f).visible(this.enableSound::isValue);

    private boolean isParticleMode() {
        return this.effectType.isSelected("Particles") || this.showForFriends.isValue() && this.friendEffectType.isSelected("Particles");
    }

    public static KillEffect getInstance() {
        return Instance.get(KillEffect.class);
    }

    public KillEffect() {
        super("module.killeffect.name", ModuleCategory.OTHER);
        GroupSetting effectGroup = new GroupSetting("group.killeffect.effect.name", "group.killeffect.effect.desc", false).settings(this.effectType, this.friendEffectType, this.showForFriends, this.targetType);
        GroupSetting colorGroup = new GroupSetting("group.killeffect.colors.name", "group.killeffect.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors, this.colorAnimation).visible(this::isParticleMode);
        GroupSetting appearanceGroup = new GroupSetting("group.killeffect.appearance.name", "group.killeffect.appearance.desc", false).settings(this.mode, this.physics, this.scale).visible(this::isParticleMode);
        GroupSetting behaviorGroup = new GroupSetting("group.killeffect.behavior.name", "group.killeffect.behavior.desc", false).settings(this.lifeTime, this.speed, this.amount).visible(this::isParticleMode);
        GroupSetting soundGroup = new GroupSetting("group.killeffect.sound.name", "group.killeffect.sound.desc", false).settings(this.enableSound, this.soundType, this.soundVolume, this.soundPitch);
        this.setup(effectGroup, colorGroup, appearanceGroup, behaviorGroup, this.linkDistance, soundGroup);
    }

    @Override
    public SelectSetting getColorMode() {
        return this.colorMode;
    }

    @Override
    public SelectSetting getColorAnimation() {
        return this.colorAnimation;
    }

    @Override
    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    private String getRandomMode() {
        List<String> selected = this.mode.getSelected();
        if (selected.isEmpty()) {
            return "Stars";
        }
        return selected.get(ThreadLocalRandom.current().nextInt(selected.size()));
    }

    private String getRandomPhysics() {
        List<String> selected = this.physics.getSelected();
        if (selected.isEmpty()) {
            return "Emerge";
        }
        return selected.get(ThreadLocalRandom.current().nextInt(selected.size()));
    }

    @EventHandler
    public void onAttack(EventAttack event) {
        if (KillEffect.mc.field_1724 == null || KillEffect.mc.field_1687 == null) {
            return;
        }
        if (event.isPre()) {
            return;
        }
        class_1297 target = event.getTarget();
        if (!(target instanceof class_1309)) {
            return;
        }
        this.recentlyAttacked.put(target, System.currentTimeMillis());
    }

    @EventHandler
    public void onTick(TickEvent e) {
        if (KillEffect.mc.field_1724 == null || KillEffect.mc.field_1687 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        List<WorldParticle> toRemove = ParticleUpdateExecutor.updateParticles(this.particles, currentTime, p -> true);
        toRemove.forEach(particle -> {
            this.particles.remove(particle);
            if (particle.getParticleMode().equals("Network")) {
                if (this.spatialGrid != null) {
                    this.spatialGrid.remove((WorldParticle)particle, particle.getX(), particle.getY(), particle.getZ());
                }
                this.networkParticles.remove(particle);
            }
        });
        if (this.spatialGrid != null && !this.networkParticles.isEmpty()) {
            for (WorldParticle particle2 : this.networkParticles) {
                this.spatialGrid.update(particle2, particle2.getPx(), particle2.getPy(), particle2.getPz(), particle2.getX(), particle2.getY(), particle2.getZ());
            }
        }
        this.recentlyAttacked.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 5000L);
        this.recentlyAttackedByFriends.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 5000L);
        for (class_1297 entity : KillEffect.mc.field_1687.method_18112()) {
            class_1309 attacker;
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            if (entity == KillEffect.mc.field_1724) continue;
            float currentHealth = livingEntity.method_6032();
            EntityHealthData data = this.trackedEntities.computeIfAbsent(entity, k -> new EntityHealthData(currentHealth, livingEntity.method_6063()));
            if (currentHealth < data.previousHealth && (attacker = livingEntity.method_6065()) instanceof class_1657 && FriendUtils.isFriend((class_1297)attacker)) {
                this.recentlyAttackedByFriends.put(entity, currentTime);
            }
            if (data.wasAlive && !livingEntity.method_5805()) {
                if (this.recentlyAttacked.containsKey(entity)) {
                    this.onEntityKilled(entity, livingEntity, false);
                } else if (this.recentlyAttackedByFriends.containsKey(entity)) {
                    this.onEntityKilled(entity, livingEntity, true);
                }
            } else if (data.previousHealth > 0.0f && currentHealth <= 0.0f) {
                if (this.recentlyAttacked.containsKey(entity)) {
                    this.onEntityKilled(entity, livingEntity, false);
                } else if (this.recentlyAttackedByFriends.containsKey(entity)) {
                    this.onEntityKilled(entity, livingEntity, true);
                }
            } else if (data.previousHealth > 2.0f && currentHealth <= 2.0f) {
                if (this.recentlyAttacked.containsKey(entity)) {
                    data.markedForKill = true;
                    data.killedByFriend = false;
                    data.killMarkTime = currentTime;
                } else if (this.recentlyAttackedByFriends.containsKey(entity)) {
                    data.markedForKill = true;
                    data.killedByFriend = true;
                    data.killMarkTime = currentTime;
                }
            }
            data.previousHealth = currentHealth;
            data.wasAlive = livingEntity.method_5805();
        }
        this.trackedEntities.entrySet().removeIf(entry -> {
            class_1297 ent = (class_1297)entry.getKey();
            EntityHealthData data = (EntityHealthData)entry.getValue();
            if (data.markedForKill && ent.method_31481()) {
                if (this.recentlyAttacked.containsKey(ent)) {
                    this.onEntityKilled(ent, (class_1309)ent, false);
                } else if (this.recentlyAttackedByFriends.containsKey(ent)) {
                    this.onEntityKilled(ent, (class_1309)ent, true);
                }
                return true;
            }
            if (ent.method_31481() || !ent.method_5805()) {
                if (this.recentlyAttacked.containsKey(ent) && data.previousHealth <= 2.0f) {
                    this.onEntityKilled(ent, (class_1309)ent, false);
                } else if (this.recentlyAttackedByFriends.containsKey(ent) && data.previousHealth <= 2.0f) {
                    this.onEntityKilled(ent, (class_1309)ent, true);
                }
                return true;
            }
            if (data.markedForKill && currentTime - data.killMarkTime > 1000L) {
                data.markedForKill = false;
            }
            return false;
        });
    }

    private void onEntityKilled(class_1297 entity, class_1309 livingEntity, boolean killedByFriend) {
        this.recentlyAttacked.remove(entity);
        this.recentlyAttackedByFriends.remove(entity);
        this.trackedEntities.remove(entity);
        boolean isPlayer = entity instanceof class_1657;
        String targetTypeSelected = this.targetType.getSelected();
        if (targetTypeSelected.equals("Player") && !isPlayer) {
            return;
        }
        if (targetTypeSelected.equals("Mobs") && isPlayer) {
            return;
        }
        if (killedByFriend && !this.showForFriends.isValue()) {
            return;
        }
        String selectedEffectType = killedByFriend ? this.friendEffectType.getSelected() : this.effectType.getSelected();
        class_243 position = entity.method_19538().method_1031(0.0, (double)livingEntity.method_17682() / 2.0, 0.0);
        if (selectedEffectType.equals("Particles")) {
            this.spawnParticlesEffect(position);
        } else if (selectedEffectType.equals("Thunder")) {
            this.spawnThunderEffect(position);
        }
        if (this.enableSound.isValue()) {
            this.playKillSound();
        }
    }

    private void playKillSound() {
        class_3414 sound = switch (this.soundType.getSelected()) {
            case "Abmiss" -> SoundManager.KILL_ABMISS;
            case "Critow" -> SoundManager.KILL_CRITOW;
            case "Final Blink" -> SoundManager.KILL_FINAL_BLINK;
            case "Final Pok" -> SoundManager.KILL_FINAL_POK;
            case "Neptune" -> SoundManager.KILL_NEPTUNE;
            case "Rust Headshot" -> SoundManager.KILL_RUST_HEADSHOT;
            case "Whii" -> SoundManager.KILL_WHII;
            default -> SoundManager.KILL_NEPTUNE;
        };
        SoundManager.playSound(sound, this.soundVolume.getValue(), this.soundPitch.getValue());
    }

    private void spawnParticlesEffect(class_243 position) {
        int[] colors;
        int colorInt = this.colorMode.isSelected("Sync") ? ColorUtil.getClientColor() : ((colors = this.getCustomColors()) != null && colors.length > 0 ? colors[0] : -1);
        int i = 0;
        while ((float)i < this.amount.getValue()) {
            String selectedMode = this.getRandomMode();
            String selectedPhysics = selectedMode.equals("Network") ? "Fly" : this.getRandomPhysics();
            float x = (float)position.field_1352;
            float y = (float)position.field_1351;
            float z = (float)position.field_1350;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            WorldParticle particle = new WorldParticle(this, x, y, z, new Color(colorInt), (float)(random.nextDouble() * 360.0), (float)(random.nextDouble() * 25.0 + 5.0), 0.0f, selectedMode, selectedPhysics, selectedMode.equals("Glyph") ? ParticleData.getRandomGlyphTexture() : (selectedMode.equals("Things") ? ParticleData.getRandomGlyphAltTexture() : null), this.lifeTime.getValue(), this.scale.getValue(), this.speed.getValue(), this){

                @Override
                protected void initMotion(float speed) {
                    ThreadLocalRandom rng = ThreadLocalRandom.current();
                    float scale = speed * 0.05f;
                    this.motionX = (float)(rng.nextGaussian() * (double)scale);
                    this.motionY = (float)(rng.nextGaussian() * (double)scale);
                    this.motionZ = (float)(rng.nextGaussian() * (double)scale);
                }
            };
            this.particles.add(particle);
            if (selectedMode.equals("Network")) {
                if (this.spatialGrid == null) {
                    this.spatialGrid = new SpatialGrid3D(this.linkDistance.getValue());
                }
                this.networkParticles.add(particle);
                this.spatialGrid.insert(particle, x, y, z);
            }
            ++i;
        }
    }

    private void spawnThunderEffect(class_243 position) {
        if (KillEffect.mc.field_1687 == null) {
            return;
        }
        class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)KillEffect.mc.field_1687);
        lightning.method_29495(position);
        lightning.method_29498(true);
        KillEffect.mc.field_1687.method_53875((class_1297)lightning);
    }

    @EventHandler
    public void onWorldRender(WorldRenderEvent event) {
        class_4587 stack = event.getStack();
        if (KillEffect.mc.field_1724 != null && KillEffect.mc.field_1687 != null) {
            long currentTime = System.currentTimeMillis();
            for (WorldParticle particle : this.particles) {
                particle.render(stack, currentTime);
            }
            if (this.mode.getSelected().contains("Network") && this.spatialGrid != null && !this.networkParticles.isEmpty()) {
                NetworkRenderer.renderNetworkLinks(stack, this.networkParticles, this.spatialGrid, currentTime, this.linkDistance.getValue(), this);
            }
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.particles.clear();
        this.networkParticles.clear();
        this.trackedEntities.clear();
        this.recentlyAttacked.clear();
        this.recentlyAttackedByFriends.clear();
        if (this.spatialGrid != null) {
            this.spatialGrid = null;
        }
    }

    public SpatialGrid3D<WorldParticle> getSpatialGrid() {
        return this.spatialGrid;
    }

    public SelectSetting getEffectType() {
        return this.effectType;
    }

    public SelectSetting getFriendEffectType() {
        return this.friendEffectType;
    }

    public BooleanSetting getShowForFriends() {
        return this.showForFriends;
    }

    public SelectSetting getTargetType() {
        return this.targetType;
    }

    public ValueSetting getLinkDistance() {
        return this.linkDistance;
    }

    public BooleanSetting getEnableSound() {
        return this.enableSound;
    }

    public SelectSetting getSoundType() {
        return this.soundType;
    }

    public ValueSetting getSoundVolume() {
        return this.soundVolume;
    }

    public ValueSetting getSoundPitch() {
        return this.soundPitch;
    }

    private static class EntityHealthData {
        float previousHealth;
        float maxHealth;
        boolean wasAlive;
        boolean markedForKill;
        boolean killedByFriend;
        long killMarkTime;

        EntityHealthData(float currentHealth, float maxHealth) {
            this.previousHealth = currentHealth;
            this.maxHealth = maxHealth;
            this.wasAlive = true;
            this.markedForKill = false;
            this.killedByFriend = false;
            this.killMarkTime = 0L;
        }
    }
}

