/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_238;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.IParticleModule;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.math.ProjectionUtil;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.particle.ParticleColorUtil;
import padej.soup.base.util.particle.ParticleUpdateExecutor;
import padej.soup.base.util.spatial.SpatialGrid3D;
import padej.soup.implement.events.player.TickEvent;
import padej.soup.implement.events.render.WorldRenderEvent;
import padej.soup.implement.features.modules.particles.ParticleData;
import padej.soup.implement.features.modules.particles.types.FireFlyParticle;
import padej.soup.implement.features.modules.particles.types.WorldParticle;

public class AmbientParticles
extends Module
implements IParticleModule {
    private final SelectSetting colorMode = new SelectSetting("setting.ambientparticles.colormode.name", "setting.ambientparticles.colormode.desc").value("Sync", "Custom").selected("Sync");
    private final SelectSetting customColorsCount = new SelectSetting("setting.ambientparticles.colorcount.name", "setting.ambientparticles.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Solo").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiColorSetting customColors = new MultiColorSetting("setting.ambientparticles.gradientcolors.name", "setting.ambientparticles.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom"));
    private final SelectSetting colorAnimation = new SelectSetting("setting.ambientparticles.coloranimation.name", "setting.ambientparticles.coloranimation.desc").value("Wave", "Vertex").selected("Wave").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiSelectSetting mode = new MultiSelectSetting("setting.ambientparticles.mode.name", "setting.ambientparticles.mode.desc").value("Stars", "Hearts", "Bloom", "Glyph", "Things", "Blink", "Coron", "Dollar", "Flame", "Geometric", "Snowflake", "Logo", "Virus", "SoupAPI Old", "Sword", "Firefly", "Network", "Cube", "Pyramid").selected("Stars");
    private final MultiSelectSetting physics = new MultiSelectSetting("setting.ambientparticles.physics.name", "setting.ambientparticles.physics.desc").value("Fall", "Fly", "Emerge").selected("Fly");
    private final ValueSetting regularCount = new ValueSetting("setting.ambientparticles.regularcount.name", "setting.ambientparticles.regularcount.desc").setValue(100.0f).range(20, 500);
    private final ValueSetting regularScale = new ValueSetting("setting.ambientparticles.regularscale.name", "setting.ambientparticles.regularscale.desc").setValue(2.5f).range(0.1f, 15.0f);
    private final ValueSetting fireflyCount = new ValueSetting("setting.ambientparticles.fireflycount.name", "setting.ambientparticles.fireflycount.desc").setValue(30.0f).range(10, 100);
    private final ValueSetting fireflyScale = new ValueSetting("setting.ambientparticles.fireflyscale.name", "setting.ambientparticles.fireflyscale.desc").setValue(1.0f).range(0.3f, 3.0f);
    private final ValueSetting fireflyTrailLength = new ValueSetting("setting.ambientparticles.firefly.traillength.name", "setting.ambientparticles.firefly.traillength.desc").setValue(20.0f).range(5, 60);
    private final ValueSetting geometricsCount = new ValueSetting("setting.ambientparticles.geometricscount.name", "setting.ambientparticles.geometricscount.desc").setValue(50.0f).range(10, 200);
    private final ValueSetting geometricsScale = new ValueSetting("setting.ambientparticles.geometricsscale.name", "setting.ambientparticles.geometricsscale.desc").setValue(2.0f).range(0.5f, 15.0f);
    private final ValueSetting linkDistance = new ValueSetting("setting.ambientparticles.linkdistance.name", "setting.ambientparticles.linkdistance.desc").setValue(5.0f).range(2, 8);
    private final ValueSetting maxLinksPerParticle = new ValueSetting("setting.ambientparticles.maxlinks.name", "setting.ambientparticles.maxlinks.desc").setValue(5.0f).range(1, 10);
    private final ValueSetting spawnRadius = new ValueSetting("setting.ambientparticles.spawnradius.name", "setting.ambientparticles.spawnradius.desc").setValue(25.0f).range(10, 40);
    private final ValueSetting spawnHeight = new ValueSetting("setting.ambientparticles.spawnheight.name", "setting.ambientparticles.spawnheight.desc").setValue(4.0f).range(2, 20);
    private final CopyOnWriteArrayList<WorldParticle> particles = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<WorldParticle> networkParticles = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<WorldParticle> geometricsParticles = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<FireFlyParticle> fireflyParticles = new CopyOnWriteArrayList();
    private SpatialGrid3D<WorldParticle> spatialGrid = null;

    public static AmbientParticles getInstance() {
        return Instance.get(AmbientParticles.class);
    }

    public AmbientParticles() {
        super("module.ambientparticles.name", ModuleCategory.PARTICLES);
        GroupSetting colorGroup = new GroupSetting("group.ambientparticles.colors.name", "group.ambientparticles.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors, this.colorAnimation);
        GroupSetting appearanceGroup = new GroupSetting("group.ambientparticles.appearance.name", "group.ambientparticles.appearance.desc", false).settings(this.mode, this.physics);
        GroupSetting regularGroup = new GroupSetting("group.ambientparticles.regular.name", "group.ambientparticles.regular.desc", false).settings(this.regularCount, this.regularScale).visible(() -> this.mode.getSelected().stream().anyMatch(m -> m.equals("Stars") || m.equals("Hearts") || m.equals("Bloom") || m.equals("Glyph") || m.equals("Things") || m.equals("Blink") || m.equals("Coron") || m.equals("Dollar") || m.equals("Flame") || m.equals("Geometric") || m.equals("Snowflake") || m.equals("Logo") || m.equals("Virus") || m.equals("SoupAPI Old") || m.equals("Sword") || m.equals("Network")));
        GroupSetting fireflyGroup = new GroupSetting("group.ambientparticles.firefly.name", "group.ambientparticles.firefly.desc", false).settings(this.fireflyCount, this.fireflyScale, this.fireflyTrailLength).visible(() -> this.mode.getSelected().contains("Firefly"));
        GroupSetting geometricsGroup = new GroupSetting("group.ambientparticles.geometrics.name", "group.ambientparticles.geometrics.desc", false).settings(this.geometricsCount, this.geometricsScale).visible(() -> this.mode.getSelected().contains("Cube") || this.mode.getSelected().contains("Pyramid"));
        GroupSetting networkGroup = new GroupSetting("group.ambientparticles.network.name", "group.ambientparticles.network.desc", false).settings(this.linkDistance, this.maxLinksPerParticle).visible(() -> this.mode.getSelected().contains("Network"));
        GroupSetting spawnGroup = new GroupSetting("group.ambientparticles.spawn.name", "group.ambientparticles.spawn.desc", false).settings(this.spawnRadius, this.spawnHeight);
        this.setup(colorGroup, appearanceGroup, regularGroup, fireflyGroup, geometricsGroup, networkGroup, spawnGroup);
    }

    @Override
    public SelectSetting getColorMode() {
        return this.colorMode;
    }

    @Override
    public SelectSetting getColorAnimation() {
        return this.colorAnimation;
    }

    @Override
    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    private String getRandomMode() {
        List<String> selected = this.mode.getSelected().stream().filter(m -> !m.equals("Firefly") && !m.equals("Cube") && !m.equals("Pyramid")).toList();
        if (selected.isEmpty()) {
            return null;
        }
        return selected.get(ThreadLocalRandom.current().nextInt(selected.size()));
    }

    private String getRandomGeometricMode() {
        List<String> selected = this.mode.getSelected().stream().filter(m -> m.equals("Cube") || m.equals("Pyramid")).toList();
        if (selected.isEmpty()) {
            return "Cube";
        }
        return selected.get(ThreadLocalRandom.current().nextInt(selected.size()));
    }

    private String getRandomPhysics() {
        List<String> selected = this.physics.getSelected();
        if (selected.isEmpty()) {
            return "Fall";
        }
        return selected.get(ThreadLocalRandom.current().nextInt(selected.size()));
    }

    @EventHandler
    public void onTick(TickEvent event) {
        if (AmbientParticles.mc.field_1724 == null || AmbientParticles.mc.field_1687 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.mode.isSelected("Firefly")) {
            this.fireflyParticles.removeIf(firefly -> firefly.tick(this::isFireflyVisible));
        } else {
            this.fireflyParticles.clear();
        }
        List<WorldParticle> toRemove = ParticleUpdateExecutor.updateParticles(this.particles, currentTime, this::isParticleVisible);
        for (WorldParticle worldParticle : toRemove) {
            this.particles.remove(worldParticle);
            if (!worldParticle.getParticleMode().equals("Network")) continue;
            if (this.spatialGrid != null) {
                this.spatialGrid.remove(worldParticle, worldParticle.getX(), worldParticle.getY(), worldParticle.getZ());
            }
            this.networkParticles.remove(worldParticle);
        }
        List<WorldParticle> geometricsToRemove = ParticleUpdateExecutor.updateParticles(this.geometricsParticles, currentTime, this::isParticleVisible);
        this.geometricsParticles.removeAll(geometricsToRemove);
        if (this.spatialGrid != null && !this.networkParticles.isEmpty()) {
            for (WorldParticle particle : this.networkParticles) {
                this.spatialGrid.update(particle, particle.getPx(), particle.getPy(), particle.getPz(), particle.getX(), particle.getY(), particle.getZ());
            }
        }
        List<String> list = this.mode.getSelected();
        List<String> selectedPhysics = this.physics.getSelected();
        if (!list.isEmpty() && !selectedPhysics.isEmpty()) {
            int i;
            boolean hasRegularParticles = list.stream().anyMatch(m -> !m.equals("Firefly") && !m.equals("Cube") && !m.equals("Pyramid"));
            if (hasRegularParticles) {
                int currentRegularCount = this.particles.size();
                int targetRegularCount = (int)this.regularCount.getValue();
                for (i = currentRegularCount; i < targetRegularCount; ++i) {
                    this.spawnParticle(currentTime);
                }
            } else {
                this.particles.clear();
                this.networkParticles.clear();
                if (this.spatialGrid != null) {
                    this.spatialGrid = null;
                }
            }
            if (list.contains("Cube") || list.contains("Pyramid")) {
                int currentGeometricsCount = this.geometricsParticles.size();
                int targetGeometricsCount = (int)this.geometricsCount.getValue();
                for (i = currentGeometricsCount; i < targetGeometricsCount; ++i) {
                    this.spawnGeometric(currentTime);
                }
            } else {
                this.geometricsParticles.clear();
            }
            if (list.contains("Firefly")) {
                int currentFireflyCount = this.fireflyParticles.size();
                int targetFireflyCount = (int)this.fireflyCount.getValue();
                for (i = currentFireflyCount; i < targetFireflyCount; ++i) {
                    this.spawnFirefly();
                }
            }
        } else {
            this.particles.clear();
            this.geometricsParticles.clear();
            this.fireflyParticles.clear();
            this.networkParticles.clear();
            if (this.spatialGrid != null) {
                this.spatialGrid = null;
            }
        }
    }

    private void spawnFirefly() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        float radius = this.spawnRadius.getValue();
        float height = this.spawnHeight.getValue();
        float x = (float)(AmbientParticles.mc.field_1724.method_23317() + (random.nextDouble() * 2.0 - 1.0) * (double)radius);
        float y = (float)(AmbientParticles.mc.field_1724.method_23318() + 2.0 + random.nextDouble() * (double)(height - 2.0f));
        float z = (float)(AmbientParticles.mc.field_1724.method_23321() + (random.nextDouble() * 2.0 - 1.0) * (double)radius);
        int[] customColorsArray = null;
        int colorInt = this.colorMode.isSelected("Sync") ? ColorUtil.getClientColor() : ((customColorsArray = this.getCustomColors()) != null && customColorsArray.length > 0 ? customColorsArray[0] : -256);
        FireFlyParticle firefly = new FireFlyParticle(x, y, z, new Color(colorInt), customColorsArray, this.fireflyScale.getValue(), (int)this.fireflyTrailLength.getValue());
        this.fireflyParticles.add(firefly);
    }

    private void spawnGeometric(long currentTime) {
        int[] colors;
        String selectedMode = this.getRandomGeometricMode();
        String selectedPhysics = this.getRandomPhysics();
        boolean emerge = selectedPhysics.equals("Emerge");
        ThreadLocalRandom random = ThreadLocalRandom.current();
        float radius = this.spawnRadius.getValue();
        float height = this.spawnHeight.getValue();
        float x = (float)(AmbientParticles.mc.field_1724.method_23317() + (random.nextDouble() * 2.0 - 1.0) * (double)radius);
        float y = emerge ? (float)(AmbientParticles.mc.field_1724.method_23318() - 1.0 - random.nextDouble() * 2.0) : (float)(AmbientParticles.mc.field_1724.method_23318() + 2.0 + random.nextDouble() * (double)(height - 2.0f));
        float z = (float)(AmbientParticles.mc.field_1724.method_23321() + (random.nextDouble() * 2.0 - 1.0) * (double)radius);
        int colorInt = this.colorMode.isSelected("Sync") ? ColorUtil.getClientColor() : ((colors = this.getCustomColors()) != null && colors.length > 0 ? colors[0] : -1);
        WorldParticle particle = new WorldParticle(x, y, z, new Color(colorInt), (float)(random.nextDouble() * 180.0), (float)(random.nextDouble() * 5.0 + 5.0), 0.0f, selectedMode, selectedPhysics, null, 0.0f, this.geometricsScale.getValue(), 0.0f, this);
        this.geometricsParticles.add(particle);
    }

    private void spawnParticle(long currentTime) {
        int[] colors;
        String selectedMode = this.getRandomMode();
        if (selectedMode == null) {
            return;
        }
        String selectedPhysics = selectedMode.equals("Network") ? "Fly" : this.getRandomPhysics();
        boolean drop = selectedPhysics.equals("Fall");
        boolean emerge = selectedPhysics.equals("Emerge");
        ThreadLocalRandom random = ThreadLocalRandom.current();
        float radius = this.spawnRadius.getValue();
        float height = this.spawnHeight.getValue();
        float x = (float)(AmbientParticles.mc.field_1724.method_23317() + (random.nextDouble() * 2.0 - 1.0) * (double)radius);
        float y = emerge ? (float)(AmbientParticles.mc.field_1724.method_23318() - 1.0 - random.nextDouble() * 2.0) : (float)(AmbientParticles.mc.field_1724.method_23318() + 2.0 + random.nextDouble() * (double)(height - 2.0f));
        float z = (float)(AmbientParticles.mc.field_1724.method_23321() + (random.nextDouble() * 2.0 - 1.0) * (double)radius);
        int colorInt = this.colorMode.isSelected("Sync") ? ColorUtil.getClientColor() : ((colors = this.getCustomColors()) != null && colors.length > 0 ? colors[0] : -1);
        WorldParticle particle = new WorldParticle(x, y, z, new Color(colorInt), (float)(random.nextDouble() * 180.0), (float)(random.nextDouble() * 5.0 + 5.0), 0.0f, selectedMode, selectedPhysics, selectedMode.equals("Glyph") ? ParticleData.getRandomGlyphTexture() : (selectedMode.equals("Things") ? ParticleData.getRandomGlyphAltTexture() : null), 0.0f, this.regularScale.getValue(), 0.0f, this);
        this.particles.add(particle);
        if (selectedMode.equals("Network")) {
            if (this.spatialGrid == null) {
                this.spatialGrid = new SpatialGrid3D(this.linkDistance.getValue());
            }
            this.networkParticles.add(particle);
            this.spatialGrid.insert(particle, x, y, z);
        }
    }

    @EventHandler
    public void onWorldRender(WorldRenderEvent event) {
        class_4587 stack = event.getStack();
        if (AmbientParticles.mc.field_1724 != null && AmbientParticles.mc.field_1687 != null) {
            long currentTime = System.currentTimeMillis();
            if (this.mode.isSelected("Firefly") && !this.fireflyParticles.isEmpty()) {
                for (FireFlyParticle fireflyParticle : this.fireflyParticles) {
                    if (!fireflyParticle.isVisible()) continue;
                    fireflyParticle.render(stack);
                }
            }
            for (WorldParticle particle : this.particles) {
                if (!particle.isVisible()) continue;
                particle.render(stack, currentTime);
            }
            for (WorldParticle particle : this.geometricsParticles) {
                if (!particle.isVisible()) continue;
                particle.render(stack, currentTime);
            }
            if (this.mode.isSelected("Network") && this.spatialGrid != null && !this.networkParticles.isEmpty()) {
                this.renderNetworkLinks(stack, currentTime);
            }
        }
    }

    private boolean isParticleVisible(WorldParticle particle) {
        float size = particle.getScale() * 0.07f;
        class_238 particleBox = new class_238((double)(particle.getX() - size), (double)(particle.getY() - size), (double)(particle.getZ() - size), (double)(particle.getX() + size), (double)(particle.getY() + size), (double)(particle.getZ() + size));
        return ProjectionUtil.canSee(particleBox);
    }

    private boolean isFireflyVisible(FireFlyParticle firefly) {
        float size = this.fireflyScale.getValue() * 0.5f;
        class_238 particleBox = new class_238((double)(firefly.getPosX() - size), (double)(firefly.getPosY() - size), (double)(firefly.getPosZ() - size), (double)(firefly.getPosX() + size), (double)(firefly.getPosY() + size), (double)(firefly.getPosZ() + size));
        return ProjectionUtil.canSee(particleBox);
    }

    private void renderNetworkLinks(class_4587 matrices, long currentTime) {
        if (this.networkParticles.size() < 2 || this.spatialGrid == null) {
            return;
        }
        float maxLinkDistance = this.linkDistance.getValue();
        int maxLinks = (int)this.maxLinksPerParticle.getValue();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        RenderSystem.enableDepthTest();
        int lineCount = 0;
        int estimatedPairs = Math.min(this.networkParticles.size() * maxLinks / 2, 1000);
        HashSet<ParticlePair> processedPairs = new HashSet<ParticlePair>(estimatedPairs);
        double cameraX = AmbientParticles.mc.field_1773.method_19418().method_19326().field_1352;
        double cameraY = AmbientParticles.mc.field_1773.method_19418().method_19326().field_1351;
        double cameraZ = AmbientParticles.mc.field_1773.method_19418().method_19326().field_1350;
        block0: for (WorldParticle p1 : this.networkParticles) {
            double posZ1;
            double posY1;
            if (!p1.isVisible()) continue;
            double posX1 = MathUtil.interpolate(p1.getPx(), p1.getX());
            double camDistSq = (posX1 - cameraX) * (posX1 - cameraX) + ((posY1 = (double)MathUtil.interpolate(p1.getPy(), p1.getY()) + 0.1) - cameraY) * (posY1 - cameraY) + ((posZ1 = (double)MathUtil.interpolate(p1.getPz(), p1.getZ())) - cameraZ) * (posZ1 - cameraZ);
            int effectiveMaxLinks = camDistSq < 100.0 ? maxLinks : (camDistSq < 400.0 ? Math.max(1, maxLinks / 2) : Math.max(1, maxLinks / 4));
            List<SpatialGrid3D.GridEntry<WorldParticle>> nearbyEntries = this.spatialGrid.queryRadiusWithPositions((float)posX1, (float)posY1, (float)posZ1, maxLinkDistance);
            if (nearbyEntries.size() > effectiveMaxLinks) {
                nearbyEntries.sort((e1, e2) -> {
                    double dist1Sq = ((double)e1.getX() - posX1) * ((double)e1.getX() - posX1) + ((double)e1.getY() - posY1) * ((double)e1.getY() - posY1) + ((double)e1.getZ() - posZ1) * ((double)e1.getZ() - posZ1);
                    double dist2Sq = ((double)e2.getX() - posX1) * ((double)e2.getX() - posX1) + ((double)e2.getY() - posY1) * ((double)e2.getY() - posY1) + ((double)e2.getZ() - posZ1) * ((double)e2.getZ() - posZ1);
                    return Double.compare(dist1Sq, dist2Sq);
                });
                nearbyEntries = nearbyEntries.subList(0, effectiveMaxLinks);
            }
            int linksDrawn = 0;
            for (SpatialGrid3D.GridEntry<WorldParticle> entry : nearbyEntries) {
                int color2;
                int color1;
                double posZ2;
                double dz;
                double posY2;
                double dy;
                ParticlePair pair;
                if (linksDrawn >= effectiveMaxLinks) continue block0;
                WorldParticle p2 = entry.getObject();
                if (p1 == p2 || !p2.isVisible() || processedPairs.contains(pair = new ParticlePair(p1, p2))) continue;
                processedPairs.add(pair);
                double posX2 = MathUtil.interpolate(p2.getPx(), p2.getX());
                double dx = posX2 - posX1;
                double dist = Math.sqrt(dx * dx + (dy = (posY2 = (double)MathUtil.interpolate(p2.getPy(), p2.getY()) + 0.1) - posY1) * dy + (dz = (posZ2 = (double)MathUtil.interpolate(p2.getPz(), p2.getZ())) - posZ1) * dz);
                if (!(dist < (double)maxLinkDistance) || !(dist > 0.01)) continue;
                float lineAlpha = (float)(1.0 - dist / (double)maxLinkDistance);
                float particleAlpha1 = p1.getAlpha();
                float particleAlpha2 = p2.getAlpha();
                float alpha = Math.min(lineAlpha, Math.min(particleAlpha1, particleAlpha2));
                if (camDistSq > 100.0) {
                    float distFade = Math.max(0.1f, 1.0f - (float)(camDistSq - 100.0) / 300.0f);
                    alpha *= distFade;
                }
                if (this.colorMode.isSelected("Sync")) {
                    int baseColor = ColorUtil.getClientColor();
                    color2 = color1 = ColorUtil.multAlpha(baseColor, alpha);
                } else {
                    int[] colors = this.getCustomColors();
                    if (colors != null && colors.length > 0) {
                        if (this.colorAnimation.isSelected("Vertex")) {
                            int offset1 = System.identityHashCode(p1) % 360;
                            int offset2 = System.identityHashCode(p2) % 360;
                            color1 = ParticleColorUtil.getVertexGradientColor(offset1, colors, alpha);
                            color2 = ParticleColorUtil.getVertexGradientColor(offset2, colors, alpha);
                        } else {
                            color1 = ParticleColorUtil.getWaveColor(colors, alpha, p1.getColorOffset());
                            color2 = ParticleColorUtil.getWaveColor(colors, alpha, p2.getColorOffset());
                        }
                    } else {
                        color2 = color1 = ColorUtil.multAlpha(-1, alpha);
                    }
                }
                bufferBuilder.method_22918(matrix, (float)posX1, (float)posY1, (float)posZ1).method_22915((float)(color1 >> 16 & 0xFF) / 255.0f, (float)(color1 >> 8 & 0xFF) / 255.0f, (float)(color1 & 0xFF) / 255.0f, (float)(color1 >> 24 & 0xFF) / 255.0f);
                bufferBuilder.method_22918(matrix, (float)posX2, (float)posY2, (float)posZ2).method_22915((float)(color2 >> 16 & 0xFF) / 255.0f, (float)(color2 >> 8 & 0xFF) / 255.0f, (float)(color2 & 0xFF) / 255.0f, (float)(color2 >> 24 & 0xFF) / 255.0f);
                ++lineCount;
                ++linksDrawn;
            }
        }
        if (lineCount > 0) {
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.particles.clear();
        this.networkParticles.clear();
        this.geometricsParticles.clear();
        this.fireflyParticles.clear();
        if (this.spatialGrid != null) {
            this.spatialGrid = null;
        }
    }

    public SelectSetting getCustomColorsCount() {
        return this.customColorsCount;
    }

    public MultiSelectSetting getMode() {
        return this.mode;
    }

    public MultiSelectSetting getPhysics() {
        return this.physics;
    }

    public ValueSetting getRegularCount() {
        return this.regularCount;
    }

    public ValueSetting getRegularScale() {
        return this.regularScale;
    }

    public ValueSetting getFireflyCount() {
        return this.fireflyCount;
    }

    public ValueSetting getFireflyScale() {
        return this.fireflyScale;
    }

    public ValueSetting getFireflyTrailLength() {
        return this.fireflyTrailLength;
    }

    public ValueSetting getGeometricsCount() {
        return this.geometricsCount;
    }

    public ValueSetting getGeometricsScale() {
        return this.geometricsScale;
    }

    public ValueSetting getLinkDistance() {
        return this.linkDistance;
    }

    public ValueSetting getMaxLinksPerParticle() {
        return this.maxLinksPerParticle;
    }

    public ValueSetting getSpawnRadius() {
        return this.spawnRadius;
    }

    public ValueSetting getSpawnHeight() {
        return this.spawnHeight;
    }

    public CopyOnWriteArrayList<WorldParticle> getParticles() {
        return this.particles;
    }

    public CopyOnWriteArrayList<WorldParticle> getNetworkParticles() {
        return this.networkParticles;
    }

    public CopyOnWriteArrayList<WorldParticle> getGeometricsParticles() {
        return this.geometricsParticles;
    }

    public CopyOnWriteArrayList<FireFlyParticle> getFireflyParticles() {
        return this.fireflyParticles;
    }

    public SpatialGrid3D<WorldParticle> getSpatialGrid() {
        return this.spatialGrid;
    }

    private record ParticlePair(WorldParticle p1, WorldParticle p2) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            WorldParticle other1;
            WorldParticle worldParticle;
            if (!(obj instanceof ParticlePair)) return false;
            ParticlePair particlePair = (ParticlePair)obj;
            try {
                other1 = worldParticle = particlePair.p1();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            WorldParticle other2 = worldParticle = particlePair.p2();
            if (this.p1 == other1) {
                if (this.p2 == other2) return true;
            }
            if (this.p1 != other2) return false;
            if (this.p2 != other1) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.p1) + System.identityHashCode(this.p2);
        }
    }
}

