/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.particles;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.base.util.animation.Interpolations;
import padej.soup.base.util.animation.ThreeStageAnimation;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.other.StopWatch;
import padej.soup.base.util.render.HitBubblesRenderer;
import padej.soup.implement.events.player.EventAttack;
import padej.soup.implement.events.render.WorldRenderEvent;

public class HitBubbles
extends Module {
    private final List<Bubble> bubbles = new ArrayList<Bubble>();
    private boolean wasLastAttackCrit = false;
    public final SelectSetting colorMode = new SelectSetting("setting.hitbubbles.colormode.name", "setting.hitbubbles.colormode.desc").value("Sync", "Custom").selected("Sync");
    public final SelectSetting customColorsCount = new SelectSetting("setting.hitbubbles.colorcount.name", "setting.hitbubbles.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Solo").visible(() -> this.colorMode.isSelected("Custom"));
    public final MultiColorSetting customColors = new MultiColorSetting("setting.hitbubbles.gradientcolors.name", "setting.hitbubbles.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom"));
    public final SelectSetting colorAnimation = new SelectSetting("setting.hitbubbles.coloranimation.name", "setting.hitbubbles.coloranimation.desc").value("Wave", "Vertexes").selected("Wave").visible(() -> this.colorMode.isSelected("Custom"));
    private final SelectSetting bubbleTexture = new SelectSetting("setting.hitbubbles.bubblestyle.name", "setting.hitbubbles.bubblestyle.desc").value("Default", "Bold", "Portal", "Soup").selected("Portal");
    public final SelectSetting animationType = new SelectSetting("setting.hitbubbles.animationtype.name", "setting.hitbubbles.animationtype.desc").value("Fade", "Scale", "Both").selected("Both");
    public final ValueSetting appearDuration = new ValueSetting("setting.hitbubbles.appearduration.name", "setting.hitbubbles.appearduration.desc").setValue(0.3f).range(0.1f, 3.0f);
    public final ValueSetting existDuration = new ValueSetting("setting.hitbubbles.existduration.name", "setting.hitbubbles.existduration.desc").setValue(0.5f).range(0.1f, 3.0f);
    public final ValueSetting disappearDuration = new ValueSetting("setting.hitbubbles.disappearduration.name", "setting.hitbubbles.disappearduration.desc").setValue(0.5f).range(0.1f, 3.0f);
    public final SelectSetting appearInterpolation = new SelectSetting("setting.hitbubbles.appearinterpolation.name", "setting.hitbubbles.appearinterpolation.desc").value(Interpolations.getAllNames()).selected("Bounce");
    public final SelectSetting disappearInterpolation = new SelectSetting("setting.hitbubbles.disappearinterpolation.name", "setting.hitbubbles.disappearinterpolation.desc").value(Interpolations.getAllNames()).selected("Smooth");
    public final ValueSetting rotateSpeed = new ValueSetting("setting.hitbubbles.rotatespeed.name", "setting.hitbubbles.rotatespeed.desc").setValue(2.0f).range(0.5f, 5.0f);
    public final ValueSetting scale = new ValueSetting("setting.hitbubbles.scale.name", "setting.hitbubbles.scale.desc").setValue(0.75f).range(0.5f, 2.0f);
    public final BooleanSetting onlyCrits = new BooleanSetting("setting.hitbubbles.onlycrits.name", "setting.hitbubbles.onlycrits.desc").setValue(false);

    public static HitBubbles getInstance() {
        return Instance.get(HitBubbles.class);
    }

    public HitBubbles() {
        super("module.hitbubbles.name", ModuleCategory.PARTICLES);
        GroupSetting colorGroup = new GroupSetting("group.hitbubbles.colors.name", "group.hitbubbles.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors, this.colorAnimation);
        GroupSetting durationGroup = new GroupSetting("group.hitbubbles.duration.name", "group.hitbubbles.duration.desc", false).settings(this.appearDuration, this.existDuration, this.disappearDuration);
        GroupSetting animationGroup = new GroupSetting("group.hitbubbles.animation.name", "group.hitbubbles.animation.desc", false).settings(this.appearInterpolation, this.disappearInterpolation, this.rotateSpeed, this.scale);
        this.setup(colorGroup, this.bubbleTexture, this.animationType, durationGroup, animationGroup, this.onlyCrits);
    }

    private boolean isCrit() {
        class_746 player = HitBubbles.mc.field_1724;
        if (player == null) {
            return false;
        }
        boolean bl = player.method_7261(0.5f) > 0.9f;
        return bl && player.field_6017 > 0.0f && !player.method_24828() && !player.method_6101() && !player.method_5799() && !player.method_6059(class_1294.field_5919) && !player.method_5765() && !player.method_5624();
    }

    @EventHandler
    public void onAttack(EventAttack event) {
        if (HitBubbles.mc.field_1724 == null || HitBubbles.mc.field_1687 == null) {
            return;
        }
        if (event.isPre()) {
            if (HitBubbles.mc.field_1724.method_7261(0.5f) > 0.9f) {
                this.wasLastAttackCrit = this.isCrit();
            }
            return;
        }
        if (event.getTarget() == null) {
            return;
        }
        if (this.onlyCrits.isValue() && !this.wasLastAttackCrit) {
            return;
        }
        class_243 point = event.getHitPos();
        if (point != null) {
            class_243 fromPos = HitBubbles.mc.field_1724.method_33571();
            class_243 direction = point.method_1020(fromPos).method_1029();
            float yaw = (float)Math.toDegrees(Math.atan2(direction.field_1350, direction.field_1352)) - 90.0f;
            float pitch = (float)(-Math.toDegrees(Math.asin(direction.field_1351)));
            this.bubbles.add(new Bubble(point, -yaw, pitch, new StopWatch(), (class_1657)HitBubbles.mc.field_1724));
        }
    }

    @EventHandler
    public void onWorldRender(WorldRenderEvent e) {
        if (HitBubbles.mc.field_1687 == null || HitBubbles.mc.field_1724 == null) {
            return;
        }
        this.bubbles.removeIf(bubble -> {
            double totalDuration;
            double elapsedSeconds = (double)bubble.timer.elapsedTime() / 1000.0;
            return elapsedSeconds > (totalDuration = this.getTotalAnimationDuration());
        });
        if (this.bubbles.isEmpty()) {
            return;
        }
        for (Bubble bubble2 : this.bubbles) {
            bubble2.updateRotation(this);
            bubble2.updateAnimation(this);
            HitBubblesRenderer.renderBubble(bubble2.pos, bubble2.yaw, bubble2.pitch, bubble2.timer, bubble2.rotationAngle, this, bubble2.animation);
        }
    }

    @Override
    public void deactivate() {
        this.bubbles.clear();
    }

    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    public double getTotalAnimationDuration() {
        return this.appearDuration.getValue() + this.existDuration.getValue() + this.disappearDuration.getValue();
    }

    public ThreeStageAnimation createAnimation() {
        return new ThreeStageAnimation(this.appearDuration.getValue(), this.existDuration.getValue(), this.disappearDuration.getValue(), Interpolations.getByName(this.appearInterpolation.getSelected()), Interpolations.getByName(this.disappearInterpolation.getSelected()));
    }

    public class_2960 getBubbleTexture() {
        return switch (this.bubbleTexture.getSelected()) {
            case "Default" -> class_2960.method_60654((String)"textures/circles/circle.png");
            case "Bold" -> class_2960.method_60654((String)"textures/circles/circle_bold.png");
            case "Portal" -> class_2960.method_60654((String)"textures/circles/portal.png");
            case "Soup" -> class_2960.method_60654((String)"textures/circles/soup.png");
            default -> null;
        };
    }

    public List<Bubble> getBubbles() {
        return this.bubbles;
    }

    public boolean isWasLastAttackCrit() {
        return this.wasLastAttackCrit;
    }

    public SelectSetting getColorMode() {
        return this.colorMode;
    }

    public SelectSetting getCustomColorsCount() {
        return this.customColorsCount;
    }

    public SelectSetting getColorAnimation() {
        return this.colorAnimation;
    }

    public SelectSetting getAnimationType() {
        return this.animationType;
    }

    public ValueSetting getAppearDuration() {
        return this.appearDuration;
    }

    public ValueSetting getExistDuration() {
        return this.existDuration;
    }

    public ValueSetting getDisappearDuration() {
        return this.disappearDuration;
    }

    public SelectSetting getAppearInterpolation() {
        return this.appearInterpolation;
    }

    public SelectSetting getDisappearInterpolation() {
        return this.disappearInterpolation;
    }

    public ValueSetting getRotateSpeed() {
        return this.rotateSpeed;
    }

    public ValueSetting getScale() {
        return this.scale;
    }

    public BooleanSetting getOnlyCrits() {
        return this.onlyCrits;
    }

    private static class Bubble {
        final class_243 pos;
        final float yaw;
        final float pitch;
        final StopWatch timer;
        final class_1657 player;
        float rotationAngle;
        final float angularVelocity;
        long lastUpdateTime;
        ThreeStageAnimation animation;

        Bubble(class_243 pos, float yaw, float pitch, StopWatch timer, class_1657 player) {
            this.pos = pos;
            this.yaw = yaw;
            this.pitch = pitch;
            this.timer = timer;
            this.player = player;
            this.rotationAngle = 0.0f;
            this.angularVelocity = (float)ThreadLocalRandom.current().nextDouble(1.0, 3.0);
            this.lastUpdateTime = System.currentTimeMillis();
        }

        void updateAnimation(HitBubbles module) {
            if (this.animation == null) {
                this.animation = module.createAnimation();
            }
        }

        void updateRotation(HitBubbles module) {
            long currentTime = System.currentTimeMillis();
            float deltaTime = (float)(currentTime - this.lastUpdateTime) / 1000.0f;
            this.lastUpdateTime = currentTime;
            deltaTime = Math.min(deltaTime, 0.1f);
            double elapsedSeconds = (double)this.timer.elapsedTime() / 1000.0;
            if (this.animation != null) {
                ThreeStageAnimation.AnimationStage stage = this.animation.getStage(elapsedSeconds);
                float frameTime = 0.016666668f;
                float normalizedDelta = deltaTime / frameTime;
                switch (stage) {
                    case APPEAR: {
                        this.rotationAngle -= this.angularVelocity * normalizedDelta * module.rotateSpeed.getValue();
                        break;
                    }
                    case EXIST: {
                        this.rotationAngle -= this.angularVelocity * normalizedDelta * module.rotateSpeed.getValue();
                        break;
                    }
                    case DISAPPEAR: {
                        double disappearProgress = (elapsedSeconds - this.animation.getAppearDuration() - this.animation.getExistDuration()) / this.animation.getDisappearDuration();
                        float fadeFactor = (float)(1.0 - disappearProgress);
                        this.rotationAngle -= this.angularVelocity * normalizedDelta * fadeFactor * module.rotateSpeed.getValue();
                        break;
                    }
                }
            }
        }
    }
}

