/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.particles;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.IParticleModule;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.ColorSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.particle.ParticleUpdateExecutor;
import padej.soup.base.util.spatial.SpatialGrid3D;
import padej.soup.implement.events.player.EventAttack;
import padej.soup.implement.events.player.TickEvent;
import padej.soup.implement.events.render.WorldRenderEvent;
import padej.soup.implement.features.modules.particles.ParticleData;
import padej.soup.implement.features.modules.particles.render.NetworkRenderer;
import padej.soup.implement.features.modules.particles.types.WorldParticle;

public class HitParticles
extends Module
implements IParticleModule {
    public final SelectSetting colorMode = new SelectSetting("setting.hitparticles.colormode.name", "setting.hitparticles.colormode.desc").value("Sync", "Custom").selected("Sync");
    private final SelectSetting customColorsCount = new SelectSetting("setting.hitparticles.colorcount.name", "setting.hitparticles.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Solo").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiColorSetting customColors = new MultiColorSetting("setting.hitparticles.gradientcolors.name", "setting.hitparticles.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom"));
    public final SelectSetting colorAnimation = new SelectSetting("setting.hitparticles.coloranimation.name", "setting.hitparticles.coloranimation.desc").value("Wave", "Vertex").selected("Wave").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiSelectSetting mode = new MultiSelectSetting("setting.hitparticles.mode.name", "setting.hitparticles.mode.desc").selected("Stars", "Hearts", "Bloom").value("Stars", "Hearts", "Bloom", "Glyph", "Things", "Blink", "Coron", "Dollar", "Flame", "Geometric", "Snowflake", "Logo", "Virus", "SoupAPI Old", "Sword", "Network", "Cube", "Pyramid");
    private final MultiSelectSetting physics = new MultiSelectSetting("setting.hitparticles.physics.name", "setting.hitparticles.physics.desc").selected("Fly").value("Fall", "Fly");
    private final ValueSetting scale = new ValueSetting("setting.hitparticles.scale.name", "setting.hitparticles.scale.desc").setValue(3.0f).range(1.0f, 10.0f);
    private final ColorSetting healColor = new ColorSetting("setting.hitparticles.healcolor.name", "setting.hitparticles.healcolor.desc").value(-13641408);
    private final ColorSetting damageColor = new ColorSetting("setting.hitparticles.damagecolor.name", "setting.hitparticles.damagecolor.desc").value(-973005);
    public final ValueSetting linkDistance = new ValueSetting("setting.hitparticles.linkdistance.name", "setting.hitparticles.linkdistance.desc").setValue(3.0f).range(1.0f, 10.0f).visible(() -> this.mode.getSelected().contains("Network"));
    private final SelectSetting spawnLocation = new SelectSetting("setting.hitparticles.spawnloc.name", "setting.hitparticles.spawnloc.desc").value("Center", "Hit Loc").selected("Hit Loc");
    private final BooleanSetting showSelf = new BooleanSetting("setting.hitparticles.showself.name", "setting.hitparticles.showself.desc").setValue(true);
    private final BooleanSetting onlyCrits = new BooleanSetting("setting.hitparticles.onlycrits.name", "setting.hitparticles.onlycrits.desc").setValue(false);
    private final ValueSetting amount = new ValueSetting("setting.hitparticles.amount.name", "setting.hitparticles.amount.desc").setValue(2.0f).range(1, 5);
    private final ValueSetting spawnFrequency = new ValueSetting("setting.hitparticles.spawnfrequency.name", "setting.hitparticles.spawnfrequency.desc").setValue(1.0f).range(1, 10);
    private final ValueSetting lifeTime = new ValueSetting("setting.hitparticles.lifetime.name", "setting.hitparticles.lifetime.desc").setValue(2.0f).range(1, 15);
    private final ValueSetting speed = new ValueSetting("setting.hitparticles.speed.name", "setting.hitparticles.speed.desc").setValue(2.0f).range(1, 20);
    private final HashMap<Integer, Float> healthMap = new HashMap();
    private boolean wasLastAttackCrit = false;
    private final CopyOnWriteArrayList<WorldParticle> particles = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<WorldParticle> networkParticles = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Emitter> emitters = new CopyOnWriteArrayList();
    private SpatialGrid3D<WorldParticle> spatialGrid = null;

    public static HitParticles getInstance() {
        return Instance.get(HitParticles.class);
    }

    public HitParticles() {
        super("module.hitparticles.name", ModuleCategory.PARTICLES);
        GroupSetting colorGroup = new GroupSetting("group.hitparticles.colors.name", "group.hitparticles.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors, this.colorAnimation);
        GroupSetting textColorGroup = new GroupSetting("group.hitparticles.textcolors.name", "group.hitparticles.textcolors.desc", false).settings(this.healColor, this.damageColor).visible(() -> this.mode.getSelected().contains("Text"));
        GroupSetting appearanceGroup = new GroupSetting("group.hitparticles.appearance.name", "group.hitparticles.appearance.desc", false).settings(this.mode, this.physics, this.scale);
        GroupSetting behaviorGroup = new GroupSetting("group.hitparticles.behavior.name", "group.hitparticles.behavior.desc", false).settings(this.lifeTime, this.speed);
        GroupSetting spawnGroup = new GroupSetting("group.hitparticles.spawn.name", "group.hitparticles.spawn.desc", false).settings(this.spawnLocation, this.showSelf, this.onlyCrits, this.amount, this.spawnFrequency);
        this.setup(colorGroup, textColorGroup, appearanceGroup, behaviorGroup, spawnGroup, this.linkDistance);
    }

    @Override
    public SelectSetting getColorMode() {
        return this.colorMode;
    }

    @Override
    public SelectSetting getColorAnimation() {
        return this.colorAnimation;
    }

    @Override
    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    @Override
    public int getHealColor() {
        return this.healColor.getColor();
    }

    @Override
    public int getDamageColor() {
        return this.damageColor.getColor();
    }

    private String getRandomMode() {
        List<String> selected = this.mode.getSelected().stream().filter(m -> !m.equals("Text")).toList();
        if (selected.isEmpty()) {
            return "Stars";
        }
        return selected.get(ThreadLocalRandom.current().nextInt(selected.size()));
    }

    private String getRandomPhysics() {
        List<String> selected = this.physics.getSelected();
        if (selected.isEmpty()) {
            return "Fall";
        }
        return selected.get(ThreadLocalRandom.current().nextInt(selected.size()));
    }

    private boolean isCrit() {
        class_746 player = HitParticles.mc.field_1724;
        if (player == null) {
            return false;
        }
        boolean bl = player.method_7261(0.5f) > 0.9f;
        return bl && player.field_6017 > 0.0f && !player.method_24828() && !player.method_6101() && !player.method_5799() && !player.method_6059(class_1294.field_5919) && !player.method_5765() && !player.method_5624();
    }

    @EventHandler
    public void onTick(TickEvent event) {
        float currentCooldown;
        long currentTime = System.currentTimeMillis();
        List<WorldParticle> toRemove = ParticleUpdateExecutor.updateParticles(this.particles, currentTime, p -> true);
        for (WorldParticle particle : toRemove) {
            this.particles.remove(particle);
            if (!particle.getParticleMode().equals("Network")) continue;
            if (this.spatialGrid != null) {
                this.spatialGrid.remove(particle, particle.getX(), particle.getY(), particle.getZ());
            }
            this.networkParticles.remove(particle);
        }
        if (this.spatialGrid != null && !this.networkParticles.isEmpty()) {
            for (WorldParticle particle : this.networkParticles) {
                this.spatialGrid.update(particle, particle.getPx(), particle.getPy(), particle.getPz(), particle.getX(), particle.getY(), particle.getZ());
            }
        }
        if (HitParticles.mc.field_1724 != null && (currentCooldown = HitParticles.mc.field_1724.method_7261(0.5f)) > 0.9f) {
            this.wasLastAttackCrit = this.isCrit();
        }
        if (!this.emitters.isEmpty()) {
            for (Emitter emitter2 : this.emitters) {
                this.spawnParticlesFromEmitter(emitter2);
            }
            this.emitters.removeIf(emitter -> emitter.tick(currentTime));
        }
        if (this.mode.isSelected("Text")) {
            for (class_1297 entity : HitParticles.mc.field_1687.method_18112()) {
                int[] colors;
                if (entity == null || HitParticles.mc.field_1724.method_5858(entity) > 256.0 || !entity.method_5805() || !(entity instanceof class_1309)) continue;
                class_1309 lent = (class_1309)entity;
                int colorInt = this.colorMode.isSelected("Sync") ? ColorUtil.getClientColor() : ((colors = this.getCustomColors()) != null && colors.length > 0 ? colors[0] : -1);
                float health = lent.method_6032() + lent.method_6067();
                float lastHealth = this.healthMap.getOrDefault(entity.method_5628(), Float.valueOf(health)).floatValue();
                this.healthMap.put(entity.method_5628(), Float.valueOf(health));
                if (lastHealth == health) continue;
                ThreadLocalRandom random = ThreadLocalRandom.current();
                this.particles.add(new WorldParticle((float)lent.method_23317(), (float)(lent.method_23318() + random.nextDouble() * (double)lent.method_17682()), (float)lent.method_23321(), new Color(colorInt), (float)(random.nextDouble() * 180.0), (float)(random.nextDouble() * 25.0 + 5.0), health - lastHealth, "Text", this.getRandomPhysics(), null, this.lifeTime.getValue(), this.scale.getValue(), this.speed.getValue(), this));
            }
        }
    }

    @EventHandler
    public void onAttack(EventAttack event) {
        class_243 point;
        if (HitParticles.mc.field_1724 == null || HitParticles.mc.field_1687 == null) {
            return;
        }
        if (event.isPre()) {
            if (HitParticles.mc.field_1724.method_7261(0.5f) > 0.9f) {
                this.wasLastAttackCrit = this.isCrit();
            }
            return;
        }
        if (event.getTarget() == null) {
            return;
        }
        if (!this.showSelf.isValue() && event.getTarget() == HitParticles.mc.field_1724) {
            return;
        }
        if (this.onlyCrits.isValue() && !this.wasLastAttackCrit) {
            return;
        }
        class_243 class_2432 = point = this.spawnLocation.isSelected("Hit Loc") ? event.getHitPos() : this.getEntityCenter(event.getTarget());
        if (point != null) {
            this.emitters.add(new Emitter(point, System.currentTimeMillis(), (int)this.spawnFrequency.getValue()));
        }
    }

    private class_243 getEntityCenter(class_1297 target) {
        if (target == null) {
            return null;
        }
        return target.method_19538().method_1031(0.0, (double)target.method_17682() / 2.0, 0.0);
    }

    @EventHandler
    public void onWorldRender(WorldRenderEvent event) {
        class_4587 stack = event.getStack();
        if (HitParticles.mc.field_1724 != null && HitParticles.mc.field_1687 != null) {
            long currentTime = System.currentTimeMillis();
            for (WorldParticle particle : this.particles) {
                particle.render(stack, currentTime);
            }
            if (this.mode.isSelected("Network") && this.spatialGrid != null && !this.networkParticles.isEmpty()) {
                NetworkRenderer.renderNetworkLinks(stack, this.networkParticles, this.spatialGrid, currentTime, this.linkDistance.getValue(), this);
            }
        }
    }

    private void spawnParticlesFromEmitter(Emitter emitter) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int i = 0;
        while ((float)i < this.amount.getValue()) {
            int[] colors;
            String selectedPhysics;
            String selectedMode = this.getRandomMode();
            String string = selectedPhysics = selectedMode.equals("Network") ? "Fly" : this.getRandomPhysics();
            int colorInt = this.colorMode.isSelected("Sync") ? ColorUtil.getClientColor() : ((colors = this.getCustomColors()) != null && colors.length > 0 ? colors[0] : -1);
            float x = (float)emitter.position.field_1352;
            float y = (float)emitter.position.field_1351;
            float z = (float)emitter.position.field_1350;
            WorldParticle particle = new WorldParticle(this, x, y, z, new Color(colorInt), (float)(random.nextDouble() * 360.0), (float)(random.nextDouble() * 25.0 + 5.0), 0.0f, selectedMode, selectedPhysics, selectedMode.equals("Glyph") ? ParticleData.getRandomGlyphTexture() : (selectedMode.equals("Things") ? ParticleData.getRandomGlyphAltTexture() : null), this.lifeTime.getValue(), this.scale.getValue(), this.speed.getValue(), this){

                @Override
                protected void initMotion(float speed) {
                    ThreadLocalRandom rng = ThreadLocalRandom.current();
                    float scale = speed * 0.05f;
                    this.motionX = (float)(rng.nextGaussian() * (double)scale);
                    this.motionY = (float)(rng.nextGaussian() * (double)scale);
                    this.motionZ = (float)(rng.nextGaussian() * (double)scale);
                }
            };
            this.particles.add(particle);
            if (selectedMode.equals("Network")) {
                if (this.spatialGrid == null) {
                    this.spatialGrid = new SpatialGrid3D(this.linkDistance.getValue());
                }
                this.networkParticles.add(particle);
                this.spatialGrid.insert(particle, x, y, z);
            }
            ++i;
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.particles.clear();
        this.networkParticles.clear();
        this.emitters.clear();
        if (this.spatialGrid != null) {
            this.spatialGrid = null;
        }
    }

    public SpatialGrid3D<WorldParticle> getSpatialGrid() {
        return this.spatialGrid;
    }

    private record Emitter(class_243 position, long startTime, int duration) {
        public boolean tick(long currentTime) {
            long durationMs = (long)this.duration * 50L;
            return currentTime - this.startTime > durationMs;
        }
    }
}

