/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.particles.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import padej.soup.api.feature.module.IParticleModule;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.particle.ParticleColorUtil;

public class ParticleBatchRenderer
implements QuickImports {
    private static final int MATRIX_POOL_SIZE = 256;
    private static final Queue<Matrix4f> MATRIX_POOL = new ArrayBlockingQueue<Matrix4f>(256);
    private static final Queue<TexturedParticleData> TEXTURED_PARTICLES;
    private static final Queue<CubeParticleData> CUBE_PARTICLES;
    private static final Queue<PyramidParticleData> PYRAMID_PARTICLES;
    private static final Queue<TextParticleData> TEXT_PARTICLES;
    private static final Queue<BloomParticleData> BLOOM_PARTICLES;
    private static final Queue<FireflyTrailData> FIREFLY_TRAILS;
    private static final Queue<BubbleParticleData> BUBBLE_PARTICLES;
    private static final Queue<GhostParticleData> GHOST_PARTICLES;
    private static final Map<class_2960, List<TexturedParticleData>> TEXTURED_GROUPS;
    private static final Map<class_2960, List<AmbientTexturedParticleData>> AMBIENT_GROUPS;
    private static final Map<class_2960, List<BubbleParticleData>> BUBBLE_GROUPS;
    private static final Map<String, List<GhostParticleData>> GHOST_GROUPS;
    private static final float SQRT_3;
    private static final float SQRT_6;
    private static final Queue<AmbientTexturedParticleData> AMBIENT_TEXTURED_PARTICLES;

    private static Matrix4f acquireMatrix(Matrix4f source) {
        Matrix4f matrix = MATRIX_POOL.poll();
        if (matrix == null) {
            matrix = new Matrix4f();
        }
        return matrix.set((Matrix4fc)source);
    }

    private static void releaseMatrix(Matrix4f matrix) {
        if (MATRIX_POOL.size() < 256) {
            MATRIX_POOL.offer(matrix);
        }
    }

    private static void clearGroupLists(Map<?, List<?>> groups) {
        groups.values().forEach(List::clear);
        groups.clear();
    }

    public static void queueTexturedParticle(class_4587 matrices, class_2960 texture, float size, float alpha, int color, boolean useVertexGradient, int[] gradientColors, IParticleModule module) {
        TEXTURED_PARTICLES.add(new TexturedParticleData(ParticleBatchRenderer.acquireMatrix(matrices.method_23760().method_23761()), texture, size, alpha, color, useVertexGradient, gradientColors, module));
    }

    public static void queueCubeParticle(class_4587 matrices, float size, float alpha, int color) {
        CUBE_PARTICLES.add(new CubeParticleData(ParticleBatchRenderer.acquireMatrix(matrices.method_23760().method_23761()), size, alpha, color));
    }

    public static void queuePyramidParticle(class_4587 matrices, float size, float alpha, int color) {
        PYRAMID_PARTICLES.add(new PyramidParticleData(ParticleBatchRenderer.acquireMatrix(matrices.method_23760().method_23761()), size, alpha, color));
    }

    public static void queueTextParticle(class_4587 matrices, String text, int color) {
        TEXT_PARTICLES.add(new TextParticleData(ParticleBatchRenderer.acquireMatrix(matrices.method_23760().method_23761()), text, color));
    }

    public static void queueBloomParticle(class_4587 matrices, float size, float alpha, boolean useVertexGradient, int[] gradientColors, IParticleModule module, int colorOffset) {
        BLOOM_PARTICLES.add(new BloomParticleData(ParticleBatchRenderer.acquireMatrix(matrices.method_23760().method_23761()), size, alpha, useVertexGradient, gradientColors, module, colorOffset));
    }

    public static void queueFireflyTrail(Matrix4f matrix, float size, int color) {
        FIREFLY_TRAILS.add(new FireflyTrailData(matrix, size, color));
    }

    public static void queueBubble(class_4587 matrices, class_2960 texture, float scale, int color1, int color2, int color3, int color4) {
        BUBBLE_PARTICLES.add(new BubbleParticleData(ParticleBatchRenderer.acquireMatrix(matrices.method_23760().method_23761()), texture, scale, color1, color2, color3, color4));
    }

    public static void queueGhost(Matrix4f matrix, class_2960 texture, float scale, int color, String blendMode) {
        GHOST_PARTICLES.add(new GhostParticleData(matrix, texture, scale, color, blendMode));
    }

    public static void renderBatches() {
        if (!BLOOM_PARTICLES.isEmpty()) {
            ParticleBatchRenderer.renderBloomBatch();
        }
        if (!TEXTURED_PARTICLES.isEmpty()) {
            ParticleBatchRenderer.renderTexturedBatch();
        }
        if (!AMBIENT_TEXTURED_PARTICLES.isEmpty()) {
            ParticleBatchRenderer.renderAmbientTexturedBatch();
        }
        if (!FIREFLY_TRAILS.isEmpty()) {
            ParticleBatchRenderer.renderFireflyBatch();
        }
        if (!CUBE_PARTICLES.isEmpty()) {
            ParticleBatchRenderer.renderCubeBatch();
        }
        if (!PYRAMID_PARTICLES.isEmpty()) {
            ParticleBatchRenderer.renderPyramidBatch();
        }
        if (!TEXT_PARTICLES.isEmpty()) {
            ParticleBatchRenderer.renderTextBatch();
        }
        if (!BUBBLE_PARTICLES.isEmpty()) {
            ParticleBatchRenderer.renderBubbleBatch();
        }
        if (!GHOST_PARTICLES.isEmpty()) {
            ParticleBatchRenderer.renderGhostBatch();
        }
    }

    private static void renderTexturedBatch() {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        TEXTURED_GROUPS.clear();
        while (!TEXTURED_PARTICLES.isEmpty()) {
            TexturedParticleData data = TEXTURED_PARTICLES.poll();
            TEXTURED_GROUPS.computeIfAbsent(data.texture, k -> new ArrayList()).add(data);
        }
        TEXTURED_GROUPS.forEach((texture, particles) -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            for (TexturedParticleData data : particles) {
                if (data.useVertexGradient && data.gradientColors != null) {
                    int col1 = ParticleColorUtil.getVertexGradientColor(0, data.gradientColors, data.alpha);
                    int col2 = ParticleColorUtil.getVertexGradientColor(90, data.gradientColors, data.alpha);
                    int col3 = ParticleColorUtil.getVertexGradientColor(180, data.gradientColors, data.alpha);
                    int col4 = ParticleColorUtil.getVertexGradientColor(270, data.gradientColors, data.alpha);
                    bufferBuilder.method_22918(data.matrix, 0.0f, data.size, 0.0f).method_22913(0.0f, 1.0f).method_39415(col1);
                    bufferBuilder.method_22918(data.matrix, data.size, data.size, 0.0f).method_22913(1.0f, 1.0f).method_39415(col2);
                    bufferBuilder.method_22918(data.matrix, data.size, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_39415(col3);
                    bufferBuilder.method_22918(data.matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_39415(col4);
                } else {
                    bufferBuilder.method_22918(data.matrix, 0.0f, data.size, 0.0f).method_22913(0.0f, 1.0f).method_39415(data.color);
                    bufferBuilder.method_22918(data.matrix, data.size, data.size, 0.0f).method_22913(1.0f, 1.0f).method_39415(data.color);
                    bufferBuilder.method_22918(data.matrix, data.size, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_39415(data.color);
                    bufferBuilder.method_22918(data.matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_39415(data.color);
                }
                ParticleBatchRenderer.releaseMatrix(data.matrix);
            }
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private static void renderCubeBatch() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        RenderSystem.enableDepthTest();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        while (!CUBE_PARTICLES.isEmpty()) {
            CubeParticleData data = CUBE_PARTICLES.poll();
            float r = (float)(data.color >> 16 & 0xFF) / 255.0f;
            float g = (float)(data.color >> 8 & 0xFF) / 255.0f;
            float b = (float)(data.color & 0xFF) / 255.0f;
            float a = (float)(data.color >> 24 & 0xFF) / 255.0f;
            float half = data.size / 2.0f;
            bufferBuilder.method_22918(data.matrix, -half, -half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, -half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, -half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, -half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, -half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, -half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, -half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, -half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, -half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, -half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, -half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, -half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, -half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, -half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, -half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, half, -half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, -half, -half, half).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, half, half, -half).method_22915(r, g, b, a);
            ParticleBatchRenderer.releaseMatrix(data.matrix);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private static void renderPyramidBatch() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        RenderSystem.enableDepthTest();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        while (!PYRAMID_PARTICLES.isEmpty()) {
            PyramidParticleData data = PYRAMID_PARTICLES.poll();
            float r = (float)(data.color >> 16 & 0xFF) / 255.0f;
            float g = (float)(data.color >> 8 & 0xFF) / 255.0f;
            float b = (float)(data.color & 0xFF) / 255.0f;
            float a = (float)(data.color >> 24 & 0xFF) / 255.0f;
            float v1x = 0.0f;
            float v1y = 0.0f;
            float v1z = data.size * SQRT_6 / 4.0f;
            float v2x = -data.size / 2.0f;
            float v2y = -data.size * SQRT_3 / 6.0f;
            float v2z = -data.size * SQRT_6 / 12.0f;
            float v3x = data.size / 2.0f;
            float v3y = -data.size * SQRT_3 / 6.0f;
            float v3z = -data.size * SQRT_6 / 12.0f;
            float v4x = 0.0f;
            float v4y = data.size * SQRT_3 / 3.0f;
            float v4z = -data.size * SQRT_6 / 12.0f;
            bufferBuilder.method_22918(data.matrix, v2x, v2y, v2z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v3x, v3y, v3z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v3x, v3y, v3z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v4x, v4y, v4z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v4x, v4y, v4z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v2x, v2y, v2z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v1x, v1y, v1z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v2x, v2y, v2z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v1x, v1y, v1z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v3x, v3y, v3z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v1x, v1y, v1z).method_22915(r, g, b, a);
            bufferBuilder.method_22918(data.matrix, v4x, v4y, v4z).method_22915(r, g, b, a);
            ParticleBatchRenderer.releaseMatrix(data.matrix);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private static void renderTextBatch() {
        while (!TEXT_PARTICLES.isEmpty()) {
            TextParticleData data = TEXT_PARTICLES.poll();
            float textX = (float)(-ParticleBatchRenderer.mc.field_1772.method_1727(data.text)) / 2.0f;
            ParticleBatchRenderer.mc.field_1772.method_27521(data.text, textX, 0.0f, data.color, false, data.matrix, (class_4597)mc.method_22940().method_23000(), class_327.class_6415.field_33993, 0, 0xF000F0);
            ParticleBatchRenderer.releaseMatrix(data.matrix);
        }
    }

    private static void renderBloomBatch() {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_2960.method_60654((String)"textures/particles/bloom/bloom_small.png"));
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        while (!BLOOM_PARTICLES.isEmpty()) {
            BloomParticleData data = BLOOM_PARTICLES.poll();
            if (data.useVertexGradient && data.gradientColors != null) {
                int col1 = ParticleColorUtil.getVertexGradientColor(data.colorOffset + 0, data.gradientColors, data.alpha);
                int col2 = ParticleColorUtil.getVertexGradientColor(data.colorOffset + 90, data.gradientColors, data.alpha);
                int col3 = ParticleColorUtil.getVertexGradientColor(data.colorOffset + 180, data.gradientColors, data.alpha);
                int col4 = ParticleColorUtil.getVertexGradientColor(data.colorOffset + 270, data.gradientColors, data.alpha);
                bufferBuilder.method_22918(data.matrix, 0.0f, data.size, 0.0f).method_22913(0.0f, 1.0f).method_39415(col1);
                bufferBuilder.method_22918(data.matrix, data.size, data.size, 0.0f).method_22913(1.0f, 1.0f).method_39415(col2);
                bufferBuilder.method_22918(data.matrix, data.size, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_39415(col3);
                bufferBuilder.method_22918(data.matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_39415(col4);
            } else {
                int[] colors;
                int color = data.module.getColorMode().isSelected("Sync") ? ColorUtil.multAlpha(ColorUtil.getClientColor(), data.alpha) : ((colors = data.module.getCustomColors()) != null && colors.length > 0 ? ParticleColorUtil.getWaveColor(colors, data.alpha, data.colorOffset) : ColorUtil.multAlpha(-1, data.alpha));
                bufferBuilder.method_22918(data.matrix, 0.0f, data.size, 0.0f).method_22913(0.0f, 1.0f).method_39415(color);
                bufferBuilder.method_22918(data.matrix, data.size, data.size, 0.0f).method_22913(1.0f, 1.0f).method_39415(color);
                bufferBuilder.method_22918(data.matrix, data.size, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_39415(color);
                bufferBuilder.method_22918(data.matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_39415(color);
            }
            ParticleBatchRenderer.releaseMatrix(data.matrix);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private static void renderAmbientTexturedBatch() {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        AMBIENT_GROUPS.clear();
        while (!AMBIENT_TEXTURED_PARTICLES.isEmpty()) {
            AmbientTexturedParticleData data = AMBIENT_TEXTURED_PARTICLES.poll();
            AMBIENT_GROUPS.computeIfAbsent(data.texture, k -> new ArrayList()).add(data);
        }
        AMBIENT_GROUPS.forEach((texture, particles) -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            for (AmbientTexturedParticleData data : particles) {
                if (data.useVertexGradient && data.gradientColors != null) {
                    int col1 = ParticleColorUtil.getVertexGradientColor(0, data.gradientColors, data.alpha);
                    int col2 = ParticleColorUtil.getVertexGradientColor(90, data.gradientColors, data.alpha);
                    int col3 = ParticleColorUtil.getVertexGradientColor(180, data.gradientColors, data.alpha);
                    int col4 = ParticleColorUtil.getVertexGradientColor(270, data.gradientColors, data.alpha);
                    bufferBuilder.method_22918(data.matrix, 0.0f, data.size, 0.0f).method_22913(0.0f, 1.0f).method_39415(col1);
                    bufferBuilder.method_22918(data.matrix, data.size, data.size, 0.0f).method_22913(1.0f, 1.0f).method_39415(col2);
                    bufferBuilder.method_22918(data.matrix, data.size, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_39415(col3);
                    bufferBuilder.method_22918(data.matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_39415(col4);
                } else {
                    bufferBuilder.method_22918(data.matrix, 0.0f, data.size, 0.0f).method_22913(0.0f, 1.0f).method_39415(data.color);
                    bufferBuilder.method_22918(data.matrix, data.size, data.size, 0.0f).method_22913(1.0f, 1.0f).method_39415(data.color);
                    bufferBuilder.method_22918(data.matrix, data.size, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_39415(data.color);
                    bufferBuilder.method_22918(data.matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_39415(data.color);
                }
                ParticleBatchRenderer.releaseMatrix(data.matrix);
            }
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private static void renderFireflyBatch() {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_2960.method_60654((String)"textures/particles/firefly.png"));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        while (!FIREFLY_TRAILS.isEmpty()) {
            FireflyTrailData data = FIREFLY_TRAILS.poll();
            bufferBuilder.method_22918(data.matrix, 0.0f, -data.size, 0.0f).method_22913(0.0f, 1.0f).method_39415(data.color);
            bufferBuilder.method_22918(data.matrix, -data.size, -data.size, 0.0f).method_22913(1.0f, 1.0f).method_39415(data.color);
            bufferBuilder.method_22918(data.matrix, -data.size, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_39415(data.color);
            bufferBuilder.method_22918(data.matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_39415(data.color);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    public static void queueAmbientTexturedParticle(class_4587 matrices, class_2960 texture, float size, float alpha, int color, boolean useVertexGradient, int[] gradientColors, IParticleModule module) {
        AMBIENT_TEXTURED_PARTICLES.add(new AmbientTexturedParticleData(ParticleBatchRenderer.acquireMatrix(matrices.method_23760().method_23761()), texture, size, alpha, color, useVertexGradient, gradientColors, module));
    }

    private static void renderBubbleBatch() {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        BUBBLE_GROUPS.clear();
        while (!BUBBLE_PARTICLES.isEmpty()) {
            BubbleParticleData data = BUBBLE_PARTICLES.poll();
            BUBBLE_GROUPS.computeIfAbsent(data.texture, k -> new ArrayList()).add(data);
        }
        BUBBLE_GROUPS.forEach((texture, bubbles) -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            for (BubbleParticleData data : bubbles) {
                float half = data.scale / 2.0f;
                bufferBuilder.method_22918(data.matrix, -half, half, 0.0f).method_22913(0.0f, 1.0f).method_39415(data.color1);
                bufferBuilder.method_22918(data.matrix, half, half, 0.0f).method_22913(1.0f, 1.0f).method_39415(data.color2);
                bufferBuilder.method_22918(data.matrix, half, -half, 0.0f).method_22913(1.0f, 0.0f).method_39415(data.color3);
                bufferBuilder.method_22918(data.matrix, -half, -half, 0.0f).method_22913(0.0f, 0.0f).method_39415(data.color4);
                ParticleBatchRenderer.releaseMatrix(data.matrix);
            }
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private static void renderGhostBatch() {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        GHOST_GROUPS.clear();
        while (!GHOST_PARTICLES.isEmpty()) {
            GhostParticleData data = GHOST_PARTICLES.poll();
            String key2 = data.texture.toString() + "|" + data.blendMode;
            GHOST_GROUPS.computeIfAbsent(key2, k -> new ArrayList()).add(data);
        }
        GHOST_GROUPS.forEach((key, ghosts) -> {
            if (ghosts.isEmpty()) {
                return;
            }
            GhostParticleData firstGhost = (GhostParticleData)ghosts.getFirst();
            RenderSystem.setShaderTexture((int)0, (class_2960)firstGhost.texture);
            String selector0$temp = firstGhost.blendMode;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"Smoke", "Plasma"}, (Object)selector0$temp, index$1)) {
                case 0: {
                    RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR);
                    break;
                }
                case 1: {
                    RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                    break;
                }
                default: {
                    RenderSystem.defaultBlendFunc();
                }
            }
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            for (GhostParticleData data : ghosts) {
                float half = data.scale / 2.0f;
                bufferBuilder.method_22918(data.matrix, -half, half, 0.0f).method_22913(0.0f, 1.0f).method_39415(data.color);
                bufferBuilder.method_22918(data.matrix, half, half, 0.0f).method_22913(1.0f, 1.0f).method_39415(data.color);
                bufferBuilder.method_22918(data.matrix, half, -half, 0.0f).method_22913(1.0f, 0.0f).method_39415(data.color);
                bufferBuilder.method_22918(data.matrix, -half, -half, 0.0f).method_22913(0.0f, 0.0f).method_39415(data.color);
            }
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MATRIX_POOL.offer(new Matrix4f());
        }
        TEXTURED_PARTICLES = new ConcurrentLinkedQueue<TexturedParticleData>();
        CUBE_PARTICLES = new ConcurrentLinkedQueue<CubeParticleData>();
        PYRAMID_PARTICLES = new ConcurrentLinkedQueue<PyramidParticleData>();
        TEXT_PARTICLES = new ConcurrentLinkedQueue<TextParticleData>();
        BLOOM_PARTICLES = new ConcurrentLinkedQueue<BloomParticleData>();
        FIREFLY_TRAILS = new ConcurrentLinkedQueue<FireflyTrailData>();
        BUBBLE_PARTICLES = new ConcurrentLinkedQueue<BubbleParticleData>();
        GHOST_PARTICLES = new ConcurrentLinkedQueue<GhostParticleData>();
        TEXTURED_GROUPS = new HashMap<class_2960, List<TexturedParticleData>>();
        AMBIENT_GROUPS = new HashMap<class_2960, List<AmbientTexturedParticleData>>();
        BUBBLE_GROUPS = new HashMap<class_2960, List<BubbleParticleData>>();
        GHOST_GROUPS = new HashMap<String, List<GhostParticleData>>();
        SQRT_3 = (float)Math.sqrt(3.0);
        SQRT_6 = (float)Math.sqrt(6.0);
        AMBIENT_TEXTURED_PARTICLES = new ConcurrentLinkedQueue<AmbientTexturedParticleData>();
    }

    private record TexturedParticleData(Matrix4f matrix, class_2960 texture, float size, float alpha, int color, boolean useVertexGradient, int[] gradientColors, IParticleModule module) {
    }

    private record CubeParticleData(Matrix4f matrix, float size, float alpha, int color) {
    }

    private record PyramidParticleData(Matrix4f matrix, float size, float alpha, int color) {
    }

    private record TextParticleData(Matrix4f matrix, String text, int color) {
    }

    private record BloomParticleData(Matrix4f matrix, float size, float alpha, boolean useVertexGradient, int[] gradientColors, IParticleModule module, int colorOffset) {
    }

    private record FireflyTrailData(Matrix4f matrix, float size, int color) {
    }

    private record BubbleParticleData(Matrix4f matrix, class_2960 texture, float scale, int color1, int color2, int color3, int color4) {
    }

    private record GhostParticleData(Matrix4f matrix, class_2960 texture, float scale, int color, String blendMode) {
    }

    private record AmbientTexturedParticleData(Matrix4f matrix, class_2960 texture, float size, float alpha, int color, boolean useVertexGradient, int[] gradientColors, IParticleModule module) {
    }
}

