/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.particles.types;

import java.awt.Color;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import padej.soup.api.feature.module.IParticleModule;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.particle.AbstractParticle;
import padej.soup.implement.features.modules.particles.render.ParticleRenderer;

public class WorldParticle
extends AbstractParticle {
    private final String particleMode;
    private final String glyphTexture;
    private final float health;
    private final IParticleModule module;

    public WorldParticle(float x, float y, float z, Color color, float rotationAngle, float rotationSpeed, float health, String mode, String physics, String glyphTexture, float lifeTime, float scale, float speed, IParticleModule module) {
        super(x, y, z, color, rotationAngle, rotationSpeed, lifeTime, scale, physics, !mode.equals("Network"));
        this.health = health;
        this.particleMode = mode;
        this.glyphTexture = glyphTexture;
        this.module = module;
        this.initMotion(speed);
    }

    @Override
    public void render(class_4587 matrixStack, long currentTime) {
        boolean isZAxisLocked;
        float size = this.scale;
        float renderScale = this.particleMode.equals("Text") ? 0.025f * size : 0.07f;
        float alpha = this.cachedAlpha;
        double posX = MathUtil.interpolate(this.px, this.x);
        double posY = MathUtil.interpolate(this.py, this.y);
        double posZ = MathUtil.interpolate(this.pz, this.z);
        float interpolatedAngle = MathUtil.interpolate(this.prevRotationAngle, this.rotationAngle);
        matrixStack.method_22903();
        matrixStack.method_22904(posX, posY, posZ);
        matrixStack.method_22905(renderScale, renderScale, renderScale);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-WorldParticle.mc.field_1773.method_19418().method_19330()));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(WorldParticle.mc.field_1773.method_19418().method_19329()));
        matrixStack.method_46416(size / 2.0f, size / 2.0f, size / 2.0f);
        boolean bl = isZAxisLocked = this.particleMode.equals("Text") || this.particleMode.equals("Flame");
        if (isZAxisLocked) {
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        } else if (!this.particleMode.equals("Cube")) {
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(interpolatedAngle));
        }
        if (!this.particleMode.equals("Cube") && !this.particleMode.equals("Pyramid")) {
            matrixStack.method_46416(-size / 2.0f, -size / 2.0f, -size / 2.0f);
            ParticleRenderer.render(matrixStack, this.particleMode, size, alpha, this.color, this.glyphTexture, this.health, this.module, this.colorOffset);
        } else if (this.particleMode.equals("Cube")) {
            ParticleRenderer.drawCubeBloom(matrixStack, size, alpha, this.module, this.color, this.colorOffset);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(interpolatedAngle));
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(interpolatedAngle * 0.7f));
            ParticleRenderer.render(matrixStack, this.particleMode, size, alpha, this.color, this.glyphTexture, this.health, this.module, this.colorOffset);
        } else {
            ParticleRenderer.drawPyramidBloom(matrixStack, size, alpha, this.module, this.color, this.colorOffset);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(interpolatedAngle));
            ParticleRenderer.render(matrixStack, this.particleMode, size, alpha, this.color, this.glyphTexture, this.health, this.module, this.colorOffset);
        }
        matrixStack.method_22909();
    }

    public String getParticleMode() {
        return this.particleMode;
    }

    public float getHealth() {
        return this.health;
    }
}

