/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.visuals;

import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.base.util.other.Instance;

public class ChinaHat
extends Module {
    private final SelectSetting colorMode = new SelectSetting("setting.chinahat.colormode.name", "setting.chinahat.colormode.desc").value("Sync", "Custom").selected("Sync");
    private final SelectSetting customColorsCount = new SelectSetting("setting.chinahat.colorcount.name", "setting.chinahat.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Quartet").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiColorSetting customColors = new MultiColorSetting("setting.chinahat.gradientcolors.name", "setting.chinahat.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom"));
    private final ValueSetting centerAlpha = new ValueSetting("setting.chinahat.centeralpha.name", "setting.chinahat.centeralpha.desc").setValue(1.0f).range(0.0f, 1.0f);
    private final ValueSetting edgeAlpha = new ValueSetting("setting.chinahat.edgealpha.name", "setting.chinahat.edgealpha.desc").setValue(0.4f).range(0.0f, 1.0f);
    private final BooleanSetting renderOnFriends = new BooleanSetting("setting.chinahat.renderonfriends.name", "setting.chinahat.renderonfriends.desc").setValue(true);
    private final ValueSetting rotationSpeed = new ValueSetting("setting.chinahat.rotationspeed.name", "setting.chinahat.rotationspeed.desc").setValue(-0.2f).range(-3.0f, 3.0f);

    public static ChinaHat getInstance() {
        return Instance.get(ChinaHat.class);
    }

    public ChinaHat() {
        super("module.chinahat.name", ModuleCategory.VISUALS);
        GroupSetting colorGroup = new GroupSetting("group.chinahat.colors.name", "group.chinahat.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors);
        GroupSetting alphaGroup = new GroupSetting("group.chinahat.alpha.name", "group.chinahat.alpha.desc", false).settings(this.centerAlpha, this.edgeAlpha);
        this.setup(colorGroup, alphaGroup, this.renderOnFriends, this.rotationSpeed);
    }

    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    public SelectSetting getColorMode() {
        return this.colorMode;
    }

    public SelectSetting getCustomColorsCount() {
        return this.customColorsCount;
    }

    public ValueSetting getCenterAlpha() {
        return this.centerAlpha;
    }

    public ValueSetting getEdgeAlpha() {
        return this.edgeAlpha;
    }

    public BooleanSetting getRenderOnFriends() {
        return this.renderOnFriends;
    }

    public ValueSetting getRotationSpeed() {
        return this.rotationSpeed;
    }
}

