/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.visuals;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_742;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.ITargetRenderModule;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.api.repository.friend.FriendUtils;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.base.util.entity.VisibleUtils;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.render.TargetRenderer;
import padej.soup.core.server.ServerLimitCfg;
import padej.soup.implement.events.player.TickEvent;
import padej.soup.implement.events.render.WorldRenderEvent;
import padej.soup.implement.features.modules.particles.render.ParticleBatchRenderer;
import padej.soup.implement.features.modules.visuals.TargetRender;

public class FriendsTargetRender
extends Module
implements ITargetRenderModule {
    private Map<UUID, FriendTargetData> friendTargets = new HashMap<UUID, FriendTargetData>();
    private final Animation animation = new DecelerateAnimation().setMs(500).setValue(1.0);
    private final SelectSetting colorMode = new SelectSetting("setting.friendstargetrender.colormode.name", "setting.friendstargetrender.colormode.desc").value("Sync", "Custom").selected("Custom");
    private final SelectSetting customColorsCount = new SelectSetting("setting.friendstargetrender.colorcount.name", "setting.friendstargetrender.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Solo").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiColorSetting customColors = new MultiColorSetting("setting.friendstargetrender.gradientcolors.name", "setting.friendstargetrender.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom"));
    private final SelectSetting targetEspType = new SelectSetting("setting.friendstargetrender.rendertype.name", "setting.friendstargetrender.rendertype.desc").value("Legacy", "Circle", "Ghosts").selected("Legacy");
    private final SelectSetting legacyTexture = new SelectSetting("setting.friendstargetrender.legacytexture.name", "setting.friendstargetrender.legacytexture.desc").value("Amogus", "Bo", "Capture", "Jeka", "Marker", "Scifi", "Simple", "Skull", "Vegas").selected("Capture");
    private final BooleanSetting optimalAim = new BooleanSetting("setting.friendstargetrender.optimalaim.name", "setting.friendstargetrender.optimalaim.desc").setValue(false);
    private final ValueSetting legacySize = new ValueSetting("setting.friendstargetrender.legacysize.name", "setting.friendstargetrender.legacysize.desc").setValue(1.0f).range(0.5f, 1.5f);
    private final SelectSetting ghostsTexture = new SelectSetting("setting.friendstargetrender.ghoststexture.name", "setting.friendstargetrender.ghoststexture.desc").value("Bloom", "Soft").selected("Soft");
    private final SelectSetting ghostsBlend = new SelectSetting("setting.friendstargetrender.ghostsblend.name", "setting.friendstargetrender.ghostsblend.desc").value("Smoke", "Plasma").selected("Plasma");
    private final ValueSetting ghostsLength = new ValueSetting("setting.friendstargetrender.ghostslength.name", "setting.friendstargetrender.ghostslength.desc").setValue(1.3f).range(0.5f, 1.5f);
    private final SelectSetting ghostsTrajectory = new SelectSetting("setting.friendstargetrender.ghoststrajectory.name", "setting.friendstargetrender.ghoststrajectory.desc").value("Standard", "Spiral", "Atomic").selected("Standard");
    private final ValueSetting ghostsRadiusModifier = new ValueSetting("setting.friendstargetrender.ghostsradiusmodifier.name", "setting.friendstargetrender.ghostsradiusmodifier.desc").setValue(1.6f).range(0.5f, 2.0f);
    private final ValueSetting ghostsEndSize = new ValueSetting("setting.friendstargetrender.ghostsstartsize.name", "setting.friendstargetrender.ghostsstartsize.desc").setValue(0.1f).range(0.1f, 1.0f);
    private final ValueSetting ghostsStartSize = new ValueSetting("setting.friendstargetrender.ghostsendsize.name", "setting.friendstargetrender.ghostsendsize.desc").setValue(0.7f).range(0.1f, 1.0f);
    private final ValueSetting ghostsCount = new ValueSetting("setting.friendstargetrender.ghostscount.name", "setting.friendstargetrender.ghostscount.desc").setValue(4.0f).range(1, 8);
    private final ValueSetting ghostsSubdivision = new ValueSetting("setting.friendstargetrender.ghostssubdivision.name", "setting.friendstargetrender.ghostssubdivision.desc").setValue(5.0f).range(1, 8);
    private final SelectSetting renderPriority = new SelectSetting("setting.friendstargetrender.priority.name", "setting.friendstargetrender.priority.desc").value("Self", "Friend", "Both").selected("Friend");
    private final MultiSelectSetting showOn = new MultiSelectSetting("setting.friendstargetrender.showon.name", "setting.friendstargetrender.showon.desc").value("Self", "Friends").selected("Friends");
    private final ValueSetting followTime = new ValueSetting("setting.friendstargetrender.followtime.name", "setting.friendstargetrender.followtime.desc").setValue(5.0f).range(0, 10);
    private final ValueSetting speedMod = new ValueSetting("setting.friendstargetrender.speedmod.name", "setting.friendstargetrender.speedmod.desc").setValue(0.7f).range(0.5f, 2.0f);
    private final ValueSetting maxDistance = new ValueSetting("setting.friendstargetrender.maxdistance.name", "setting.friendstargetrender.maxdistance.desc").setValue(128.0f).range(16.0f, 128.0f);

    public static FriendsTargetRender getInstance() {
        return Instance.get(FriendsTargetRender.class);
    }

    public FriendsTargetRender() {
        super("module.friendstargetrender.name", ModuleCategory.VISUALS, true, false);
        GroupSetting colorGroup = new GroupSetting("group.friendstargetrender.colors.name", "group.friendstargetrender.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors);
        GroupSetting legacyGroup = new GroupSetting("group.friendstargetrender.legacy.name", "group.friendstargetrender.legacy.desc", false).settings(this.legacyTexture, this.optimalAim, this.legacySize).visible(() -> this.targetEspType.isSelected("Legacy"));
        GroupSetting ghostsVisualGroup = new GroupSetting("group.friendstargetrender.ghosts.visual.name", "group.friendstargetrender.ghosts.visual.desc", false).settings(this.ghostsTexture, this.ghostsBlend);
        GroupSetting ghostsAnimationGroup = new GroupSetting("group.friendstargetrender.ghosts.animation.name", "group.friendstargetrender.ghosts.animation.desc", false).settings(this.ghostsLength, this.ghostsTrajectory);
        GroupSetting ghostsSizeGroup = new GroupSetting("group.friendstargetrender.ghosts.size.name", "group.friendstargetrender.ghosts.size.desc", false).settings(this.ghostsRadiusModifier, this.ghostsStartSize, this.ghostsEndSize, this.ghostsCount, this.ghostsSubdivision);
        GroupSetting ghostsGroup = new GroupSetting("group.friendstargetrender.ghosts.name", "group.friendstargetrender.ghosts.desc", false).settings(ghostsVisualGroup, ghostsAnimationGroup, ghostsSizeGroup).visible(() -> this.targetEspType.isSelected("Ghosts"));
        GroupSetting behaviorGroup = new GroupSetting("group.friendstargetrender.behavior.name", "group.friendstargetrender.behavior.desc", false).settings(this.showOn, this.renderPriority, this.followTime, this.speedMod, this.maxDistance);
        this.setup(colorGroup, this.targetEspType, legacyGroup, ghostsGroup, behaviorGroup);
    }

    @Override
    public void deactivate() {
        this.friendTargets.clear();
    }

    @EventHandler
    public void onWorldRender(WorldRenderEvent e) {
        if (!ServerLimitCfg.showFriendsTargetRender()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long followTimeMs = (long)(this.followTime.getValue() * 1000.0f);
        class_1309 playerTarget = this.getPlayerTarget();
        HashMap<class_1309, TargetRenderData> uniqueTargets = new HashMap<class_1309, TargetRenderData>();
        this.friendTargets.forEach((uuid, data) -> {
            TargetRenderData existingData;
            boolean shouldRender;
            class_1309 target;
            class_1309 class_13092 = target = data.targetEntity != null ? data.targetEntity : data.lastTargetEntity;
            if (target != null && !this.shouldShowTarget(target)) {
                return;
            }
            boolean bl = shouldRender = data.targetEntity != null && this.canFriendSeeTarget(data.friend, data.targetEntity);
            if (data.targetEntity == null && data.lastTargetEntity != null) {
                boolean bl2 = shouldRender = currentTime - data.lastTargetTime < followTimeMs && this.canFriendSeeTarget(data.friend, data.lastTargetEntity);
                if (data.lastTargetEntity.method_29504() || !data.lastTargetEntity.method_5805()) {
                    shouldRender = false;
                }
            }
            data.animation.setDirection(shouldRender ? Direction.FORWARDS : Direction.BACKWARDS);
            float animationDelta = data.animation.getOutput().floatValue();
            if (data.targetEntity != null) {
                data.lastTargetEntity = data.targetEntity;
            }
            if (data.lastTargetEntity == null || data.animation.isFinished(Direction.BACKWARDS)) {
                return;
            }
            if (playerTarget != null && playerTarget == data.lastTargetEntity) {
                switch (this.renderPriority.getSelected()) {
                    case "Self": {
                        return;
                    }
                    case "Friend": {
                        break;
                    }
                }
            }
            if ((existingData = (TargetRenderData)uniqueTargets.get(data.lastTargetEntity)) == null || animationDelta > existingData.animationDelta) {
                uniqueTargets.put(data.lastTargetEntity, new TargetRenderData(data.lastTargetEntity, animationDelta));
            }
        });
        float tickDelta = tickCounter.method_60637(false);
        uniqueTargets.forEach((target, renderData) -> {
            float red = class_3532.method_15363((float)(((float)target.field_6235 - tickDelta) / 10.0f), (float)0.0f, (float)1.0f);
            switch (this.targetEspType.getSelected()) {
                case "Legacy": {
                    TargetRenderer.drawLegacy(target, renderData.animationDelta, red, this);
                    break;
                }
                case "Circle": {
                    TargetRenderer.drawCircle(e.getStack(), target, renderData.animationDelta, red, this);
                    break;
                }
                case "Ghosts": {
                    TargetRenderer.drawGhosts(target, renderData.animationDelta, red, this.speedMod.getValue(), this.ghostsLength.getValue(), this.ghostsRadiusModifier.getValue(), this.ghostsStartSize.getValue(), this.ghostsEndSize.getValue(), this.ghostsSubdivision.getValue(), this);
                    ParticleBatchRenderer.renderBatches();
                }
            }
        });
    }

    @EventHandler
    public void onTick(TickEvent e) {
        if (FriendsTargetRender.mc.field_1687 == null || FriendsTargetRender.mc.field_1724 == null) {
            return;
        }
        for (class_742 player : FriendsTargetRender.mc.field_1687.method_18456()) {
            if (!FriendUtils.isFriend((class_1297)player) || player == FriendsTargetRender.mc.field_1724) continue;
            if (FriendsTargetRender.mc.field_1724.method_5739((class_1297)player) > this.maxDistance.getValue()) {
                this.friendTargets.remove(player.method_5667());
                continue;
            }
            FriendTargetData data = this.friendTargets.computeIfAbsent(player.method_5667(), uuid -> new FriendTargetData(player));
            data.friend = player;
            class_1309 previousTarget = data.targetEntity;
            data.targetEntity = this.getFriendTarget(player);
            if (data.targetEntity != null && (data.targetEntity.method_29504() || !data.targetEntity.method_5805())) {
                data.targetEntity = null;
                if (previousTarget != null) {
                    data.lastTargetTime = System.currentTimeMillis();
                }
            }
            if (previousTarget == null || data.targetEntity != null) continue;
            data.lastTargetTime = System.currentTimeMillis();
        }
        this.friendTargets.keySet().removeIf(uuid -> FriendsTargetRender.mc.field_1687.method_18456().stream().noneMatch(p -> p.method_5667().equals(uuid)));
        TargetRenderer.updateAnimations(this.speedMod.getValue());
    }

    private boolean canFriendSeeTarget(class_742 friend, class_1309 target) {
        if (friend == null || target == null) {
            return false;
        }
        double distance = friend.method_19538().method_1022(target.method_19538());
        if (distance > 16.0) {
            return false;
        }
        if (friend.method_6057((class_1297)target)) {
            return VisibleUtils.canBeTargeted(target);
        }
        return false;
    }

    private boolean shouldShowTarget(class_1309 target) {
        boolean showOnSelf = this.showOn.isSelected("Self");
        boolean showOnFriends = this.showOn.isSelected("Friends");
        if (target == FriendsTargetRender.mc.field_1724) {
            return showOnSelf;
        }
        if (FriendUtils.isFriend((class_1297)target)) {
            return showOnFriends;
        }
        return true;
    }

    private class_1309 getPlayerTarget() {
        TargetRender targetRender = TargetRender.getInstance();
        if (targetRender != null && targetRender.isEnabled()) {
            return targetRender.getTargetEntity();
        }
        return null;
    }

    private class_1309 getFriendTarget(class_742 friend) {
        class_1309 target;
        class_1297 class_12972;
        class_238 box;
        class_243 direction;
        class_243 end;
        float raycastDistance = friend.method_7337() ? 5.3f : 3.3f;
        class_243 start = friend.method_5836(tickCounter.method_60637(false));
        class_3966 result = class_1675.method_18075((class_1297)friend, (class_243)start, (class_243)(end = start.method_1019((direction = friend.method_5828(tickCounter.method_60637(false))).method_1021((double)raycastDistance))), (class_238)(box = friend.method_5829().method_18804(direction.method_1021((double)raycastDistance)).method_1014(1.0)), entity -> !entity.method_7325() && entity.method_5805() && entity instanceof class_1309, (double)(raycastDistance * raycastDistance));
        if (result != null && (class_12972 = result.method_17782()) instanceof class_1309 && VisibleUtils.canBeTargeted(target = (class_1309)class_12972)) {
            return target;
        }
        return null;
    }

    @Override
    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    @Override
    public boolean isOptimalAim() {
        return this.optimalAim.isValue();
    }

    @Override
    public boolean isStaticMode() {
        return false;
    }

    @Override
    public float getLegacySize() {
        return this.legacySize.getValue();
    }

    @Override
    public class_2960 getGhostTexture() {
        return switch (this.ghostsTexture.getSelected()) {
            case "Bloom" -> class_2960.method_60654((String)"textures/particles/bloom/bloom.png");
            case "Soft" -> class_2960.method_60654((String)"textures/particles/bloom/bloom_soft.png");
            default -> null;
        };
    }

    @Override
    public class_2960 getLegacyTexture() {
        return switch (this.legacyTexture.getSelected()) {
            case "Amogus" -> class_2960.method_60654((String)"textures/legacy/amongus.png");
            case "Bo" -> class_2960.method_60654((String)"textures/legacy/bo.png");
            case "Capture" -> class_2960.method_60654((String)"textures/legacy/capture.png");
            case "Jeka" -> class_2960.method_60654((String)"textures/legacy/jeka.png");
            case "Marker" -> class_2960.method_60654((String)"textures/legacy/marker.png");
            case "Scifi" -> class_2960.method_60654((String)"textures/legacy/scifi.png");
            case "Simple" -> class_2960.method_60654((String)"textures/legacy/simple.png");
            case "Skull" -> class_2960.method_60654((String)"textures/legacy/skull.png");
            case "Vegas" -> class_2960.method_60654((String)"textures/legacy/vegas.png");
            default -> null;
        };
    }

    public boolean isFriendTargeting(class_1309 entity) {
        if (entity == null) {
            return false;
        }
        for (FriendTargetData data : this.friendTargets.values()) {
            if (data.targetEntity != entity && data.lastTargetEntity != entity) continue;
            return true;
        }
        return false;
    }

    public Map<UUID, FriendTargetData> getFriendTargets() {
        return this.friendTargets;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    public SelectSetting getColorMode() {
        return this.colorMode;
    }

    public SelectSetting getCustomColorsCount() {
        return this.customColorsCount;
    }

    public SelectSetting getTargetEspType() {
        return this.targetEspType;
    }

    public BooleanSetting getOptimalAim() {
        return this.optimalAim;
    }

    public SelectSetting getGhostsTexture() {
        return this.ghostsTexture;
    }

    @Override
    public SelectSetting getGhostsBlend() {
        return this.ghostsBlend;
    }

    public ValueSetting getGhostsLength() {
        return this.ghostsLength;
    }

    @Override
    public SelectSetting getGhostsTrajectory() {
        return this.ghostsTrajectory;
    }

    public ValueSetting getGhostsRadiusModifier() {
        return this.ghostsRadiusModifier;
    }

    public ValueSetting getGhostsEndSize() {
        return this.ghostsEndSize;
    }

    public ValueSetting getGhostsStartSize() {
        return this.ghostsStartSize;
    }

    @Override
    public ValueSetting getGhostsCount() {
        return this.ghostsCount;
    }

    public ValueSetting getGhostsSubdivision() {
        return this.ghostsSubdivision;
    }

    public SelectSetting getRenderPriority() {
        return this.renderPriority;
    }

    public MultiSelectSetting getShowOn() {
        return this.showOn;
    }

    public ValueSetting getFollowTime() {
        return this.followTime;
    }

    public ValueSetting getSpeedMod() {
        return this.speedMod;
    }

    public ValueSetting getMaxDistance() {
        return this.maxDistance;
    }

    private static class FriendTargetData {
        private class_742 friend;
        private class_1309 targetEntity;
        private class_1309 lastTargetEntity;
        private long lastTargetTime;
        private final Animation animation = new DecelerateAnimation().setMs(500).setValue(1.0);

        FriendTargetData(class_742 friend) {
            this.friend = friend;
        }
    }

    private record TargetRenderData(class_1309 entity, float animationDelta) {
    }
}

