/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.visuals;

import java.awt.Color;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import padej.soup.api.accessor.IEntity;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.api.repository.friend.FriendUtils;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.VisibleUtils;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.render.TrailRenderer;
import padej.soup.core.server.ServerConfigManager;
import padej.soup.core.server.ServerLimitCfg;
import padej.soup.implement.events.player.TickEvent;
import padej.soup.implement.events.render.WorldRenderEvent;

public class Trails
extends Module {
    private long lastTrailUpdateTime = 0L;
    private final SelectSetting colorMode = new SelectSetting("setting.trails.colormode.name", "setting.trails.colormode.desc").value("Sync", "Custom").selected("Sync");
    private final SelectSetting customColorsCount = new SelectSetting("setting.trails.colorcount.name", "setting.trails.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Solo").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiColorSetting customColors = new MultiColorSetting("setting.trails.gradientcolors.name", "setting.trails.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom"));
    private final SelectSetting colorAnimation = new SelectSetting("setting.trails.coloranimation.name", "setting.trails.coloranimation.desc").value("Wave", "Vertex").selected("Wave").visible(() -> this.colorMode.isSelected("Custom"));
    private final SelectSetting players = new SelectSetting("setting.trails.players.name", "setting.trails.players.desc").value("Trail", "Tail", "None").selected("Trail");
    private final BooleanSetting friends = new BooleanSetting("setting.trails.friends.name", "setting.trails.friends.desc").setValue(false).visible(() -> !this.players.isSelected("None"));
    private final BooleanSetting onlyF5 = new BooleanSetting("setting.trails.onlyf5.name", "setting.trails.onlyf5.desc").setValue(false).visible(() -> this.players.isSelected("Trail"));
    private final SelectSetting style = new SelectSetting("setting.trails.style.name", "setting.trails.style.desc").value("Solid", "Faded", "Invert").selected("Solid").visible(() -> this.players.isSelected("Trail"));
    private final BooleanSetting renderHalf = new BooleanSetting("setting.trails.renderhalf.name", "setting.trails.renderhalf.desc").setValue(false).visible(() -> this.players.isSelected("Trail"));
    private final ValueSetting alphaFactor = new ValueSetting("setting.trails.alphafactor.name", "setting.trails.alphafactor.desc").setValue(50.0f).range(0.0f, 100.0f).visible(() -> this.players.isSelected("Trail") && this.style.isSelected("Invert"));
    private final ValueSetting trailAlpha = new ValueSetting("setting.trails.alpha.name", "setting.trails.alpha.desc").setValue(100.0f).range(0.0f, 100.0f).visible(() -> this.players.isSelected("Trail"));
    private final ValueSetting down = new ValueSetting("setting.trails.down.name", "setting.trails.down.desc").setValue(0.0f).range(-1.0f, 1.0f);
    private final ValueSetting height = new ValueSetting("setting.trails.height.name", "setting.trails.height.desc").setValue(100.0f).range(10, 100).visible(() -> this.players.isSelected("Trail"));
    private final ValueSetting trailDuration = new ValueSetting("setting.trails.duration.name", "setting.trails.duration.desc").setValue(1.5f).range(1.0f, 4.0f).visible(() -> this.players.isSelected("Trail"));
    private final BooleanSetting debugLines = new BooleanSetting("setting.trails.debuglines.name", "setting.trails.debuglines.desc").setValue(false);
    private final ValueSetting lineWidth = new ValueSetting("setting.trails.linewidth.name", "setting.trails.linewidth.desc").setValue(3.0f).range(1.5f, 5.0f).visible(this.debugLines::isValue);

    public static Trails getInstance() {
        return Instance.get(Trails.class);
    }

    public Trails() {
        super("module.trails.name", ModuleCategory.VISUALS);
        GroupSetting colorGroup = new GroupSetting("group.trails.colors.name", "group.trails.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors, this.colorAnimation);
        GroupSetting renderGroup = new GroupSetting("group.trails.render.name", "group.trails.render.desc", false).settings(this.players, this.friends, this.onlyF5);
        GroupSetting styleGroup = new GroupSetting("group.trails.style.name", "group.trails.style.desc", false).settings(this.style, this.renderHalf, this.alphaFactor, this.trailAlpha).visible(() -> this.players.isSelected("Trail"));
        GroupSetting dimensionGroup = new GroupSetting("group.trails.dimensions.name", "group.trails.dimensions.desc", false).settings(this.down, this.height, this.trailDuration, this.debugLines, this.lineWidth).visible(() -> this.players.isSelected("Trail"));
        this.setup(colorGroup, renderGroup, styleGroup, dimensionGroup);
    }

    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    @EventHandler
    public void onTick(TickEvent event) {
        if (this.players.isSelected("Tail")) {
            this.updateTrails();
        }
        if (!this.players.isSelected("None")) {
            this.cleanupExpiredTrails();
        }
    }

    @EventHandler
    public void onWorldRender(WorldRenderEvent event) {
        class_4587 stack = event.getStack();
        if (this.players.isSelected("Trail")) {
            long currentTime = System.currentTimeMillis();
            long frameDuration = currentTime - this.lastTrailUpdateTime;
            if (frameDuration > 0L) {
                this.lastTrailUpdateTime = currentTime;
                this.updateTrails();
            }
            this.queuePlayerTrails(stack);
        } else if (this.players.isSelected("Tail")) {
            this.queuePlayerTails(stack);
        }
        TrailRenderer.renderBatches();
    }

    private void queuePlayerTrails(class_4587 stack) {
        class_243 cameraPos = Trails.mc.field_1773.method_19418().method_19326();
        double maxRenderDistSq = 4096.0;
        Trails.mc.field_1687.method_18456().stream().filter(entity -> {
            if (entity == Trails.mc.field_1724) {
                return !this.onlyF5.isValue() || !Trails.mc.field_1690.method_31044().method_31034();
            }
            return this.friends.isValue() && FriendUtils.isFriend((class_1297)entity);
        }).filter(entity -> {
            double distSq = entity.method_5707(cameraPos);
            return distSq <= maxRenderDistSq;
        }).filter(entity -> !entity.method_6128() || ServerLimitCfg.showElytraTrail()).filter(entity -> {
            VisibleUtils.VisibilityLevel level = VisibleUtils.getVisibilityLevel((class_1309)entity);
            return ServerConfigManager.showTrails(level.name());
        }).map(entity -> ((IEntity)entity).getTrails()).filter(trails -> !trails.isEmpty()).forEach(trails -> {
            TrailRenderer.queueTrails(stack, trails, this);
            if (this.debugLines.isValue()) {
                TrailRenderer.queueDebugLines(stack, trails, this);
            }
        });
    }

    private void queuePlayerTails(class_4587 stack) {
        class_243 cameraPos = Trails.mc.field_1773.method_19418().method_19326();
        double maxRenderDistSq = 4096.0;
        Trails.mc.field_1687.method_18456().stream().filter(entity -> {
            if (entity == Trails.mc.field_1724) {
                return !Trails.mc.field_1690.method_31044().method_31034();
            }
            return this.friends.isValue() && FriendUtils.isFriend((class_1297)entity);
        }).filter(entity -> {
            double distSq = entity.method_5707(cameraPos);
            return distSq <= maxRenderDistSq;
        }).filter(entity -> !entity.method_6128() || ServerLimitCfg.showElytraTrail()).filter(entity -> {
            VisibleUtils.VisibilityLevel level = VisibleUtils.getVisibilityLevel((class_1309)entity);
            return ServerConfigManager.showTrails(level.name());
        }).map(entity -> ((IEntity)entity).getTrails()).filter(trails -> !trails.isEmpty()).forEach(trails -> TrailRenderer.queueTails(stack, trails, this));
    }

    private void updateTrails() {
        int[] colors;
        Color c = this.colorMode.isSelected("Custom") ? new Color((colors = this.getCustomColors()) != null && colors.length > 0 ? colors[0] : -1) : new Color(ColorUtil.getClientColor());
        Trails.mc.field_1687.method_18456().forEach(player -> {
            List<Trail> trails = ((IEntity)player).getTrails();
            boolean shouldCreateTrail = false;
            if (player.method_6128() && !ServerLimitCfg.showElytraTrail()) {
                return;
            }
            VisibleUtils.VisibilityLevel level = VisibleUtils.getVisibilityLevel((class_1309)player);
            if (!ServerConfigManager.showTrails(level.name())) {
                return;
            }
            if (player != Trails.mc.field_1724 && (player.method_19538().method_10215() != player.field_5969 || player.method_19538().method_10216() != player.field_6014) && this.friends.isValue() && FriendUtils.isFriend((class_1297)player)) {
                shouldCreateTrail = true;
            }
            if (!(player != Trails.mc.field_1724 || Trails.mc.field_1724.method_18798().field_1352 == 0.0 && Trails.mc.field_1724.method_18798().field_1350 == 0.0 || this.onlyF5.isValue() && Trails.mc.field_1690.method_31044().method_31034())) {
                shouldCreateTrail = true;
            }
            if (shouldCreateTrail) {
                class_243 interpolatedPos = MathUtil.interpolate((class_1297)player);
                class_243 lastPos = trails.isEmpty() ? new class_243(player.field_6014, player.field_6036, player.field_5969) : trails.getLast().currentPos;
                long lifetime = (long)this.trailDuration.getValue() * 1000L;
                double distance = lastPos.method_1022(interpolatedPos);
                int subdivisions = Math.max(1, (int)Math.ceil(distance * 3.0));
                subdivisions = Math.min(subdivisions, 10);
                for (int sub = 0; sub < subdivisions; ++sub) {
                    float t = (float)sub / (float)subdivisions;
                    float nextT = (float)(sub + 1) / (float)subdivisions;
                    class_243 subFrom = new class_243(lastPos.field_1352 + (interpolatedPos.field_1352 - lastPos.field_1352) * (double)t, lastPos.field_1351 + (interpolatedPos.field_1351 - lastPos.field_1351) * (double)t, lastPos.field_1350 + (interpolatedPos.field_1350 - lastPos.field_1350) * (double)t);
                    class_243 subTo = new class_243(lastPos.field_1352 + (interpolatedPos.field_1352 - lastPos.field_1352) * (double)nextT, lastPos.field_1351 + (interpolatedPos.field_1351 - lastPos.field_1351) * (double)nextT, lastPos.field_1350 + (interpolatedPos.field_1350 - lastPos.field_1350) * (double)nextT);
                    trails.add(new Trail(subFrom, subTo, c, player.method_17682(), lifetime));
                }
            }
        });
    }

    private void cleanupExpiredTrails() {
        Trails.mc.field_1687.method_18456().forEach(player -> {
            List<Trail> trails = ((IEntity)player).getTrails();
            trails.removeIf(Trail::shouldRemove);
        });
    }

    public SelectSetting getColorMode() {
        return this.colorMode;
    }

    public SelectSetting getColorAnimation() {
        return this.colorAnimation;
    }

    public SelectSetting getStyle() {
        return this.style;
    }

    public BooleanSetting getRenderHalf() {
        return this.renderHalf;
    }

    public ValueSetting getAlphaFactor() {
        return this.alphaFactor;
    }

    public ValueSetting getTrailAlpha() {
        return this.trailAlpha;
    }

    public ValueSetting getDown() {
        return this.down;
    }

    public ValueSetting getHeight() {
        return this.height;
    }

    public ValueSetting getTrailDuration() {
        return this.trailDuration;
    }

    public ValueSetting getLineWidth() {
        return this.lineWidth;
    }

    public static class Trail
    implements QuickImports {
        private final class_243 prevPos;
        public class_243 currentPos;
        private final Color color;
        public final float entityHeight;
        private final long creationTime;
        private final long maxLifetime;
        private long lastCacheTime = -1L;
        private float cachedProgress = 0.0f;
        private float cachedAlpha = 1.0f;

        public Trail(class_243 from, class_243 to, Color color, float entityHeight, long maxLifetimeMs) {
            this.prevPos = from;
            this.currentPos = to;
            this.color = color;
            this.entityHeight = entityHeight;
            this.creationTime = System.currentTimeMillis();
            this.maxLifetime = maxLifetimeMs;
        }

        public class_243 interpolate(float pt) {
            double x = this.prevPos.field_1352 + (this.currentPos.field_1352 - this.prevPos.field_1352) * (double)pt;
            double y = this.prevPos.field_1351 + (this.currentPos.field_1351 - this.prevPos.field_1351) * (double)pt;
            double z = this.prevPos.field_1350 + (this.currentPos.field_1350 - this.prevPos.field_1350) * (double)pt;
            return new class_243(x, y, z);
        }

        public Color color() {
            return this.color;
        }

        private void updateCache() {
            long currentTime = System.currentTimeMillis();
            if (currentTime != this.lastCacheTime) {
                this.lastCacheTime = currentTime;
                long age = currentTime - this.creationTime;
                this.cachedProgress = Math.min(1.0f, (float)age / (float)this.maxLifetime);
                this.cachedAlpha = 1.0f - this.cachedProgress;
            }
        }

        public float getProgress() {
            this.updateCache();
            return this.cachedProgress;
        }

        public float getAlpha() {
            this.updateCache();
            return this.cachedAlpha;
        }

        public boolean shouldRemove() {
            return System.currentTimeMillis() - this.creationTime >= this.maxLifetime;
        }
    }
}

