/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5498;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.ColorSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.localization.LocalizationManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.ProjectionUtil;
import padej.soup.base.util.other.Instance;
import padej.soup.implement.events.player.TickEvent;
import padej.soup.implement.events.render.DrawEvent;

public class Gps
extends Module {
    private final Animation radiusAnim = new DecelerateAnimation().setMs(150).setValue(12.0);
    private class_2338 targetPos = null;
    private boolean ignoreY = false;
    private final SelectSetting anchorType = new SelectSetting("setting.gps.anchor.name", "setting.gps.anchor.desc").value("Point", "Crosshair").selected("Point");
    private final SelectSetting arrowType = new SelectSetting("setting.gps.arrowtype.name", "setting.gps.arrowtype.desc").value("Fill", "Outline").selected("Fill");
    private final ValueSetting arrowSize = new ValueSetting("setting.gps.arrowsize.name", "setting.gps.arrowsize.desc").setValue(16.0f).range(8, 32);
    private final ValueSetting radiusSetting = new ValueSetting("setting.gps.arrowradius.name", "setting.gps.arrowradius.desc").setValue(50.0f).range(30, 100);
    private final ValueSetting markerSize = new ValueSetting("setting.gps.markersize.name", "setting.gps.markersize.desc").setValue(16.0f).range(8, 32);
    private final BooleanSetting showDistance = new BooleanSetting("setting.gps.showdistance.name", "setting.gps.showdistance.desc").setValue(false);
    private final SelectSetting distancePosition = new SelectSetting("setting.gps.distanceposition.name", "setting.gps.distanceposition.desc").value("Arrow", "Location Icon").selected("Arrow");
    private final SelectSetting distanceTextPosition = new SelectSetting("setting.gps.distancetextposition.name", "setting.gps.distancetextposition.desc").value("Above", "Follow", "Bottom").selected("Bottom").visible(() -> this.showDistance.isValue() && this.distancePosition.isSelected("Arrow") && this.anchorType.isSelected("Point"));
    private final ColorSetting distanceColor = new ColorSetting("setting.gps.distancecolor.name", "setting.gps.distancecolor.desc").value(-1);
    private final BooleanSetting showBeam = new BooleanSetting("setting.gps.showbeam.name", "setting.gps.showbeam.desc").setValue(true);
    private final BooleanSetting autoDelete = new BooleanSetting("setting.gps.autodelete.name", "setting.gps.autodelete.desc").setValue(false);
    private final ValueSetting autoDeleteDistance = new ValueSetting("setting.gps.autodeletedistance.name", "setting.gps.autodeletedistance.desc").setValue(5.0f).range(1, 10).visible(this.autoDelete::isValue);

    public static Gps getInstance() {
        return Instance.get(Gps.class);
    }

    public Gps() {
        super("module.gps.name", ModuleCategory.WORLD);
        GroupSetting arrowGroup = new GroupSetting("group.gps.arrow.name", "group.gps.arrow.desc", false).settings(this.arrowType, this.arrowSize, this.radiusSetting);
        GroupSetting markerGroup = new GroupSetting("group.gps.marker.name", "group.gps.marker.desc", false).settings(this.showBeam, this.markerSize);
        GroupSetting distanceGroup = new GroupSetting("group.gps.distance.name", "group.gps.distance.desc", false).settings(this.showDistance, this.distancePosition, this.distanceTextPosition, this.distanceColor);
        GroupSetting autoDeleteGroup = new GroupSetting("group.gps.autodelete.name", "group.gps.autodelete.desc", false).settings(this.autoDelete, this.autoDeleteDistance);
        this.setup(this.anchorType, arrowGroup, markerGroup, distanceGroup, autoDeleteGroup);
        this.registerCommands();
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"gps").then(ClientCommandManager.literal((String)"clear").executes(context -> {
            this.targetPos = null;
            this.ignoreY = false;
            String message = LocalizationManager.getInstance().get("message.gps.cleared");
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("\u00a7a" + message)));
            return 1;
        }))).then(ClientCommandManager.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int x = IntegerArgumentType.getInteger((CommandContext)context, (String)"x");
            int y = IntegerArgumentType.getInteger((CommandContext)context, (String)"y");
            int z = IntegerArgumentType.getInteger((CommandContext)context, (String)"z");
            this.targetPos = new class_2338(x, y, z);
            this.ignoreY = false;
            String message = LocalizationManager.getInstance().getFormatted("message.gps.set", x, y, z);
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("\u00a7a" + message)));
            return 1;
        }))).executes(context -> {
            int x = IntegerArgumentType.getInteger((CommandContext)context, (String)"x");
            int z = IntegerArgumentType.getInteger((CommandContext)context, (String)"y");
            this.targetPos = new class_2338(x, 0, z);
            this.ignoreY = true;
            String message = LocalizationManager.getInstance().getFormatted("message.gps.setnoheight", x, z);
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("\u00a7a" + message)));
            return 1;
        })))));
    }

    @EventHandler
    public void onTick(TickEvent e) {
        float distance;
        this.radiusAnim.setDirection(Gps.mc.field_1724.method_5624() ? Direction.FORWARDS : Direction.BACKWARDS);
        if (this.autoDelete.isValue() && this.targetPos != null && (distance = this.getDistanceToTarget()) <= this.autoDeleteDistance.getValue()) {
            this.targetPos = null;
            this.ignoreY = false;
            if (Gps.mc.field_1724 != null) {
                String message = LocalizationManager.getInstance().get("message.gps.targetreached");
                Gps.mc.field_1724.method_7353(class_2561.method_30163((String)("\u00a7a" + message)), false);
            }
        }
    }

    @EventHandler
    public void onDraw(DrawEvent e) {
        float posY;
        float anchorY;
        float anchorX;
        if (this.targetPos == null) {
            return;
        }
        class_4587 matrix = e.getDrawContext().method_51448();
        float middleW = (float)mc.method_22683().method_4486() / 2.0f;
        float middleH = (float)mc.method_22683().method_4502() / 2.0f;
        float size = this.arrowSize.getValue();
        if (this.anchorType.isSelected("Point")) {
            anchorX = middleW;
            posY = anchorY = middleH / 2.0f;
        } else {
            anchorX = middleW;
            anchorY = middleH;
            float radius = this.radiusSetting.getValue() + this.radiusAnim.getOutput().floatValue();
            posY = anchorY - radius;
        }
        if (!Gps.mc.field_1690.field_1842 && Gps.mc.field_1690.method_31044().equals((Object)class_5498.field_26664)) {
            float yaw = this.getRotationToTarget() - this.getInterpolatedYaw();
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_CONSTANT_ALPHA);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.getArrowTexture());
            RenderSystem.setShader((class_10156)class_10142.field_53880);
            class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            int color = ColorUtil.getClientColor();
            matrix.method_22903();
            matrix.method_46416(anchorX, anchorY, 0.0f);
            matrix.method_22907(class_7833.field_40718.rotationDegrees(yaw));
            matrix.method_46416(-anchorX, -anchorY, 0.0f);
            Matrix4f matrix4f = matrix.method_23760().method_23761();
            buffer.method_22918(matrix4f, anchorX - size / 2.0f, posY + size, 0.0f).method_22913(0.0f, 1.0f).method_39415(ColorUtil.multAlpha(ColorUtil.multDark(color, 0.4f), 0.5f));
            buffer.method_22918(matrix4f, anchorX + size / 2.0f, posY + size, 0.0f).method_22913(1.0f, 1.0f).method_39415(ColorUtil.multAlpha(ColorUtil.multDark(color, 0.4f), 0.5f));
            buffer.method_22918(matrix4f, anchorX + size / 2.0f, posY, 0.0f).method_22913(1.0f, 0.0f).method_39415(color);
            buffer.method_22918(matrix4f, anchorX - size / 2.0f, posY, 0.0f).method_22913(0.0f, 0.0f).method_39415(color);
            class_286.method_43433((class_9801)buffer.method_60800());
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            if (this.showDistance.isValue() && this.distancePosition.isSelected("Arrow")) {
                this.renderDistanceOnArrow(matrix, anchorX, anchorY, posY, size, yaw);
            }
            matrix.method_22909();
        }
        if (this.showBeam.isValue()) {
            this.renderLocationIcon(matrix);
        }
    }

    private void renderDistanceOnArrow(class_4587 matrix, float anchorX, float anchorY, float posY, float size, float yaw) {
        float distance = this.getDistanceToTarget();
        String distanceText = String.format("%.1fm", Float.valueOf(distance));
        float textWidth = Gps.mc.field_1772.method_1727(distanceText);
        if (this.anchorType.isSelected("Point")) {
            float textX = anchorX - textWidth / 2.0f;
            switch (this.distanceTextPosition.getSelected()) {
                case "Above": {
                    float textY = posY - 10.0f;
                    Fonts.getSize(15, Fonts.Type.INTER_BOLD).drawString(matrix, distanceText, textX, textY, this.distanceColor.getColor());
                    break;
                }
                case "Follow": {
                    float textY = posY + size + 4.0f;
                    Fonts.getSize(15, Fonts.Type.INTER_BOLD).drawString(matrix, distanceText, textX, textY, this.distanceColor.getColor());
                    break;
                }
                case "Bottom": {
                    matrix.method_22909();
                    float textY = posY + size + 4.0f;
                    Fonts.getSize(15, Fonts.Type.INTER_BOLD).drawString(matrix, distanceText, textX, textY, this.distanceColor.getColor());
                    matrix.method_22903();
                    matrix.method_46416(anchorX, anchorY, 0.0f);
                    matrix.method_22907(class_7833.field_40718.rotationDegrees(yaw));
                    matrix.method_46416(-anchorX, -anchorY, 0.0f);
                }
            }
        } else {
            float textX = anchorX - textWidth / 2.0f;
            float textY = posY + size + 4.0f;
            Fonts.getSize(15, Fonts.Type.INTER_BOLD).drawString(matrix, distanceText, textX, textY, this.distanceColor.getColor());
        }
    }

    private void renderLocationIcon(class_4587 matrix) {
        float yOffset = Gps.mc.field_1724.method_17682() / 2.0f;
        double targetY = this.ignoreY ? class_3532.method_16436((double)mc.method_61966().method_60637(false), (double)(Gps.mc.field_1724.field_6036 + (double)yOffset), (double)(Gps.mc.field_1724.method_23318() + (double)yOffset)) : (double)this.targetPos.method_10264() + 0.5;
        class_243 targetWorldPos = new class_243((double)this.targetPos.method_10263() + 0.5, targetY, (double)this.targetPos.method_10260() + 0.5);
        class_243 screenPos = ProjectionUtil.worldSpaceToScreenSpace(targetWorldPos);
        if (screenPos.field_1350 > 0.0) {
            float screenWidth = mc.method_22683().method_4486();
            float screenHeight = mc.method_22683().method_4502();
            float margin = 100.0f;
            if (screenPos.field_1352 >= (double)(-margin) && screenPos.field_1352 <= (double)(screenWidth + margin) && screenPos.field_1351 >= (double)(-margin) && screenPos.field_1351 <= (double)(screenHeight + margin)) {
                float size = this.markerSize.getValue();
                float x = (float)screenPos.field_1352;
                float y = (float)screenPos.field_1351;
                RenderSystem.enableBlend();
                RenderSystem.disableCull();
                RenderSystem.disableDepthTest();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_CONSTANT_ALPHA);
                RenderSystem.setShaderTexture((int)0, (class_2960)class_2960.method_60654((String)"textures/loc.png"));
                RenderSystem.setShader((class_10156)class_10142.field_53880);
                class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
                int color = ColorUtil.getClientColor();
                matrix.method_22903();
                matrix.method_46416(x, y, 0.0f);
                matrix.method_46416(-x, -y, 0.0f);
                Matrix4f matrix4f = matrix.method_23760().method_23761();
                buffer.method_22918(matrix4f, x - size / 2.0f, y + size, 0.0f).method_22913(0.0f, 1.0f).method_39415(ColorUtil.multAlpha(ColorUtil.multDark(color, 0.4f), 0.5f));
                buffer.method_22918(matrix4f, x + size / 2.0f, y + size, 0.0f).method_22913(1.0f, 1.0f).method_39415(ColorUtil.multAlpha(ColorUtil.multDark(color, 0.4f), 0.5f));
                buffer.method_22918(matrix4f, x + size / 2.0f, y, 0.0f).method_22913(1.0f, 0.0f).method_39415(color);
                buffer.method_22918(matrix4f, x - size / 2.0f, y, 0.0f).method_22913(0.0f, 0.0f).method_39415(color);
                class_286.method_43433((class_9801)buffer.method_60800());
                RenderSystem.enableDepthTest();
                RenderSystem.enableCull();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                if (this.showDistance.isValue() && this.distancePosition.isSelected("Location Icon")) {
                    float distance = this.getDistanceToTarget();
                    String distanceText = String.format("%.1fm", Float.valueOf(distance));
                    float textWidth = Gps.mc.field_1772.method_1727(distanceText);
                    float textX = x - textWidth / 2.0f;
                    float textY = y + size + 4.0f;
                    Fonts.getSize(15, Fonts.Type.INTER_BOLD).drawString(matrix, distanceText, textX, textY, this.distanceColor.getColor());
                }
                matrix.method_22909();
            }
        }
    }

    private float getRotationToTarget() {
        float tickDelta = mc.method_61966().method_60637(false);
        double playerX = class_3532.method_16436((double)tickDelta, (double)Gps.mc.field_1724.field_6014, (double)Gps.mc.field_1724.method_23317());
        double playerZ = class_3532.method_16436((double)tickDelta, (double)Gps.mc.field_1724.field_5969, (double)Gps.mc.field_1724.method_23321());
        double x = (double)this.targetPos.method_10263() - playerX;
        double z = (double)this.targetPos.method_10260() - playerZ;
        return (float)(-(Math.atan2(x, z) * 57.29577951308232));
    }

    private float getInterpolatedYaw() {
        float tickDelta = mc.method_61966().method_60637(false);
        return class_3532.method_16439((float)tickDelta, (float)Gps.mc.field_1724.field_5982, (float)Gps.mc.field_1724.method_36454());
    }

    private float getDistanceToTarget() {
        float tickDelta = mc.method_61966().method_60637(false);
        double playerX = class_3532.method_16436((double)tickDelta, (double)Gps.mc.field_1724.field_6014, (double)Gps.mc.field_1724.method_23317());
        double playerZ = class_3532.method_16436((double)tickDelta, (double)Gps.mc.field_1724.field_5969, (double)Gps.mc.field_1724.method_23321());
        double dx = (double)this.targetPos.method_10263() - playerX;
        double dz = (double)this.targetPos.method_10260() - playerZ;
        return (float)Math.sqrt(dx * dx + dz * dz);
    }

    public class_2960 getArrowTexture() {
        return switch (this.arrowType.getSelected()) {
            case "Fill" -> class_2960.method_60654((String)"textures/arrows/arrow_fill.png");
            case "Outline" -> class_2960.method_60654((String)"textures/arrows/arrow_outline.png");
            default -> null;
        };
    }

    public Animation getRadiusAnim() {
        return this.radiusAnim;
    }

    public class_2338 getTargetPos() {
        return this.targetPos;
    }

    public boolean isIgnoreY() {
        return this.ignoreY;
    }

    public SelectSetting getAnchorType() {
        return this.anchorType;
    }

    public SelectSetting getArrowType() {
        return this.arrowType;
    }

    public ValueSetting getArrowSize() {
        return this.arrowSize;
    }

    public ValueSetting getRadiusSetting() {
        return this.radiusSetting;
    }

    public ValueSetting getMarkerSize() {
        return this.markerSize;
    }

    public BooleanSetting getShowDistance() {
        return this.showDistance;
    }

    public SelectSetting getDistancePosition() {
        return this.distancePosition;
    }

    public SelectSetting getDistanceTextPosition() {
        return this.distanceTextPosition;
    }

    public ColorSetting getDistanceColor() {
        return this.distanceColor;
    }

    public BooleanSetting getShowBeam() {
        return this.showBeam;
    }

    public BooleanSetting getAutoDelete() {
        return this.autoDelete;
    }

    public ValueSetting getAutoDeleteDistance() {
        return this.autoDeleteDistance;
    }
}

