/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.LinearAnimation;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.Render2DUtil;
import padej.soup.implement.menu.components.AbstractComponent;
import padej.soup.implement.menu.components.implement.other.BackgroundComponent;
import padej.soup.implement.menu.components.implement.other.CategoryContainerComponent;
import padej.soup.implement.menu.components.implement.other.HomeComponent;
import padej.soup.implement.menu.components.implement.other.ModuleDescriptionComponent;
import padej.soup.implement.menu.components.implement.other.SearchComponent;
import padej.soup.implement.menu.components.implement.other.UserComponent;
import padej.soup.implement.menu.components.implement.settings.TextComponent;
import padej.soup.implement.menu.components.implement.settings.multiselect.MultiSelectComponent;
import padej.soup.implement.menu.components.implement.settings.select.SelectComponent;

public class MenuScreen
extends class_437
implements QuickImports {
    public static MenuScreen INSTANCE = new MenuScreen();
    private final List<AbstractComponent> components = new ArrayList<AbstractComponent>();
    private final BackgroundComponent backgroundComponent = new BackgroundComponent();
    private final UserComponent userComponent = new UserComponent();
    private final SearchComponent searchComponent = new SearchComponent();
    private final CategoryContainerComponent categoryContainerComponent = new CategoryContainerComponent();
    private final HomeComponent homeComponent = new HomeComponent();
    private final ModuleDescriptionComponent moduleDescriptionComponent = new ModuleDescriptionComponent();
    public final Animation animation = new LinearAnimation().setMs(200).setValue(1.0);
    public ModuleCategory category = ModuleCategory.VISUALS;
    public int x;
    public int y;
    public int width;
    public int height;
    private boolean menuDragging = false;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private int customX = -1;
    private int customY = -1;

    public MenuScreen() {
        super(class_2561.method_30163((String)"MenuScreen"));
        this.initialize();
    }

    public void initialize() {
        this.animation.setDirection(Direction.FORWARDS);
        this.categoryContainerComponent.initializeCategoryComponents();
        this.backgroundComponent.setSearchComponent(this.searchComponent);
        this.components.addAll(Arrays.asList(this.backgroundComponent, this.userComponent, this.searchComponent, this.categoryContainerComponent, this.homeComponent, this.moduleDescriptionComponent));
    }

    public void method_25393() {
        this.method_25419();
        this.components.forEach(AbstractComponent::tick);
        super.method_25393();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.width = 322;
        this.height = 233;
        if (this.customX != -1 && this.customY != -1) {
            this.x = this.customX;
            this.y = this.customY;
        } else {
            this.x = window.method_4486() / 2 - this.width / 2;
            this.y = window.method_4502() / 2 - this.height / 2;
        }
        this.backgroundComponent.position(this.x, this.y).size(this.width, this.height);
        this.userComponent.position(this.x + 257, this.y + 36);
        this.searchComponent.position(this.x + 35, this.y + 5);
        this.categoryContainerComponent.position(this.x, this.y);
        this.homeComponent.position(this.x + 8, this.y + 5);
        MathUtil.scale(context.method_51448(), (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, this.getScaleAnimation(), () -> {
            this.components.forEach(component -> component.render(context, mouseX, mouseY, delta));
            windowManager.render(context, mouseX, mouseY, delta);
        });
        if (this.menuDragging) {
            int windowWidth = window.method_4486();
            int windowHeight = window.method_4502();
            int radius = 3;
            float mouseDragX = mouseX + this.dragOffsetX;
            float mouseDragY = mouseY + this.dragOffsetY;
            if (Math.abs(mouseDragX - (float)(windowWidth - this.width) / 2.0f) <= (float)radius) {
                this.drawRect((float)windowWidth / 2.0f - 0.5f, 0.0f, 1.0f, windowHeight);
            }
            if (Math.abs(mouseDragY - (float)(windowHeight - this.height) / 2.0f) <= (float)radius) {
                this.drawRect(0.0f, (float)windowHeight / 2.0f - 0.5f, windowWidth, 1.0f);
            }
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawRect(float x, float y, float width, float height) {
        Render2DUtil.drawQuad(x, y, width, height, ColorUtil.getText(0.5f));
    }

    public void openGui() {
        this.animation.setDirection(Direction.FORWARDS);
        mc.method_1507((class_437)this);
        SoundManager.playSound(SoundManager.OPEN_GUI);
    }

    public float getScaleAnimation() {
        return this.animation.getOutput().floatValue();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int headerHeight = 25;
        if (button == 0 && MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, headerHeight)) {
            boolean clickedOnComponent = false;
            for (AbstractComponent component : this.components) {
                if (component != this.searchComponent && component != this.homeComponent && component != this.userComponent || !component.mouseClicked(mouseX, mouseY, button)) continue;
                clickedOnComponent = true;
                break;
            }
            if (!clickedOnComponent) {
                this.menuDragging = true;
                this.dragOffsetX = (int)((double)this.x - mouseX);
                this.dragOffsetY = (int)((double)this.y - mouseY);
                return true;
            }
        }
        if (!windowManager.mouseClicked(mouseX, mouseY, button)) {
            for (AbstractComponent component : this.components) {
                if (!component.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            SelectComponent.handleGlobalClick(mouseX, mouseY);
            MultiSelectComponent.handleGlobalClick(mouseX, mouseY);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.menuDragging && button == 0) {
            this.menuDragging = false;
            return true;
        }
        this.components.forEach(component -> component.mouseReleased(mouseX, mouseY, button));
        windowManager.mouseReleased(mouseX, mouseY, button);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.menuDragging) {
            float mouseDragX = (float)(mouseX + (double)this.dragOffsetX);
            float mouseDragY = (float)(mouseY + (double)this.dragOffsetY);
            int windowWidth = window.method_4486();
            int windowHeight = window.method_4502();
            this.customX = (int)Math.max(0.0f, Math.min(mouseDragX, (float)(windowWidth - this.width)));
            this.customY = (int)Math.max(0.0f, Math.min(mouseDragY, (float)(windowHeight - this.height)));
            int radius = 3;
            if (Math.abs(mouseDragX - (float)(windowWidth - this.width) / 2.0f) <= (float)radius) {
                this.customX = (windowWidth - this.width) / 2;
            }
            if (Math.abs(mouseDragY - (float)(windowHeight - this.height) / 2.0f) <= (float)radius) {
                this.customY = (windowHeight - this.height) / 2;
            }
            return true;
        }
        if (!windowManager.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            this.components.forEach(component -> component.mouseDragged(mouseX, mouseY, button, deltaX, deltaY));
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        if (!windowManager.mouseScrolled(mouseX, mouseY, vertical)) {
            this.components.forEach(component -> component.mouseScrolled(mouseX, mouseY, vertical));
        }
        return super.method_25401(mouseX, mouseY, horizontal, vertical);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.method_25422()) {
            if (this.animation.isDirection(Direction.FORWARDS)) {
                SoundManager.playSound(SoundManager.CLOSE_GUI);
                this.animation.setDirection(Direction.BACKWARDS);
            }
            return true;
        }
        if (keyCode == 70 && (modifiers & 2) != 0 && !SearchComponent.typing) {
            SearchComponent.typing = true;
            this.searchComponent.setText("");
            this.searchComponent.setCursorPosition(0);
            this.searchComponent.setPreviousCategory(this.category != ModuleCategory.SEARCH ? this.category : ModuleCategory.VISUALS);
            return true;
        }
        if (keyCode == 86 && (modifiers & 2) != 0) {
            if (!windowManager.keyPressed(keyCode, scanCode, modifiers)) {
                this.components.forEach(component -> component.keyPressed(keyCode, scanCode, modifiers));
            }
            return true;
        }
        if (!windowManager.keyPressed(keyCode, scanCode, modifiers)) {
            this.components.forEach(component -> component.keyPressed(keyCode, scanCode, modifiers));
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (!windowManager.keyReleased(keyCode, scanCode, modifiers)) {
            this.components.forEach(component -> component.keyReleased(keyCode, scanCode, modifiers));
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!windowManager.charTyped(chr, modifiers)) {
            this.components.forEach(component -> component.charTyped(chr, modifiers));
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        if (this.animation.isFinished(Direction.BACKWARDS)) {
            TextComponent.typing = false;
            SelectComponent.closeAllDropdowns();
            MultiSelectComponent.closeAllDropdowns();
            super.method_25419();
        }
    }

    public void setCategory(ModuleCategory category) {
        this.category = category;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setMenuDragging(boolean menuDragging) {
        this.menuDragging = menuDragging;
    }

    public void setDragOffsetX(int dragOffsetX) {
        this.dragOffsetX = dragOffsetX;
    }

    public void setDragOffsetY(int dragOffsetY) {
        this.dragOffsetY = dragOffsetY;
    }

    public void setCustomX(int customX) {
        this.customX = customX;
    }

    public void setCustomY(int customY) {
        this.customY = customY;
    }

    public List<AbstractComponent> getComponents() {
        return this.components;
    }

    public BackgroundComponent getBackgroundComponent() {
        return this.backgroundComponent;
    }

    public UserComponent getUserComponent() {
        return this.userComponent;
    }

    public SearchComponent getSearchComponent() {
        return this.searchComponent;
    }

    public CategoryContainerComponent getCategoryContainerComponent() {
        return this.categoryContainerComponent;
    }

    public HomeComponent getHomeComponent() {
        return this.homeComponent;
    }

    public ModuleDescriptionComponent getModuleDescriptionComponent() {
        return this.moduleDescriptionComponent;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public ModuleCategory getCategory() {
        return this.category;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isMenuDragging() {
        return this.menuDragging;
    }

    public int getDragOffsetX() {
        return this.dragOffsetX;
    }

    public int getDragOffsetY() {
        return this.dragOffsetY;
    }

    public int getCustomX() {
        return this.customX;
    }

    public int getCustomY() {
        return this.customY;
    }
}

