/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.category;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.ScissorManager;
import padej.soup.core.Main;
import padej.soup.implement.menu.MenuScreen;
import padej.soup.implement.menu.components.AbstractComponent;
import padej.soup.implement.menu.components.implement.module.ModuleComponent;
import padej.soup.implement.menu.components.implement.other.ActivityCalendarComponent;
import padej.soup.implement.menu.components.implement.other.ConfigManagerComponent;
import padej.soup.implement.menu.components.implement.other.FriendsListComponent;
import padej.soup.implement.menu.components.implement.other.ModuleDescriptionComponent;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;

public class CategoryComponent
extends AbstractComponent {
    private final List<ModuleComponent> moduleComponents = new ArrayList<ModuleComponent>();
    private static final Set<ModuleComponent> globalModuleComponents = new HashSet<ModuleComponent>();
    private final ModuleCategory category;
    private ActivityCalendarComponent activityCalendarComponent;
    private final FriendsListComponent friendsListComponent;
    private final ConfigManagerComponent configManagerComponent;
    private final Animation alphaAnimation = new DecelerateAnimation().setMs(300).setValue(1.0);
    private final Animation hoverAnimation = new DecelerateAnimation().setMs(200).setValue(0.15f);
    private final Animation selectionAnimation = new DecelerateAnimation().setMs(300).setValue(1.0);
    private final Map<ModuleComponent, Integer> assignedColumns = new HashMap<ModuleComponent, Integer>();
    private ModuleCategory lastCategory = null;
    private String lastSearchText = "";
    private boolean isInitialized = false;
    private long lastConfigSaveTime = 0L;
    private static final long CONFIG_SAVE_INTERVAL = 4000L;
    private int mouseX = 0;
    private int mouseY = 0;

    private void initialize() {
        List<Module> modules = Main.getInstance().getModuleRepository().modules();
        modules.sort((a, b) -> Integer.compare(this.countAllSettings((Module)b), this.countAllSettings((Module)a)));
        for (Module module : modules) {
            ModuleComponent newComponent;
            if (!module.isVisible() || !globalModuleComponents.add(newComponent = new ModuleComponent(module))) continue;
            this.moduleComponents.add(newComponent);
        }
    }

    public CategoryComponent(ModuleCategory category) {
        this.category = category;
        this.initialize();
        if (Main.getInstance().getActivityManager() != null) {
            this.activityCalendarComponent = new ActivityCalendarComponent(Main.getInstance().getActivityManager());
        }
        this.friendsListComponent = new FriendsListComponent();
        this.configManagerComponent = new ConfigManagerComponent();
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        globalModuleComponents.clear();
        Matrix4f positionMatrix = context.method_51448().method_23760().method_23761();
        ScissorManager scissorManager = Main.getInstance().getScissorManager();
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (menuScreen.getCategory() == ModuleCategory.HOME && this.category == ModuleCategory.HOME && CategoryComponent.mc.field_1755 == menuScreen) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastConfigSaveTime >= 4000L) {
                this.lastConfigSaveTime = currentTime;
                if (this.configManagerComponent != null) {
                    this.configManagerComponent.saveActiveConfigIfExists();
                }
            }
        } else {
            this.lastConfigSaveTime = 0L;
        }
        if (this.category != ModuleCategory.PERSONAL_INFO && this.category != ModuleCategory.SEARCH && this.category != ModuleCategory.HOME) {
            this.drawCategoryTab(context, context.method_51448(), mouseX, mouseY);
        }
        if (menuScreen.getCategory() == ModuleCategory.PERSONAL_INFO) {
            if (this.category == ModuleCategory.PERSONAL_INFO) {
                float offsetX = 33.0f;
                float offsetY = 28.0f;
                scissorManager.push(positionMatrix, (float)menuScreen.x + offsetX, (float)menuScreen.y + offsetY, (float)menuScreen.width - offsetX, (float)menuScreen.height - offsetY - 1.0f);
                this.renderStatsContent(context, menuScreen, mouseX, mouseY, delta);
                scissorManager.pop();
                this.renderStatsTooltips(context, mouseX, mouseY);
            }
            return;
        }
        if (menuScreen.getCategory() == ModuleCategory.HOME) {
            if (this.category == ModuleCategory.HOME) {
                float offsetX = 33.0f;
                float offsetY = 28.0f;
                scissorManager.push(positionMatrix, (float)menuScreen.x + offsetX, (float)menuScreen.y + offsetY, (float)menuScreen.width - offsetX, (float)menuScreen.height - offsetY - 1.0f);
                this.renderHomeContent(context, menuScreen, mouseX, mouseY, delta);
                scissorManager.pop();
            }
            return;
        }
        ModuleCategory currentCategory = menuScreen.getCategory();
        String currentSearchText = menuScreen.getSearchComponent().getText().toLowerCase();
        if (!this.isInitialized && currentCategory == this.category) {
            this.isInitialized = true;
            this.lastCategory = currentCategory;
            this.lastSearchText = currentSearchText;
            this.assignColumns();
        } else if (!currentCategory.equals((Object)this.lastCategory) || !currentSearchText.equals(this.lastSearchText)) {
            this.lastCategory = currentCategory;
            this.lastSearchText = currentSearchText;
            this.assignColumns();
        }
        int[] offsets = this.calculateOffsets();
        int columnWidth = 130;
        int columnGapX = 10;
        int columnGapY = 10;
        float offsetX = 33.0f;
        float offsetY = 28.0f;
        scissorManager.push(positionMatrix, (float)menuScreen.x + offsetX, (float)menuScreen.y + offsetY, (float)menuScreen.width - offsetX, (float)menuScreen.height - offsetY - 1.0f);
        for (int i = this.moduleComponents.size() - 1; i >= 0; --i) {
            ModuleComponent component = this.moduleComponents.get(i);
            if (!this.shouldRenderComponent(component)) continue;
            int componentHeight = component.getComponentHeight() + columnGapY;
            int column = this.getModuleColumn(i);
            component.x = menuScreen.x + 42 + column * (columnWidth + columnGapX);
            component.y = (float)((double)(menuScreen.y + 32 + columnGapY + offsets[column] - componentHeight) + this.smoothedScroll);
            component.width = columnWidth;
            component.render(context, mouseX, mouseY, delta);
            int n = column;
            offsets[n] = offsets[n] - componentHeight;
        }
        scissorManager.pop();
        this.renderTooltips(context);
        int maxScrollHeight = this.calculateMaxScrollHeight();
        this.scroll = class_3532.method_15350((double)this.scroll, (double)(-maxScrollHeight), (double)0.0);
        this.smoothedScroll = MathUtil.interpolateSmooth(2.0, this.smoothedScroll, this.scroll);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        float offsetY;
        float offsetX;
        float outlineSize;
        float iconY;
        float outlineY;
        float padding;
        float iconSize;
        float iconX;
        float outlineX;
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        if (this.category != ModuleCategory.PERSONAL_INFO && this.category != ModuleCategory.SEARCH && this.category != ModuleCategory.HOME && MathUtil.isHovered(mouseX, mouseY, outlineX = (iconX = this.x + (this.width - (iconSize = 11.0f)) / 2.0f) - (padding = 6.0f), outlineY = (iconY = this.y + (this.height - iconSize) / 2.0f) - padding, outlineSize = iconSize + padding * 2.0f, outlineSize) && button == 0) {
            if (!MenuScreen.INSTANCE.getCategory().equals((Object)this.category)) {
                SoundManager.playSound(SoundManager.CHANGE_CATEGORY, 2.0f, 1.3f);
            }
            MenuScreen.INSTANCE.setCategory(this.category);
        }
        if (MathUtil.isHovered(mouseX, mouseY, (float)menuScreen.x + (offsetX = 33.0f), (float)menuScreen.y + (offsetY = 28.0f), (float)menuScreen.width - offsetX, (float)menuScreen.height - offsetY)) {
            boolean isAnyComponentHovered;
            if (menuScreen.getCategory() == ModuleCategory.PERSONAL_INFO && this.category == ModuleCategory.PERSONAL_INFO && this.activityCalendarComponent != null && this.activityCalendarComponent.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (menuScreen.getCategory() == ModuleCategory.HOME && this.category == ModuleCategory.HOME) {
                if (this.friendsListComponent != null && this.friendsListComponent.mouseClicked(mouseX, mouseY, button)) {
                    return true;
                }
                if (this.configManagerComponent != null && this.configManagerComponent.mouseClicked(mouseX, mouseY, button)) {
                    return true;
                }
            }
            if (isAnyComponentHovered = this.moduleComponents.stream().anyMatch(moduleComponent -> moduleComponent.isHover(mouseX, mouseY))) {
                for (ModuleComponent moduleComponent2 : this.moduleComponents) {
                    if (!this.shouldRenderComponent(moduleComponent2) || !moduleComponent2.isHover(mouseX, mouseY) || !moduleComponent2.mouseClicked(mouseX, mouseY, button)) continue;
                    return true;
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        this.moduleComponents.forEach(moduleComponent -> moduleComponent.isHover(mouseX, mouseY));
        for (ModuleComponent moduleComponent2 : this.moduleComponents) {
            if (!moduleComponent2.isHover(mouseX, mouseY)) continue;
            return true;
        }
        return super.isHover(mouseX, mouseY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.moduleComponents.forEach(moduleComponent -> moduleComponent.mouseReleased(mouseX, mouseY, button));
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        float offsetX = 33.0f;
        float offsetY = 28.0f;
        if (MathUtil.isHovered(mouseX, mouseY, (float)menuScreen.x + offsetX, (float)menuScreen.y + offsetY, (float)menuScreen.width - offsetX, (float)menuScreen.height - offsetY)) {
            if (menuScreen.getCategory() == ModuleCategory.HOME && this.category == ModuleCategory.HOME) {
                if (this.friendsListComponent != null && this.friendsListComponent.mouseScrolled(mouseX, mouseY, amount)) {
                    return true;
                }
                if (this.configManagerComponent != null && this.configManagerComponent.mouseScrolled(mouseX, mouseY, amount)) {
                    return true;
                }
            } else {
                this.scroll += amount * 20.0;
            }
        }
        this.moduleComponents.forEach(moduleComponent -> {
            if (this.shouldRenderComponent((ModuleComponent)moduleComponent)) {
                moduleComponent.mouseScrolled(mouseX, mouseY, amount);
            }
        });
        return super.mouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        if (menuScreen.getCategory() == ModuleCategory.HOME && this.category == ModuleCategory.HOME) {
            if (this.friendsListComponent != null && this.friendsListComponent.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.configManagerComponent != null && this.configManagerComponent.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        this.moduleComponents.forEach(moduleComponent -> {
            if (this.shouldRenderComponent((ModuleComponent)moduleComponent)) {
                moduleComponent.keyPressed(keyCode, scanCode, modifiers);
            }
        });
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        if (menuScreen.getCategory() == ModuleCategory.HOME && this.category == ModuleCategory.HOME) {
            if (this.friendsListComponent != null && this.friendsListComponent.charTyped(chr, modifiers)) {
                return true;
            }
            if (this.configManagerComponent != null && this.configManagerComponent.charTyped(chr, modifiers)) {
                return true;
            }
        }
        this.moduleComponents.forEach(moduleComponent -> {
            if (this.shouldRenderComponent((ModuleComponent)moduleComponent)) {
                moduleComponent.charTyped(chr, modifiers);
            }
        });
        return super.charTyped(chr, modifiers);
    }

    private void drawCategoryTab(class_332 context, class_4587 matrix, int mouseX, int mouseY) {
        float iconSize = 11.0f;
        float padding = 6.0f;
        float outlineSize = iconSize + padding * 2.0f;
        float iconX = this.x + (this.width - iconSize) / 2.0f;
        float iconY = this.y + (this.height - iconSize) / 2.0f;
        float outlineX = iconX - padding;
        float outlineY = iconY - padding;
        boolean isSelected = MenuScreen.INSTANCE.getCategory() == this.category;
        this.selectionAnimation.setDirection(isSelected ? Direction.FORWARDS : Direction.BACKWARDS);
        boolean isHovered = MathUtil.isHovered(mouseX, mouseY, outlineX, outlineY, outlineSize, outlineSize);
        this.hoverAnimation.setDirection(isHovered ? Direction.FORWARDS : Direction.BACKWARDS);
        float hoverScale = 1.0f + this.hoverAnimation.getOutput().floatValue();
        float selectionProgress = this.selectionAnimation.getOutput().floatValue();
        MathUtil.scale(matrix, this.x + this.width / 2.0f, this.y + this.height / 2.0f, hoverScale, () -> {
            String texture = "textures/modules/" + this.category.getIdentifier() + ".png";
            int descriptionColor = ColorUtil.getDescription();
            int clientColor = ColorUtil.getClientColor();
            int iconColor = ColorUtil.overCol(descriptionColor, clientColor, selectionProgress);
            image.setTexture(texture).render(ShapeProperties.create(matrix, iconX, iconY, iconSize, iconSize).color(iconColor).build());
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void assignColumns() {
        this.assignedColumns.clear();
        if (this.category != ModuleCategory.CLIENT) {
            int columnIndex = 0;
            int i = this.moduleComponents.size() - 1;
            while (true) {
                if (i < 0) {
                    return;
                }
                ModuleComponent component = this.moduleComponents.get(i);
                if (this.shouldRenderComponent(component)) {
                    int targetColumn = columnIndex % 2;
                    this.assignedColumns.put(component, targetColumn);
                    ++columnIndex;
                }
                --i;
            }
        }
        int columnIndex = 0;
        int i = this.moduleComponents.size() - 1;
        while (i >= 0) {
            ModuleComponent component = this.moduleComponents.get(i);
            if (component.getModule().getCategory() == ModuleCategory.CLIENT) {
                String moduleName;
                int targetColumn = switch (moduleName = component.getModule().getVisibleName()) {
                    case "Theme" -> 0;
                    case "Fake Player", "Key Bind" -> 1;
                    default -> columnIndex++ % 2;
                };
                this.assignedColumns.put(component, targetColumn);
            }
            --i;
        }
        return;
    }

    private int getModuleColumn(int moduleIndex) {
        ModuleComponent component = this.moduleComponents.get(moduleIndex);
        return this.assignedColumns.getOrDefault(component, 0);
    }

    private int[] calculateOffsets() {
        int[] offsets = new int[2];
        int columnGapY = 10;
        for (int i = this.moduleComponents.size() - 1; i >= 0; --i) {
            int column;
            ModuleComponent component = this.moduleComponents.get(i);
            if (!this.shouldRenderComponent(component)) continue;
            int componentHeight = component.getComponentHeight() + columnGapY;
            int n = column = this.getModuleColumn(i);
            offsets[n] = offsets[n] + componentHeight;
        }
        return offsets;
    }

    private int calculateMaxScrollHeight() {
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        int[] offsets = this.calculateOffsets();
        int maxColumnHeight = Math.max(offsets[0], offsets[1]);
        int visibleHeight = menuScreen.height - 38;
        int maxScroll = maxColumnHeight - visibleHeight;
        return Math.max(0, maxScroll);
    }

    private boolean shouldRenderComponent(ModuleComponent component) {
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        ModuleCategory moduleCategory = component.getModule().getCategory();
        ModuleCategory currentCategory = menuScreen.getCategory();
        String searchText = menuScreen.getSearchComponent().getText().toLowerCase();
        if (currentCategory == ModuleCategory.SEARCH) {
            if (searchText.equalsIgnoreCase("")) {
                return false;
            }
            String moduleName = component.getModule().getLocalizedName().toLowerCase();
            if (moduleName.contains(searchText)) {
                return true;
            }
            return component.getModule().settings().stream().anyMatch(setting -> this.searchInSetting((Setting)setting, searchText));
        }
        return moduleCategory.equals((Object)currentCategory);
    }

    private boolean searchInSetting(Setting setting, String searchText) {
        MultiSelectSetting multiSelectSetting;
        SelectSetting selectSetting;
        if (setting.getLocalizedName().toLowerCase().contains(searchText)) {
            return true;
        }
        if (setting.getLocalizedDescription() != null && setting.getLocalizedDescription().toLowerCase().contains(searchText)) {
            return true;
        }
        if (setting instanceof SelectSetting && (selectSetting = (SelectSetting)setting).getList() != null) {
            return selectSetting.getList().stream().anyMatch(option -> option.toLowerCase().contains(searchText));
        }
        if (setting instanceof MultiSelectSetting && (multiSelectSetting = (MultiSelectSetting)setting).getList() != null) {
            return multiSelectSetting.getList().stream().anyMatch(option -> option.toLowerCase().contains(searchText));
        }
        if (setting instanceof GroupSetting) {
            GroupSetting groupSetting = (GroupSetting)setting;
            return groupSetting.getSubSettings().stream().anyMatch(subSetting -> this.searchInSetting((Setting)subSetting, searchText));
        }
        return false;
    }

    private void renderStatsContent(class_332 context, MenuScreen menuScreen, int mouseX, int mouseY, float delta) {
        float contentX = menuScreen.x + 36;
        float contentY = menuScreen.y - 40;
        if (this.activityCalendarComponent != null) {
            this.activityCalendarComponent.x = contentX - 3.0f;
            this.activityCalendarComponent.y = contentY + 75.0f;
            this.activityCalendarComponent.render(context, mouseX, mouseY, delta);
        }
    }

    private void renderHomeContent(class_332 context, MenuScreen menuScreen, int mouseX, int mouseY, float delta) {
        float contentX = menuScreen.x + 41;
        float contentY = menuScreen.y + 32;
        if (this.friendsListComponent != null) {
            this.friendsListComponent.x = contentX;
            this.friendsListComponent.y = contentY;
            this.friendsListComponent.width = 120.0f;
            this.friendsListComponent.render(context, mouseX, mouseY, delta);
        }
        if (this.configManagerComponent != null) {
            this.configManagerComponent.x = contentX + 130.0f;
            this.configManagerComponent.y = contentY;
            this.configManagerComponent.width = 140.0f;
            this.configManagerComponent.render(context, mouseX, mouseY, delta);
        }
    }

    private void renderStatsTooltips(class_332 context, int mouseX, int mouseY) {
        if (this.activityCalendarComponent != null && this.activityCalendarComponent.hoveredDate != null && this.activityCalendarComponent.hoveredActivity != null) {
            this.activityCalendarComponent.renderTooltip(context, mouseX, mouseY);
        }
    }

    private void renderTooltips(class_332 context) {
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        ModuleDescriptionComponent descriptionComponent = menuScreen.getModuleDescriptionComponent();
        if (descriptionComponent != null) {
            if (windowManager.isMouseOverAnyWindow(this.mouseX, this.mouseY)) {
                return;
            }
            ModuleComponent hoveredModule = null;
            AbstractSettingComponent hoveredSetting = null;
            for (ModuleComponent moduleComponent : this.moduleComponents) {
                float headerHeight;
                if (!this.shouldRenderComponent(moduleComponent) || !moduleComponent.isHover(this.mouseX, this.mouseY)) continue;
                hoveredModule = moduleComponent;
                float f = headerHeight = moduleComponent.getModule().isShowEnable() ? 40.0f : 28.0f;
                if ((float)this.mouseY < moduleComponent.y + headerHeight) {
                    descriptionComponent.setHoveredModule(hoveredModule.getModule());
                    descriptionComponent.render(context, this.mouseX, this.mouseY, 0.0f);
                    return;
                }
                for (AbstractSettingComponent settingComponent : moduleComponent.getComponents()) {
                    if (!settingComponent.isHover(this.mouseX, this.mouseY)) continue;
                    hoveredSetting = settingComponent;
                    break;
                }
                if (hoveredSetting == null) break;
                descriptionComponent.setHoveredSetting(hoveredSetting.getSetting());
                descriptionComponent.render(context, this.mouseX, this.mouseY, 0.0f);
                return;
            }
            descriptionComponent.hide();
        }
    }

    private int countAllSettings(Module module) {
        int count = 0;
        for (Setting setting : module.settings()) {
            ++count;
            if (!(setting instanceof GroupSetting)) continue;
            GroupSetting groupSetting = (GroupSetting)setting;
            count += this.countSettingsInGroup(groupSetting);
        }
        return count;
    }

    private int countSettingsInGroup(GroupSetting group) {
        int count = 0;
        for (Setting setting : group.getSubSettings()) {
            ++count;
            if (!(setting instanceof GroupSetting)) continue;
            GroupSetting nestedGroup = (GroupSetting)setting;
            count += this.countSettingsInGroup(nestedGroup);
        }
        return count;
    }

    public ModuleCategory getCategory() {
        return this.category;
    }

    public ConfigManagerComponent getConfigManagerComponent() {
        return this.configManagerComponent;
    }
}

