/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.module;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_7833;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.api.feature.module.setting.SettingComponentAdder;
import padej.soup.api.feature.module.setting.implement.BindSetting;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.ColorSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.TextSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.localization.LocalizationManager;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.api.system.shape.implement.Image;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.logger.LoggerUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.StringUtil;
import padej.soup.base.util.render.ScissorManager;
import padej.soup.core.Main;
import padej.soup.implement.menu.MenuScreen;
import padej.soup.implement.menu.components.AbstractComponent;
import padej.soup.implement.menu.components.implement.other.CheckComponent;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;

public class ModuleComponent
extends AbstractComponent {
    private static final Gson GSON_COMPACT = new Gson();
    private final List<AbstractSettingComponent> components = new ArrayList<AbstractSettingComponent>();
    private final CheckComponent checkComponent = new CheckComponent();
    private final Module module;
    private boolean binding;
    private boolean collapsed = false;
    private boolean isHovered = false;
    private long lastCopyTime = 0L;
    private long lastPasteTime = 0L;
    private static final long COPY_PASTE_COOLDOWN_MS = 150L;
    private final Animation hoverAnimation = new DecelerateAnimation().setMs(200).setValue(1.0);
    private final Animation arrowRotationAnimation = new DecelerateAnimation().setMs(300).setValue(1.0);
    private final Animation collapseAnimation = new DecelerateAnimation().setMs(250).setValue(1.0);
    private final Animation outlineColorAnimation = new DecelerateAnimation().setMs(300).setValue(1.0);
    private float visualX;
    private float visualY;
    private float prevX;
    private float prevY;
    private float cachedExpandedHeight = 0.0f;
    private final Image arrowImage = new Image().setTexture("textures/modules/arrow.png");

    private void initialize() {
        new SettingComponentAdder().addSettingComponent(this.module.settings(), this.components);
    }

    public ModuleComponent(Module module) {
        this.module = module;
        this.initialize();
        this.collapsed = this.canCollapse() && !module.isExpanded();
        this.collapseAnimation.setDirection(this.collapsed ? Direction.BACKWARDS : Direction.FORWARDS);
        if (this.collapsed) {
            this.collapseAnimation.reset();
        }
        this.prevX = 0.0f;
        this.visualX = 0.0f;
        this.prevY = 0.0f;
        this.visualY = 0.0f;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        float animationProgress;
        Matrix4f untransformedMatrix = new Matrix4f((Matrix4fc)context.method_51448().method_23760().method_23761());
        if (this.prevX == 0.0f && this.prevY == 0.0f) {
            this.visualX = this.prevX = this.x;
            this.visualY = this.prevY = this.y;
        } else if (this.prevX != this.x || this.prevY != this.y) {
            this.prevX = this.x;
            this.prevY = this.y;
        }
        if (MenuScreen.INSTANCE.isMenuDragging()) {
            this.visualX = this.x;
            this.visualY = this.y;
        } else {
            this.visualX = MathUtil.interpolateSmooth(2.0, this.visualX, this.x);
            this.visualY = MathUtil.interpolateSmooth(2.0, this.visualY, this.y);
        }
        float offsetX = this.visualX - this.x;
        float offsetY = this.visualY - this.y;
        this.isHovered = this.isHover(mouseX, mouseY);
        this.hoverAnimation.setDirection(this.isHovered ? Direction.FORWARDS : Direction.BACKWARDS);
        this.outlineColorAnimation.setDirection(this.module.isState() ? Direction.FORWARDS : Direction.BACKWARDS);
        float scale = 1.0f + (this.hoverAnimation.getOutput().floatValue() - 1.0f) * 0.05f;
        context.method_51448().method_22903();
        context.method_51448().method_46416(offsetX, offsetY, 0.0f);
        context.method_51448().method_46416(this.x + this.width / 2.0f, this.y + this.height / 2.0f, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        context.method_51448().method_46416(-(this.x + this.width / 2.0f), -(this.y + this.height / 2.0f), 0.0f);
        rectangle.render(ShapeProperties.create(context.method_51448(), this.x, this.y, this.width, 18.0).round(5.0f, 0.0f, 5.0f, 0.0f).color(ColorUtil.getGuiRectColor2(1.0f)).build());
        int defaultOutlineColor = ColorUtil.getOutline(0.56f);
        int activeOutlineColor = ColorUtil.getClientColor();
        int outlineColor = ColorUtil.overCol(defaultOutlineColor, activeOutlineColor, this.outlineColorAnimation.getOutput().floatValue());
        this.height = this.getComponentHeight();
        rectangle.render(ShapeProperties.create(context.method_51448(), this.x, this.y, this.width, this.height).round(5.0f).softness(1.0f).thickness(2.2f).outlineColor(outlineColor).color(ColorUtil.getRectDarker(0.0f)).build());
        if (this.canCollapse()) {
            this.arrowRotationAnimation.setDirection(this.collapsed ? Direction.FORWARDS : Direction.BACKWARDS);
            this.renderArrow(context, this.x + 4.0f, this.y + 4.0f);
        }
        float nameOffset = this.canCollapse() ? 18.0f : 9.0f;
        Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawString(context.method_51448(), this.module.getLocalizedName(), this.x + nameOffset, this.y + 8.0f, ColorUtil.getText());
        if (this.module.isShowEnable()) {
            String enableText = LocalizationManager.getInstance().get("module.setting.enable");
            Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawString(context.method_51448(), enableText, this.x + 9.0f, this.y + 29.0f, ColorUtil.getText());
            ((CheckComponent)this.checkComponent.position(this.x + this.width - 16.0f, this.y + 27.0f)).setRunnable(this.module::switchState).setState(this.module.isState()).render(context, mouseX, mouseY, delta);
        }
        if (this.module.isShowEnable() && this.module.isCanBind()) {
            this.drawBind(context, this.x, this.y);
        }
        if (!this.components.isEmpty() && (animationProgress = this.collapseAnimation.getOutput().floatValue()) > 0.01f) {
            for (AbstractSettingComponent component : this.components) {
                component.updateVisibilityAnimation();
            }
            this.cachedExpandedHeight = this.calculateExpandedSettingsHeight();
            float hiddenHeight = this.cachedExpandedHeight * (1.0f - animationProgress);
            ScissorManager scissorManager = Main.getInstance().getScissorManager();
            MenuScreen menuScreen = MenuScreen.INSTANCE;
            float desiredScissorY = this.module.isShowEnable() ? this.y + 32.0f : this.y + 14.0f;
            float visualDesiredScissorY = desiredScissorY + offsetY;
            float menuTopBoundary = menuScreen.y + 37;
            float visualScissorY = Math.max(visualDesiredScissorY, menuTopBoundary);
            float scissorHeight = (float)(menuScreen.y + menuScreen.height) - visualScissorY;
            scissorManager.push(untransformedMatrix, this.x + offsetX, visualScissorY, this.width, scissorHeight);
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, -hiddenHeight, 0.0f);
            float offset = this.y + (float)(this.module.isShowEnable() ? 42 : 24);
            for (int i = this.components.size() - 1; i >= 0; --i) {
                AbstractSettingComponent component = this.components.get(i);
                if (component.shouldSkipRender()) continue;
                double visibilityProgress = component.getVisibilityProgress();
                float animatedHeight = (float)((double)component.height * visibilityProgress);
                component.x = this.x;
                component.y = offset + (this.getExpandedHeightFloat() - (float)(this.module.isShowEnable() ? 46 : 28) - animatedHeight);
                component.width = this.width;
                component.render(context, mouseX, mouseY, delta);
                offset -= animatedHeight;
            }
            context.method_51448().method_22909();
            scissorManager.pop();
        }
        context.method_51448().method_22909();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean isAnyComponentHovered;
        if (this.canCollapse() && button == 0 && MathUtil.isHovered(mouseX, mouseY, this.x + 4.0f, this.y + 4.0f, 10.0, 10.0)) {
            this.collapsed = !this.collapsed;
            this.module.setExpanded(!this.collapsed);
            this.collapseAnimation.setDirection(this.collapsed ? Direction.BACKWARDS : Direction.FORWARDS);
            SoundManager.playSound(this.collapsed ? SoundManager.TURN_OFF : SoundManager.TURN_ON, 1.0f, 1.3f);
            return true;
        }
        if (this.collapseAnimation.getOutput().floatValue() > 0.5f && (isAnyComponentHovered = this.components.stream().anyMatch(abstractComponent -> abstractComponent.isHover(mouseX, mouseY)))) {
            for (AbstractSettingComponent abstractComponent2 : this.components) {
                if (!abstractComponent2.isHover(mouseX, mouseY) || !abstractComponent2.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (this.module.isShowEnable() && this.module.isCanBind()) {
            String bindName = StringUtil.getBindName(this.module.getKey());
            float stringWidth = Fonts.getSize(12, Fonts.Type.INTER_BOLD).getStringWidth(bindName);
            if (MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 15.0f - stringWidth, this.y + 8.0f, stringWidth + 6.0f, 9.0) && button == 0) {
                if (!this.binding) {
                    SoundManager.playSound(SoundManager.CLICK, 1.0f, 1.8f);
                } else {
                    SoundManager.playSound(SoundManager.CLICK, 1.0f, 0.8f);
                }
                this.binding = !this.binding;
                return true;
            }
            if (this.binding) {
                if (button == -1) {
                    SoundManager.playSound(SoundManager.TURN_OFF, 1.0f, 1.3f);
                } else {
                    SoundManager.playSound(SoundManager.TURN_ON, 1.0f, 1.3f);
                }
                this.module.setKey(button);
                this.binding = false;
                return true;
            }
        }
        if (this.checkComponent.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        boolean isModuleHovered;
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        float menuTop = menuScreen.y;
        float menuBottom = menuScreen.y + menuScreen.height;
        float menuLeft = menuScreen.x;
        float menuRight = menuScreen.x + menuScreen.width;
        if (mouseX < (double)menuLeft || mouseX > (double)menuRight || mouseY < (double)menuTop || mouseY > (double)menuBottom) {
            return false;
        }
        if (this.collapseAnimation.getOutput().floatValue() > 0.01f) {
            for (AbstractComponent abstractComponent : this.components) {
                if (!abstractComponent.isHover(mouseX, mouseY) || !(abstractComponent.y >= menuTop) || !(abstractComponent.y <= menuBottom)) continue;
                return true;
            }
        }
        if (isModuleHovered = MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            float f = Math.max(this.y, menuTop);
            float visibleBottom = Math.min(this.y + this.height, menuBottom);
            return mouseY >= (double)f && mouseY <= (double)visibleBottom;
        }
        return false;
    }

    @Override
    public void tick() {
        this.components.forEach(AbstractComponent::tick);
        super.tick();
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.collapseAnimation.getOutput().floatValue() > 0.5f) {
            this.components.forEach(abstractComponent -> abstractComponent.mouseDragged(mouseX, mouseY, button, deltaX, deltaY));
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.collapseAnimation.getOutput().floatValue() > 0.5f) {
            this.components.forEach(abstractComponent -> abstractComponent.mouseReleased(mouseX, mouseY, button));
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (this.collapseAnimation.getOutput().floatValue() > 0.5f) {
            this.components.forEach(abstractComponent -> abstractComponent.mouseScrolled(mouseX, mouseY, amount));
        }
        return super.mouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        int key;
        int n = key = keyCode == 261 ? -1 : keyCode;
        if (this.binding && this.module.isCanBind()) {
            if (key == -1) {
                SoundManager.playSound(SoundManager.TURN_OFF, 1.0f, 1.3f);
            } else {
                SoundManager.playSound(SoundManager.TURN_ON, 1.0f, 1.3f);
            }
            this.module.setKey(key);
            this.binding = false;
            return true;
        }
        if (keyCode == 67 && (modifiers & 2) != 0 && this.isHovered) {
            this.copyModuleConfig();
            return true;
        }
        if (keyCode == 86 && (modifiers & 2) != 0) {
            this.pasteModuleConfig();
        }
        if (this.collapseAnimation.getOutput().floatValue() > 0.5f) {
            this.components.forEach(abstractComponent -> abstractComponent.keyPressed(keyCode, scanCode, modifiers));
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.collapseAnimation.getOutput().floatValue() > 0.5f) {
            this.components.forEach(abstractComponent -> abstractComponent.keyReleased(keyCode, scanCode, modifiers));
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (this.collapseAnimation.getOutput().floatValue() > 0.5f) {
            this.components.forEach(abstractComponent -> abstractComponent.charTyped(chr, modifiers));
        }
        return super.charTyped(chr, modifiers);
    }

    private boolean canCollapse() {
        return this.module.isShowEnable() && !this.components.isEmpty();
    }

    private float calculateExpandedSettingsHeight() {
        float offsetY = 0.0f;
        for (AbstractSettingComponent component : this.components) {
            if (component.shouldSkipRender()) continue;
            double visibilityProgress = component.getVisibilityProgress();
            offsetY += (float)((double)component.height * visibilityProgress);
        }
        return offsetY;
    }

    private float getExpandedSettingsHeight() {
        return this.cachedExpandedHeight;
    }

    private float getExpandedHeightFloat() {
        return this.getExpandedSettingsHeight() + (float)(this.module.isShowEnable() ? 46 : 28);
    }

    public int getComponentHeight() {
        int baseHeight;
        int n = baseHeight = this.module.isShowEnable() ? 46 : 28;
        if (this.components.isEmpty()) {
            return baseHeight;
        }
        float animationProgress = this.collapseAnimation.getOutput().floatValue();
        float expandedSettingsHeight = this.getExpandedSettingsHeight();
        float currentSettingsHeight = expandedSettingsHeight * animationProgress;
        return Math.round((float)baseHeight + currentSettingsHeight);
    }

    private void drawBind(class_332 context, float renderX, float renderY) {
        String bindName = StringUtil.getBindName(this.module.getKey());
        Object name = this.binding ? "(" + bindName + ") ..." : bindName;
        float stringWidth = Fonts.getSize(12, Fonts.Type.INTER_BOLD).getStringWidth((String)name);
        rectangle.render(ShapeProperties.create(context.method_51448(), renderX + this.width - stringWidth - 15.0f, renderY + 4.5f, stringWidth + 6.0f, 9.0).round(2.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getGuiRectColor(1.0f)).build());
        int bindingColor = class_9848.method_61324((int)255, (int)135, (int)136, (int)148);
        Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawString(context.method_51448(), (String)name, renderX + this.width - 12.0f - stringWidth, renderY + 8.0f, bindingColor);
    }

    private void renderArrow(class_332 context, float x, float y) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (class_2960)class_2960.method_60654((String)"textures/modules/arrow.png"));
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        float rotationAngle = -90.0f + this.arrowRotationAnimation.getOutput().floatValue() * 180.0f;
        float centerX = x + 5.0f;
        float centerY = y + 5.0f;
        context.method_51448().method_22903();
        context.method_51448().method_46416(centerX, centerY, 0.0f);
        context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(rotationAngle));
        context.method_51448().method_46416(-centerX, -centerY, 0.0f);
        drawEngine.quad(context.method_51448().method_23760().method_23761(), x, y, 10.0f, 10.0f, ColorUtil.getDescription());
        context.method_51448().method_22909();
        RenderSystem.disableBlend();
    }

    private void copyModuleConfig() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCopyTime < 150L) {
            return;
        }
        this.lastCopyTime = currentTime;
        try {
            JsonObject rootObject = new JsonObject();
            JsonObject moduleData = new JsonObject();
            rootObject.addProperty("moduleId", this.module.getIdentifier());
            rootObject.addProperty("moduleName", this.module.getName());
            moduleData.addProperty("enabled", Boolean.valueOf(this.module.isState()));
            moduleData.addProperty("bind", (Number)this.module.getKey());
            for (Setting setting : this.module.settings()) {
                this.saveSetting(setting, moduleData);
            }
            rootObject.add("config", (JsonElement)moduleData);
            String jsonString = GSON_COMPACT.toJson((JsonElement)rootObject);
            long windowHandle = mc.method_22683().method_4490();
            GLFW.glfwSetClipboardString((long)windowHandle, (CharSequence)jsonString);
            LoggerUtil.info("Copied config for module: " + this.module.getIdentifier());
            SoundManager.playSound(SoundManager.CLICK, 1.0f, 1.5f);
        }
        catch (Exception e) {
            LoggerUtil.error((Object)"Failed to copy module config", e);
        }
    }

    private void pasteModuleConfig() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPasteTime < 150L) {
            return;
        }
        this.lastPasteTime = currentTime;
        try {
            long windowHandle = mc.method_22683().method_4490();
            String jsonString = GLFW.glfwGetClipboardString((long)windowHandle);
            if (jsonString == null || jsonString.trim().isEmpty()) {
                LoggerUtil.warn("Clipboard is empty");
                return;
            }
            JsonObject rootObject = (JsonObject)GSON_COMPACT.fromJson(jsonString = jsonString.trim(), JsonObject.class);
            if (!rootObject.has("moduleId") || !rootObject.has("config")) {
                LoggerUtil.warn("Clipboard does not contain valid module config");
                return;
            }
            String clipboardModuleId = rootObject.get("moduleId").getAsString();
            if (!clipboardModuleId.equals(this.module.getIdentifier())) {
                return;
            }
            JsonObject moduleData = rootObject.getAsJsonObject("config");
            if (moduleData.has("enabled")) {
                this.module.setStateSilent(moduleData.get("enabled").getAsBoolean());
            }
            if (moduleData.has("bind")) {
                this.module.setKey(moduleData.get("bind").getAsInt());
            }
            for (Setting setting : this.module.settings()) {
                try {
                    this.loadSetting(setting, moduleData);
                }
                catch (Exception e) {
                    LoggerUtil.error((Object)("Failed to load setting: " + setting.getNameKey()), e);
                }
            }
            if (this.module.isEnabled()) {
                this.module.setStateSilent(true);
            }
            LoggerUtil.info("Pasted config for module: " + this.module.getIdentifier());
            SoundManager.playSound(SoundManager.CLICK, 1.0f, 2.0f);
        }
        catch (Exception e) {
            LoggerUtil.error((Object)"Failed to paste module config", e);
        }
    }

    private void saveSetting(Setting setting, JsonObject moduleData) {
        if (!setting.isSaveToConfig()) {
            return;
        }
        String key = setting.getNameKey();
        Setting setting2 = setting;
        Objects.requireNonNull(setting2);
        Setting setting3 = setting2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanSetting.class, ValueSetting.class, TextSetting.class, BindSetting.class, ColorSetting.class, SelectSetting.class, MultiSelectSetting.class, MultiColorSetting.class, GroupSetting.class}, (Object)setting3, n)) {
            case 0: {
                BooleanSetting booleanSetting = (BooleanSetting)setting3;
                moduleData.addProperty(key, Boolean.valueOf(booleanSetting.isValue()));
                break;
            }
            case 1: {
                ValueSetting valueSetting = (ValueSetting)setting3;
                moduleData.addProperty(key, (Number)Float.valueOf(valueSetting.getValue()));
                break;
            }
            case 2: {
                TextSetting textSetting = (TextSetting)setting3;
                String value = textSetting.getText();
                value = value.replace(" ", "%%").replace("/", "++");
                moduleData.addProperty(key, value);
                break;
            }
            case 3: {
                BindSetting bindSetting = (BindSetting)setting3;
                moduleData.addProperty(key, (Number)bindSetting.getKey());
                break;
            }
            case 4: {
                ColorSetting colorSetting = (ColorSetting)setting3;
                moduleData.addProperty(key, (Number)colorSetting.getColor());
                break;
            }
            case 5: {
                SelectSetting selectSetting = (SelectSetting)setting3;
                moduleData.addProperty(key, selectSetting.getSelected());
                break;
            }
            case 6: {
                MultiSelectSetting multiSelectSetting = (MultiSelectSetting)setting3;
                List<String> selected = multiSelectSetting.getSelected();
                moduleData.addProperty(key, String.join((CharSequence)",", selected));
                break;
            }
            case 7: {
                MultiColorSetting multiColor = (MultiColorSetting)setting3;
                JsonObject colorObject = new JsonObject();
                colorObject.addProperty("selectedColorIndex", (Number)multiColor.getSelectedColorIndex());
                JsonArray colorsArray = new JsonArray();
                for (ColorSetting color : multiColor.getAllColors()) {
                    colorsArray.add((Number)color.getColor());
                }
                colorObject.add("colors", (JsonElement)colorsArray);
                moduleData.add(key, (JsonElement)colorObject);
                break;
            }
            case 8: {
                GroupSetting group = (GroupSetting)setting3;
                JsonObject groupObject = new JsonObject();
                groupObject.addProperty("state", Boolean.valueOf(group.isValue()));
                for (Setting subSetting : group.getSubSettings()) {
                    this.saveSetting(subSetting, groupObject);
                }
                moduleData.add(key, (JsonElement)groupObject);
                break;
            }
        }
    }

    private void loadSetting(Setting setting, JsonObject moduleData) {
        if (!setting.isSaveToConfig()) {
            return;
        }
        String key = setting.getNameKey();
        if (!moduleData.has(key)) {
            return;
        }
        JsonElement element = moduleData.get(key);
        Setting setting2 = setting;
        Objects.requireNonNull(setting2);
        Setting setting3 = setting2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanSetting.class, ValueSetting.class, TextSetting.class, BindSetting.class, ColorSetting.class, SelectSetting.class, MultiSelectSetting.class, MultiColorSetting.class, GroupSetting.class}, (Object)setting3, n)) {
            case 0: {
                BooleanSetting booleanSetting = (BooleanSetting)setting3;
                booleanSetting.setValue(element.getAsBoolean());
                break;
            }
            case 1: {
                ValueSetting valueSetting = (ValueSetting)setting3;
                valueSetting.setValue(element.getAsFloat());
                break;
            }
            case 2: {
                TextSetting textSetting = (TextSetting)setting3;
                String value = element.getAsString();
                value = value.replace("%%", " ").replace("++", "/");
                textSetting.setText(value);
                break;
            }
            case 3: {
                BindSetting bindSetting = (BindSetting)setting3;
                bindSetting.setKey(element.getAsInt());
                break;
            }
            case 4: {
                ColorSetting colorSetting = (ColorSetting)setting3;
                colorSetting.setColor(element.getAsInt());
                break;
            }
            case 5: {
                SelectSetting selectSetting = (SelectSetting)setting3;
                selectSetting.setSelected(element.getAsString());
                break;
            }
            case 6: {
                MultiSelectSetting multiSelectSetting = (MultiSelectSetting)setting3;
                String value = element.getAsString();
                ArrayList<String> selected = new ArrayList<String>(Arrays.asList(value.split(",")));
                selected.removeIf(s -> !((MultiSelectSetting)setting).getList().contains(s));
                multiSelectSetting.setSelected(selected);
                break;
            }
            case 7: {
                MultiColorSetting multiColor = (MultiColorSetting)setting3;
                if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
                    int oldColor = element.getAsInt();
                    if (multiColor.getColor1() != null) {
                        multiColor.getColor1().setColor(oldColor);
                    }
                    return;
                }
                JsonObject colorObject = element.getAsJsonObject();
                if (colorObject.has("selectedColorIndex")) {
                    multiColor.setSelectedColorIndex(colorObject.get("selectedColorIndex").getAsInt());
                }
                if (!colorObject.has("colors")) break;
                JsonArray colorsArray = colorObject.getAsJsonArray("colors");
                List<ColorSetting> colorSettings = multiColor.getAllColors();
                for (int i = 0; i < Math.min(colorsArray.size(), colorSettings.size()); ++i) {
                    colorSettings.get(i).setColor(colorsArray.get(i).getAsInt());
                }
                break;
            }
            case 8: {
                GroupSetting group = (GroupSetting)setting3;
                JsonObject groupObject = element.getAsJsonObject();
                if (groupObject.has("state")) {
                    group.setValue(groupObject.get("state").getAsBoolean());
                }
                for (Setting subSetting : group.getSubSettings()) {
                    this.loadSetting(subSetting, groupObject);
                }
                break;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleComponent that = (ModuleComponent)o;
        return this.module.equals(that.module);
    }

    public int hashCode() {
        return Objects.hash(this.module);
    }

    public List<AbstractSettingComponent> getComponents() {
        return this.components;
    }

    public CheckComponent getCheckComponent() {
        return this.checkComponent;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean isBinding() {
        return this.binding;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public long getLastCopyTime() {
        return this.lastCopyTime;
    }

    public long getLastPasteTime() {
        return this.lastPasteTime;
    }

    public Animation getHoverAnimation() {
        return this.hoverAnimation;
    }

    public Animation getArrowRotationAnimation() {
        return this.arrowRotationAnimation;
    }

    public Animation getCollapseAnimation() {
        return this.collapseAnimation;
    }

    public Animation getOutlineColorAnimation() {
        return this.outlineColorAnimation;
    }

    public float getVisualX() {
        return this.visualX;
    }

    public float getVisualY() {
        return this.visualY;
    }

    public float getPrevX() {
        return this.prevX;
    }

    public float getPrevY() {
        return this.prevY;
    }

    public float getCachedExpandedHeight() {
        return this.cachedExpandedHeight;
    }

    public Image getArrowImage() {
        return this.arrowImage;
    }
}

