/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.other;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_332;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.implement.menu.MenuScreen;
import padej.soup.implement.menu.components.AbstractComponent;
import padej.soup.implement.menu.components.implement.category.CategoryComponent;

public class CategoryContainerComponent
extends AbstractComponent {
    private static final List<ModuleCategory> EXCLUDED_CATEGORIES = List.of(ModuleCategory.PERSONAL_INFO, ModuleCategory.SEARCH, ModuleCategory.HOME);
    private final List<CategoryComponent> categoryComponents = new ArrayList<CategoryComponent>();
    private float selectionX = 0.0f;
    private float selectionY = 0.0f;
    private ModuleCategory previousCategory = null;
    private final Animation selectionColorAnimation = new DecelerateAnimation().setMs(300).setValue(1.0);

    public void initializeCategoryComponents() {
        this.categoryComponents.clear();
        Arrays.stream(ModuleCategory.values()).filter(category -> !EXCLUDED_CATEGORIES.contains(category)).map(CategoryComponent::new).forEach(this.categoryComponents::add);
        this.categoryComponents.add(new CategoryComponent(ModuleCategory.HOME));
        this.categoryComponents.add(new CategoryComponent(ModuleCategory.PERSONAL_INFO));
        this.categoryComponents.add(new CategoryComponent(ModuleCategory.SEARCH));
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        ModuleCategory currentCategory = MenuScreen.INSTANCE.getCategory();
        AtomicReference<Float> offset = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> targetX = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> targetY = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicBoolean foundTarget = new AtomicBoolean(false);
        this.categoryComponents.stream().filter(component -> !EXCLUDED_CATEGORIES.contains((Object)component.getCategory())).forEach(component -> {
            component.x = this.x + 11.0f;
            component.y = this.y + 49.0f + ((Float)offset.get()).floatValue();
            component.width = 11.0f;
            component.height = 11.0f;
            if (component.getCategory() == currentCategory) {
                targetX.set(Float.valueOf(component.x));
                targetY.set(Float.valueOf(component.y));
                foundTarget.set(true);
            }
            offset.updateAndGet(v -> Float.valueOf(v.floatValue() + component.height + 14.0f));
        });
        if (this.previousCategory != currentCategory && !EXCLUDED_CATEGORIES.contains((Object)currentCategory)) {
            if (this.previousCategory == null || EXCLUDED_CATEGORIES.contains((Object)this.previousCategory)) {
                this.selectionX = targetX.get().floatValue();
                this.selectionY = targetY.get().floatValue();
                this.selectionColorAnimation.setDirection(Direction.FORWARDS);
            } else {
                this.selectionColorAnimation.setDirection(Direction.BACKWARDS);
                this.selectionColorAnimation.reset();
                this.selectionColorAnimation.setDirection(Direction.FORWARDS);
            }
            this.previousCategory = currentCategory;
        } else if (this.previousCategory != currentCategory) {
            this.previousCategory = currentCategory;
        }
        if (foundTarget.get() && !EXCLUDED_CATEGORIES.contains((Object)currentCategory)) {
            if (MenuScreen.INSTANCE.isMenuDragging()) {
                this.selectionX = targetX.get().floatValue();
                this.selectionY = targetY.get().floatValue();
            } else {
                this.selectionX = MathUtil.interpolateSmooth(4.0, this.selectionX, targetX.get().floatValue());
                this.selectionY = MathUtil.interpolateSmooth(4.0, this.selectionY, targetY.get().floatValue());
            }
            float squareSize = 17.0f;
            float iconSize = 11.0f;
            float squareX = this.selectionX + (iconSize - squareSize) / 2.0f;
            float squareY = this.selectionY + (iconSize - squareSize) / 2.0f;
            float colorProgress = this.selectionColorAnimation.getOutput().floatValue();
            int defaultOutlineColor = ColorUtil.getOutline();
            int clientOutlineColor = ColorUtil.getClientColor();
            int outlineColor = ColorUtil.overCol(defaultOutlineColor, clientOutlineColor, colorProgress);
            rectangle.render(ShapeProperties.create(context.method_51448(), squareX, squareY, squareSize, squareSize).round(3.0f).thickness(2.0f).softness(1.0f).outlineColor(outlineColor).color(ColorUtil.getGuiRectColor(0.5f)).build());
        }
        this.categoryComponents.forEach(component -> component.render(context, mouseX, mouseY, delta));
    }

    @Override
    public void tick() {
        this.categoryComponents.forEach(AbstractComponent::tick);
        super.tick();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.categoryComponents.stream().anyMatch(categoryComponent -> categoryComponent.mouseClicked(mouseX, mouseY, button)) || super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.categoryComponents.forEach(categoryComponent -> categoryComponent.mouseReleased(mouseX, mouseY, button));
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.categoryComponents.forEach(categoryComponent -> categoryComponent.mouseDragged(mouseX, mouseY, button, deltaX, deltaY));
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        this.categoryComponents.forEach(categoryComponent -> categoryComponent.mouseScrolled(mouseX, mouseY, amount));
        return super.mouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.categoryComponents.forEach(categoryComponent -> categoryComponent.keyPressed(keyCode, scanCode, modifiers));
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        this.categoryComponents.forEach(categoryComponent -> categoryComponent.charTyped(chr, modifiers));
        return super.charTyped(chr, modifiers);
    }

    public CategoryContainerComponent setSelectionX(float selectionX) {
        this.selectionX = selectionX;
        return this;
    }

    public CategoryContainerComponent setSelectionY(float selectionY) {
        this.selectionY = selectionY;
        return this;
    }

    public CategoryContainerComponent setPreviousCategory(ModuleCategory previousCategory) {
        this.previousCategory = previousCategory;
        return this;
    }
}

