/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.other;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import padej.soup.api.file.impl.ConfigFile;
import padej.soup.api.repository.config.Config;
import padej.soup.api.repository.config.ConfigUtils;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.localization.LocalizationManager;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.logger.LoggerUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.ScissorManager;
import padej.soup.core.Main;
import padej.soup.implement.menu.components.AbstractComponent;
import padej.soup.implement.menu.components.implement.other.FriendsListComponent;
import padej.soup.implement.menu.components.implement.other.SearchComponent;

public class ConfigManagerComponent
extends AbstractComponent {
    public static boolean typing = false;
    private String inputText = "";
    private int cursorPosition = 0;
    private long lastClickTime = 0L;
    private float xOffset = 0.0f;
    private String renamingConfig = null;
    private String editingConfigName = null;
    private String editingText = "";
    private int editingCursorPosition = 0;
    private float editingXOffset = 0.0f;
    private final Animation hoverAnimation = new DecelerateAnimation().setMs(200).setValue(1.0);
    private final Animation typingAnimation = new DecelerateAnimation().setMs(200).setValue(0.3f);
    private final Map<String, Animation> cardAppearAnimations = new HashMap<String, Animation>();
    private final Map<String, Animation> editIconHoverAnimations = new HashMap<String, Animation>();
    private final Map<String, Animation> deleteIconHoverAnimations = new HashMap<String, Animation>();
    private final Map<String, Boolean> cardDisappearing = new HashMap<String, Boolean>();
    private double listScrollOffset = 0.0;
    private double smoothListScrollOffset = 0.0;
    private long lastConfigRefresh = 0L;
    private static final long CONFIG_REFRESH_INTERVAL = 3000L;
    private String[] lastScannedFiles = new String[0];
    private static final int HEADER_HEIGHT = 18;
    private static final int INPUT_HEIGHT = 15;
    private static final int CONFIG_ENTRY_HEIGHT = 14;
    private static final int CONFIG_ENTRY_SPACING = 2;
    private static final int PADDING = 9;
    private static final int MIN_CARD_HEIGHT = 130;
    private final ConfigFile configFile = new ConfigFile();

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrix = context.method_51448();
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastConfigRefresh > 3000L) {
            this.refreshConfigsOptimized();
            this.lastConfigRefresh = currentTime;
        }
        this.height = this.getComponentHeight();
        boolean isHovered = this.isHover(mouseX, mouseY);
        this.hoverAnimation.setDirection(isHovered ? Direction.FORWARDS : Direction.BACKWARDS);
        float scale = 1.0f + (this.hoverAnimation.getOutput().floatValue() - 1.0f) * 0.05f;
        matrix.method_22903();
        matrix.method_46416(this.x + this.width / 2.0f, this.y + this.height / 2.0f, 0.0f);
        matrix.method_22905(scale, scale, 1.0f);
        matrix.method_46416(-(this.x + this.width / 2.0f), -(this.y + this.height / 2.0f), 0.0f);
        rectangle.render(ShapeProperties.create(matrix, this.x, this.y, this.width, 18.0).round(5.0f, 0.0f, 5.0f, 0.0f).color(ColorUtil.getGuiRectColor2(1.0f)).build());
        rectangle.render(ShapeProperties.create(matrix, this.x, this.y, this.width, this.height).round(5.0f).softness(1.0f).thickness(2.2f).outlineColor(ColorUtil.getOutline(0.56f)).color(ColorUtil.getGuiRectColor(0.0f)).build());
        Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawCenteredString(matrix, LocalizationManager.getInstance().get("ui.config_manager"), this.x + this.width / 2.0f, this.y + 7.0f, ColorUtil.getText());
        this.renderInputField(context, mouseX, mouseY);
        this.renderConfigsList(context, mouseX, mouseY);
        matrix.method_22909();
    }

    private void renderInputField(class_332 context, int mouseX, int mouseY) {
        boolean focused;
        class_4587 matrix = context.method_51448();
        float inputY = this.y + 18.0f + 9.0f;
        boolean inputHovered = MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, inputY, this.width - 18.0f, 15.0);
        this.typingAnimation.setDirection(typing || inputHovered ? Direction.FORWARDS : Direction.BACKWARDS);
        float typingAnim = this.typingAnimation.getOutput().floatValue();
        rectangle.render(ShapeProperties.create(matrix, this.x + 9.0f, inputY, this.width - 18.0f, 15.0).round(2.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getGuiRectColor(0.5f + typingAnim * 0.3f)).build());
        FontRenderer font = Fonts.getSize(13);
        this.updateXOffset(font, this.cursorPosition);
        String displayText = this.inputText.equalsIgnoreCase("") && !typing ? LocalizationManager.getInstance().get("ui.config.placeholder") : this.inputText;
        int textColor = this.inputText.isEmpty() && !typing ? ColorUtil.getDescription() : ColorUtil.getText();
        ScissorManager scissorManager = Main.getInstance().getScissorManager();
        scissorManager.push(context.method_51448().method_23760().method_23761(), this.x + 9.0f + 3.0f, inputY, this.width - 18.0f - 6.0f, 15.0f);
        font.drawString(matrix, displayText, this.x + 9.0f + 3.0f - this.xOffset, inputY + 6.0f, textColor);
        long currentTime = System.currentTimeMillis();
        boolean bl = focused = typing && currentTime % 1000L < 500L;
        if (focused) {
            float cursorX = font.getStringWidth(this.inputText.substring(0, this.cursorPosition));
            rectangle.render(ShapeProperties.create(matrix, this.x + 9.0f + 3.0f - this.xOffset + cursorX, inputY + 2.0f, 0.5, 9.0).color(-1).build());
        }
        scissorManager.pop();
        String instructionText = this.inputText.isEmpty() ? LocalizationManager.getInstance().get("ui.config.instruction_empty") : (ConfigUtils.isConfig(this.inputText.trim()) ? LocalizationManager.getInstance().get("ui.config.instruction_exists") : LocalizationManager.getInstance().get("ui.config.instruction_new"));
        Fonts.getSize(10).drawCenteredString(matrix, instructionText, this.x + this.width / 2.0f, inputY + 15.0f + 4.0f, ColorUtil.getDescription());
    }

    private void renderConfigsList(class_332 context, int mouseX, int mouseY) {
        List<Config> configs = ConfigUtils.searchConfigs(this.inputText);
        class_4587 matrix = context.method_51448();
        Matrix4f positionMatrix = matrix.method_23760().method_23761();
        ScissorManager scissorManager = Main.getInstance().getScissorManager();
        if (configs.isEmpty()) {
            float emptyY = this.y + 18.0f + 15.0f + 18.0f + 14.0f + 15.0f;
            if (this.inputText.trim().isEmpty()) {
                Fonts.getSize(12).drawCenteredString(matrix, LocalizationManager.getInstance().get("ui.config.empty_title"), this.x + this.width / 2.0f, emptyY, ColorUtil.getDescription());
                Fonts.getSize(10).drawCenteredString(matrix, LocalizationManager.getInstance().get("ui.config.empty_subtitle"), this.x + this.width / 2.0f, emptyY + 12.0f, ColorUtil.getDescription(0.4f));
            } else {
                Fonts.getSize(12).drawCenteredString(matrix, LocalizationManager.getInstance().get("ui.config.no_match_title"), this.x + this.width / 2.0f, emptyY, ColorUtil.getDescription());
                Fonts.getSize(10).drawCenteredString(matrix, LocalizationManager.getInstance().get("ui.config.no_match_subtitle"), this.x + this.width / 2.0f, emptyY + 12.0f, ColorUtil.getDescription(0.4f));
            }
            return;
        }
        float listStartY = this.y + 18.0f + 15.0f + 18.0f + 14.0f;
        float listHeight = this.height - 74.0f - 5.0f;
        int maxScroll = this.getScroll(configs, (int)listHeight);
        this.listScrollOffset = class_3532.method_15350((double)this.listScrollOffset, (double)0.0, (double)maxScroll);
        this.smoothListScrollOffset = MathUtil.interpolateSmooth(4.0, this.smoothListScrollOffset, this.listScrollOffset);
        scissorManager.push(positionMatrix, this.x + 9.0f, listStartY, this.width - 18.0f, listHeight);
        float currentY = listStartY - (float)this.smoothListScrollOffset;
        for (int i = 0; i < configs.size(); ++i) {
            Config config = configs.get(i);
            float entryY = currentY + (float)(i * 16);
            if (entryY + 14.0f < listStartY || entryY > listStartY + listHeight) continue;
            boolean withinScrollableArea = (float)mouseX >= this.x + 9.0f && (float)mouseX <= this.x + this.width - 9.0f && (float)mouseY >= listStartY && (float)mouseY <= listStartY + listHeight;
            boolean entryHovered = withinScrollableArea && (float)mouseY >= entryY && (float)mouseY <= entryY + 14.0f;
            String configKey = config.getName() + "_" + i;
            Animation appearAnimation = this.cardAppearAnimations.computeIfAbsent(configKey, k -> new DecelerateAnimation().setMs(300).setValue(1.0));
            float animValue = appearAnimation.getOutput().floatValue();
            boolean isDisappearing = this.cardDisappearing.getOrDefault(configKey, false);
            float effectiveValue = isDisappearing ? 1.0f - animValue : animValue;
            float scale = 0.8f + effectiveValue * 0.2f;
            int alpha = (int)(255.0f * effectiveValue);
            float cardCenterX = this.x + 9.0f + (this.width - 18.0f) / 2.0f;
            float cardCenterY = entryY + 7.0f;
            int finalI = i;
            MathUtil.scale(matrix, cardCenterX, cardCenterY, scale, () -> {
                String activeIndicator;
                int bgColor = alpha << 24 | ColorUtil.getGuiRectColor(0.4f) & 0xFFFFFF;
                int outlineColor = alpha << 24 | (entryHovered ? ColorUtil.getClientColor(0.8f) : ColorUtil.getOutline()) & 0xFFFFFF;
                rectangle.render(ShapeProperties.create(matrix, this.x + 9.0f, entryY, this.width - 18.0f, 14.0).round(2.0f).thickness(2.0f).outlineColor(outlineColor).color(bgColor).build());
                boolean isActiveConfig = ConfigUtils.isActiveConfig(config.getName());
                int baseTextColor = isActiveConfig ? ColorUtil.getClientColor() : ColorUtil.getText();
                int textColor = alpha << 24 | baseTextColor & 0xFFFFFF;
                String configName = config.getName();
                String string = activeIndicator = isActiveConfig ? LocalizationManager.getInstance().get("ui.config.active_indicator") : "";
                if (this.editingConfigName != null && this.editingConfigName.equals(configName)) {
                    this.renderInlineEditField(context, matrix, this.x + 9.0f + 5.0f, entryY + 2.0f, this.width - 18.0f - 50.0f);
                } else {
                    String displayName = configName.length() > 13 ? configName.substring(0, 13) + "..." + activeIndicator : configName + activeIndicator;
                    Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawString(matrix, displayName, this.x + 9.0f + 5.0f, entryY + 6.0f, textColor);
                }
                if (isActiveConfig) {
                    float dotSize = 4.0f;
                    float dotX = this.x + this.width - 9.0f - 44.0f;
                    float dotY = entryY + 7.0f - dotSize / 2.0f;
                    int dotColor = alpha << 24 | ColorUtil.getClientColor() & 0xFFFFFF;
                    rectangle.render(ShapeProperties.create(matrix, dotX, dotY, dotSize, dotSize).round(dotSize / 2.0f).color(dotColor).build());
                }
                float iconSize = 8.4f;
                float editX = this.x + this.width - 9.0f - iconSize * 2.0f - 8.0f;
                float deleteX = this.x + this.width - 9.0f - iconSize - 4.0f;
                float iconY = entryY + (14.0f - iconSize) / 2.0f;
                boolean editIconHovered = MathUtil.isHovered(mouseX, mouseY, editX, iconY, iconSize, iconSize);
                boolean deleteIconHovered = MathUtil.isHovered(mouseX, mouseY, deleteX, iconY, iconSize, iconSize);
                String editAnimKey = config.getName() + "_" + finalI + "_edit";
                Animation editHoverAnim = this.editIconHoverAnimations.computeIfAbsent(editAnimKey, k -> new DecelerateAnimation().setMs(150).setValue(1.0));
                editHoverAnim.setDirection(editIconHovered ? Direction.BACKWARDS : Direction.FORWARDS);
                float editAnimValue = editHoverAnim.getOutput().floatValue();
                int greyColor = ColorUtil.getDescription();
                int clientColor = ColorUtil.getClientColor();
                int editColor = this.interpolateColor(clientColor, greyColor, editAnimValue);
                int editIconColor = alpha << 24 | editColor & 0xFFFFFF;
                image.setTexture("textures/edit.png").render(ShapeProperties.create(matrix, editX, iconY, iconSize, iconSize).color(editIconColor).build());
                boolean canDelete = ConfigUtils.canDeleteConfig();
                String deleteAnimKey = config.getName() + "_" + finalI + "_delete";
                Animation deleteHoverAnim = this.deleteIconHoverAnimations.computeIfAbsent(deleteAnimKey, k -> new DecelerateAnimation().setMs(150).setValue(1.0));
                deleteHoverAnim.setDirection(deleteIconHovered && canDelete ? Direction.BACKWARDS : Direction.FORWARDS);
                float deleteAnimValue = deleteHoverAnim.getOutput().floatValue();
                int disabledColor = ColorUtil.getDescription(0.27f);
                int deleteBaseColor = canDelete ? greyColor : disabledColor;
                int deleteTargetColor = canDelete ? clientColor : disabledColor;
                int deleteColor = this.interpolateColor(deleteTargetColor, deleteBaseColor, deleteAnimValue);
                int deleteIconColor = alpha << 24 | deleteColor & 0xFFFFFF;
                image.setTexture("textures/trash.png").render(ShapeProperties.create(matrix, deleteX, iconY, iconSize, iconSize).color(deleteIconColor).build());
            });
        }
        this.cardAppearAnimations.entrySet().removeIf(entry -> {
            String key = (String)entry.getKey();
            Animation animation = (Animation)entry.getValue();
            boolean isDisappearing = this.cardDisappearing.getOrDefault(key, false);
            if (isDisappearing && animation.getOutput().floatValue() <= 0.01f) {
                this.cardDisappearing.remove(key);
                this.editIconHoverAnimations.remove(key + "_edit");
                this.deleteIconHoverAnimations.remove(key + "_delete");
                return true;
            }
            return false;
        });
        scissorManager.pop();
    }

    private int getScroll(List<Config> configs, int listHeight) {
        int totalContentHeight = configs.size() * 16;
        return Math.max(0, totalContentHeight - listHeight);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        float listHeight;
        float listStartY;
        if (button != 0) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        float inputY = this.y + 18.0f + 9.0f;
        if (MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, inputY, this.width - 18.0f, 15.0)) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 250L) {
                this.cursorPosition = this.inputText.length();
            } else {
                SearchComponent.typing = false;
                FriendsListComponent.typing = false;
                typing = true;
                this.lastClickTime = currentTime;
                this.cursorPosition = this.getCursorIndexAt(mouseX);
            }
            return true;
        }
        List<Config> configs = ConfigUtils.searchConfigs(this.inputText);
        if (!configs.isEmpty() && MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, listStartY = this.y + 18.0f + 15.0f + 18.0f + 14.0f, this.width - 18.0f, listHeight = this.height - 74.0f)) {
            float currentY = listStartY - (float)this.smoothListScrollOffset;
            for (int i = 0; i < configs.size(); ++i) {
                Config config = configs.get(i);
                float entryY = currentY + (float)(i * 16);
                if (entryY + 14.0f < listStartY || entryY > listStartY + listHeight) continue;
                float iconSize = 8.4f;
                float editX = this.x + this.width - 9.0f - iconSize * 2.0f - 8.0f;
                float deleteX = this.x + this.width - 9.0f - iconSize - 4.0f;
                float iconY = entryY + (14.0f - iconSize) / 2.0f;
                if (mouseX >= (double)(editX - 2.0f) && mouseX <= (double)(editX + iconSize + 2.0f) && mouseY >= (double)(iconY - 2.0f) && mouseY <= (double)(iconY + iconSize + 2.0f)) {
                    this.startRenaming(config.getName());
                    return true;
                }
                if (ConfigUtils.canDeleteConfig() && mouseX >= (double)(deleteX - 2.0f) && mouseX <= (double)(deleteX + iconSize + 2.0f) && mouseY >= (double)(iconY - 2.0f) && mouseY <= (double)(iconY + iconSize + 2.0f)) {
                    this.removeConfig(config.getName());
                    return true;
                }
                if (!(mouseY >= (double)entryY) || !(mouseY <= (double)(entryY + 14.0f)) || !(mouseX < (double)(editX - 5.0f))) continue;
                if (this.editingConfigName != null && this.editingConfigName.equals(config.getName())) {
                    float textWidth;
                    int position;
                    float fieldX = this.x + 9.0f + 5.0f;
                    float relativeX = (float)mouseX - fieldX - 3.0f + this.editingXOffset;
                    FontRenderer font = Fonts.getSize(12, Fonts.Type.INTER_BOLD);
                    for (position = 0; position < this.editingText.length() && !((textWidth = font.getStringWidth(this.editingText.substring(0, position + 1))) > relativeX); ++position) {
                    }
                    this.editingCursorPosition = position;
                } else if (!ConfigUtils.isActiveConfig(config.getName())) {
                    this.loadConfig(config.getName());
                }
                return true;
            }
            return true;
        }
        typing = false;
        if (this.editingConfigName != null) {
            this.editingConfigName = null;
            this.editingText = "";
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int totalContentHeight;
        int maxScroll;
        List<Config> configs = ConfigUtils.searchConfigs(this.inputText);
        if (configs.isEmpty()) {
            return super.mouseScrolled(mouseX, mouseY, amount);
        }
        float listStartY = this.y + 18.0f + 15.0f + 18.0f + 14.0f;
        float listHeight = this.height - 74.0f;
        if (MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, listStartY, this.width - 18.0f, listHeight) && (maxScroll = Math.max(0, (totalContentHeight = configs.size() * 16) - (int)listHeight)) > 0) {
            this.listScrollOffset = class_3532.method_15350((double)(this.listScrollOffset - amount * 15.0), (double)0.0, (double)maxScroll);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.editingConfigName != null) {
            switch (keyCode) {
                case 256: {
                    this.editingConfigName = null;
                    this.editingText = "";
                    return true;
                }
                case 257: {
                    if (!this.editingText.trim().isEmpty()) {
                        this.renameConfig(this.editingConfigName, this.editingText.trim());
                    }
                    this.editingConfigName = null;
                    this.editingText = "";
                    return true;
                }
                case 259: {
                    if (this.editingCursorPosition > 0) {
                        this.editingText = this.editingText.substring(0, this.editingCursorPosition - 1) + this.editingText.substring(this.editingCursorPosition);
                        --this.editingCursorPosition;
                    }
                    return true;
                }
                case 263: {
                    if (this.editingCursorPosition > 0) {
                        --this.editingCursorPosition;
                    }
                    return true;
                }
                case 262: {
                    if (this.editingCursorPosition < this.editingText.length()) {
                        ++this.editingCursorPosition;
                    }
                    return true;
                }
            }
        } else if (typing) {
            switch (keyCode) {
                case 257: 
                case 259: {
                    this.handleTextModification(keyCode);
                    break;
                }
                case 262: 
                case 263: {
                    this.moveCursor(keyCode);
                }
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (this.editingConfigName != null && chr >= ' ') {
            this.editingText = this.editingText.substring(0, this.editingCursorPosition) + chr + this.editingText.substring(this.editingCursorPosition);
            ++this.editingCursorPosition;
            return true;
        }
        if (typing && Fonts.getSize(13).getStringWidth(this.inputText) < this.width - 18.0f - 7.0f && chr >= ' ') {
            this.inputText = this.inputText.substring(0, this.cursorPosition) + chr + this.inputText.substring(this.cursorPosition);
            ++this.cursorPosition;
            return true;
        }
        return false;
    }

    private void saveCurrentConfig(String configName) {
        try {
            this.configFile.saveConfig(configName);
            ConfigUtils.setActiveConfig(configName);
        }
        catch (Exception e) {
            LoggerUtil.error((Object)("Failed to save current config: " + configName), e);
        }
    }

    private void loadConfig(String configName) {
        try {
            String currentActiveConfig = ConfigUtils.getActiveConfigName();
            if (currentActiveConfig != null && ConfigUtils.isConfig(currentActiveConfig)) {
                this.configFile.saveConfig(currentActiveConfig);
            }
            this.configFile.loadConfig(configName);
            ConfigUtils.setActiveConfig(configName);
        }
        catch (Exception e) {
            LoggerUtil.error((Object)("Failed to load config: " + configName), e);
        }
    }

    private void removeConfig(String configName) {
        String nextConfig;
        if (!ConfigUtils.canDeleteConfig()) {
            return;
        }
        if (ConfigUtils.isActiveConfig(configName) && (nextConfig = ConfigUtils.getNextConfigForDeletion(configName)) != null) {
            this.loadConfig(nextConfig);
        }
        this.cardAppearAnimations.forEach((key, animation) -> {
            if (key.startsWith(configName + "_")) {
                this.cardDisappearing.put((String)key, true);
                animation.setDirection(Direction.BACKWARDS);
            }
        });
        try {
            this.configFile.deleteConfig(configName);
        }
        catch (Exception e) {
            LoggerUtil.error((Object)("Failed to remove config: " + configName), e);
        }
    }

    public void saveActiveConfigIfExists() {
        try {
            String activeConfigName = ConfigUtils.getActiveConfigName();
            if (activeConfigName != null && ConfigUtils.isConfig(activeConfigName)) {
                this.configFile.saveConfig(activeConfigName);
            }
        }
        catch (Exception e) {
            LoggerUtil.error((Object)"Failed to save active config", e);
        }
    }

    public int getComponentHeight() {
        List<Config> configs = ConfigUtils.searchConfigs(this.inputText);
        int baseHeight = 20;
        if (configs.isEmpty()) {
            int emptyHeight = baseHeight + 50;
            return Math.max(emptyHeight, 130);
        }
        int configsListHeight = Math.min(configs.size() * 16, 120);
        int totalHeight = baseHeight + configsListHeight + 10;
        return Math.max(totalHeight, 130);
    }

    private void handleTextModification(int keyCode) {
        if (keyCode == 259) {
            if (this.cursorPosition > 0) {
                this.inputText = this.inputText.substring(0, this.cursorPosition - 1) + this.inputText.substring(this.cursorPosition);
                --this.cursorPosition;
            }
        } else if (keyCode == 257) {
            this.handleEnterKey();
        }
    }

    private void handleEnterKey() {
        String configName = this.inputText.trim();
        if (!configName.isEmpty()) {
            if (this.renamingConfig != null) {
                this.renameConfig(this.renamingConfig, configName);
                this.renamingConfig = null;
            } else if (ConfigUtils.isConfig(configName)) {
                this.loadConfig(configName);
            } else {
                this.saveCurrentConfig(configName);
            }
            this.inputText = "";
            this.cursorPosition = 0;
            typing = false;
        }
    }

    private void moveCursor(int keyCode) {
        if (keyCode == 263 && this.cursorPosition > 0) {
            --this.cursorPosition;
        } else if (keyCode == 262 && this.cursorPosition < this.inputText.length()) {
            ++this.cursorPosition;
        }
    }

    private int getCursorIndexAt(double mouseX) {
        float textWidth;
        int position;
        FontRenderer font = Fonts.getSize(13);
        float relativeX = (float)mouseX - this.x - 9.0f - 3.0f + this.xOffset;
        for (position = 0; position < this.inputText.length() && !((textWidth = font.getStringWidth(this.inputText.substring(0, position + 1))) > relativeX); ++position) {
        }
        return position;
    }

    private void updateXOffset(FontRenderer font, int cursorPosition) {
        float cursorX = font.getStringWidth(this.inputText.substring(0, cursorPosition));
        if (cursorX < this.xOffset) {
            this.xOffset = cursorX;
        } else if (cursorX - this.xOffset > this.width - 18.0f - 7.0f) {
            this.xOffset = cursorX - (this.width - 18.0f - 7.0f);
        }
    }

    private void updateEditingXOffset(FontRenderer font, int cursorPosition) {
        float cursorX = font.getStringWidth(this.editingText.substring(0, cursorPosition));
        float fieldWidth = this.width - 18.0f - 50.0f - 6.0f;
        if (cursorX < this.editingXOffset) {
            this.editingXOffset = cursorX;
        } else if (cursorX - this.editingXOffset > fieldWidth) {
            this.editingXOffset = cursorX - fieldWidth;
        }
    }

    private void renderInlineEditField(class_332 context, class_4587 matrix, float fieldX, float fieldY, float fieldWidth) {
        boolean focused;
        FontRenderer font = Fonts.getSize(12, Fonts.Type.INTER_BOLD);
        this.updateEditingXOffset(font, this.editingCursorPosition);
        ScissorManager scissorManager = Main.getInstance().getScissorManager();
        scissorManager.push(context.method_51448().method_23760().method_23761(), fieldX + 2.0f, fieldY, fieldWidth - 4.0f, 10.0f);
        font.drawString(matrix, this.editingText, fieldX + 3.0f - this.editingXOffset, fieldY + 4.0f, -1);
        long currentTime = System.currentTimeMillis();
        boolean bl = focused = currentTime % 1000L < 500L;
        if (focused) {
            float cursorX = font.getStringWidth(this.editingText.substring(0, this.editingCursorPosition));
            rectangle.render(ShapeProperties.create(matrix, fieldX + 3.0f - this.editingXOffset + cursorX, fieldY + 1.0f, 0.5, 8.0).color(-1).build());
        }
        scissorManager.pop();
    }

    private void startRenaming(String configName) {
        this.editingConfigName = configName;
        this.editingText = configName;
        this.editingCursorPosition = configName.length();
        this.editingXOffset = 0.0f;
        SearchComponent.typing = false;
        FriendsListComponent.typing = false;
        typing = false;
    }

    private void renameConfig(String oldName, String newName) {
        try {
            boolean renamed;
            File newFile;
            String newFileName;
            Config oldConfig;
            block23: {
                if (ConfigUtils.isConfig(newName)) {
                    LoggerUtil.warn("Config with name " + newName + " already exists");
                    return;
                }
                oldConfig = ConfigUtils.getConfig(oldName);
                if (oldConfig == null) {
                    LoggerUtil.warn("Config not found: " + oldName);
                    return;
                }
                File configDir = ConfigUtils.getConfigDirectory();
                File oldFile = new File(configDir, oldConfig.getFileName());
                newFileName = newName.toLowerCase() + ".soup";
                newFile = new File(configDir, newFileName);
                if (!oldFile.exists()) {
                    LoggerUtil.warn("Config file not found: " + oldConfig.getFileName());
                    return;
                }
                if (newFile.exists()) {
                    LoggerUtil.error("Config file with name '" + newFileName + "' already exists, cannot rename");
                    return;
                }
                LoggerUtil.info("Renaming: " + oldFile.getAbsolutePath() + " -> " + newFile.getAbsolutePath());
                renamed = false;
                try {
                    try {
                        Files.move(oldFile.toPath(), newFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                        LoggerUtil.info("File renamed successfully using atomic move");
                        renamed = true;
                    }
                    catch (AtomicMoveNotSupportedException e) {
                        LoggerUtil.info("Atomic move not supported, using regular move");
                        Files.move(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        LoggerUtil.info("File renamed successfully using regular move");
                        renamed = true;
                    }
                }
                catch (IOException e) {
                    LoggerUtil.warn("Failed to move file, trying copy+delete approach: " + e.getMessage());
                    try {
                        int attempts;
                        Files.copy(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        LoggerUtil.info("File copied successfully");
                        if (!newFile.exists()) {
                            LoggerUtil.error("New file was not created!");
                            return;
                        }
                        for (attempts = 0; attempts < 5 && oldFile.exists(); ++attempts) {
                            if (oldFile.delete()) {
                                LoggerUtil.info("Old file deleted successfully");
                                renamed = true;
                                break;
                            }
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (!renamed) {
                            LoggerUtil.error("Failed to delete old config file after " + attempts + " attempts: " + oldFile.getName());
                            newFile.delete();
                        }
                    }
                    catch (IOException e2) {
                        LoggerUtil.error((Object)"Failed to copy config file during rename", e2);
                        if (!newFile.exists()) break block23;
                        newFile.delete();
                    }
                }
            }
            if (renamed) {
                boolean wasActive = ConfigUtils.isActiveConfig(oldName);
                ConfigUtils.removeConfig(oldConfig);
                Object capitalizedNewName = newName;
                if (!((String)capitalizedNewName).isEmpty()) {
                    capitalizedNewName = ((String)capitalizedNewName).substring(0, 1).toUpperCase() + ((String)capitalizedNewName).substring(1);
                }
                Config newConfig = new Config((String)capitalizedNewName, oldConfig.getDescription(), newFileName, newFile.lastModified());
                ConfigUtils.addConfig(newConfig);
                if (wasActive) {
                    if (ConfigUtils.getConfigManager() != null) {
                        ConfigUtils.getConfigManager().setCurrentConfig(newFile);
                        ConfigUtils.getConfigManager().saveCurrentConfig();
                    }
                    ConfigUtils.setActiveConfigName((String)capitalizedNewName);
                }
                LoggerUtil.info("Successfully renamed config from '" + oldName + "' to '" + (String)capitalizedNewName + "'");
            } else {
                LoggerUtil.error("Failed to rename config file from " + oldConfig.getFileName() + " to " + newFileName);
            }
        }
        catch (Exception e) {
            LoggerUtil.error((Object)("Failed to rename config from " + oldName + " to " + newName), e);
        }
    }

    private int interpolateColor(int startColor, int endColor, float progress) {
        int startA = startColor >> 24 & 0xFF;
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endA = endColor >> 24 & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        int a = (int)((float)startA + (float)(endA - startA) * progress);
        int r = (int)((float)startR + (float)(endR - startR) * progress);
        int g = (int)((float)startG + (float)(endG - startG) * progress);
        int b = (int)((float)startB + (float)(endB - startB) * progress);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private void refreshConfigsOptimized() {
        try {
            File configDir = ConfigUtils.getConfigDirectory();
            if (!configDir.exists()) {
                return;
            }
            File[] configFiles = configDir.listFiles((dir, name) -> name.endsWith(".soup"));
            Object[] currentFiles = new String[]{};
            if (configFiles != null) {
                currentFiles = new String[configFiles.length];
                for (int i = 0; i < configFiles.length; ++i) {
                    currentFiles[i] = configFiles[i].getName();
                }
                Arrays.sort(currentFiles);
            }
            if (!Arrays.equals(this.lastScannedFiles, currentFiles)) {
                ConfigUtils.loadConfigsFromDirectory();
                this.lastScannedFiles = currentFiles;
            }
        }
        catch (Exception e) {
            LoggerUtil.warn("Failed to refresh configs, will retry later", e);
        }
    }
}

