/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.other;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_640;
import org.joml.Matrix4f;
import padej.soup.api.file.impl.FriendFile;
import padej.soup.api.repository.friend.Friend;
import padej.soup.api.repository.friend.FriendUtils;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.localization.LocalizationManager;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.logger.LoggerUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.ScissorManager;
import padej.soup.core.Main;
import padej.soup.implement.menu.components.AbstractComponent;
import padej.soup.implement.menu.components.implement.other.ConfigManagerComponent;
import padej.soup.implement.menu.components.implement.other.SearchComponent;

public class FriendsListComponent
extends AbstractComponent {
    public static boolean typing = false;
    private String inputText = "";
    private int cursorPosition = 0;
    private long lastClickTime = 0L;
    private float xOffset = 0.0f;
    private final Animation hoverAnimation = new DecelerateAnimation().setMs(200).setValue(1.0);
    private final Animation typingAnimation = new DecelerateAnimation().setMs(200).setValue(0.3f);
    private final Map<String, Animation> cardAppearAnimations = new HashMap<String, Animation>();
    private final Map<String, Boolean> cardDisappearing = new HashMap<String, Boolean>();
    private double listScrollOffset = 0.0;
    private double smoothListScrollOffset = 0.0;
    private static final int HEADER_HEIGHT = 18;
    private static final int INPUT_HEIGHT = 15;
    private static final int FRIEND_ENTRY_HEIGHT = 14;
    private static final int FRIEND_ENTRY_SPACING = 2;
    private static final int PADDING = 9;
    private static final int MIN_CARD_HEIGHT = 130;

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrix = context.method_51448();
        this.height = this.getComponentHeight();
        boolean isHovered = this.isHover(mouseX, mouseY);
        this.hoverAnimation.setDirection(isHovered ? Direction.FORWARDS : Direction.BACKWARDS);
        float scale = 1.0f + (this.hoverAnimation.getOutput().floatValue() - 1.0f) * 0.05f;
        matrix.method_22903();
        matrix.method_46416(this.x + this.width / 2.0f, this.y + this.height / 2.0f, 0.0f);
        matrix.method_22905(scale, scale, 1.0f);
        matrix.method_46416(-(this.x + this.width / 2.0f), -(this.y + this.height / 2.0f), 0.0f);
        rectangle.render(ShapeProperties.create(matrix, this.x, this.y, this.width, 18.0).round(5.0f, 0.0f, 5.0f, 0.0f).color(ColorUtil.getGuiRectColor2(1.0f)).build());
        rectangle.render(ShapeProperties.create(matrix, this.x, this.y, this.width, this.height).round(5.0f).softness(1.0f).thickness(2.2f).outlineColor(ColorUtil.getOutline(0.56f)).color(ColorUtil.getGuiRectColor(0.0f)).build());
        Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawCenteredString(matrix, LocalizationManager.getInstance().get("ui.friends_list"), this.x + this.width / 2.0f, this.y + 7.0f, ColorUtil.getText());
        this.renderInputField(context, mouseX, mouseY);
        this.renderFriendsList(context, mouseX, mouseY);
        matrix.method_22909();
    }

    private void renderInputField(class_332 context, int mouseX, int mouseY) {
        boolean focused;
        class_4587 matrix = context.method_51448();
        float inputY = this.y + 18.0f + 9.0f;
        boolean inputHovered = MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, inputY, this.width - 18.0f, 15.0);
        this.typingAnimation.setDirection(typing || inputHovered ? Direction.FORWARDS : Direction.BACKWARDS);
        float typingAnim = this.typingAnimation.getOutput().floatValue();
        rectangle.render(ShapeProperties.create(matrix, this.x + 9.0f, inputY, this.width - 18.0f, 15.0).round(2.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getGuiRectColor(0.5f + typingAnim * 0.3f)).build());
        FontRenderer font = Fonts.getSize(13);
        this.updateXOffset(font, this.cursorPosition);
        String displayText = this.inputText.equalsIgnoreCase("") && !typing ? LocalizationManager.getInstance().get("ui.friends.placeholder") : this.inputText;
        int textColor = this.inputText.isEmpty() && !typing ? ColorUtil.getDescription() : ColorUtil.getText();
        ScissorManager scissorManager = Main.getInstance().getScissorManager();
        scissorManager.push(context.method_51448().method_23760().method_23761(), this.x + 9.0f + 3.0f, inputY, this.width - 18.0f - 6.0f, 15.0f);
        if (!this.inputText.isEmpty() && typing) {
            this.getSuggestion(this.inputText).ifPresent(suggestion -> {
                String remainingText = suggestion.substring(this.inputText.length());
                float textWidth = font.getStringWidth(this.inputText);
                FontRenderer italicFont = Fonts.getSize(13, Fonts.Type.INTER_DEFAULT);
                italicFont.drawString(context.method_51448(), remainingText, this.x + 9.0f + 3.0f - this.xOffset + textWidth, inputY + 6.0f, ColorUtil.getDescription(0.47f));
            });
        }
        font.drawString(matrix, displayText, this.x + 9.0f + 3.0f - this.xOffset, inputY + 6.0f, textColor);
        long currentTime = System.currentTimeMillis();
        boolean bl = focused = typing && currentTime % 1000L < 500L;
        if (focused) {
            float cursorX = font.getStringWidth(this.inputText.substring(0, this.cursorPosition));
            rectangle.render(ShapeProperties.create(matrix, this.x + 9.0f + 3.0f - this.xOffset + cursorX, inputY + 2.0f, 0.5, 9.0).color(-1).build());
        }
        scissorManager.pop();
        String instructionText = this.inputText.isEmpty() ? LocalizationManager.getInstance().get("ui.friends.instruction_empty") : LocalizationManager.getInstance().get("ui.friends.instruction_add");
        Fonts.getSize(10).drawCenteredString(matrix, instructionText, this.x + this.width / 2.0f, inputY + 15.0f + 4.0f, ColorUtil.getDescription());
    }

    private void renderFriendsList(class_332 context, int mouseX, int mouseY) {
        List<Friend> friends = FriendUtils.getFriends();
        class_4587 matrix = context.method_51448();
        Matrix4f positionMatrix = matrix.method_23760().method_23761();
        ScissorManager scissorManager = Main.getInstance().getScissorManager();
        String searchText = this.inputText.toLowerCase();
        if (friends.isEmpty()) {
            float emptyY = this.y + 18.0f + 15.0f + 18.0f + 14.0f + 15.0f;
            Fonts.getSize(12).drawCenteredString(matrix, LocalizationManager.getInstance().get("ui.friends.empty_title"), this.x + this.width / 2.0f, emptyY, ColorUtil.getDescription());
            Fonts.getSize(10).drawCenteredString(matrix, LocalizationManager.getInstance().get("ui.friends.empty_subtitle"), this.x + this.width / 2.0f, emptyY + 12.0f, ColorUtil.getDescription(0.4f));
            return;
        }
        float listStartY = this.y + 18.0f + 15.0f + 18.0f + 14.0f;
        float listHeight = this.height - 74.0f;
        int maxScroll = this.getScroll(searchText, friends, (int)listHeight);
        this.listScrollOffset = class_3532.method_15350((double)this.listScrollOffset, (double)0.0, (double)maxScroll);
        this.smoothListScrollOffset = MathUtil.interpolateSmooth(4.0, this.smoothListScrollOffset, this.listScrollOffset);
        scissorManager.push(positionMatrix, this.x + 9.0f, listStartY, this.width - 18.0f, listHeight);
        float currentY = listStartY - (float)this.smoothListScrollOffset;
        int visibleIndex = 0;
        for (int i = 0; i < friends.size(); ++i) {
            Friend friend = friends.get(i);
            if (!searchText.isEmpty() && !friend.getName().toLowerCase().contains(searchText)) continue;
            float entryY = currentY + (float)(visibleIndex * 16);
            if (entryY + 14.0f < listStartY || entryY > listStartY + listHeight) {
                ++visibleIndex;
                continue;
            }
            boolean withinScrollableArea = (float)mouseX >= this.x + 9.0f && (float)mouseX <= this.x + this.width - 9.0f && (float)mouseY >= listStartY && (float)mouseY <= listStartY + listHeight;
            boolean entryHovered = withinScrollableArea && (float)mouseY >= entryY && (float)mouseY <= entryY + 14.0f;
            String friendKey = friend.getName() + "_" + i;
            Animation appearAnimation = this.cardAppearAnimations.computeIfAbsent(friendKey, k -> new DecelerateAnimation().setMs(300).setValue(1.0));
            float animValue = appearAnimation.getOutput().floatValue();
            boolean isDisappearing = this.cardDisappearing.getOrDefault(friendKey, false);
            float effectiveValue = isDisappearing ? 1.0f - animValue : animValue;
            float scale = 0.8f + effectiveValue * 0.2f;
            int alpha = (int)(255.0f * effectiveValue);
            float cardCenterX = this.x + 9.0f + (this.width - 18.0f) / 2.0f;
            float cardCenterY = entryY + 7.0f;
            MathUtil.scale(matrix, cardCenterX, cardCenterY, scale, () -> {
                int bgColor = alpha << 24 | ColorUtil.getGuiRectColor(0.4f) & 0xFFFFFF;
                int outlineColor = alpha << 24 | (entryHovered ? ColorUtil.getClientColor(0.8f) : ColorUtil.getOutline()) & 0xFFFFFF;
                rectangle.render(ShapeProperties.create(matrix, this.x + 9.0f, entryY, this.width - 18.0f, 14.0).round(2.0f).thickness(2.0f).outlineColor(outlineColor).color(bgColor).build());
                int textColor = alpha << 24 | ColorUtil.getText() & 0xFFFFFF;
                Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawString(matrix, friend.getName(), this.x + 9.0f + 5.0f, entryY + 6.0f, textColor);
                float iconSize = 8.4f;
                float deleteX = this.x + this.width - 9.0f - iconSize - 4.0f;
                float deleteY = entryY + (14.0f - iconSize) / 2.0f;
                int baseIconColor = entryHovered ? ColorUtil.getClientColor() : ColorUtil.getDescription();
                int iconColor = alpha << 24 | baseIconColor & 0xFFFFFF;
                image.setTexture("textures/trash.png").render(ShapeProperties.create(matrix, deleteX, deleteY, iconSize, iconSize).color(iconColor).build());
            });
            ++visibleIndex;
        }
        this.cardAppearAnimations.entrySet().removeIf(entry -> {
            String key = (String)entry.getKey();
            Animation animation = (Animation)entry.getValue();
            boolean isDisappearing = this.cardDisappearing.getOrDefault(key, false);
            if (isDisappearing && animation.getOutput().floatValue() <= 0.01f) {
                this.cardDisappearing.remove(key);
                return true;
            }
            return false;
        });
        scissorManager.pop();
    }

    private int getScroll(String searchText, List<Friend> friends, int listHeight) {
        int visibleFriendsCount = 0;
        if (searchText.isEmpty()) {
            visibleFriendsCount = friends.size();
        } else {
            for (Friend friend : friends) {
                if (!friend.getName().toLowerCase().contains(searchText)) continue;
                ++visibleFriendsCount;
            }
        }
        int totalContentHeight = visibleFriendsCount * 16;
        int maxScroll = Math.max(0, totalContentHeight - listHeight);
        return maxScroll;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        float listHeight;
        float listStartY;
        if (button != 0) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        float inputY = this.y + 18.0f + 9.0f;
        if (MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, inputY, this.width - 18.0f, 15.0)) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 250L) {
                this.cursorPosition = this.inputText.length();
            } else {
                SearchComponent.typing = false;
                ConfigManagerComponent.typing = false;
                typing = true;
                this.lastClickTime = currentTime;
                this.cursorPosition = this.getCursorIndexAt(mouseX);
            }
            return true;
        }
        List<Friend> friends = FriendUtils.getFriends();
        if (!friends.isEmpty() && MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, listStartY = this.y + 18.0f + 15.0f + 18.0f + 14.0f, this.width - 18.0f, listHeight = this.height - 74.0f)) {
            float currentY = listStartY - (float)this.smoothListScrollOffset;
            for (int i = 0; i < friends.size(); ++i) {
                Friend friend = friends.get(i);
                float entryY = currentY + (float)(i * 16);
                if (entryY + 14.0f < listStartY || entryY > listStartY + listHeight) continue;
                float iconSize = 8.0f;
                float deleteX = this.x + this.width - 9.0f - iconSize - 4.0f;
                float deleteY = entryY + (14.0f - iconSize) / 2.0f;
                if (!(mouseX >= (double)(deleteX - 2.0f)) || !(mouseX <= (double)(deleteX + iconSize + 2.0f)) || !(mouseY >= (double)(deleteY - 2.0f)) || !(mouseY <= (double)(deleteY + iconSize + 2.0f))) continue;
                this.removeFriend(friend.getName());
                return true;
            }
            return true;
        }
        typing = false;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        int totalContentHeight;
        int maxScroll;
        List<Friend> friends = FriendUtils.getFriends();
        if (friends.isEmpty()) {
            return super.mouseScrolled(mouseX, mouseY, amount);
        }
        float listStartY = this.y + 18.0f + 15.0f + 18.0f + 14.0f;
        float listHeight = this.height - 74.0f;
        if (MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, listStartY, this.width - 18.0f, listHeight) && (maxScroll = Math.max(0, (totalContentHeight = friends.size() * 16) - (int)listHeight)) > 0) {
            this.listScrollOffset = class_3532.method_15350((double)(this.listScrollOffset - amount * 15.0), (double)0.0, (double)maxScroll);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (typing) {
            switch (keyCode) {
                case 257: 
                case 259: {
                    this.handleTextModification(keyCode);
                    break;
                }
                case 262: 
                case 263: {
                    this.moveCursor(keyCode);
                    break;
                }
                case 258: {
                    this.handleTabCompletion();
                }
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (typing && Fonts.getSize(13).getStringWidth(this.inputText) < this.width - 18.0f - 7.0f) {
            this.inputText = this.inputText.substring(0, this.cursorPosition) + chr + this.inputText.substring(this.cursorPosition);
            ++this.cursorPosition;
            return true;
        }
        return false;
    }

    private void addFriend() {
        String friendName = this.inputText.trim();
        if (!friendName.isEmpty() && !FriendUtils.isFriend(friendName)) {
            FriendUtils.addFriend(friendName);
            this.inputText = "";
            this.cursorPosition = 0;
            typing = false;
            this.saveToFile();
        }
    }

    private void removeFriend(String friendName) {
        this.cardAppearAnimations.forEach((key, animation) -> {
            if (key.startsWith(friendName + "_")) {
                this.cardDisappearing.put((String)key, true);
                animation.setDirection(Direction.BACKWARDS);
            }
        });
        FriendUtils.removeFriend(friendName);
        this.saveToFile();
    }

    private void saveToFile() {
        try {
            File configDir = new File("./soupapi/files/");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            FriendFile friendFile = new FriendFile();
            friendFile.saveToFile(configDir);
        }
        catch (Exception e) {
            LoggerUtil.error((Object)"Failed to save friends to file", e);
        }
    }

    public int getComponentHeight() {
        List<Friend> friends = FriendUtils.getFriends();
        int baseHeight = 20;
        if (friends.isEmpty()) {
            int emptyHeight = baseHeight + 50;
            return Math.max(emptyHeight, 130);
        }
        int friendsListHeight = Math.min(friends.size() * 16, 120);
        int totalHeight = baseHeight + friendsListHeight + 10;
        return Math.max(totalHeight, 130);
    }

    private void handleTextModification(int keyCode) {
        if (keyCode == 259) {
            if (this.cursorPosition > 0) {
                this.inputText = this.inputText.substring(0, this.cursorPosition - 1) + this.inputText.substring(this.cursorPosition);
                --this.cursorPosition;
            }
        } else if (keyCode == 257) {
            this.addFriend();
        }
    }

    private void moveCursor(int keyCode) {
        if (keyCode == 263 && this.cursorPosition > 0) {
            --this.cursorPosition;
        } else if (keyCode == 262 && this.cursorPosition < this.inputText.length()) {
            ++this.cursorPosition;
        }
    }

    private int getCursorIndexAt(double mouseX) {
        float textWidth;
        int position;
        FontRenderer font = Fonts.getSize(13);
        float relativeX = (float)mouseX - this.x - 9.0f - 3.0f + this.xOffset;
        for (position = 0; position < this.inputText.length() && !((textWidth = font.getStringWidth(this.inputText.substring(0, position + 1))) > relativeX); ++position) {
        }
        return position;
    }

    private void updateXOffset(FontRenderer font, int cursorPosition) {
        float cursorX = font.getStringWidth(this.inputText.substring(0, cursorPosition));
        if (cursorX < this.xOffset) {
            this.xOffset = cursorX;
        } else if (cursorX - this.xOffset > this.width - 18.0f - 7.0f) {
            this.xOffset = cursorX - (this.width - 18.0f - 7.0f);
        }
    }

    private Optional<String> getSuggestion(String input) {
        if (input.isEmpty()) {
            return Optional.empty();
        }
        String lowerInput = input.toLowerCase();
        ArrayList<String> suggestions = new ArrayList<String>();
        class_310 mc = class_310.method_1551();
        if (mc.method_1562() != null) {
            suggestions.addAll(mc.method_1562().method_2880().stream().map(class_640::method_2966).map(profile -> profile.getName()).filter(name -> name.toLowerCase().startsWith(lowerInput)).collect(Collectors.toList()));
        }
        List<Friend> friends = FriendUtils.getFriends();
        for (Friend friend : friends) {
            String friendName = friend.getName();
            if (!friendName.toLowerCase().startsWith(lowerInput) || suggestions.contains(friendName)) continue;
            suggestions.add(friendName);
        }
        return suggestions.stream().findFirst();
    }

    private void handleTabCompletion() {
        if (!this.inputText.isEmpty()) {
            this.getSuggestion(this.inputText).ifPresent(suggestion -> {
                this.inputText = suggestion;
                this.cursorPosition = this.inputText.length();
            });
        }
    }
}

