/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.other;

import net.minecraft.class_332;
import net.minecraft.class_4587;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.implement.menu.MenuScreen;
import padej.soup.implement.menu.components.AbstractComponent;

public class HomeComponent
extends AbstractComponent {
    private final Animation hoverAnimation = new DecelerateAnimation().setMs(200).setValue(0.15f);
    private final Animation selectAnimation = new DecelerateAnimation().setMs(200).setValue(1.0);

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrix = context.method_51448();
        float componentWidth = 17.0f;
        float componentHeight = 17.0f;
        boolean isHomeSelected = MenuScreen.INSTANCE.getCategory() == ModuleCategory.HOME;
        boolean isHovered = MathUtil.isHovered(mouseX, mouseY, this.x, this.y, componentWidth, componentHeight);
        this.hoverAnimation.setDirection(isHovered ? Direction.FORWARDS : Direction.BACKWARDS);
        this.selectAnimation.setDirection(isHomeSelected ? Direction.FORWARDS : Direction.BACKWARDS);
        float hoverScale = 1.0f + this.hoverAnimation.getOutput().floatValue();
        float selectProgress = this.selectAnimation.getOutput().floatValue();
        float centerX = this.x + componentWidth / 2.0f;
        float centerY = this.y + componentHeight / 2.0f;
        MathUtil.scale(matrix, centerX, centerY, hoverScale, () -> {
            int outlineColor = ColorUtil.overCol(ColorUtil.getOutline(), ColorUtil.getClientColor(), selectProgress);
            int iconColor = ColorUtil.overCol(ColorUtil.getDescription(), ColorUtil.getClientColor(), selectProgress);
            rectangle.render(ShapeProperties.create(matrix, this.x, this.y, componentWidth, componentHeight).round(3.0f).thickness(2.0f).softness(1.0f).outlineColor(outlineColor).color(ColorUtil.getGuiRectColor(0.5f)).build());
            float iconSize = 7.0f;
            float iconX = this.x + (componentWidth - iconSize) / 2.0f;
            float iconY = this.y + (componentHeight - iconSize) / 2.0f;
            image.setTexture("textures/home.png").render(ShapeProperties.create(matrix, iconX, iconY, iconSize, iconSize).color(iconColor).build());
        });
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && MathUtil.isHovered(mouseX, mouseY, this.x, this.y, 17.0, 17.0)) {
            MenuScreen.INSTANCE.setCategory(ModuleCategory.HOME);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

