/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.other;

import java.util.Optional;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.ScissorManager;
import padej.soup.core.Main;
import padej.soup.implement.menu.MenuScreen;
import padej.soup.implement.menu.components.AbstractComponent;
import padej.soup.implement.menu.components.implement.other.ConfigManagerComponent;
import padej.soup.implement.menu.components.implement.other.FriendsListComponent;

public class SearchComponent
extends AbstractComponent {
    public static boolean typing = false;
    private int cursorPosition = 0;
    private long lastClickTime = 0L;
    private float xOffset = 0.0f;
    private String text = "";
    private ModuleCategory previousCategory = ModuleCategory.VISUALS;
    private float animatedWidth = 17.0f;
    private static final float COLLAPSED_WIDTH = 17.0f;
    private static final float EXPANDED_WIDTH = 78.0f;
    private static final float ICON_SIZE = 7.0f;
    private final Animation hoverAnimation = new DecelerateAnimation().setMs(200).setValue(0.15f);
    private final Animation selectAnimation = new DecelerateAnimation().setMs(200).setValue(1.0);

    public float getAnimationProgress() {
        return (this.animatedWidth - 17.0f) / 61.0f;
    }

    public void setText(String text) {
        this.text = text;
        this.cursorPosition = text.length();
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = Math.max(0, Math.min(position, this.text.length()));
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrix = context.method_51448();
        FontRenderer font = Fonts.getSize(12);
        this.updateXOffset(font, this.cursorPosition);
        float targetWidth = typing ? 78.0f : 17.0f;
        this.width = this.animatedWidth = class_3532.method_16439((float)(delta * 0.5f), (float)this.animatedWidth, (float)targetWidth);
        this.height = 17.0f;
        boolean isSearchSelected = MenuScreen.INSTANCE.getCategory() == ModuleCategory.SEARCH;
        boolean isHovered = MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height);
        this.hoverAnimation.setDirection(isHovered ? Direction.FORWARDS : Direction.BACKWARDS);
        this.selectAnimation.setDirection(isSearchSelected ? Direction.FORWARDS : Direction.BACKWARDS);
        float hoverScale = 1.0f + this.hoverAnimation.getOutput().floatValue();
        float selectProgress = this.selectAnimation.getOutput().floatValue();
        float centerX = this.x + this.width / 2.0f;
        float centerY = this.y + this.height / 2.0f;
        MathUtil.scale(matrix, centerX, centerY, hoverScale, () -> {
            float iconX;
            int outlineColor = ColorUtil.overCol(ColorUtil.getOutline(), ColorUtil.getClientColor(), selectProgress);
            int iconColor = ColorUtil.overCol(ColorUtil.getText(), ColorUtil.getClientColor(), selectProgress);
            rectangle.render(ShapeProperties.create(matrix, this.x, this.y, this.width, this.height).round(3.0f).thickness(2.0f).softness(1.0f).outlineColor(outlineColor).color(ColorUtil.getGuiRectColor(0.5f)).build());
            float iconY = this.y + (this.height - 7.0f) / 2.0f;
            if (this.animatedWidth < 77.0f) {
                float progress = (this.animatedWidth - 17.0f) / 61.0f;
                float collapsedIconX = this.x + 5.0f;
                float expandedIconX = this.x + this.width - 7.0f - 5.0f;
                iconX = class_3532.method_16439((float)progress, (float)collapsedIconX, (float)expandedIconX);
            } else {
                iconX = this.x + this.width - 7.0f - 5.0f;
            }
            image.setTexture("textures/search.png").render(ShapeProperties.create(matrix, iconX, iconY, 7.0, 7.0).color(iconColor).build());
            float animationProgress = (this.animatedWidth - 17.0f) / 61.0f;
            float textAlpha = Math.max(0.0f, Math.min(1.0f, (animationProgress - 0.2f) / 0.6f));
            if (textAlpha > 0.01f) {
                boolean focused;
                String displayText = this.text;
                ScissorManager scissor = Main.getInstance().getScissorManager();
                scissor.push(matrix.method_23760().method_23761(), this.x + 1.0f, this.y, this.width - 7.0f - 8.0f, this.height);
                if (!this.text.isEmpty() && typing) {
                    String searchText = this.text.toLowerCase();
                    int autocompleteAlpha = (int)(textAlpha * 119.0f) << 24;
                    int autocompleteColor = autocompleteAlpha | 0x777777;
                    Main.getInstance().getModuleProvider().getModules().stream().filter(mod -> mod.getLocalizedName().toLowerCase().startsWith(searchText)).findFirst().ifPresentOrElse(module -> {
                        String completion = module.getLocalizedName();
                        String remainingText = completion.substring(this.text.length());
                        float textWidth = font.getStringWidth(this.text);
                        FontRenderer italicFont = Fonts.getSize(12, Fonts.Type.INTER_DEFAULT);
                        italicFont.drawString(context.method_51448(), remainingText, this.x + 4.0f + textWidth, this.y + this.height / 2.0f - 1.0f, autocompleteColor);
                    }, () -> this.findFirstMatchingSetting(searchText).ifPresent(setting -> {
                        String completion = setting.getLocalizedName();
                        String remainingText = completion.substring(this.text.length());
                        float textWidth = font.getStringWidth(this.text);
                        FontRenderer italicFont = Fonts.getSize(12, Fonts.Type.INTER_DEFAULT);
                        italicFont.drawString(context.method_51448(), remainingText, this.x + 4.0f + textWidth, this.y + this.height / 2.0f - 1.0f, autocompleteColor);
                    }));
                }
                int alpha = (int)(textAlpha * 255.0f) << 24;
                font.drawString(context.method_51448(), displayText, this.x + 4.0f, this.y + this.height / 2.0f - 1.0f, ColorUtil.getDescription());
                scissor.pop();
                long currentTime = System.currentTimeMillis();
                boolean bl = focused = typing && currentTime % 1000L < 500L;
                if (focused && textAlpha > 0.5f) {
                    float cursorX = font.getStringWidth(this.text.substring(0, this.cursorPosition));
                    int cursorColor = (int)(textAlpha * 255.0f) << 24 | 0xFFFFFF;
                    rectangle.render(ShapeProperties.create(matrix, this.x + 4.0f - this.xOffset + cursorX, this.y + this.height / 2.0f - 3.5f, 0.5, 7.0).color(cursorColor).build());
                }
            }
        });
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height) && button == 0) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 250L && typing) {
                this.cursorPosition = this.text.length();
            } else {
                FriendsListComponent.typing = false;
                ConfigManagerComponent.typing = false;
                boolean wasTyping = typing;
                typing = true;
                this.lastClickTime = currentTime;
                if (wasTyping && this.animatedWidth > 73.0f) {
                    this.cursorPosition = this.getCursorIndexAt(mouseX);
                } else {
                    this.text = "";
                    this.cursorPosition = 0;
                    this.xOffset = 0.0f;
                }
                MenuScreen menuScreen = MenuScreen.INSTANCE;
                if (menuScreen.getCategory() != ModuleCategory.SEARCH) {
                    this.previousCategory = menuScreen.getCategory();
                }
                if (!this.text.isEmpty()) {
                    menuScreen.setCategory(ModuleCategory.SEARCH);
                }
            }
        } else if (typing) {
            MenuScreen menuScreen;
            typing = false;
            if (this.text.isEmpty() && (menuScreen = MenuScreen.INSTANCE).getCategory() == ModuleCategory.SEARCH) {
                menuScreen.setCategory(this.previousCategory);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        float maxTextWidth = 59.0f;
        if (typing && Fonts.getSize(12).getStringWidth(this.text) < maxTextWidth) {
            MenuScreen menuScreen;
            if ((chr == '/' || chr == '.') && this.text.isEmpty()) {
                return true;
            }
            if (this.text.isEmpty() && (menuScreen = MenuScreen.INSTANCE).getCategory() != ModuleCategory.SEARCH) {
                this.previousCategory = menuScreen.getCategory();
                menuScreen.setCategory(ModuleCategory.SEARCH);
            }
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (typing) {
            switch (keyCode) {
                case 257: 
                case 259: {
                    this.handleTextModification(keyCode);
                    break;
                }
                case 262: 
                case 263: {
                    this.moveCursor(keyCode);
                    break;
                }
                case 258: {
                    this.handleTabCompletion();
                }
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void handleTextModification(int keyCode) {
        if (keyCode == 259) {
            if (this.cursorPosition > 0) {
                MenuScreen menuScreen;
                this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                --this.cursorPosition;
                if (this.text.isEmpty() && (menuScreen = MenuScreen.INSTANCE).getCategory() == ModuleCategory.SEARCH) {
                    menuScreen.setCategory(this.previousCategory);
                }
            }
        } else if (keyCode == 257) {
            MenuScreen menuScreen;
            typing = false;
            if (this.text.isEmpty() && (menuScreen = MenuScreen.INSTANCE).getCategory() == ModuleCategory.SEARCH) {
                menuScreen.setCategory(this.previousCategory);
            }
        }
    }

    private void moveCursor(int keyCode) {
        if (keyCode == 263 && this.cursorPosition > 0) {
            --this.cursorPosition;
        } else if (keyCode == 262 && this.cursorPosition < this.text.length()) {
            ++this.cursorPosition;
        }
    }

    private int getCursorIndexAt(double mouseX) {
        float textWidth;
        int position;
        FontRenderer font = Fonts.getSize(12);
        float relativeX = (float)mouseX - this.x - 4.0f + this.xOffset;
        for (position = 0; position < this.text.length() && !((textWidth = font.getStringWidth(this.text.substring(0, position + 1))) > relativeX); ++position) {
        }
        return position;
    }

    private void updateXOffset(FontRenderer font, int cursorPosition) {
        float cursorX = font.getStringWidth(this.text.substring(0, cursorPosition));
        float availableWidth = this.width - 7.0f - 12.0f;
        if (cursorX < this.xOffset) {
            this.xOffset = cursorX;
        } else if (cursorX - this.xOffset > availableWidth) {
            this.xOffset = cursorX - availableWidth;
        }
    }

    private void handleTabCompletion() {
        if (!this.text.isEmpty()) {
            String searchText = this.text.toLowerCase();
            Main.getInstance().getModuleProvider().getModules().stream().filter(mod -> mod.getLocalizedName().toLowerCase().startsWith(searchText)).findFirst().ifPresentOrElse(module -> {
                this.text = module.getLocalizedName();
                this.cursorPosition = this.text.length();
            }, () -> this.findFirstMatchingSetting(searchText).ifPresent(setting -> {
                this.text = setting.getLocalizedName();
                this.cursorPosition = this.text.length();
            }));
        }
    }

    private Optional<Setting> findFirstMatchingSetting(String searchText) {
        return Main.getInstance().getModuleProvider().getModules().stream().flatMap(module -> this.findMatchingSettingInModule((Module)module, searchText).stream()).findFirst();
    }

    private Optional<Setting> findMatchingSettingInModule(Module module, String searchText) {
        return module.settings().stream().flatMap(setting -> this.findMatchingSettingRecursive((Setting)setting, searchText).stream()).findFirst();
    }

    private Optional<Setting> findMatchingSettingRecursive(Setting setting, String searchText) {
        if (setting.getLocalizedName().toLowerCase().startsWith(searchText)) {
            return Optional.of(setting);
        }
        if (setting instanceof GroupSetting) {
            GroupSetting groupSetting = (GroupSetting)setting;
            return groupSetting.getSubSettings().stream().flatMap(subSetting -> this.findMatchingSettingRecursive((Setting)subSetting, searchText).stream()).findFirst();
        }
        return Optional.empty();
    }

    public String getText() {
        return this.text;
    }

    public void setPreviousCategory(ModuleCategory previousCategory) {
        this.previousCategory = previousCategory;
    }
}

