/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.settings;

import java.util.ArrayList;
import net.minecraft.class_332;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.system.font.Fonts;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.StringUtil;
import padej.soup.implement.menu.components.implement.other.CheckComponent;
import padej.soup.implement.menu.components.implement.other.SettingComponent;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;
import padej.soup.implement.menu.components.implement.settings.ResetIconComponent;
import padej.soup.implement.menu.components.implement.window.AbstractWindow;
import padej.soup.implement.menu.components.implement.window.implement.settings.group.GroupWindow;

public class GroupComponent
extends AbstractSettingComponent {
    private final CheckComponent checkComponent = new CheckComponent();
    private final SettingComponent settingComponent = new SettingComponent();
    private final GroupSetting setting;

    public GroupComponent(GroupSetting setting) {
        super(setting);
        this.setting = setting;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateVisibilityAnimation();
        boolean isModified = this.setting.isModified();
        float textOffset = isModified ? ResetIconComponent.getTextOffset() : 0.0f;
        String wrapped = StringUtil.wrap(this.setting.getLocalizedName(), (int)(this.width - 42.0f - textOffset), 14);
        float wrappedHeight = Fonts.getSize(14).getStringHeight(wrapped);
        this.height = (int)(18.0f + Math.max(0.0f, (wrappedHeight - 14.0f) / 2.0f));
        int textColor = ColorUtil.multAlpha(ColorUtil.getText(), this.currentAlpha);
        this.resetIcon.position(this.x, this.y).alpha(this.currentAlpha).modified(isModified).render(context.method_51448());
        float textX = this.x + 9.0f + textOffset;
        Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawString(context.method_51448(), wrapped, textX, this.y + 9.0f, textColor);
        boolean isWindowOpen = this.isGroupWindowOpen();
        if (this.setting.isCheckbox()) {
            ((CheckComponent)this.checkComponent.position(this.x + this.width - 15.0f, this.y + this.height / 2.0f - 3.5f)).setRunnable(() -> this.setting.setValue(!this.setting.isValue())).setState(this.setting.isValue()).render(context, mouseX, mouseY, delta);
            ((SettingComponent)this.settingComponent.position(this.x + this.width - 27.0f, this.y + this.height / 2.0f - 2.0f)).setRunnable(() -> this.spawnWindow(mouseX, mouseY)).setWindowOpen(isWindowOpen).render(context, mouseX, mouseY, delta);
        } else {
            ((SettingComponent)this.settingComponent.position(this.x + this.width - 15.0f, this.y + this.height / 2.0f - 2.0f)).setRunnable(() -> this.spawnWindow(mouseX, mouseY)).setWindowOpen(isWindowOpen).render(context, mouseX, mouseY, delta);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.resetIcon.isHovered(mouseX, mouseY)) {
            this.setting.reset();
            return true;
        }
        if (this.setting.isCheckbox() && this.checkComponent.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.settingComponent.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        if (!this.setting.isVisible()) {
            return false;
        }
        if (this.setting.isCheckbox() && MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 16.0f, this.y + this.height / 2.0f - 3.5f, 7.0, 7.0)) {
            return true;
        }
        if (this.setting.isCheckbox() ? MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 27.0f, this.y + this.height / 2.0f - 2.0f, 12.0, 12.0) : MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 15.0f, this.y + this.height / 2.0f - 2.0f, 12.0, 12.0)) {
            return true;
        }
        return MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, this.y + 6.0f, this.width - 27.0f, this.height - 12.0f);
    }

    private void spawnWindow(int mouseX, int mouseY) {
        AbstractWindow existingWindow = null;
        for (AbstractWindow window : windowManager.getWindows()) {
            if (!(window instanceof GroupWindow) || ((GroupWindow)window).getSetting() != this.setting) continue;
            existingWindow = window;
            break;
        }
        if (existingWindow != null) {
            this.closeChildGroupWindows(this.setting);
            windowManager.delete(existingWindow);
        } else {
            int windowWidth = 137;
            int windowHeight = 200;
            int windowX = mouseX + 5;
            int windowY = mouseY + 5;
            int screenWidth = mc.method_22683().method_4486();
            int screenHeight = mc.method_22683().method_4502();
            windowX = Math.max(0, Math.min(windowX, screenWidth - windowWidth));
            windowY = Math.max(0, Math.min(windowY, screenHeight - windowHeight));
            AbstractWindow groupWindow = new GroupWindow(this.setting).position(windowX, windowY).size(windowWidth, 23.0f).draggable(false);
            windowManager.add(groupWindow);
        }
    }

    private void closeChildGroupWindows(GroupSetting parentSetting) {
        ArrayList<AbstractWindow> windowsCopy = new ArrayList<AbstractWindow>(windowManager.getWindows());
        block0: for (Setting childSetting : parentSetting.getSubSettings()) {
            if (!(childSetting instanceof GroupSetting)) continue;
            GroupSetting groupSetting = (GroupSetting)childSetting;
            this.closeChildGroupWindows(groupSetting);
            for (AbstractWindow window : windowsCopy) {
                GroupWindow groupWindow;
                if (!(window instanceof GroupWindow) || (groupWindow = (GroupWindow)window).getSetting() != groupSetting) continue;
                windowManager.delete(window);
                continue block0;
            }
        }
    }

    private boolean isGroupWindowOpen() {
        for (AbstractWindow window : windowManager.getWindows()) {
            GroupWindow groupWindow;
            if (!(window instanceof GroupWindow) || (groupWindow = (GroupWindow)window).getSetting() != this.setting) continue;
            return true;
        }
        return false;
    }
}

