/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.settings;

import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.glfw.GLFW;
import padej.soup.api.feature.module.setting.implement.TextSetting;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.StringUtil;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;
import padej.soup.implement.menu.components.implement.settings.ResetIconComponent;

public class TextComponent
extends AbstractSettingComponent {
    public static boolean typing;
    private final TextSetting setting;
    private float rectX;
    private float rectY;
    private float rectWidth;
    private float rectHeight;
    private boolean dragging;
    private int cursorPosition = 0;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private long lastClickTime = 0L;
    private float xOffset = 0.0f;
    private String text = "";

    public TextComponent(TextSetting setting) {
        super(setting);
        this.setting = setting;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        boolean focused;
        int end;
        int start;
        this.updateVisibilityAnimation();
        boolean isModified = this.setting.isModified();
        float textOffset = isModified ? ResetIconComponent.getTextOffset() : 0.0f;
        class_4587 matrix = context.method_51448();
        FontRenderer font = Fonts.getSize(12);
        String wrapped = StringUtil.wrap(this.setting.getLocalizedName(), (int)(this.width - 75.0f - textOffset), 14);
        float wrappedHeight = Fonts.getSize(14).getStringHeight(wrapped);
        this.height = (int)(18.0f + Math.max(0.0f, (wrappedHeight - 14.0f) / 2.0f));
        this.rectX = this.x + this.width - 61.5f;
        this.rectY = this.y + this.height / 2.0f - 6.0f;
        this.rectWidth = 53.0f;
        this.rectHeight = 12.0f;
        rectangle.render(ShapeProperties.create(matrix, this.rectX, this.rectY, this.rectWidth, this.rectHeight).round(2.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getGuiRectColor(1.0f)).build());
        int textColor = ColorUtil.multAlpha(ColorUtil.getText(), this.currentAlpha);
        int descColor = ColorUtil.multAlpha(ColorUtil.getDescription(), this.currentAlpha);
        this.resetIcon.position(this.x, this.y).alpha(this.currentAlpha).modified(isModified).render(matrix);
        float textX = this.x + 9.0f + textOffset;
        Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawString(context.method_51448(), wrapped, textX, this.y + 9.0f, textColor);
        this.updateXOffset(font, this.cursorPosition);
        if (typing && this.selectionStart != -1 && this.selectionEnd != -1 && this.selectionStart != this.selectionEnd && (start = Math.max(0, Math.min(this.getStartOfSelection(), this.text.length()))) < (end = Math.max(0, Math.min(this.getEndOfSelection(), this.text.length())))) {
            float selectionXStart = this.rectX + 3.0f - this.xOffset + font.getStringWidth(this.text.substring(0, start));
            float selectionXEnd = this.rectX + 3.0f - this.xOffset + font.getStringWidth(this.text.substring(0, end));
            float selectionWidth = selectionXEnd - selectionXStart;
            rectangle.render(ShapeProperties.create(matrix, selectionXStart, this.rectY + this.rectHeight / 2.0f - 4.0f, selectionWidth, 8.0).color(-11172376).build());
        }
        font.drawString(context.method_51448(), this.text, this.rectX + 3.0f - this.xOffset, this.rectY + this.rectHeight / 2.0f - 1.0f, typing ? -1 : ColorUtil.getDescription());
        if (!typing && this.text.isEmpty()) {
            this.text = this.setting.getText();
            font.drawString(context.method_51448(), this.text, this.rectX + 3.0f, this.rectY + this.rectHeight / 2.0f - 1.0f, ColorUtil.getDescription());
        }
        long currentTime = System.currentTimeMillis();
        boolean bl = focused = typing && currentTime % 1000L < 500L;
        if (focused && (this.selectionStart == -1 || this.selectionStart == this.selectionEnd)) {
            float cursorX = font.getStringWidth(this.text.substring(0, this.cursorPosition));
            rectangle.render(ShapeProperties.create(matrix, this.rectX + 3.0f - this.xOffset + cursorX, this.rectY + this.rectHeight / 2.0f - 3.5f, 0.5, 7.0).color(-1).build());
        }
        if (this.dragging) {
            this.cursorPosition = this.getCursorIndexAt(mouseX);
            if (this.selectionStart == -1) {
                this.selectionStart = this.cursorPosition + 1;
            }
            this.selectionEnd = this.cursorPosition;
        }
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.dragging = true;
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.resetIcon.isHovered(mouseX, mouseY)) {
            this.setting.reset();
            this.text = this.setting.getText() != null ? this.setting.getText() : "";
            this.cursorPosition = this.text.length();
            return true;
        }
        if (MathUtil.isHovered(mouseX, mouseY, this.rectX, this.rectY, this.rectWidth, this.rectHeight) && button == 0) {
            SoundManager.playSound(SoundManager.CLICK);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 250L) {
                this.selectionStart = 0;
                this.selectionEnd = this.text.length();
            } else {
                typing = true;
                this.dragging = true;
                this.lastClickTime = currentTime;
                this.selectionStart = this.cursorPosition = this.getCursorIndexAt(mouseX);
                this.selectionEnd = this.cursorPosition;
            }
            return true;
        }
        typing = false;
        this.clearSelection();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        if (!this.setting.isVisible()) {
            return false;
        }
        if (MathUtil.isHovered(mouseX, mouseY, this.rectX, this.rectY, this.rectWidth, this.rectHeight)) {
            return true;
        }
        return MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, this.y + 6.0f, this.width - this.rectWidth - 18.0f, this.height - 12.0f);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (typing && this.text.length() < this.setting.getMax()) {
            this.deleteSelectedText();
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.clearSelection();
        }
        return super.charTyped(chr, modifiers);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (typing) {
            if (class_437.method_25441()) {
                switch (keyCode) {
                    case 65: {
                        this.selectAllText();
                        break;
                    }
                    case 86: {
                        this.pasteFromClipboard();
                        break;
                    }
                    case 67: {
                        this.copyToClipboard();
                    }
                }
            } else {
                switch (keyCode) {
                    case 257: 
                    case 259: {
                        this.handleTextModification(keyCode);
                        break;
                    }
                    case 262: 
                    case 263: {
                        this.moveCursor(keyCode);
                    }
                }
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void pasteFromClipboard() {
        String clipboardText = GLFW.glfwGetClipboardString((long)window.method_4490());
        if (clipboardText != null) {
            this.replaceText(this.cursorPosition, this.cursorPosition, clipboardText);
        }
    }

    private void copyToClipboard() {
        if (this.hasSelection()) {
            GLFW.glfwSetClipboardString((long)window.method_4490(), (CharSequence)this.getSelectedText());
        }
    }

    private void selectAllText() {
        this.selectionStart = 0;
        this.selectionEnd = this.text.length();
    }

    private void handleTextModification(int keyCode) {
        if (keyCode == 259) {
            if (this.hasSelection()) {
                this.replaceText(this.getStartOfSelection(), this.getEndOfSelection(), "");
            } else if (this.cursorPosition > 0) {
                this.replaceText(this.cursorPosition - 1, this.cursorPosition, "");
            }
        } else if (keyCode == 257 && this.text.length() >= this.setting.getMin() && this.text.length() <= this.setting.getMax()) {
            this.setting.setText(this.text);
            typing = false;
        }
    }

    private void moveCursor(int keyCode) {
        if (keyCode == 263 && this.cursorPosition > 0) {
            --this.cursorPosition;
        } else if (keyCode == 262 && this.cursorPosition < this.text.length()) {
            ++this.cursorPosition;
        }
        this.updateSelectionAfterCursorMove();
    }

    private void updateSelectionAfterCursorMove() {
        if (class_437.method_25442()) {
            if (this.selectionStart == -1) {
                this.selectionStart = this.cursorPosition;
            }
            this.selectionEnd = this.cursorPosition;
        } else {
            this.clearSelection();
        }
    }

    private void replaceText(int start, int end, String replacement) {
        if (start < 0) {
            start = 0;
        }
        if (end > this.text.length()) {
            end = this.text.length();
        }
        if (start > end) {
            start = end;
        }
        this.text = this.text.substring(0, start) + replacement + this.text.substring(end);
        this.cursorPosition = start + replacement.length();
        this.clearSelection();
    }

    private boolean hasSelection() {
        return this.selectionStart != -1 && this.selectionEnd != -1 && this.selectionStart != this.selectionEnd;
    }

    private String getSelectedText() {
        return this.text.substring(this.getStartOfSelection(), this.getEndOfSelection());
    }

    private int getStartOfSelection() {
        return Math.min(this.selectionStart, this.selectionEnd);
    }

    private int getEndOfSelection() {
        return Math.max(this.selectionStart, this.selectionEnd);
    }

    private void clearSelection() {
        this.selectionStart = -1;
        this.selectionEnd = -1;
    }

    private int getCursorIndexAt(double mouseX) {
        float textWidth;
        int position;
        FontRenderer font = Fonts.getSize(12, Fonts.Type.INTER_BOLD);
        float relativeX = (float)mouseX - this.rectX - 3.0f + this.xOffset;
        for (position = 0; position < this.text.length() && !((textWidth = font.getStringWidth(this.text.substring(0, position + 1))) > relativeX); ++position) {
        }
        return position;
    }

    private void updateXOffset(FontRenderer font, int cursorPosition) {
        float cursorX = font.getStringWidth(this.text.substring(0, cursorPosition));
        if (cursorX < this.xOffset) {
            this.xOffset = cursorX;
        } else if (cursorX - this.xOffset > this.rectWidth - 7.0f) {
            this.xOffset = cursorX - (this.rectWidth - 7.0f);
        }
    }

    private void deleteSelectedText() {
        if (this.hasSelection()) {
            this.replaceText(this.getStartOfSelection(), this.getEndOfSelection(), "");
        }
    }
}

