/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.settings;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.StringUtil;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;
import padej.soup.implement.menu.components.implement.settings.ResetIconComponent;

public class ValueComponent
extends AbstractSettingComponent {
    public static final int SLIDER_WIDTH = 45;
    private final ValueSetting setting;
    private boolean dragging;
    private double animation;
    private float previousValue;
    private boolean isSliderHovered = false;

    public ValueComponent(ValueSetting setting) {
        super(setting);
        this.setting = setting;
        this.previousValue = setting.getValue();
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateVisibilityAnimation();
        boolean isModified = this.setting.isModified();
        float textOffset = isModified ? ResetIconComponent.getTextOffset() : 0.0f;
        class_4587 matrix = context.method_51448();
        String wrapped = StringUtil.wrap(this.setting.getLocalizedName(), (int)(this.width - 68.0f - textOffset), 14);
        float wrappedHeight = Fonts.getSize(14).getStringHeight(wrapped);
        this.height = (int)(24.0f + Math.max(0.0f, (wrappedHeight - 14.0f) / 2.0f));
        this.isSliderHovered = MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 45.0f - 9.0f, this.y + this.height - 15.0f - 2.0f, 45.0, 6.0);
        String value = String.valueOf(this.setting.getValue());
        int valueColor = ColorUtil.multAlpha(ColorUtil.getClientColor(), this.currentAlpha);
        int textColor = ColorUtil.multAlpha(ColorUtil.getText(), this.currentAlpha);
        Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawString(matrix, value, this.x + this.width - 9.0f - Fonts.getSize(12).getStringWidth(value), this.y + 3.0f, valueColor);
        this.changeValue(this.getDifference(mouseX, matrix));
        this.resetIcon.position(this.x, this.y).alpha(this.currentAlpha).modified(isModified).render(matrix);
        float textX = this.x + 9.0f + textOffset;
        Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawString(matrix, wrapped, textX, this.y + 9.0f, textColor);
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        if (!this.setting.isVisible()) {
            return false;
        }
        if (MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 45.0f - 9.0f, this.y + this.height - 15.0f - 2.0f, 45.0, 6.0)) {
            return true;
        }
        return MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, this.y + 6.0f, this.width - 45.0f - 18.0f, this.height - 12.0f);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean wasClicked;
        if (button == 0 && this.resetIcon.isHovered(mouseX, mouseY)) {
            this.setting.reset();
            return true;
        }
        boolean bl = wasClicked = MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 45.0f - 9.0f, this.y + this.height - 15.0f - 2.0f, 45.0, 6.0) && button == 0;
        if (wasClicked) {
            SoundManager.playSound(SoundManager.CLICK);
            this.dragging = true;
            return true;
        }
        this.dragging = false;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private float getDifference(int mouseX, class_4587 matrix) {
        float percentValue = 45.0f * (this.setting.getValue() - this.setting.getMin()) / (this.setting.getMax() - this.setting.getMin());
        float difference = class_3532.method_15363((float)((float)mouseX - (this.x + this.width - 45.0f - 9.0f)), (float)0.0f, (float)45.0f);
        this.animation = MathUtil.interpolate(this.animation, (double)percentValue);
        int bgColor = ColorUtil.multAlpha(758006093, this.currentAlpha);
        int sliderColor = ColorUtil.multAlpha(ColorUtil.getClientColor(), this.currentAlpha);
        int sliderDarkColor = ColorUtil.multAlpha(new Color(ColorUtil.getClientColor()).darker().getRGB(), this.currentAlpha);
        int thumbBg = ColorUtil.multAlpha(ColorUtil.getMainGuiColor(), this.currentAlpha);
        float sliderY = this.y + this.height - 15.0f;
        rectangle.render(ShapeProperties.create(matrix, this.x + this.width - 45.0f - 9.0f, sliderY, 45.0, 1.0).color(bgColor).build());
        rectangle.render(ShapeProperties.create(matrix, this.x + this.width - 45.0f - 9.0f, sliderY, (float)this.animation, 1.0).color(sliderColor, sliderColor, sliderDarkColor, sliderDarkColor).build());
        float v = class_3532.method_15363((float)((float)((double)(this.x + this.width - 45.0f) + this.animation)), (float)0.0f, (float)(this.x + this.width - 4.0f));
        rectangle.render(ShapeProperties.create(matrix, v - 10.0f, sliderY - 2.5f, 6.0, 6.0).round(3.0f).color(thumbBg).build());
        rectangle.render(ShapeProperties.create(matrix, v - 8.8f, sliderY - 1.5f, 4.0, 4.0).round(2.0f).color(sliderColor).build());
        return difference;
    }

    private void changeValue(float difference) {
        BigDecimal bd = BigDecimal.valueOf(difference / 45.0f * (this.setting.getMax() - this.setting.getMin()) + this.setting.getMin()).setScale(2, RoundingMode.HALF_UP);
        if (this.dragging) {
            float value;
            float f = value = difference == 0.0f ? this.setting.getMin() : bd.floatValue();
            if (this.setting.isInteger()) {
                value = (int)value;
            }
            if (value != this.previousValue) {
                SoundManager.playSound(SoundManager.SLIDER_STEP, 1.0f, 1.0f);
                this.previousValue = value;
            }
            this.setting.setValue(value);
        }
    }

    public boolean isSliderHovered() {
        return this.isSliderHovered;
    }
}

