/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.settings.multiselect;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.joml.Vector4f;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.implement.menu.components.AbstractComponent;

public class MultiSelectedButton
extends AbstractComponent {
    private final MultiSelectSetting setting;
    private final String text;
    private float alpha;
    private final Animation alphaAnimation = new DecelerateAnimation().setMs(300).setValue(0.5);

    public MultiSelectedButton(MultiSelectSetting setting, String text) {
        this.setting = setting;
        this.text = text;
        this.alphaAnimation.setDirection(Direction.BACKWARDS);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrix = context.method_51448();
        this.alphaAnimation.setDirection(this.setting.getSelected().contains(this.text) ? Direction.FORWARDS : Direction.BACKWARDS);
        float opacity = this.alphaAnimation.getOutput().floatValue();
        int selectedOpacity = ColorUtil.multAlpha(ColorUtil.getClientColor(), opacity * this.alpha);
        if (!this.alphaAnimation.isFinished(Direction.BACKWARDS)) {
            rectangle.render(ShapeProperties.create(matrix, this.x, this.y, this.width, this.height + 0.15f).round(MultiSelectedButton.getRound(this.setting.getList(), this.text)).color(selectedOpacity).build());
        }
        Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawString(matrix, this.text, this.x + 4.0f, this.y + 5.0f, ColorUtil.getText(this.alpha));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height) && button == 0) {
            ArrayList<String> selected = new ArrayList<String>(this.setting.getSelected());
            if (selected.contains(this.text)) {
                SoundManager.playSound(SoundManager.TURN_OFF, 1.0f, 1.5f);
                selected.remove(this.text);
            } else {
                SoundManager.playSound(SoundManager.TURN_ON, 1.0f, 1.5f);
                selected.add(this.text);
                this.sortSelectedAccordingToList(selected, this.setting.getList());
            }
            this.setting.setSelected(selected);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void sortSelectedAccordingToList(List<String> selected, List<String> list) {
        selected.sort(Comparator.comparingInt(list::indexOf));
    }

    public static Vector4f getRound(List<String> list, String text) {
        if (list.size() == 1) {
            return new Vector4f(4.0f);
        }
        if (list.getLast().contains(text)) {
            return new Vector4f(0.0f, 4.0f, 0.0f, 4.0f);
        }
        if (list.getFirst().contains(text)) {
            return new Vector4f(4.0f, 0.0f, 4.0f, 0.0f);
        }
        return new Vector4f(0.0f);
    }

    public MultiSelectedButton setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }
}

