/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.settings.select;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.joml.Vector4f;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.TargetHudRenderer;
import padej.soup.implement.features.modules.hud.TargetHud;
import padej.soup.implement.menu.components.AbstractComponent;

public class SelectedButton
extends AbstractComponent {
    private final SelectSetting setting;
    private final String text;
    private float alpha;
    private boolean isHovered = false;
    private final Animation alphaAnimation = new DecelerateAnimation().setMs(300).setValue(0.5);

    public SelectedButton(SelectSetting setting, String text) {
        this.setting = setting;
        this.text = text;
        this.alphaAnimation.setDirection(Direction.BACKWARDS);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrices = context.method_51448();
        this.isHovered = MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height);
        this.alphaAnimation.setDirection(this.setting.getSelected().contains(this.text) ? Direction.FORWARDS : Direction.BACKWARDS);
        float opacity = this.alphaAnimation.getOutput().floatValue();
        int selectedOpacity = ColorUtil.multAlpha(ColorUtil.multAlpha(ColorUtil.getClientColor(), opacity), this.alpha);
        if (!this.alphaAnimation.isFinished(Direction.BACKWARDS)) {
            rectangle.render(ShapeProperties.create(matrices, this.x, this.y, this.width, this.height + 0.15f).round(SelectedButton.getRound(this.setting.getList(), this.text)).color(selectedOpacity).build());
        }
        Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawString(matrices, this.text, this.x + 4.0f, this.y + 5.0f, ColorUtil.getText(this.alpha));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height) && button == 0) {
            SoundManager.playSound(SoundManager.CLICK);
            this.setting.setSelected(this.text);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void renderTargetHudTooltip(class_332 context) {
        if (!this.isTargetHudStyleSetting() || !this.isHovered) {
            return;
        }
        int screenWidth = window.method_4486();
        int screenHeight = window.method_4502();
        if (SelectedButton.mc.field_1724 != null) {
            TargetHud hudModule = TargetHud.getInstance();
            float scale = hudModule.scale.getValue();
            float baseWidth = this.text.equals("Default") ? 100.0f : 120.0f;
            float baseHeight = this.text.equals("Default") ? 36.0f : 46.0f;
            float scaledWidth = baseWidth * scale;
            float scaledHeight = baseHeight * scale;
            float xScaleOffset = scaledWidth - baseWidth;
            float yScaleOffset = scaledHeight - baseHeight;
            float tooltipX = (float)screenWidth / 2.0f - 205.0f;
            float tooltipY = (float)screenHeight / 2.0f + 120.0f;
            context.method_51448().method_22903();
            context.method_51448().method_46416((tooltipX += xScaleOffset / 2.0f) + 10.0f + baseWidth / 2.0f, (tooltipY += yScaleOffset / 2.0f) + 5.0f + baseHeight / 2.0f, 0.0f);
            context.method_51448().method_22905(scale, scale, 1.0f);
            context.method_51448().method_46416(-baseWidth / 2.0f, -baseHeight / 2.0f, 0.0f);
            switch (this.text) {
                case "Default": {
                    TargetHudRenderer.renderStyleZenith(context, (class_1309)SelectedButton.mc.field_1724, 0.0f, 0.0f, 100.0f, 36.0f, 50.0f);
                    break;
                }
                case "Round": {
                    TargetHudRenderer.renderStyleAres(context, (class_1309)SelectedButton.mc.field_1724, 0.0f, 0.0f, 120.0f, 46.0f, 50.0f);
                }
            }
            context.method_51448().method_22909();
        }
    }

    private boolean isTargetHudStyleSetting() {
        return this.setting.getNameKey().equals("setting.targethud.style.name");
    }

    public static Vector4f getRound(List<String> list, String text) {
        if (list.size() == 1) {
            return new Vector4f(4.0f);
        }
        if (list.getLast().contains(text)) {
            return new Vector4f(0.0f, 4.0f, 0.0f, 4.0f);
        }
        if (list.getFirst().contains(text)) {
            return new Vector4f(4.0f, 0.0f, 4.0f, 0.0f);
        }
        return new Vector4f(0.0f);
    }

    public String getText() {
        return this.text;
    }

    public SelectedButton setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public boolean isHovered() {
        return this.isHovered;
    }
}

