/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.window.implement.settings.group;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.api.feature.module.setting.SettingComponentAdder;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.ScissorManager;
import padej.soup.core.Main;
import padej.soup.implement.menu.components.AbstractComponent;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;
import padej.soup.implement.menu.components.implement.window.AbstractWindow;

public class GroupWindow
extends AbstractWindow {
    private final List<AbstractSettingComponent> components = new ArrayList<AbstractSettingComponent>();
    private final GroupSetting setting;
    private int cachedComponentHeight = 0;

    public GroupWindow(GroupSetting setting) {
        this.setting = setting;
        new SettingComponentAdder().addSettingComponent(setting.getSubSettings(), this.components);
    }

    @Override
    public void drawWindow(class_332 context, int mouseX, int mouseY, float delta) {
        boolean isLimitedHeight;
        class_4587 matrix = context.method_51448();
        ScissorManager scissorManager = Main.getInstance().getScissorManager();
        this.cachedComponentHeight = this.calculateComponentHeight();
        this.height = class_3532.method_15340((int)this.cachedComponentHeight, (int)0, (int)200);
        rectangle.render(ShapeProperties.create(matrix, this.x, this.y, this.width, this.height).round(4.0f).thickness(2.0f).softness(1.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getGuiRectColor(1.0f)).build());
        Fonts.getSize(15, Fonts.Type.INTER_BOLD).drawString(context.method_51448(), this.setting.getLocalizedName(), this.x + 9.0f, this.y + 10.0f, ColorUtil.getText());
        boolean bl = isLimitedHeight = class_3532.method_15363((float)this.height, (float)0.0f, (float)200.0f) == 200.0f;
        if (isLimitedHeight) {
            scissorManager.push(matrix.method_23760().method_23761(), this.x, this.y + 23.0f, this.width, this.height - 28.0f);
        }
        float offset = 0.0f;
        int totalHeight = 0;
        for (int i = this.components.size() - 1; i >= 0; --i) {
            AbstractSettingComponent component = this.components.get(i);
            Supplier<Boolean> visible = component.getSetting().getVisible();
            if (visible != null && !visible.get().booleanValue()) continue;
            component.x = this.x;
            component.y = (float)((double)(this.y + 19.0f + offset + (this.height - 25.0f - component.height)) + this.smoothedScroll);
            component.width = this.width;
            component.render(context, mouseX, mouseY, delta);
            offset -= component.height;
            totalHeight += (int)component.height;
        }
        if (isLimitedHeight) {
            scissorManager.pop();
        }
        int maxScroll = (int)Math.max(0.0f, (float)totalHeight - (this.height - 23.0f));
        this.scroll = class_3532.method_15350((double)this.scroll, (double)(-maxScroll), (double)0.0);
        this.smoothedScroll = class_3532.method_16436((double)0.1f, (double)this.smoothedScroll, (double)this.scroll);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, 19.0) && button == 1) {
            this.closeChildGroupWindows(this.setting);
            windowManager.delete(this);
            return true;
        }
        this.draggable(MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, 19.0) && button == 0);
        boolean isAnyComponentHovered = this.components.stream().anyMatch(abstractComponent -> abstractComponent.isHover(mouseX, mouseY));
        if (isAnyComponentHovered) {
            this.closeChildGroupWindows(this.setting);
            for (AbstractSettingComponent component : this.components) {
                if (!component.isHover(mouseX, mouseY) || !component.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        this.components.forEach(abstractComponent -> abstractComponent.mouseClicked(mouseX, mouseY, button));
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void closeChildGroupWindows(GroupSetting parentSetting) {
        ArrayList<AbstractWindow> windowsCopy = new ArrayList<AbstractWindow>(windowManager.getWindows());
        block0: for (Setting childSetting : parentSetting.getSubSettings()) {
            if (!(childSetting instanceof GroupSetting)) continue;
            GroupSetting groupSetting = (GroupSetting)childSetting;
            this.closeChildGroupWindows(groupSetting);
            for (AbstractWindow window : windowsCopy) {
                GroupWindow groupWindow;
                if (!(window instanceof GroupWindow) || (groupWindow = (GroupWindow)window).getSetting() != groupSetting) continue;
                windowManager.delete(window);
                continue block0;
            }
        }
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        this.components.forEach(abstractComponent -> abstractComponent.isHover(mouseX, mouseY));
        for (AbstractComponent abstractComponent2 : this.components) {
            if (!abstractComponent2.isHover(mouseX, mouseY)) continue;
            return true;
        }
        return super.isHover(mouseX, mouseY);
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        for (AbstractComponent abstractComponent : this.components) {
            if (!abstractComponent.isHover(mouseX, mouseY)) continue;
            return true;
        }
        return super.isHovered(mouseX, mouseY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.components.forEach(abstractComponent -> abstractComponent.mouseReleased(mouseX, mouseY, button));
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        boolean scrolled;
        boolean bl = scrolled = class_3532.method_15363((float)this.height, (float)0.0f, (float)200.0f) == 200.0f && MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height);
        if (scrolled) {
            this.scroll += amount * 20.0;
        }
        this.components.forEach(abstractComponent -> abstractComponent.mouseScrolled(mouseX, mouseY, amount));
        return scrolled;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.components.forEach(abstractComponent -> abstractComponent.keyPressed(keyCode, scanCode, modifiers));
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        this.components.forEach(abstractComponent -> abstractComponent.charTyped(chr, modifiers));
        return super.charTyped(chr, modifiers);
    }

    private int calculateComponentHeight() {
        float offsetY = 0.0f;
        for (AbstractSettingComponent component : this.components) {
            Supplier<Boolean> visible = component.getSetting().getVisible();
            if (visible != null && !visible.get().booleanValue()) continue;
            offsetY += component.height;
        }
        return (int)(offsetY + 25.0f);
    }

    public int getComponentHeight() {
        return this.cachedComponentHeight;
    }

    public List<AbstractSettingComponent> getComponents() {
        return this.components;
    }

    public GroupSetting getSetting() {
        return this.setting;
    }

    public int getCachedComponentHeight() {
        return this.cachedComponentHeight;
    }
}

