/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.mixins;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import padej.soup.api.event.EventManager;
import padej.soup.base.util.render.Render3DUtil;
import padej.soup.base.util.render.shader.ShaderHelper;
import padej.soup.implement.events.render.WorldRenderEvent;
import padej.soup.implement.features.modules.hud.TotemPop;
import padej.soup.implement.features.modules.other.AspectRatio;
import padej.soup.implement.features.modules.visuals.HandsShader;

@Mixin(value={class_757.class}, priority=1001)
public abstract class GameRendererMixin {
    @Final
    @Shadow
    private class_310 field_4015;
    @Shadow
    private float field_4005;
    @Shadow
    private float field_3988;
    @Shadow
    private float field_4004;
    @Shadow
    private float field_4025;

    @Inject(method={"renderWorld"}, at={@At(value="FIELD", target="Lnet/minecraft/client/render/GameRenderer;renderHand:Z", opcode=180, ordinal=0)})
    public void hookWorldRender(class_9779 tickCounter, CallbackInfo ci, @Local(ordinal=2) Matrix4f matrix4f) {
        class_4587 matrixStack = new class_4587();
        matrixStack.method_34425(matrix4f);
        matrixStack.method_61958(this.field_4015.method_1561().field_4686.method_19326().method_22882());
        Render3DUtil.setLastProjMat(RenderSystem.getProjectionMatrix());
        Render3DUtil.setLastWorldSpaceMatrix(matrixStack.method_23760());
        WorldRenderEvent event = new WorldRenderEvent(matrixStack, tickCounter.method_60637(false));
        EventManager.callEvent(event);
        Render3DUtil.onWorldRender();
    }

    @Inject(method={"renderWorld"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/GameRenderer;renderHand(Lnet/minecraft/client/render/Camera;FLorg/joml/Matrix4f;)V")})
    public void beforeRenderHand(class_9779 tickCounter, CallbackInfo ci) {
        HandsShader hands;
        if (!ShaderHelper.isInitialized()) {
            ShaderHelper.initShadersIfNeeded();
        }
        if ((hands = HandsShader.getInstance()) != null && hands.isEnabled() && hands.getMainShader().isSelected("Glass") && hands.getGlassHideHand().isValue()) {
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
    }

    @Inject(method={"renderWorld"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/GameRenderer;renderHand(Lnet/minecraft/client/render/Camera;FLorg/joml/Matrix4f;)V", shift=At.Shift.AFTER)})
    public void afterRenderHand(class_9779 tickCounter, CallbackInfo ci) {
        HandsShader hands = HandsShader.getInstance();
        if (hands != null && hands.isEnabled()) {
            if (hands.getMainShader().isSelected("Glass") && hands.getGlassHideHand().isValue()) {
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            ShaderHelper.checkFramebuffers();
            hands.render();
        }
    }

    @Inject(method={"renderFloatingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;translate(FFF)V", ordinal=0, shift=At.Shift.AFTER)})
    private void afterTranslateInject(class_332 context, float tickDelta, CallbackInfo ci) {
        class_4587 matrices = context.method_51448();
        TotemPop instance = TotemPop.getInstance();
        if (instance == null || !instance.isEnabled()) {
            return;
        }
        float scale = instance.totemSize.getValue();
        matrices.method_22905(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)instance.totemAlpha.getValue());
    }

    @Inject(method={"renderFloatingItem"}, at={@At(value="TAIL")})
    private void afterRenderFloatingItem(class_332 context, float tickDelta, CallbackInfo ci) {
        TotemPop instance = TotemPop.getInstance();
        if (instance != null && instance.isEnabled()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Inject(method={"getBasicProjectionMatrix"}, at={@At(value="TAIL")}, cancellable=true)
    public void getBasicProjectionMatrixHook(float fovDegrees, CallbackInfoReturnable<Matrix4f> cir) {
        AspectRatio aspectRatio = AspectRatio.getInstance();
        if (aspectRatio == null || !aspectRatio.isEnabled()) {
            return;
        }
        class_4587 matrixStack = new class_4587();
        matrixStack.method_23760().method_23761().identity();
        float factor = aspectRatio.getRatio();
        if (this.field_4005 != 1.0f) {
            matrixStack.method_46416(this.field_3988, -this.field_4004, 0.0f);
            matrixStack.method_22905(this.field_4005, this.field_4005, 1.0f);
        }
        matrixStack.method_23760().method_23761().mul((Matrix4fc)new Matrix4f().setPerspective((float)((double)fovDegrees * (Math.PI / 180)), factor, 0.05f, this.field_4025 * 4.0f));
        cir.setReturnValue((Object)matrixStack.method_23760().method_23761());
    }
}

