/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.mixins;

import java.util.ConcurrentModificationException;
import net.minecraft.class_1921;
import net.minecraft.class_266;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import padej.soup.api.event.EventManager;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.base.QuickImports;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.HotBarStatusRenderer;
import padej.soup.base.util.render.Render2DUtil;
import padej.soup.core.Main;
import padej.soup.implement.events.render.DrawEvent;
import padej.soup.implement.features.draggables.TargetHud;
import padej.soup.implement.features.modules.hud.CrossHair;
import padej.soup.implement.features.modules.hud.HotBar;
import padej.soup.implement.features.modules.hud.Potions;
import padej.soup.implement.features.modules.hud.ScoreBoard;

@Mixin(value={class_329.class})
public abstract class InGameHudMixin
implements QuickImports {
    @Final
    @Shadow
    private class_310 field_2035;
    @Unique
    private float displayedHealth = 20.0f;
    @Unique
    private float displayedArmor = 0.0f;
    @Unique
    private float displayedFood = 20.0f;
    @Unique
    private float displayedAir = 300.0f;
    @Unique
    private float displayedAbsorption = 0.0f;

    @Shadow
    protected abstract void method_1760(class_332 var1);

    @Shadow
    protected abstract void method_1741(class_332 var1);

    @Inject(method={"render"}, at={@At(value="RETURN")})
    public void onRender(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        blur.setup();
        DrawEvent event = new DrawEvent(context, drawEngine, tickCounter.method_60637(false));
        EventManager.callEvent(event);
        Render2DUtil.onRender(context);
        if (!this.field_2035.field_1690.field_1842) {
            Main.getInstance().getDraggableRepository().draggable().forEach(draggable -> {
                if (draggable.canDraw((AbstractDraggable)draggable)) {
                    draggable.startAnimation();
                } else {
                    draggable.stopAnimation();
                }
                float scale = draggable.getScaleAnimation().getOutput().floatValue();
                if (scale > 0.01f) {
                    draggable.validPosition();
                    try {
                        MathUtil.setAlpha(scale, () -> draggable.drawDraggable(context));
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        // empty catch block
                    }
                }
            });
            try {
                TargetHud targetHud;
                if (padej.soup.implement.features.modules.hud.TargetHud.getInstance().isEnabled() && (targetHud = (TargetHud)Main.getInstance().getDraggableRepository().draggable().stream().filter(d -> d instanceof TargetHud).findFirst().orElse(null)) != null) {
                    targetHud.renderParticlesAlways(context);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"renderCrosshair"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/hud/InGameHud;CROSSHAIR_TEXTURE:Lnet/minecraft/util/Identifier;")}, cancellable=true)
    public void renderCrosshairHook(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        CrossHair crossHair = CrossHair.getInstance();
        if (crossHair.isState()) {
            crossHair.onRenderCrossHair();
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderStatusEffectOverlay"}, cancellable=true)
    public void renderStatusEffectOverlayHook(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (Potions.getInstance().isEnabled()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/scoreboard/ScoreboardObjective;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderScoreboardSidebarHook(class_332 context, class_266 objective, CallbackInfo ci) {
        if (ScoreBoard.getInstance().isEnabled()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderOverlayMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderOverlayMessage(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (HotBar.getInstance().isEnabled()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderExperienceLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderExperienceLevel(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (HotBar.getInstance().isEnabled()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderMainHud"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderMainHud(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (HotBar.getInstance().isEnabled()) {
            context.method_52706(class_1921::method_62277, class_329.field_45314, 0, 0, 1, 1);
            String statusBarsMode = HotBar.getInstance().getStatusBarsMode().getSelected();
            if (this.field_2035.field_1761.method_2908()) {
                if (statusBarsMode.equals("Bars")) {
                    this.renderCustomStatusBars(context);
                } else {
                    this.method_1760(context);
                }
            }
            this.method_1741(context);
            ci.cancel();
        }
    }

    @Unique
    private void renderCustomStatusBars(class_332 context) {
        if (this.field_2035.field_1724 == null) {
            return;
        }
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int offsetT = 12;
        float maxHealth = this.field_2035.field_1724.method_6063();
        float health = this.field_2035.field_1724.method_6032();
        float absorption = this.field_2035.field_1724.method_6067();
        float armor = this.field_2035.field_1724.method_6096();
        float food = this.field_2035.field_1724.method_7344().method_7586();
        float saturation = this.field_2035.field_1724.method_7344().method_7589();
        int maxAir = this.field_2035.field_1724.method_5748();
        int air = this.field_2035.field_1724.method_5669();
        this.displayedHealth += (health - this.displayedHealth) * 0.2f;
        this.displayedAbsorption += (absorption - this.displayedAbsorption) * 0.2f;
        this.displayedArmor += (armor - this.displayedArmor) * 0.2f;
        this.displayedFood += (food - this.displayedFood) * 0.2f;
        this.displayedAir += ((float)air - this.displayedAir) * 0.2f;
        int barWidth = 81;
        int barHeight = 9;
        int cornerRadius = 2;
        int centerX = screenWidth / 2;
        int offset = 91;
        int healthX = centerX - offset;
        int healthY = screenHeight - 55;
        HotBarStatusRenderer.renderHealthBar(context, healthX, healthY + offsetT, barWidth, barHeight, cornerRadius, this.displayedHealth, maxHealth, this.displayedAbsorption);
        if (armor > 0.0f) {
            int armorY = healthY - 15;
            HotBarStatusRenderer.renderArmorBar(context, healthX, armorY + offsetT, barWidth, barHeight, cornerRadius, this.displayedArmor);
        }
        int hungerX = centerX + offset - barWidth;
        int hungerY = screenHeight - 55;
        HotBarStatusRenderer.renderHungerBar(context, hungerX, hungerY + offsetT, barWidth, barHeight, cornerRadius, this.displayedFood, saturation);
        if (air < maxAir) {
            int airY = hungerY - 15;
            HotBarStatusRenderer.renderAirBar(context, hungerX, airY + offsetT, barWidth, barHeight, cornerRadius, this.displayedAir, maxAir);
        }
        if (HotBar.getInstance().getExperienceBar().isValue()) {
            float experienceProgress = this.field_2035.field_1724.field_7510;
            int experienceLevel = this.field_2035.field_1724.field_7520;
            int expBarWidth = 182;
            int expBarHeight = 4;
            int expBarX = centerX - expBarWidth / 2;
            int expBarY = screenHeight - 33;
            HotBarStatusRenderer.renderExperienceBar(context, expBarX, expBarY, expBarWidth, expBarHeight, cornerRadius, experienceProgress, experienceLevel);
        }
    }
}

