/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.mixins;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_542;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import padej.soup.api.event.EventManager;
import padej.soup.api.file.exception.FileProcessingException;
import padej.soup.api.system.font.Fonts;
import padej.soup.base.QuickImports;
import padej.soup.base.util.logger.LoggerUtil;
import padej.soup.core.Main;
import padej.soup.implement.events.container.SetScreenEvent;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin
implements QuickImports {
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Nullable
    public class_437 field_1755;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void onInit(class_542 args, CallbackInfo ci) {
        Fonts.init();
    }

    @Inject(at={@At(value="HEAD")}, method={"stop"})
    private void stop(CallbackInfo ci) {
        if (Main.getInstance().isInitialized()) {
            if (Main.getInstance().getActivityManager() != null) {
                Main.getInstance().getActivityManager().endSession();
            }
            try {
                Main.getInstance().getFileController().saveFiles();
            }
            catch (FileProcessingException e) {
                LoggerUtil.error("Error occurred while saving files: " + e.getMessage() + " " + String.valueOf(e.getCause()));
            }
            finally {
                Main.getInstance().getFileController().stopAutoSave();
            }
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    public void setScreenHook(class_437 screen, CallbackInfo ci) {
        SetScreenEvent event = new SetScreenEvent(screen);
        EventManager.callEvent(event);
        Main.getInstance().getDraggableRepository().draggable().forEach(drag -> drag.setScreen(event));
        class_437 eventScreen = event.getScreen();
        if (screen != eventScreen) {
            mc.method_1507(eventScreen);
            ci.cancel();
        }
    }
}

