/*
 * Decompiled with CFR 0.152.
 */
package com.pixelindiedev.lazy_ai_pixelindiedev;

import com.pixelindiedev.lazy_ai_pixelindiedev.config.DistanceType;
import com.pixelindiedev.lazy_ai_pixelindiedev.config.ModConfig;
import com.pixelindiedev.lazy_ai_pixelindiedev.config.OptimalizationType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.server.MinecraftServer;

public class Lazy_ai_pixelindiedev
implements ModInitializer {
    private static final float MinimumDistanceMultiplier = 1.5f;
    private static final float FarDistanceMultiplier = 16.0f;
    private static final float MediumDistanceMultiplier = 6.0f;
    private static final float CloseDistanceMultiplier = 1.65f;
    private static final Map<UUID, DistanceType> cache = new ConcurrentHashMap<UUID, DistanceType>();
    public static ModConfig CONFIG;
    private static int lastTick;

    public static void onServerTick(MinecraftServer server) {
        int currentTick = server.method_3780();
        if (currentTick != lastTick) {
            cache.clear();
            lastTick = currentTick;
        }
        if (CONFIG.hasExternalChange()) {
            CONFIG = ModConfig.load();
        }
    }

    public static float lerp(DistanceType distance) {
        DistanceType distanceType = distance;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FarRange", "MediumRange"}, (DistanceType)distanceType, n)) {
            case 0 -> 16.0f;
            case 1 -> 6.0f;
            default -> 1.65f;
        };
    }

    public static DistanceType GetClosestPlayerDistance(class_1308 mob) {
        if (mob == null) {
            return DistanceType.FarRange;
        }
        class_1657 closestPlayer = mob.method_37908().method_18460((class_1297)mob, (double)Lazy_ai_pixelindiedev.CONFIG.BlockDistance_Far);
        if (closestPlayer == null) {
            return DistanceType.FarRange;
        }
        double distancebetween = mob.method_5858((class_1297)closestPlayer);
        if (distancebetween >= (double)Lazy_ai_pixelindiedev.CONFIG.BlockDistance_Far) {
            return DistanceType.FarRange;
        }
        if (distancebetween >= (double)Lazy_ai_pixelindiedev.CONFIG.BlockDistance_Close) {
            return DistanceType.MediumRange;
        }
        return DistanceType.CloseRange;
    }

    public static DistanceType getDistance(class_1308 mob) {
        if (mob == null || mob.method_37908() == null) {
            return DistanceType.FarRange;
        }
        return cache.computeIfAbsent(mob.method_5667(), id -> Lazy_ai_pixelindiedev.GetClosestPlayerDistance(mob));
    }

    public static int squaredBlocksToChunks(int squaredBlockDistance, int multiplier) {
        return (int)Math.round(Math.sqrt(squaredBlockDistance) * (double)multiplier / 16.0);
    }

    public static int chunksToSquaredBlocks(int chunkRadius, int multiplier) {
        int blocks = chunkRadius * 16 / multiplier;
        return blocks * blocks;
    }

    public static int getTemptGoal() {
        return Lazy_ai_pixelindiedev.CONFIG.TemptDelay.ordinal();
    }

    public static OptimalizationType getOptimalizationType() {
        return Lazy_ai_pixelindiedev.CONFIG.AIOptimizationType;
    }

    public static boolean getDisableZombieEggStomping() {
        return Lazy_ai_pixelindiedev.CONFIG.DisableZombieEggStomping;
    }

    public void onInitialize() {
        ServerTickEvents.START_SERVER_TICK.register(Lazy_ai_pixelindiedev::onServerTick);
        CONFIG = ModConfig.load();
    }

    static {
        lastTick = -1;
    }
}

