/*
 * Decompiled with CFR 0.152.
 */
package pl.olafcio.protocolextension.server.api.player.packetevents;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPluginMessage;
import io.github.retrooper.packetevents.adventure.serializer.legacy.LegacyComponentSerializer;
import io.netty.buffer.Unpooled;
import java.lang.runtime.SwitchBootstraps;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import pl.olafcio.protocolextension.server.api.PacketConstructionError;
import pl.olafcio.protocolextension.server.api.virtual.managers.PlayerManager;

public class ProtocolExtensionPacketEventsPlayerManager
implements PlayerManager {
    @Override
    public void activate(Player player) {
        UserMethods.activate(PacketEvents.getAPI().getPlayerManager().getUser((Object)player));
    }

    @Override
    public void forceHUD(Player player, boolean state) {
        UserMethods.forceHUD(PacketEvents.getAPI().getPlayerManager().getUser((Object)player), state);
    }

    @Override
    public void putHUD(Player player, short id, double x, double y, Component text) {
        UserMethods.putHUD(PacketEvents.getAPI().getPlayerManager().getUser((Object)player), id, x, y, text);
    }

    @Override
    public void deleteHUD(Player player, short id) {
        UserMethods.deleteHUD(PacketEvents.getAPI().getPlayerManager().getUser((Object)player), id);
    }

    public static final class UserMethods
    extends Enum<UserMethods> {
        private static final /* synthetic */ UserMethods[] $VALUES;

        public static UserMethods[] values() {
            return (UserMethods[])$VALUES.clone();
        }

        public static UserMethods valueOf(String name) {
            return Enum.valueOf(UserMethods.class, name);
        }

        public static void activate(User player) {
            player.sendPacket(Packets.make("protocolextension:activate", new Object[0]));
        }

        public static void forceHUD(User player, boolean state) {
            player.sendPacket(Packets.make("protocolextension:toggle-hud", state));
        }

        public static void putHUD(User player, short id, double x, double y, Component text) {
            player.sendPacket(Packets.make("protocolextension:put-hud", id, x, y, LegacyComponentSerializer.legacySection().serialize(text)));
        }

        public static void deleteHUD(User player, short id) {
            player.sendPacket(Packets.make("protocolextension:delete-hud", id));
        }

        private static /* synthetic */ UserMethods[] $values() {
            return new UserMethods[0];
        }

        static {
            $VALUES = UserMethods.$values();
        }
    }

    public static final class Packets
    extends Enum<Packets> {
        private static final /* synthetic */ Packets[] $VALUES;

        public static Packets[] values() {
            return (Packets[])$VALUES.clone();
        }

        public static Packets valueOf(String name) {
            return Enum.valueOf(Packets.class, name);
        }

        public static PacketWrapper<?> make(String type, Object ... codec) {
            PacketWrapper buf = new PacketWrapper(0);
            buf.setBuffer((Object)Unpooled.buffer());
            Object[] objectArray = codec;
            int n = objectArray.length;
            block7: for (int i = 0; i < n; ++i) {
                Object obj;
                Object object = obj = objectArray[i];
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Short.class, Float.class, Double.class, String.class}, (Object)object, n2)) {
                    case 0: {
                        Boolean bool = (Boolean)object;
                        buf.writeBoolean(bool.booleanValue());
                        continue block7;
                    }
                    case 1: {
                        Short s = (Short)object;
                        buf.writeShort((int)s.shortValue());
                        continue block7;
                    }
                    case 2: {
                        Float f = (Float)object;
                        buf.writeFloat(f.floatValue());
                        continue block7;
                    }
                    case 3: {
                        Double d = (Double)object;
                        buf.writeDouble(d.doubleValue());
                        continue block7;
                    }
                    case 4: {
                        String s = (String)object;
                        buf.writeString(s);
                        continue block7;
                    }
                    default: {
                        throw new PacketConstructionError("Cannot encode type '" + obj.getClass().getName() + "'");
                    }
                }
            }
            byte[] data = buf.readRemainingBytes();
            return new WrapperPlayServerPluginMessage(type, data);
        }

        private static /* synthetic */ Packets[] $values() {
            return new Packets[0];
        }

        static {
            $VALUES = Packets.$values();
        }
    }
}

