/*
 * Decompiled with CFR 0.152.
 */
package pl.olafcio.protocolextension.server.main;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import pl.olafcio.protocolextension.both.Position;
import pl.olafcio.protocolextension.server.VariableAPI;
import pl.olafcio.protocolextension.server.api.virtual.ProtocolExtensionAPI;
import pl.olafcio.protocolextension.server.main.TMultiversion;

@ApiStatus.NonExtendable
public interface TCommands
extends TMultiversion {
    public ProtocolExtensionAPI api();

    default public Player getSinglePlayer(PlayerSelectorArgumentResolver arg, CommandSourceStack source) throws CommandSyntaxException {
        List playerList = (List)arg.resolve(source);
        if (playerList.isEmpty()) {
            source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a74 Error:\u00a7c Unknown player.");
            return null;
        }
        return (Player)playerList.getFirst();
    }

    default public void registerCommands(ReloadableRegistrarEvent<@NotNull Commands> commands) {
        LiteralArgumentBuilder px = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"protocolextension").requires(source -> source.getSender().hasPermission("protocolextension.command"))).executes(ctx -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            sender.sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 This server is using \u00a76ProtocolExtension\u00a77 made by Olafcio with \u00a7c\u2665");
            return 1;
        });
        px.then(this.registerHud());
        px.then(this.registerMousePos());
        px.then(this.registerSetWindowTitle());
        px.then(this.registerMoveToggle());
        ((Commands)commands.registrar()).register(px.build(), Set.of("px"));
    }

    private LiteralArgumentBuilder<CommandSourceStack> registerMoveToggle() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"move-toggle").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.set_window_title")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            Boolean state = (Boolean)ctx.getArgument("state", Boolean.TYPE);
            PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
            Player player = this.getSinglePlayer(playerArg, source);
            if (player != null) {
                this.api().playerManager().moveToggle(player, state);
                source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 Move toggle set to \u00a7n%s\u00a77.".formatted(state));
            }
            return 1;
        })));
    }

    private LiteralArgumentBuilder<CommandSourceStack> registerSetWindowTitle() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set-window-title").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.set_window_title")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"text", (ArgumentType)ArgumentTypes.component()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            Component component = (Component)ctx.getArgument("text", Component.class);
            PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
            Player player = this.getSinglePlayer(playerArg, source);
            if (player != null) {
                this.api().playerManager().setWindowTitle(player, component);
                source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 Window title changed.");
            }
            return 1;
        })));
    }

    default public LiteralArgumentBuilder<CommandSourceStack> registerHud() {
        LiteralArgumentBuilder hud = Commands.literal((String)"hud");
        hud.then(((LiteralArgumentBuilder)Commands.literal((String)"force").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.hud.force")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
            Boolean state = (Boolean)ctx.getArgument("state", Boolean.TYPE);
            Player player = this.getSinglePlayer(playerArg, source);
            if (player != null) {
                this.api().playerManager().forceHUD(player, state);
                source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 Forced HUD state to \u00a7n" + state + "\u00a77 for \u00a76" + player.getName());
            }
            return 1;
        }))));
        hud.then(((LiteralArgumentBuilder)Commands.literal((String)"put").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.hud.put")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(Commands.argument((String)"text", (ArgumentType)ArgumentTypes.component()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
            Integer id = (Integer)ctx.getArgument("id", Integer.TYPE);
            Float x = (Float)ctx.getArgument("x", Float.TYPE);
            Float y = (Float)ctx.getArgument("y", Float.TYPE);
            Component textNBT = (Component)ctx.getArgument("text", Component.class);
            Player player = this.getSinglePlayer(playerArg, source);
            if (player != null) {
                this.api().playerManager().putHUD(player, id.shortValue(), x.floatValue(), y.floatValue(), textNBT);
                source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 HUD element added.");
            }
            return 1;
        })))))));
        hud.then(((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.hud.delete")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            Integer id = (Integer)ctx.getArgument("id", Integer.TYPE);
            PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
            Player player = this.getSinglePlayer(playerArg, source);
            if (player != null) {
                this.api().playerManager().deleteHUD(player, id.shortValue());
                source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 HUD element deleted.");
            }
            return 1;
        }))));
        hud.then(((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.hud.clear")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
            Player player = this.getSinglePlayer(playerArg, source);
            if (player != null) {
                this.api().playerManager().clearHUD(player);
                source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 HUD elements cleared.");
            }
            return 1;
        })));
        return hud;
    }

    default public LiteralArgumentBuilder<CommandSourceStack> registerMousePos() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mouse-position").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.mouse_position")))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
            Player player = this.getSinglePlayer(playerArg, source);
            if (player != null) {
                Position pos = VariableAPI.getMousePos(player, Position.ZERO);
                source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 Player \u00a76" + player.getName() + "\u00a77's mouse is at \u00a7e" + pos.x() + "% " + pos.y() + "%");
            }
            return 1;
        })));
    }
}

