/*
 * Decompiled with CFR 0.152.
 */
package pl.olafcio.protocolextension.server;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.olafcio.protocolextension.both.Position;
import pl.olafcio.protocolextension.server.VariableAPI;
import pl.olafcio.protocolextension.server.api.base.ListenerManagerImpl;
import pl.olafcio.protocolextension.server.api.base.ProtocolExtensionAPIRecord;
import pl.olafcio.protocolextension.server.api.player.packetevents.ProtocolExtensionPacketEventsPacketListener;
import pl.olafcio.protocolextension.server.api.player.packetevents.ProtocolExtensionPacketEventsPlayerManager;
import pl.olafcio.protocolextension.server.api.virtual.ProtocolExtensionAPI;

public final class ProtocolExtension
extends JavaPlugin
implements Listener {
    private static File configFile;
    private static FileConfiguration config;
    private static ProtocolExtensionAPI api;

    public void onLoad() {
        configFile = new File(this.getDataFolder(), "config.yml");
        this.reloadConfig();
    }

    public void reloadConfig() {
        config = YamlConfiguration.loadConfiguration((File)configFile);
        InputStream defConfigStream = this.getResource("paper/config.yml");
        if (defConfigStream == null) {
            return;
        }
        config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8)));
    }

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new ProtocolExtensionPacketEventsPacketListener(), PacketListenerPriority.NORMAL);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            LiteralArgumentBuilder px = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"protocolextension").requires(source -> source.getSender().hasPermission("protocolextension.command"))).executes(ctx -> {
                CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
                sender.sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 This server is using \u00a76ProtocolExtension\u00a77 made by Olafcio with \u00a7c\u2665");
                return 1;
            });
            px.then(((LiteralArgumentBuilder)Commands.literal((String)"force-hud").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.force_hud")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
                Boolean state = (Boolean)ctx.getArgument("state", Boolean.TYPE);
                Player player = this.getSinglePlayer(playerArg, source);
                if (player != null) {
                    api.playerManager().forceHUD(player, state);
                    source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 Forced HUD state to \u00a7l" + state + "\u00a77 for \u00a76" + player.getName());
                }
                return 1;
            }))));
            px.then(((LiteralArgumentBuilder)Commands.literal((String)"mouse-position").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.mouse_position")))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
                Player player = this.getSinglePlayer(playerArg, source);
                if (player != null) {
                    Position pos = VariableAPI.getMousePos(player, Position.ZERO);
                    source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 Player \u00a76" + player.getName() + "\u00a77's mouse is at \u00a7e" + pos.x() + "% " + pos.y() + "%");
                }
                return 1;
            }))));
            px.then(((LiteralArgumentBuilder)Commands.literal((String)"put-hud").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.put_hud")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(Commands.argument((String)"text", (ArgumentType)ArgumentTypes.component()).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
                Integer id = (Integer)ctx.getArgument("id", Integer.TYPE);
                Float x = (Float)ctx.getArgument("x", Float.TYPE);
                Float y = (Float)ctx.getArgument("y", Float.TYPE);
                Component textNBT = (Component)ctx.getArgument("text", Component.class);
                Player player = this.getSinglePlayer(playerArg, source);
                if (player != null) {
                    api.playerManager().putHUD(player, id.shortValue(), x.floatValue(), y.floatValue(), textNBT);
                    source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 HUD element added.");
                }
                return 1;
            })))))));
            px.then(((LiteralArgumentBuilder)Commands.literal((String)"delete-hud").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.delete_hud")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                Integer id = (Integer)ctx.getArgument("id", Integer.TYPE);
                PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
                Player player = this.getSinglePlayer(playerArg, source);
                if (player != null) {
                    api.playerManager().deleteHUD(player, id.shortValue());
                    source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 HUD element deleted.");
                }
                return 1;
            }))));
            px.then(((LiteralArgumentBuilder)Commands.literal((String)"clear-hud").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.clear_hud")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
                Player player = this.getSinglePlayer(playerArg, source);
                if (player != null) {
                    api.playerManager().clearHUD(player);
                    source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 HUD elements cleared.");
                }
                return 1;
            })));
            px.then(((LiteralArgumentBuilder)Commands.literal((String)"set-window-title").requires(this.restricted(source -> source.getSender().hasPermission("protocolextension.command.set_window_title")))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).then(Commands.argument((String)"text", (ArgumentType)ArgumentTypes.component()).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                Component component = (Component)ctx.getArgument("text", Component.class);
                PlayerSelectorArgumentResolver playerArg = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
                Player player = this.getSinglePlayer(playerArg, source);
                if (player != null) {
                    api.playerManager().setWindowTitle(player, component);
                    source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a77 Window title changed.");
                }
                return 1;
            }))));
            ((Commands)commands.registrar()).register(px.build(), Set.of("px"));
        });
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        api.playerManager().activate(event.getPlayer());
        api.listenerManager().dispatchEvent("onConnect", (PlayerEvent)event, new Class[0], new Object[0]);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        api.listenerManager().dispatchEvent("onDisconnect", (PlayerEvent)event, new Class[0], new Object[0]);
    }

    private Player getSinglePlayer(PlayerSelectorArgumentResolver arg, CommandSourceStack source) throws CommandSyntaxException {
        List playerList = (List)arg.resolve(source);
        if (playerList.isEmpty()) {
            source.getSender().sendMessage("\u00a78[\u00a7c\ud83c\udf88\u00a78]\u00a74 Error:\u00a7c Unknown player.");
            return null;
        }
        return (Player)playerList.getFirst();
    }

    private Predicate<CommandSourceStack> restricted(Predicate<CommandSourceStack> predicate) {
        try {
            return Commands.restricted(predicate);
        }
        catch (NoSuchMethodError e) {
            return predicate;
        }
    }

    public static ProtocolExtensionAPI getAPI() {
        return api;
    }

    static {
        api = new ProtocolExtensionAPIRecord(new ListenerManagerImpl(), new ProtocolExtensionPacketEventsPlayerManager());
        api.listenerManager().registerListener(new VariableAPI());
    }
}

