/*
 * Decompiled with CFR 0.152.
 */
package pl.olafcio.protocolextension.client;

import java.lang.reflect.InvocationTargetException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.olafcio.protocolextension.both.Position;
import pl.olafcio.protocolextension.both.payloads.ActivatePayload;
import pl.olafcio.protocolextension.both.payloads.c2s.KeyPressedC2SPayload;
import pl.olafcio.protocolextension.both.payloads.c2s.MouseMoveC2SPayload;
import pl.olafcio.protocolextension.both.payloads.s2c.HUDClearS2CPayload;
import pl.olafcio.protocolextension.both.payloads.s2c.HUDDeleteElementS2CPayload;
import pl.olafcio.protocolextension.both.payloads.s2c.HUDPutElementS2CPayload;
import pl.olafcio.protocolextension.both.payloads.s2c.HUDSettingHotbarS2CPayload;
import pl.olafcio.protocolextension.both.payloads.s2c.HUDToggleS2CPayload;
import pl.olafcio.protocolextension.both.payloads.s2c.MoveToggleS2CPayload;
import pl.olafcio.protocolextension.both.payloads.s2c.ServerCommandS2CPayload;
import pl.olafcio.protocolextension.both.payloads.s2c.SetWindowTitleS2CPayload;
import pl.olafcio.protocolextension.client.NetworkUtil;
import pl.olafcio.protocolextension.client.payload.PayloadRegistry;
import pl.olafcio.protocolextension.client.state.MoveState;
import pl.olafcio.protocolextension.client.state.WindowTitle;
import pl.olafcio.protocolextension.client.state.hud.HudElement;
import pl.olafcio.protocolextension.client.state.hud.HudState;

public class Main
implements ModInitializer,
ClientModInitializer {
    public static class_310 mc;
    public static Logger logger;

    public void onInitialize() {
        logger = LoggerFactory.getLogger((String)"ProtocolExtension");
        try {
            PayloadRegistry.add(ActivatePayload.class, ActivatePayload.ID).registerC2S().registerS2C();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to add activate packet", e);
        }
        try {
            PayloadRegistry.add(KeyPressedC2SPayload.class, KeyPressedC2SPayload.ID).registerC2S();
            PayloadRegistry.add(MouseMoveC2SPayload.class, MouseMoveC2SPayload.ID).registerC2S();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to add C2S packets", e);
        }
        try {
            PayloadRegistry.add(HUDToggleS2CPayload.class, HUDToggleS2CPayload.ID).registerS2C();
            PayloadRegistry.add(HUDPutElementS2CPayload.class, HUDPutElementS2CPayload.ID).registerS2C();
            PayloadRegistry.add(HUDDeleteElementS2CPayload.class, HUDDeleteElementS2CPayload.ID).registerS2C();
            PayloadRegistry.add(HUDClearS2CPayload.class, HUDClearS2CPayload.ID).registerS2C();
            PayloadRegistry.add(SetWindowTitleS2CPayload.class, SetWindowTitleS2CPayload.ID).registerS2C();
            PayloadRegistry.add(ServerCommandS2CPayload.class, ServerCommandS2CPayload.ID).registerS2C();
            PayloadRegistry.add(MoveToggleS2CPayload.class, MoveToggleS2CPayload.ID).registerS2C();
            PayloadRegistry.add(HUDSettingHotbarS2CPayload.class, HUDSettingHotbarS2CPayload.ID).registerS2C();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to add S2C packets", e);
        }
    }

    public void onInitializeClient() {
        PayloadRegistry.handleS2C(ActivatePayload.class, (payload, context) -> {
            NetworkUtil.enabled = true;
        });
        PayloadRegistry.handleS2C(HUDToggleS2CPayload.class, (payload, context) -> {
            context.client().field_1690.field_1842 = !payload.state();
        });
        PayloadRegistry.handleS2C(HUDPutElementS2CPayload.class, (payload, context) -> HudState.elements.put(payload.id(), new HudElement(new Position(payload.x(), payload.y()), payload.text())));
        PayloadRegistry.handleS2C(HUDDeleteElementS2CPayload.class, (payload, context) -> {
            if (HudState.elements.remove(payload.id()) == null) {
                logger.warn("Tried to delete non-existent HUD element");
            }
        });
        PayloadRegistry.handleS2C(HUDClearS2CPayload.class, (payload, context) -> HudState.elements.clear());
        PayloadRegistry.handleS2C(SetWindowTitleS2CPayload.class, (payload, context) -> {
            WindowTitle.text = payload.title();
        });
        PayloadRegistry.handleS2C(ServerCommandS2CPayload.class, (payload, context) -> {
            context.client().field_1690.field_1832.method_23481(payload.sneaking());
            context.client().field_1690.field_1867.method_23481(payload.sprinting());
        });
        PayloadRegistry.handleS2C(MoveToggleS2CPayload.class, (payload, context) -> {
            MoveState.value = payload.canMove();
        });
        PayloadRegistry.handleS2C(HUDSettingHotbarS2CPayload.class, (payload, context) -> {
            HudState.hotbar = payload.shown();
        });
    }
}

