/*
 * Decompiled with CFR 0.152.
 */
package pl.olafcio.protocolextension.server;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.olafcio.protocolextension.server.VariableAPI;
import pl.olafcio.protocolextension.server.api.base.ListenerManagerImpl;
import pl.olafcio.protocolextension.server.api.base.ProtocolExtensionAPIRecord;
import pl.olafcio.protocolextension.server.api.player.packetevents.ProtocolExtensionPacketEventsPacketListener;
import pl.olafcio.protocolextension.server.api.player.packetevents.ProtocolExtensionPacketEventsPlayerManager;
import pl.olafcio.protocolextension.server.api.virtual.ProtocolExtensionAPI;
import pl.olafcio.protocolextension.server.main.TCommands;
import pl.olafcio.protocolextension.server.main.TMultiversion;

public final class ProtocolExtension
extends JavaPlugin
implements Listener,
TMultiversion,
TCommands {
    private static File configFile;
    private static FileConfiguration config;
    private static ProtocolExtensionAPI api;

    public void onLoad() {
        configFile = new File(this.getDataFolder(), "config.yml");
        this.reloadConfig();
    }

    public void reloadConfig() {
        config = YamlConfiguration.loadConfiguration((File)configFile);
        InputStream defConfigStream = this.getResource("paper/config.yml");
        if (defConfigStream == null) {
            return;
        }
        config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8)));
    }

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new ProtocolExtensionPacketEventsPacketListener(), PacketListenerPriority.NORMAL);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, this::registerCommands);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        api.listenerManager().dispatchEvent("onConnect", (PlayerEvent)event, new Class[0], new Object[0]);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        api.listenerManager().dispatchEvent("onDisconnect", (PlayerEvent)event, new Class[0], new Object[0]);
    }

    public static ProtocolExtensionAPI getAPI() {
        return api;
    }

    @Override
    public ProtocolExtensionAPI api() {
        return api;
    }

    static {
        api = new ProtocolExtensionAPIRecord(new ListenerManagerImpl(), new ProtocolExtensionPacketEventsPlayerManager());
        api.listenerManager().registerListener(new VariableAPI());
    }
}

