/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xpickup;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import jn.willfrydev.xpickup.api.XPickupAPI;
import jn.willfrydev.xpickup.commands.PickupCommand;
import jn.willfrydev.xpickup.commands.PickupTabCompleter;
import jn.willfrydev.xpickup.listeners.PickupListener;
import jn.willfrydev.xpickup.managers.ConfigManager;
import jn.willfrydev.xpickup.managers.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class XPickup
extends JavaPlugin {
    private static XPickup instance;
    private XPickupAPI api;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private final Set<UUID> autoPickupDisabled = new HashSet<UUID>();

    public void onEnable() {
        instance = this;
        this.api = new XPickupAPI(this);
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.configManager.loadConfigs();
        this.getServer().getPluginManager().registerEvents((Listener)new PickupListener(this), (Plugin)this);
        this.getCommand("xpickup").setExecutor((CommandExecutor)new PickupCommand(this));
        this.getCommand("xpickup").setTabCompleter((TabCompleter)new PickupTabCompleter());
        if (!this.getConfigManager().isAutoPickupOnByDefault()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.autoPickupDisabled.add(player.getUniqueId());
            }
        }
        this.sendAsciiArtToConsole(ChatColor.GREEN);
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "xPickup ha sido activado correctamente.");
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "=====================================================================");
    }

    public void onDisable() {
        this.sendAsciiArtToConsole(ChatColor.RED);
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "xPickup ha sido desactivado.");
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "=====================================================================");
    }

    private void sendAsciiArtToConsole(ChatColor color) {
        String[] art;
        for (String line : art = new String[]{"                                                                     ", "  ___    ___ ________  ___  ________  ___  __    ___  ___  ________   ", " |\\  \\  /  /|\\   __  \\|\\  \\|\\   ____\\|\\  \\|\\  \\ |\\  \\|\\  \\|\\   __  \\  ", " \\ \\  \\/  / | \\  \\|\\  \\ \\  \\ \\  \\___|\\ \\  \\/  /|\\ \\  \\\\\\  \\ \\  \\|\\  \\ ", "  \\ \\    / / \\ \\   ____\\ \\  \\ \\  \\    \\ \\   ___  \\ \\  \\\\\\  \\ \\   ____\\", "   /     \\/   \\ \\  \\___|\\ \\  \\ \\  \\____\\ \\  \\\\ \\  \\ \\  \\\\\\  \\ \\  \\___|", "  /  /\\   \\    \\ \\__\\    \\ \\__\\ \\_______\\ \\__\\\\ \\__\\ \\______\\ \\__\\   ", " /__/ /\\ __\\    \\|__|     \\|__|\\|_______|\\|__| \\|__|\\|_______|\\|__|   ", " |__|/ \\|__|                                                        ", "                                                                     "}) {
            this.getServer().getConsoleSender().sendMessage(color + line);
        }
    }

    public static XPickup getInstance() {
        return instance;
    }

    public XPickupAPI getApi() {
        return this.api;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public Set<UUID> getAutoPickupDisabled() {
        return this.autoPickupDisabled;
    }
}

