/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xpickup.commands;

import java.util.Set;
import java.util.UUID;
import jn.willfrydev.xpickup.XPickup;
import jn.willfrydev.xpickup.managers.ConfigManager;
import jn.willfrydev.xpickup.managers.MessageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PickupCommand
implements CommandExecutor {
    private final XPickup plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;

    public PickupCommand(XPickup plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.messageManager = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.togglePickup((Player)sender);
            } else {
                this.sendHelp(sender);
            }
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "toggle": {
                if (!(sender instanceof Player)) {
                    this.messageManager.sendPrefixedMessage(sender, "player-only");
                    return true;
                }
                this.togglePickup((Player)sender);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("xpickup.admin")) {
                    this.messageManager.sendPrefixedMessage(sender, "no-permission");
                    return true;
                }
                this.configManager.reloadConfigs();
                this.messageManager.sendPrefixedMessage(sender, "reload");
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void togglePickup(Player player) {
        UUID playerUUID;
        if (!player.hasPermission("xpickup.use")) {
            this.messageManager.sendPrefixedMessage((CommandSender)player, "no-permission");
            return;
        }
        Set<UUID> disabled = this.plugin.getAutoPickupDisabled();
        if (disabled.contains(playerUUID = player.getUniqueId())) {
            disabled.remove(playerUUID);
            this.messageManager.sendPrefixedMessage((CommandSender)player, "pickup-toggled-on");
        } else {
            disabled.add(playerUUID);
            this.messageManager.sendPrefixedMessage((CommandSender)player, "pickup-toggled-off");
        }
    }

    private void sendHelp(CommandSender sender) {
        this.messageManager.sendHelpMessage(sender);
    }
}

