/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xpickup.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jn.willfrydev.xpickup.XPickup;
import jn.willfrydev.xpickup.managers.ConfigManager;
import jn.willfrydev.xpickup.managers.MessageManager;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PickupListener
implements Listener {
    private final XPickup plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;

    public PickupListener(XPickup plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.messageManager = plugin.getMessageManager();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.configManager.isAutoPickupOnByDefault()) {
            this.plugin.getAutoPickupDisabled().add(player.getUniqueId());
        } else {
            this.plugin.getAutoPickupDisabled().remove(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldAutoPickup(player)) {
            return;
        }
        Collection drops = event.getBlock().getDrops(player.getInventory().getItemInMainHand());
        if (drops.isEmpty()) {
            return;
        }
        event.setDropItems(false);
        this.giveItems(player, drops, event.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity().getKiller() == null) {
            return;
        }
        final Player player = event.getEntity().getKiller();
        if (!this.shouldAutoPickup(player)) {
            return;
        }
        final Location deathLocation = event.getEntity().getLocation();
        new BukkitRunnable(){

            public void run() {
                Block blockAtDeath = deathLocation.getBlock();
                if (PickupListener.this.isMobHead(blockAtDeath.getType())) {
                    Collection headDrop = blockAtDeath.getDrops();
                    blockAtDeath.setType(Material.AIR);
                    PickupListener.this.giveItems(player, headDrop, deathLocation);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 2L);
    }

    private boolean shouldAutoPickup(Player player) {
        if (this.plugin.getAutoPickupDisabled().contains(player.getUniqueId())) {
            return false;
        }
        if (!player.hasPermission("xpickup.use")) {
            return false;
        }
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        if (this.configManager.isWorldControlEnabled()) {
            String worldName = player.getWorld().getName();
            List<String> worldsList = this.configManager.getWorldsList();
            String mode = this.configManager.getWorldsControlMode();
            if ("WHITELIST".equals(mode) ? !worldsList.contains(worldName) : "BLACKLIST".equals(mode) && worldsList.contains(worldName)) {
                return false;
            }
        }
        return true;
    }

    private void giveItems(Player player, Collection<ItemStack> items, Location dropLocation) {
        boolean pickedUpSomething;
        if (items == null || items.isEmpty()) {
            return;
        }
        HashMap remainingItems = player.getInventory().addItem(items.toArray(new ItemStack[0]));
        boolean bl = pickedUpSomething = items.size() > remainingItems.size();
        if (pickedUpSomething) {
            this.playEffects(player);
        }
        if (!remainingItems.isEmpty()) {
            for (ItemStack item : remainingItems.values()) {
                player.getWorld().dropItemNaturally(dropLocation, item);
            }
            this.messageManager.handleFullInventoryMessages(player);
        }
    }

    private void playEffects(Player player) {
        if (this.configManager.isSoundEnabled()) {
            try {
                Sound sound = Sound.valueOf((String)this.configManager.getSoundName().toUpperCase());
                player.playSound(player.getLocation(), sound, this.configManager.getSoundVolume(), this.configManager.getSoundPitch());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("El sonido '" + this.configManager.getSoundName() + "' no es v\u00e1lido.");
            }
        }
        if (this.configManager.isParticlesEnabled()) {
            try {
                Particle particle = Particle.valueOf((String)this.configManager.getParticleName().toUpperCase());
                player.spawnParticle(particle, player.getLocation().add(0.0, 1.0, 0.0), this.configManager.getParticleCount(), 0.3, 0.3, 0.3, 0.0);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("La part\u00edcula '" + this.configManager.getParticleName() + "' no es v\u00e1lida.");
            }
        }
    }

    private boolean isMobHead(Material material) {
        return material == Material.PLAYER_HEAD || material == Material.SKELETON_SKULL || material == Material.WITHER_SKELETON_SKULL || material == Material.ZOMBIE_HEAD || material == Material.CREEPER_HEAD || material == Material.DRAGON_HEAD;
    }
}

