/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xpickup.managers;

import java.io.File;
import java.util.List;
import jn.willfrydev.xpickup.XPickup;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final XPickup plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public ConfigManager(XPickup plugin) {
        this.plugin = plugin;
    }

    public void loadConfigs() {
        this.plugin.getConfig().options().copyDefaults(true);
        this.plugin.saveDefaultConfig();
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public boolean isWorldControlEnabled() {
        return this.plugin.getConfig().getBoolean("worlds-control.enabled");
    }

    public String getWorldsControlMode() {
        return this.plugin.getConfig().getString("worlds-control.mode", "WHITELIST").toUpperCase();
    }

    public List<String> getWorldsList() {
        return this.plugin.getConfig().getStringList("worlds-control.list");
    }

    public boolean isAutoPickupOnByDefault() {
        return this.plugin.getConfig().getBoolean("auto-pickup-on-by-default");
    }

    public boolean isSoundEnabled() {
        return this.plugin.getConfig().getBoolean("pickup-sound.enabled");
    }

    public String getSoundName() {
        return this.plugin.getConfig().getString("pickup-sound.sound");
    }

    public float getSoundVolume() {
        return (float)this.plugin.getConfig().getDouble("pickup-sound.volume");
    }

    public float getSoundPitch() {
        return (float)this.plugin.getConfig().getDouble("pickup-sound.pitch");
    }

    public boolean isParticlesEnabled() {
        return this.plugin.getConfig().getBoolean("pickup-particles.enabled");
    }

    public String getParticleName() {
        return this.plugin.getConfig().getString("pickup-particles.particle");
    }

    public int getParticleCount() {
        return this.plugin.getConfig().getInt("pickup-particles.count");
    }

    public boolean useChatForFullInv() {
        return this.plugin.getConfig().getBoolean("inventory-full-message.chat");
    }

    public boolean useActionbarForFullInv() {
        return this.plugin.getConfig().getBoolean("inventory-full-message.actionbar");
    }

    public boolean isTitleForFullInvEnabled() {
        return this.plugin.getConfig().getBoolean("inventory-full-message.title.enabled");
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        return message == null ? "<red>Mensaje no encontrado: " + path + "</red>" : message;
    }

    public String getPrefixedMessage(String path) {
        return this.getMessage("prefix") + this.getMessage(path);
    }

    public List<String> getHelpMessage() {
        return this.messagesConfig.getStringList("help-message");
    }
}

